/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore;

import com.arjuna.ats.arjuna.ArjunaNames;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.gandiva.ClassName;
import com.arjuna.ats.arjuna.gandiva.ObjectName;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.objectstore.AsyncStore;
import com.arjuna.ats.internal.arjuna.objectstore.HashedStore;
import com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore;
import java.io.SyncFailedException;

public class CacheStore
extends HashedStore {
    static final int NO_STATE_TYPE = -1;
    static AsyncStore _storeManager = new AsyncStore();
    private static boolean _cacheSync = false;

    @Override
    public boolean commit_state(Uid objUid, String tName) throws ObjectStoreException {
        return _storeManager.addWork(this, 0, objUid, tName, null, -1);
    }

    @Override
    public void sync() throws SyncFailedException, ObjectStoreException {
        _storeManager.flush();
    }

    @Override
    public int typeIs() {
        return 18;
    }

    @Override
    public ClassName className() {
        return ArjunaNames.Implementation_ObjectStore_CacheStore();
    }

    public static ClassName name() {
        return ArjunaNames.Implementation_ObjectStore_CacheStore();
    }

    public static ShadowingStore create() {
        return new CacheStore("");
    }

    public static ShadowingStore create(Object[] param) {
        int ss;
        String location;
        block5: {
            if (param == null) {
                return null;
            }
            location = (String)param[0];
            Integer shareStatus = (Integer)param[1];
            ss = 14;
            if (shareStatus != null) {
                try {
                    if (shareStatus == 13) {
                        ss = 13;
                    }
                }
                catch (Exception e) {
                    if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block5;
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.CacheStore_1", new Object[]{e});
                }
            }
        }
        return new CacheStore(location, ss);
    }

    public static ShadowingStore create(ObjectName param) {
        if (param == null) {
            return null;
        }
        return new CacheStore(param);
    }

    @Override
    protected boolean remove_state(Uid objUid, String name, int ft) throws ObjectStoreException {
        int status = _storeManager.removeState(objUid, ft);
        if (status == 4) {
            return true;
        }
        int fileState = this.currentState(objUid, name);
        if (fileState != 0 || status == 3) {
            return _storeManager.addWork(this, 1, objUid, name, null, fileState);
        }
        return fileState != 0;
    }

    @Override
    protected boolean write_state(Uid objUid, String tName, OutputObjectState state, int ft) throws ObjectStoreException {
        int status = _storeManager.removeWriteState(objUid, ft);
        return _storeManager.addWork(this, 2, objUid, tName, state, ft);
    }

    @Override
    protected InputObjectState read_state(Uid objUid, String tName, int ft) throws ObjectStoreException {
        OutputObjectState state = _storeManager.getState(objUid, ft);
        if (state == null) {
            return super.read_state(objUid, tName, ft);
        }
        return new InputObjectState(state);
    }

    protected boolean commitState(Uid objUid, String tName) throws ObjectStoreException {
        return super.commit_state(objUid, tName);
    }

    protected boolean removeState(Uid objUid, String name, int ft) throws ObjectStoreException {
        return super.remove_state(objUid, name, ft);
    }

    protected boolean writeState(Uid objUid, String tName, OutputObjectState state, int ft) throws ObjectStoreException {
        return super.write_state(objUid, tName, state, ft);
    }

    protected CacheStore(String locationOfStore) {
        this(locationOfStore, 14);
    }

    protected CacheStore(String locationOfStore, int shareStatus) {
        super(locationOfStore, shareStatus);
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(1L, 2L, 16L, "CacheStore.CacheStore(" + locationOfStore + ")");
        }
        this.syncWrites = _cacheSync;
    }

    protected CacheStore() {
        this(14);
    }

    protected CacheStore(int shareStatus) {
        super(shareStatus);
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(1L, 2L, 16L, "CacheStore.CacheStore( " + shareStatus + " )");
        }
        this.syncWrites = false;
    }

    protected CacheStore(ObjectName objName) {
        super(objName);
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(1L, 2L, 16L, "CacheStore.CacheStore( " + objName + " )");
        }
        this.syncWrites = false;
    }

    static {
        _cacheSync = arjPropertyManager.getObjectStoreEnvironmentBean().isCacheStoreSync();
    }
}

