/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore;

import com.arjuna.ats.arjuna.ArjunaNames;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.exceptions.FatalError;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.gandiva.ClassName;
import com.arjuna.ats.arjuna.gandiva.ObjectName;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.internal.arjuna.objectstore.HashedStore;
import com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore;

public class HashedActionStore
extends HashedStore {
    private static boolean checkSync = false;

    @Override
    public int typeIs() {
        return 17;
    }

    @Override
    public ClassName className() {
        return ArjunaNames.Implementation_ObjectStore_HashedActionStore();
    }

    public static ClassName name() {
        return ArjunaNames.Implementation_ObjectStore_HashedActionStore();
    }

    public static ShadowingStore create() {
        return new HashedActionStore("");
    }

    public static ShadowingStore create(Object[] param) {
        int ss;
        String location;
        block5: {
            if (param == null) {
                return null;
            }
            location = (String)param[0];
            Integer shareStatus = (Integer)param[1];
            ss = 14;
            if (shareStatus != null) {
                try {
                    if (shareStatus == 13) {
                        ss = 13;
                    }
                }
                catch (Exception e) {
                    if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block5;
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.HashedActionStore_1", new Object[]{e});
                }
            }
        }
        return new HashedActionStore(location, ss);
    }

    public static ShadowingStore create(ObjectName param) {
        if (param == null) {
            return null;
        }
        return new HashedActionStore(param);
    }

    protected HashedActionStore() {
        this(14);
    }

    protected HashedActionStore(int shareStatus) {
        super(shareStatus);
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 2L, 16L, "HashedStore.HashedActionStore( " + shareStatus + " )");
        }
    }

    protected HashedActionStore(String locationOfStore) {
        this(locationOfStore, 14);
    }

    protected HashedActionStore(String locationOfStore, int shareStatus) {
        super(shareStatus);
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 2L, 16L, "HashedStore.HashedActionStore(" + locationOfStore + ")");
        }
        try {
            this.setupStore(locationOfStore);
        }
        catch (ObjectStoreException e) {
            tsLogger.arjLogger.warn(e.getMessage());
            throw new FatalError(e.toString(), e);
        }
    }

    protected HashedActionStore(ObjectName objName) {
        super(objName);
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 2L, 16L, "HashedStore.HashedActionStore( " + objName + ")");
        }
        try {
            this.setupStore("");
        }
        catch (ObjectStoreException e) {
            tsLogger.arjLogger.warn(e.getMessage());
            throw new FatalError(e.toString(), e);
        }
    }

    @Override
    protected synchronized boolean setupStore(String location) throws ObjectStoreException {
        if (!checkSync) {
            if (arjPropertyManager.getObjectStoreEnvironmentBean().isTransactionSync()) {
                this.syncOn();
            } else {
                this.syncOff();
            }
        }
        checkSync = true;
        return super.setupStore(location);
    }
}

