/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore;

import com.arjuna.ats.arjuna.ArjunaNames;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.exceptions.FatalError;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.gandiva.ClassName;
import com.arjuna.ats.arjuna.gandiva.ObjectName;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ObjectStore;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.objectstore.FileSystemStore;
import com.arjuna.ats.internal.arjuna.objectstore.LogInstance;
import com.arjuna.ats.internal.arjuna.objectstore.LogPurger;
import com.arjuna.ats.internal.arjuna.objectstore.PurgeShutdownHook;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.SyncFailedException;
import java.nio.ByteBuffer;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class LogStore
extends FileSystemStore {
    public static final long LOG_SIZE = 0xA00000L;
    private static final String FILE_MODE = "rwd";
    private static boolean checkSync = false;
    private static Object _lock = new Object();
    private static ArrayList<LogInstance> _logNames = new ArrayList();
    private static long _maxFileSize = 0xA00000L;
    private static long _purgeTime = 100000L;
    private static LogPurger _purger;
    private static boolean _synchronousRemoval;
    private static final byte[] _redzone;
    private static final byte[] _removedState;
    private static final char HIDDENCHAR = '~';

    @Override
    public int typeIs() {
        return 1;
    }

    @Override
    public int currentState(Uid objUid, String tName) throws ObjectStoreException {
        InputObjectState ios = new InputObjectState();
        if (this.allObjUids(tName, ios, 0)) {
            Uid tempUid = new Uid(Uid.nullUid());
            do {
                try {
                    tempUid.unpack(ios);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return 0;
                }
                if (!tempUid.equals(objUid)) continue;
                return 1;
            } while (tempUid.notEquals(Uid.nullUid()));
            return 0;
        }
        return 0;
    }

    @Override
    public boolean commit_state(Uid objUid, String tName) throws ObjectStoreException {
        return true;
    }

    @Override
    public boolean hide_state(Uid u, String tn) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 16L, "LogStore.hide_state(" + u + ", " + tn + ")");
        }
        return false;
    }

    @Override
    public boolean reveal_state(Uid u, String tn) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 16L, "LogStore.reveal_state(" + u + ", " + tn + ")");
        }
        return false;
    }

    @Override
    public InputObjectState read_uncommitted(Uid u, String tn) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 16L, "LogStore.read_uncommitted(" + u + ", " + tn + ")");
        }
        return null;
    }

    @Override
    public boolean remove_uncommitted(Uid u, String tn) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 16L, "LogStore.remove_uncommitted(" + u + ", " + tn + ")");
        }
        return false;
    }

    @Override
    public boolean write_committed(Uid storeUid, String tName, OutputObjectState state) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 16L, "LogStore.write_committed(" + storeUid + ", " + tName + ")");
        }
        try {
            return super.write_committed(storeUid, tName, state);
        }
        catch (ObjectStoreException ex) {
            this.removeFromLog(storeUid);
            throw ex;
        }
    }

    @Override
    public boolean write_uncommitted(Uid u, String tn, OutputObjectState s) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 16L, "LogStore.write_uncommitted(" + u + ", " + tn + ", " + s + ")");
        }
        return false;
    }

    public boolean allLogUids(String tName, InputObjectState state, int match) throws ObjectStoreException {
        return super.allObjUids(tName, state, match);
    }

    @Override
    public boolean allObjUids(String tName, InputObjectState state, int match) throws ObjectStoreException {
        _purger.trigger();
        InputObjectState logs = new InputObjectState();
        OutputObjectState objUids = new OutputObjectState();
        if (!super.allObjUids(tName, logs, match)) {
            return false;
        }
        Uid logName = new Uid(Uid.nullUid());
        try {
            do {
                ArrayList<InputObjectState> txs;
                logName.unpack(logs);
                if (!logName.notEquals(Uid.nullUid()) || (txs = this.scanLog(logName, tName)).size() <= 0) continue;
                for (int i = 0; i < txs.size(); ++i) {
                    txs.get(i).stateUid().pack(objUids);
                }
            } while (logName.notEquals(Uid.nullUid()));
            Uid.nullUid().pack(objUids);
            state.setBuffer(objUids.buffer());
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public ClassName className() {
        return ArjunaNames.Implementation_ObjectStore_ActionLogStore();
    }

    public static ClassName name() {
        return ArjunaNames.Implementation_ObjectStore_ActionLogStore();
    }

    public static FileSystemStore create() {
        return new LogStore("");
    }

    public static FileSystemStore create(Object[] param) {
        int ss;
        String location;
        block5: {
            if (param == null) {
                return null;
            }
            location = (String)param[0];
            Integer shareStatus = (Integer)param[1];
            ss = 14;
            if (shareStatus != null) {
                try {
                    if (shareStatus == 13) {
                        ss = 13;
                    }
                }
                catch (Exception e) {
                    if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block5;
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.LogStore_2", new Object[]{e});
                }
            }
        }
        return new LogStore(location, ss);
    }

    public static FileSystemStore create(ObjectName param) {
        if (param == null) {
            return null;
        }
        return new LogStore(param);
    }

    protected LogStore(String locationOfStore) {
        this(locationOfStore, 14);
    }

    protected LogStore(String locationOfStore, int shareStatus) {
        super(shareStatus);
        try {
            this.setupStore(locationOfStore);
        }
        catch (ObjectStoreException e) {
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLogger.warn(e.getMessage());
            }
            super.makeInvalid();
            throw new FatalError(e.toString(), e);
        }
    }

    protected LogStore() {
        this(14);
    }

    protected LogStore(int shareStatus) {
        super(shareStatus);
    }

    protected LogStore(ObjectName objName) {
        super(objName);
    }

    @Override
    protected synchronized boolean setupStore(String location) throws ObjectStoreException {
        if (!checkSync) {
            if (arjPropertyManager.getObjectStoreEnvironmentBean().isTransactionSync()) {
                this.syncOn();
            } else {
                this.syncOff();
            }
        }
        checkSync = true;
        if (_purger == null) {
            _purger = new LogPurger(this, _purgeTime);
            _purger.setDaemon(true);
            Runtime.getRuntime().addShutdownHook(new PurgeShutdownHook(_purger));
            _purger.start();
        }
        return super.setupStore(location);
    }

    protected boolean unlockAndClose(File fd, RandomAccessFile rf) {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 1L, 16L, "RandomAccessFile.unlockAndClose(" + fd + ", " + rf + ")");
        }
        boolean closedOk = this.unlock(fd);
        try {
            rf.close();
        }
        catch (Exception e) {
            closedOk = false;
        }
        return closedOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean write_state(Uid objUid, String tName, OutputObjectState state, int ft) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 2L, 16L, "ShadowingStore.write_state(" + objUid + ", " + tName + ", " + ObjectStore.stateTypeString(ft) + ")");
        }
        if (!this.storeValid()) {
            return false;
        }
        String fname = null;
        File fd = null;
        if (tName != null) {
            int imageSize = state.length();
            byte[] uidString = objUid.stringForm().getBytes();
            int buffSize = _redzone.length + uidString.length + imageSize + 8;
            RandomAccessFile ofile = null;
            FileLock lock = null;
            if (imageSize > 0) {
                LogInstance.TransactionData theLogEntry = this.getLogName(objUid, tName, buffSize);
                LogInstance theLog = theLogEntry.container;
                if (theLog == null) {
                    throw new ObjectStoreException();
                }
                fname = this.genPathName(theLog.getName(), tName, ft);
                fd = this.openAndLock(fname, 1, true);
                if (fd == null) {
                    if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_18", new Object[]{fname});
                    }
                    return false;
                }
                boolean setLength = !fd.exists();
                try {
                    ofile = new RandomAccessFile(fd, FILE_MODE);
                    if (setLength) {
                        ofile.setLength(_maxFileSize);
                    } else if (theLog.remaining() < (long)buffSize) {
                        long size = ofile.length() + (long)buffSize - theLog.remaining();
                        ofile.setLength(size);
                        theLog.resize(size);
                    }
                    ByteBuffer buff = ByteBuffer.allocate(buffSize);
                    buff.put(_redzone);
                    buff.putInt(uidString.length);
                    buff.put(uidString);
                    buff.putInt(imageSize);
                    buff.put(state.buffer());
                    Object object = _lock;
                    synchronized (object) {
                        ofile.seek(theLogEntry.offset);
                        ofile.write(buff.array());
                    }
                }
                catch (SyncFailedException e) {
                    this.unlockAndClose(fd, ofile);
                    throw new ObjectStoreException("ShadowingStore::write_state() - write failed to sync for " + fname, e);
                }
                catch (FileNotFoundException e) {
                    this.unlockAndClose(fd, ofile);
                    e.printStackTrace();
                    throw new ObjectStoreException("ShadowingStore::write_state() - write failed to locate file " + fname + ": " + e, e);
                }
                catch (IOException e) {
                    this.unlockAndClose(fd, ofile);
                    e.printStackTrace();
                    throw new ObjectStoreException("ShadowingStore::write_state() - write failed for " + fname + ": " + e, e);
                }
                finally {
                    try {
                        if (lock != null) {
                            lock.release();
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            if (!this.unlockAndClose(fd, ofile) && tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_19", new Object[]{fname});
            }
            super.addToCache(fname);
            return true;
        }
        throw new ObjectStoreException("ShadowStore::write_state - " + tsLogger.log_mesg.getString("com.arjuna.ats.internal.arjuna.objectstore.notypenameuid") + objUid);
    }

    @Override
    protected InputObjectState read_state(Uid u, String tn, int s) throws ObjectStoreException {
        _purger.trigger();
        LogInstance.TransactionData td = this.getLogName(u, tn, -1L);
        if (td == null) {
            throw new ObjectStoreException();
        }
        ArrayList<InputObjectState> states = this.scanLog(td.container.getName(), tn);
        if (states == null || states.size() == 0) {
            return null;
        }
        for (int i = 0; i < states.size(); ++i) {
            if (!states.get(i).stateUid().equals(u)) continue;
            return states.get(i);
        }
        return null;
    }

    @Override
    protected boolean remove_state(Uid u, String tn, int s) throws ObjectStoreException {
        try {
            if (_synchronousRemoval) {
                OutputObjectState removalState = new OutputObjectState(u, tn);
                removalState.packBytes(_removedState);
                if (!this.write_state(u, tn, removalState, s)) {
                    throw new ObjectStoreException();
                }
            } else {
                _purger.addRemovedState(u, tn, s);
            }
        }
        catch (IOException ex) {
            throw new ObjectStoreException(ex.toString(), ex);
        }
        finally {
            this.removeFromLog(u);
        }
        return true;
    }

    @Override
    protected boolean lock(File fd, int lmode, boolean create) {
        return true;
    }

    @Override
    protected boolean unlock(File fd) {
        return true;
    }

    @Override
    protected String genPathName(Uid objUid, String tName, int ft) throws ObjectStoreException {
        String fname = super.genPathName(objUid, tName, ft);
        if (ft == 2) {
            fname = fname + '~';
        }
        return fname;
    }

    boolean removeState(Uid u, String tn, int s) throws ObjectStoreException {
        try {
            OutputObjectState removalState = new OutputObjectState(u, tn);
            removalState.packBytes(_removedState);
            if (!this.write_state(u, tn, removalState, s)) {
                throw new ObjectStoreException();
            }
        }
        catch (IOException ex) {
            throw new ObjectStoreException(ex.toString(), ex);
        }
        return true;
    }

    boolean truncateLogs() throws ObjectStoreException {
        return this.truncateLogs(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean truncateLogs(boolean force) throws ObjectStoreException {
        ArrayList<LogInstance> arrayList = _logNames;
        synchronized (arrayList) {
            Iterator<LogInstance> iter = _logNames.iterator();
            while (iter.hasNext()) {
                boolean delete = false;
                LogInstance log = null;
                try {
                    log = iter.next();
                    if (log.isFrozen() || force) {
                        delete = this.truncateLog(log, force);
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (!delete) continue;
                iter.remove();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean truncateLog(LogInstance log, boolean force) throws ObjectStoreException {
        boolean delete = false;
        Object object = _lock;
        synchronized (object) {
            block16: {
                File fd = new File(this.genPathName(log.getName(), log.getTypeName(), 1));
                try {
                    ArrayList<InputObjectState> objectStates = this.scanLog(log.getName(), log.getTypeName());
                    if (objectStates != null && objectStates.size() > 0) {
                        String fname = this.genPathName(log.getName(), log.getTypeName(), 2);
                        File fd2 = this.openAndLock(fname, 1, true);
                        RandomAccessFile oFile = new RandomAccessFile(fd2, FILE_MODE);
                        int size = 0;
                        oFile.setLength(_maxFileSize);
                        for (int i = 0; i < objectStates.size(); ++i) {
                            byte[] uidString = objectStates.get(i).stateUid().stringForm().getBytes();
                            int buffSize = _redzone.length + uidString.length + objectStates.get(i).buffer().length + 8;
                            ByteBuffer buff = ByteBuffer.allocate(buffSize);
                            size += buffSize;
                            try {
                                buff.put(_redzone);
                                buff.putInt(uidString.length);
                                buff.put(uidString);
                                buff.putInt(objectStates.get(i).buffer().length);
                                buff.put(objectStates.get(i).buffer(), 0, objectStates.get(i).buffer().length);
                                continue;
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                fd2.delete();
                                this.unlockAndClose(fd2, oFile);
                                throw new ObjectStoreException(ex.toString(), ex);
                            }
                        }
                        try {
                            if (force) {
                                oFile.setLength(size);
                                log.freeze();
                            }
                            fd2.renameTo(fd);
                            break block16;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            throw new ObjectStoreException(ex.toString(), ex);
                        }
                        finally {
                            this.unlockAndClose(fd2, oFile);
                        }
                    }
                    fd.delete();
                    delete = true;
                }
                catch (ObjectStoreException ex) {
                    ex.printStackTrace();
                    throw ex;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new ObjectStoreException(ex.toString(), ex);
                }
            }
        }
        return delete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final ArrayList<InputObjectState> scanLog(Uid logName, String typeName) throws ObjectStoreException {
        Object object = _lock;
        synchronized (object) {
            try {
                String fname = this.genPathName(logName, typeName, 1);
                File fd = this.openAndLock(fname, 1, true);
                RandomAccessFile iFile = new RandomAccessFile(fd, FILE_MODE);
                try {
                    ArrayList<InputObjectState> objectStates = new ArrayList<InputObjectState>();
                    iFile.seek(0L);
                    while (iFile.getFilePointer() < iFile.length()) {
                        byte[] buff = new byte[_redzone.length];
                        iFile.read(buff);
                        if (!this.redzoneProtected(buff)) break;
                        int uidSize = iFile.readInt();
                        byte[] uidString = new byte[uidSize];
                        iFile.read(uidString);
                        Uid txId = new Uid(new String(uidString));
                        int imageSize = iFile.readInt();
                        byte[] imageState = new byte[imageSize];
                        iFile.read(imageState);
                        try {
                            InputObjectState state = new InputObjectState(txId, "", imageState);
                            objectStates.add(state);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            throw new ObjectStoreException(ex.toString(), ex);
                        }
                    }
                    this.unlockAndClose(fd, iFile);
                    iFile = null;
                    ArrayList<InputObjectState> deletedLogs = new ArrayList<InputObjectState>();
                    for (int i = 0; i < objectStates.size(); ++i) {
                        InputObjectState curr = (InputObjectState)objectStates.get(i);
                        try {
                            if (Arrays.equals(curr.unpackBytes(), _removedState)) {
                                deletedLogs.add(curr);
                                continue;
                            }
                            curr.reread();
                            continue;
                        }
                        catch (Exception ex) {
                            curr.reread();
                        }
                    }
                    if (deletedLogs.size() > 0) {
                        objectStates.removeAll(deletedLogs);
                        this.deleteEntries(objectStates, deletedLogs);
                        this.pruneEntries(objectStates);
                        ArrayList<InputObjectState> arrayList2 = objectStates;
                        return arrayList2;
                    }
                    ArrayList<InputObjectState> arrayList = objectStates;
                    return arrayList;
                }
                finally {
                    if (iFile != null) {
                        this.unlockAndClose(fd, iFile);
                    }
                }
            }
            catch (ObjectStoreException ex) {
                ex.printStackTrace();
                throw ex;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new ObjectStoreException(ex.toString(), ex);
            }
        }
    }

    private final boolean redzoneProtected(byte[] buff) {
        for (int i = 0; i < _redzone.length; ++i) {
            if (buff[i] == _redzone[i]) continue;
            return false;
        }
        return true;
    }

    private final void deleteEntries(ArrayList<InputObjectState> allStates, ArrayList<InputObjectState> deletedStates) {
        for (int i = 0; i < deletedStates.size(); ++i) {
            Uid txId = deletedStates.get(i).stateUid();
            for (int j = 0; j < allStates.size(); ++j) {
                if (!allStates.get(j).stateUid().equals(txId)) continue;
                allStates.remove(j);
            }
        }
        deletedStates.clear();
    }

    private final void pruneEntries(ArrayList<InputObjectState> allStates) {
        for (int j = allStates.size() - 1; j >= 0; --j) {
            Uid txId = allStates.get(j).stateUid();
            for (int i = 0; i < j; ++i) {
                if (!allStates.get(i).stateUid().equals(txId)) continue;
                allStates.remove(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final LogInstance.TransactionData getLogName(Uid txid, String tName, long size) throws ObjectStoreException {
        ArrayList<LogInstance> arrayList = _logNames;
        synchronized (arrayList) {
            Iterator<LogInstance> iter = _logNames.iterator();
            LogInstance entry2 = null;
            while (iter.hasNext()) {
                entry2 = iter.next();
                if (!entry2.present(txid)) continue;
                if (size == -1L) {
                    return entry2.getTxId(txid);
                }
                return entry2.addTxId(txid, size);
            }
            for (LogInstance entry2 : _logNames) {
                if (entry2.isFrozen()) continue;
                if (entry2.remaining() > size) {
                    return entry2.addTxId(txid, size);
                }
                entry2.freeze();
            }
            entry2 = new LogInstance(tName, _maxFileSize);
            _logNames.add(entry2);
            return entry2.addTxId(txid, size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeFromLog(Uid txid) {
        if (_synchronousRemoval) {
            ArrayList<LogInstance> arrayList = _logNames;
            synchronized (arrayList) {
                Iterator<LogInstance> iter = _logNames.iterator();
                LogInstance entry = null;
                while (iter.hasNext() && !(entry = iter.next()).present(txid)) {
                }
            }
        }
    }

    static {
        _synchronousRemoval = false;
        _redzone = new byte[]{2, 4, 6, 8};
        _removedState = new byte[]{13, 14, 10, 13, 11, 14, 14, 15};
        System.out.println(arjPropertyManager.getObjectStoreEnvironmentBean().getPurgeTime());
        _synchronousRemoval = arjPropertyManager.getObjectStoreEnvironmentBean().isSynchronousRemoval();
        _purgeTime = arjPropertyManager.getObjectStoreEnvironmentBean().getPurgeTime();
        _maxFileSize = arjPropertyManager.getObjectStoreEnvironmentBean().getTxLogSize();
    }
}

