/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.recovery;

import com.arjuna.ats.arjuna.common.recoveryPropertyManager;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.arjuna.recovery.Service;
import com.arjuna.ats.internal.arjuna.recovery.Listener;
import com.arjuna.ats.internal.arjuna.recovery.WorkerService;
import java.io.IOException;
import java.net.ServerSocket;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class PeriodicRecovery
extends Thread {
    private Vector _recoveryModules;
    private int _backoffPeriod;
    private int _recoveryPeriod;
    public static final int _defaultBackoffPeriod = 10;
    public static final int _defaultRecoveryPeriod = 120;
    private final Object _stateLock;
    private Status _currentStatus;
    private Mode _currentMode;
    private boolean _workerScanRequested;
    private SimpleDateFormat _theTimestamper;
    private ServerSocket _socket;
    private final Object _socketLock;
    private Listener _listener;
    private WorkerService _workerService;

    public PeriodicRecovery(boolean threaded, boolean useListener) {
        block8: {
            super("Periodic Recovery");
            this._recoveryModules = null;
            this._backoffPeriod = 0;
            this._recoveryPeriod = 0;
            this._stateLock = new Object();
            this._workerScanRequested = false;
            this._theTimestamper = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");
            this._socket = null;
            this._socketLock = new Object();
            this._listener = null;
            this._workerService = null;
            this.initialise();
            this.loadModules();
            if (useListener) {
                try {
                    this._workerService = new WorkerService(this);
                    this._listener = new Listener(this.getServerSocket(), (Service)this._workerService);
                    this._listener.setDaemon(true);
                    if (tsLogger.arjLoggerI18N.isInfoEnabled()) {
                        tsLogger.arjLoggerI18N.info("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_13", new Object[]{this._socket.getInetAddress().getHostAddress(), this._socket.getLocalPort()});
                    }
                }
                catch (Exception ex) {
                    if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block8;
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_9", new Object[]{ex});
                }
            }
        }
        if (threaded) {
            if (tsLogger.arjLogger.isDebugEnabled()) {
                tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: starting background scanner thread");
            }
            this.start();
        }
        if (useListener && this._listener != null) {
            if (tsLogger.arjLogger.isDebugEnabled()) {
                tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: starting listener worker thread");
            }
            this._listener.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean async) {
        if (this._listener != null) {
            this._listener.stopListener();
        }
        Object object = this._stateLock;
        synchronized (object) {
            if (this.getMode() != Mode.TERMINATED) {
                if (tsLogger.arjLogger.isDebugEnabled()) {
                    tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: Mode <== TERMINATED");
                }
                this.setMode(Mode.TERMINATED);
                this._stateLock.notifyAll();
            }
            if (!async) {
                while (this.getStatus() == Status.SCANNING) {
                    try {
                        if (tsLogger.arjLogger.isDebugEnabled()) {
                            tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: shutdown waiting for scan to end");
                        }
                        this._stateLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (tsLogger.arjLogger.isDebugEnabled()) {
                    tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: shutdown scan wait complete");
                }
            }
        }
        if (!async && this.isAlive()) {
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendScan(boolean async) {
        Object object = this._stateLock;
        synchronized (object) {
            if (this.getMode() == Mode.ENABLED) {
                if (tsLogger.arjLogger.isDebugEnabled()) {
                    tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: Mode <== SUSPENDED");
                }
                this.setMode(Mode.SUSPENDED);
                this._stateLock.notifyAll();
            }
            if (!async) {
                while (this.getStatus() == Status.SCANNING) {
                    try {
                        if (tsLogger.arjLogger.isDebugEnabled()) {
                            tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: suspendScan waiting for scan to end");
                        }
                        this._stateLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!tsLogger.arjLogger.isDebugEnabled()) continue;
                    tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: suspendScan scan wait compelete");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeScan() {
        Object object = this._stateLock;
        synchronized (object) {
            if (this.getMode() == Mode.SUSPENDED) {
                if (tsLogger.arjLogger.isDebugEnabled()) {
                    tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: Mode <== ENABLED");
                }
                this.setMode(Mode.ENABLED);
                this._stateLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerSocket getServerSocket() throws IOException {
        Object object = this._socketLock;
        synchronized (object) {
            if (this._socket == null) {
                this._socket = new ServerSocket(RecoveryManager.getRecoveryManagerPort(), 50, RecoveryManager.getRecoveryManagerHost());
            }
            return this._socket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean finished = false;
        do {
            boolean workToDo = false;
            Object object = this._stateLock;
            synchronized (object) {
                if (this.getStatus() == Status.SCANNING) {
                    if (tsLogger.arjLogger.isDebugEnabled()) {
                        tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: background thread waiting on other scan");
                    }
                    this.doScanningWait();
                    if (this.getMode() == Mode.ENABLED) {
                        if (tsLogger.arjLogger.isDebugEnabled()) {
                            tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: background thread backing off");
                        }
                        this.doPeriodicWait();
                        finished = this.getMode() == Mode.TERMINATED;
                    }
                } else {
                    switch (this.getMode()) {
                        case ENABLED: {
                            if (tsLogger.arjLogger.isDebugEnabled()) {
                                tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: background thread Status <== SCANNING");
                            }
                            this.setStatus(Status.SCANNING);
                            this._stateLock.notifyAll();
                            workToDo = true;
                            break;
                        }
                        case SUSPENDED: {
                            if (tsLogger.arjLogger.isDebugEnabled()) {
                                tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: background thread wait while SUSPENDED");
                            }
                            this.doSuspendedWait();
                            finished = this.getMode() == Mode.TERMINATED;
                            break;
                        }
                        case TERMINATED: {
                            finished = true;
                        }
                    }
                }
            }
            if (!workToDo) continue;
            if (tsLogger.arjLogger.isDebugEnabled()) {
                tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: background thread scanning");
            }
            this.doWorkInternal();
            object = this._stateLock;
            synchronized (object) {
                if (tsLogger.arjLogger.isDebugEnabled()) {
                    tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: background thread Status <== INACTIVE");
                }
                this.setStatus(Status.INACTIVE);
                this._stateLock.notifyAll();
                this.notifyWorker();
                if (this.getMode() == Mode.ENABLED) {
                    if (tsLogger.arjLogger.isDebugEnabled()) {
                        tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: background thread backing off");
                    }
                    this.doPeriodicWait();
                }
                finished = this.getMode() == Mode.TERMINATED;
            }
        } while (!finished);
        Object object = this._stateLock;
        synchronized (object) {
            this.notifyWorker();
        }
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: background thread exiting");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doWork() {
        boolean workToDo = false;
        Object object = this._stateLock;
        synchronized (object) {
            if (this.getMode() == Mode.SUSPENDED) {
                if (tsLogger.arjLogger.isDebugEnabled()) {
                    tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: ad hoc thread wait while SUSPENDED");
                }
                this.doSuspendedWait();
            }
            if (this.getMode() == Mode.TERMINATED) {
                if (tsLogger.arjLogger.isDebugEnabled()) {
                    tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: ad hoc thread scan TERMINATED");
                }
            } else if (this.getStatus() == Status.SCANNING) {
                if (tsLogger.arjLogger.isDebugEnabled()) {
                    tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: ad hoc thread waiting on other scan");
                }
                this.doScanningWait();
            } else {
                this.setStatus(Status.SCANNING);
                this._stateLock.notifyAll();
                if (tsLogger.arjLogger.isDebugEnabled()) {
                    tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: ad hoc thread Status <== SCANNING");
                }
                workToDo = true;
            }
        }
        if (workToDo) {
            if (tsLogger.arjLogger.isDebugEnabled()) {
                tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: ad hoc thread scanning");
            }
            this.doWorkInternal();
            object = this._stateLock;
            synchronized (object) {
                if (tsLogger.arjLogger.isDebugEnabled()) {
                    tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: ad hoc thread Status <== INACTIVE");
                }
                this.setStatus(Status.INACTIVE);
                this._stateLock.notifyAll();
                this.notifyWorker();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUp() {
        Object object = this._stateLock;
        synchronized (object) {
            this._workerScanRequested = true;
            if (this.getStatus() != Status.SCANNING) {
                if (tsLogger.arjLogger.isDebugEnabled()) {
                    tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: listener worker interrupts background thread");
                }
                this._stateLock.notifyAll();
            }
        }
    }

    public final void addModule(RecoveryModule module) {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: adding module " + module.getClass().getName());
        }
        this._recoveryModules.add(module);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeModule(RecoveryModule module, boolean waitOnScan) {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: removing module " + module.getClass().getName());
        }
        if (waitOnScan) {
            Object object = this._stateLock;
            synchronized (object) {
                this.doScanningWait();
            }
        }
        this._recoveryModules.remove(module);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeAllModules(boolean waitOnScan) {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: removing all modules.");
        }
        if (waitOnScan) {
            Object object = this._stateLock;
            synchronized (object) {
                this.doScanningWait();
            }
        }
        this._recoveryModules.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Vector getModules() {
        Vector vector = this._recoveryModules;
        synchronized (vector) {
            return new Vector(this._recoveryModules);
        }
    }

    public Listener getListener() {
        return this._listener;
    }

    private Status getStatus() {
        return this._currentStatus;
    }

    public Mode getMode() {
        return this._currentMode;
    }

    private void setStatus(Status status) {
        this._currentStatus = status;
    }

    private void setMode(Mode mode) {
        this._currentMode = mode;
    }

    private void doBackoffWait() {
        try {
            this._stateLock.wait(this._backoffPeriod * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void doPeriodicWait() {
        try {
            this._stateLock.wait(this._recoveryPeriod * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void doSuspendedWait() {
        while (this.getMode() == Mode.SUSPENDED) {
            try {
                this._stateLock.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void doScanningWait() {
        while (this.getStatus() == Status.SCANNING) {
            try {
                this._stateLock.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWorkInternal() {
        ClassLoader cl;
        Object m;
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("Periodic recovery - first pass <" + this._theTimestamper.format(new Date()) + ">");
        }
        Enumeration modules = this.getModules().elements();
        while (modules.hasMoreElements()) {
            m = (RecoveryModule)modules.nextElement();
            cl = this.switchClassLoader((RecoveryModule)m);
            try {
                m.periodicWorkFirstPass();
            }
            finally {
                this.restoreClassLoader(cl);
            }
            if (!tsLogger.arjLogger.isDebugEnabled()) continue;
            tsLogger.arjLogger.debug(16L, 4L, 2048L, " ");
        }
        m = this._stateLock;
        synchronized (m) {
            this.doBackoffWait();
            if (this.getMode() == Mode.TERMINATED) {
                if (tsLogger.arjLogger.isDebugEnabled()) {
                    tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: scan TERMINATED at phase 1");
                }
                return;
            }
        }
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("Periodic recovery - second pass <" + this._theTimestamper.format(new Date()) + ">");
        }
        modules = this._recoveryModules.elements();
        while (modules.hasMoreElements()) {
            m = (RecoveryModule)modules.nextElement();
            cl = this.switchClassLoader((RecoveryModule)m);
            try {
                m.periodicWorkSecondPass();
            }
            finally {
                this.restoreClassLoader(cl);
            }
            if (!tsLogger.arjLogger.isDebugEnabled()) continue;
            tsLogger.arjLogger.debug(16L, 4L, 2048L, " ");
        }
    }

    private void notifyWorker() {
        if (this._workerScanRequested) {
            if (tsLogger.arjLogger.isDebugEnabled()) {
                tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: scan thread signals listener worker");
            }
            if (this._workerService != null) {
                this._workerService.notifyDone();
            }
            this._workerScanRequested = false;
        }
    }

    private ClassLoader switchClassLoader(RecoveryModule rm) {
        Thread currentThread = Thread.currentThread();
        ClassLoader cl = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(rm.getClass().getClassLoader());
        return cl;
    }

    private void restoreClassLoader(ClassLoader cl) {
        Thread currentThread = Thread.currentThread();
        currentThread.setContextClassLoader(cl);
    }

    private void loadModules() {
        Vector<String> moduleNames = new Vector<String>(recoveryPropertyManager.getRecoveryEnvironmentBean().getRecoveryExtensions());
        for (String moduleName : moduleNames) {
            this.loadModule(moduleName);
        }
    }

    private void loadModule(String className) {
        block12: {
            if (tsLogger.arjLogger.isDebugEnabled()) {
                tsLogger.arjLogger.debug(16L, 1L, 2048L, "Loading recovery module " + className);
            }
            if (className == null) {
                if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_1");
                }
                return;
            }
            try {
                Class<?> c;
                block11: {
                    c = Thread.currentThread().getContextClassLoader().loadClass(className);
                    try {
                        RecoveryModule m = (RecoveryModule)c.newInstance();
                        this._recoveryModules.add(m);
                    }
                    catch (ClassCastException e) {
                        if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_2", new Object[]{className});
                        }
                    }
                    catch (IllegalAccessException iae) {
                        if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_3", new Object[]{iae});
                        }
                    }
                    catch (InstantiationException ie) {
                        if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block11;
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_4", new Object[]{ie});
                    }
                }
                c = null;
            }
            catch (ClassNotFoundException cnfe) {
                if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block12;
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_5", new Object[]{className});
            }
        }
    }

    private void initialise() {
        this._recoveryModules = new Vector();
        this.setStatus(Status.INACTIVE);
        this.setMode(Mode.ENABLED);
        this._recoveryPeriod = recoveryPropertyManager.getRecoveryEnvironmentBean().getPeriodicRecoveryPeriod();
        if (this._recoveryPeriod != 120 && tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug(16L, 1L, 2048L, "com.arjuna.ats.arjuna.recovery.PeriodicRecovery: Recovery period set to " + this._recoveryPeriod + " seconds");
        }
        this._backoffPeriod = recoveryPropertyManager.getRecoveryEnvironmentBean().getRecoveryBackoffPeriod();
        if (this._backoffPeriod != 10 && tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug(16L, 1L, 2048L, "PeriodicRecovery: Backoff period set to " + this._backoffPeriod + " seconds");
        }
    }

    public static enum Mode {
        ENABLED,
        SUSPENDED,
        TERMINATED;

    }

    public static enum Status {
        INACTIVE,
        SCANNING;

    }
}

