/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.utils;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.arjuna.xa.XID;

public class XATxConverter {
    public static final int FORMAT_ID = 131075;
    public static final char NODE_SEPARATOR = '#';

    public static XID getXid(Uid uid, boolean branch) throws IllegalStateException {
        return XATxConverter.getXid(uid, branch, 131075);
    }

    public static XID getXid(Uid uid, boolean branch, int formatId) throws IllegalStateException {
        if (branch) {
            return XATxConverter.getXid(uid, new Uid(), formatId);
        }
        return XATxConverter.getXid(uid, Uid.nullUid(), formatId);
    }

    public static XID getXid(Uid uid, Uid branch, int formatId) throws IllegalStateException {
        if (uid == null) {
            throw new IllegalStateException();
        }
        byte[] nodeName = TxControl.getXANodeName();
        String s = uid.stringForm();
        int uidLen = s.length() + nodeName.length + 1;
        if (uidLen > 64) {
            throw new IllegalStateException();
        }
        try {
            XID xid = new XID();
            xid.formatID = formatId;
            xid.gtrid_length = uidLen;
            System.arraycopy(nodeName, 0, xid.data, 0, nodeName.length);
            xid.data[nodeName.length] = 35;
            byte[] b = s.getBytes();
            System.arraycopy(b, 0, xid.data, nodeName.length + 1, b.length);
            if (branch.notEquals(Uid.nullUid())) {
                String bs = branch.stringForm();
                int bsLen = bs.length();
                b = bs.getBytes();
                if (bsLen > 64) {
                    throw new IllegalStateException();
                }
                xid.bqual_length = bsLen;
                System.arraycopy(b, 0, xid.data, xid.gtrid_length, bsLen);
                bs = null;
            } else {
                xid.data[xid.gtrid_length] = 0;
                xid.bqual_length = 64;
            }
            b = null;
            s = null;
            return xid;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e.toString());
        }
    }

    public static Uid getUid(XID xid) {
        if (xid == null) {
            return Uid.nullUid();
        }
        if (xid.formatID == -1 || xid.gtrid_length <= 0) {
            return Uid.nullUid();
        }
        int nodeNameIndex = 0;
        for (int i = 0; i < xid.gtrid_length; ++i) {
            if (xid.data[i] != 35) continue;
            nodeNameIndex = i + 1;
            break;
        }
        byte[] buff = new byte[xid.gtrid_length - nodeNameIndex];
        System.arraycopy(xid.data, nodeNameIndex, buff, 0, buff.length);
        Uid tx2 = new Uid(new String(buff), true);
        buff = null;
        return tx2;
    }

    public static Uid getBranch(XID xid) {
        return null;
    }
}

