/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.recovery.contact;

import com.arjuna.ArjunaOTS.ArjunaFactory;
import com.arjuna.ArjunaOTS.ArjunaFactoryHelper;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.objectstore.ObjectStore;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.arjuna.utils.Utility;
import com.arjuna.ats.internal.jts.ORBManager;
import com.arjuna.ats.jts.logging.jtsLogger;
import java.io.IOException;
import java.util.Date;
import org.omg.CORBA.Object;

public class FactoryContactItem {
    private static final String _pseudoTypeName = "/Recovery/FactoryContact";
    private static final int version = 1;
    private static ObjectStore _objectStore = null;
    private static FactoryContactItem _theSingularItem = null;
    private Date _creationTime = null;
    private Date _aliveTime = null;
    private Date _deadTime = null;
    private ArjunaFactory _factory = null;
    private Uid _uid = null;

    static boolean createAndSave(ArjunaFactory factory) {
        if (_theSingularItem == null) {
            _theSingularItem = new FactoryContactItem(factory);
            return _theSingularItem.saveMe();
        }
        return true;
    }

    static FactoryContactItem recreate(Uid uid) {
        FactoryContactItem theItem = new FactoryContactItem(uid);
        if (theItem.restoreMe()) {
            return theItem;
        }
        return null;
    }

    static ObjectStore getStore() {
        if (_objectStore == null) {
            _objectStore = TxControl.getStore();
        }
        return _objectStore;
    }

    static String getTypeName() {
        return _pseudoTypeName;
    }

    ArjunaFactory getFactory() {
        return this._factory;
    }

    Date getCreationTime() {
        return this._creationTime;
    }

    Date getAliveTime() {
        return this._aliveTime;
    }

    Date getDeadTime() {
        return this._deadTime;
    }

    Uid getUid() {
        return this._uid;
    }

    void markAsDead() {
        if (this._factory != null) {
            this._factory = null;
            this._deadTime = new Date();
            this.saveMe();
        }
    }

    void markAsAlive() {
        this._aliveTime = new Date();
    }

    private FactoryContactItem(ArjunaFactory factory) {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 2048L, "FactoryContactItem(factory)");
        }
        this._uid = Utility.getProcessUid();
        this._factory = factory;
        this._creationTime = new Date();
    }

    private FactoryContactItem(Uid uid) {
        this._uid = new Uid(uid);
    }

    private boolean save_state(OutputObjectState objstate) {
        try {
            objstate.packInt(1);
            objstate.packLong(this._creationTime.getTime());
            if (this._factory != null) {
                String iorAsString = ORBManager.getORB().orb().object_to_string((Object)this._factory);
                objstate.packString(iorAsString);
            } else {
                objstate.packString("");
                objstate.packLong(this._deadTime.getTime());
            }
            return true;
        }
        catch (IOException ex) {
            jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.recovery.contact.FactoryContactItem_1", new java.lang.Object[]{ex});
        }
        catch (Exception exp) {
            jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.recovery.contact.FactoryContactItem_1", new java.lang.Object[]{exp});
        }
        return false;
    }

    private boolean restore_state(InputObjectState objstate) {
        try {
            int oldversion = objstate.unpackInt();
            if (oldversion != 1) {
                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.recovery.contact.FactoryContactItem_2");
            }
            long oldtime = objstate.unpackLong();
            this._creationTime = new Date(oldtime);
            String iorAsString = objstate.unpackString();
            if (iorAsString.length() > 1) {
                Object corbject = ORBManager.getORB().orb().string_to_object(iorAsString);
                this._factory = ArjunaFactoryHelper.narrow(corbject);
                if (this._factory == null) {
                    jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.recovery.contact.FactoryContactItem_3");
                }
                this._deadTime = null;
            } else {
                this._factory = null;
                oldtime = objstate.unpackLong();
                this._deadTime = new Date(oldtime);
            }
            this._aliveTime = null;
            return true;
        }
        catch (IOException ex) {
            jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.recovery.contact.FactoryContactItem_4", new java.lang.Object[]{ex});
        }
        catch (Exception exp) {
            jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.recovery.contact.FactoryContactItem_4", new java.lang.Object[]{exp});
        }
        return false;
    }

    private boolean saveMe() {
        try {
            OutputObjectState objstate = new OutputObjectState();
            if (this.save_state(objstate)) {
                FactoryContactItem.getStore().write_committed(this._uid, _pseudoTypeName, objstate);
                return true;
            }
        }
        catch (ObjectStoreException exo) {
            jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.recovery.contact.FactoryContactItem_1", new java.lang.Object[]{exo});
        }
        return false;
    }

    private boolean restoreMe() {
        try {
            InputObjectState objstate = FactoryContactItem.getStore().read_committed(this._uid, _pseudoTypeName);
            if (objstate == null) {
                return false;
            }
            if (this.restore_state(objstate)) {
                return true;
            }
            jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.recovery.contact.FactoryContactItem_5");
        }
        catch (ObjectStoreException exo) {
            jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.recovery.contact.FactoryContactItem_6");
        }
        return false;
    }

    private static boolean removeMe(Uid uid) {
        try {
            return FactoryContactItem.getStore().remove_committed(uid, _pseudoTypeName);
        }
        catch (ObjectStoreException exo) {
            jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.recovery.contact.FactoryContactItem_7", new java.lang.Object[]{exo});
            return false;
        }
    }
}

