/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.tsmx.mbeans;

import com.arjuna.ats.internal.tsmx.mbeans.MappingsNotFoundException;
import com.arjuna.common.util.exceptions.SavePropertiesException;
import com.arjuna.common.util.propertyservice.propertycontainer.PropertyManagerPluginInterface;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class PropertyServiceMBeanWrapper
implements DynamicMBean {
    private static final String PROPERTY_FILE_MBEAN_OBJECT_NAME_PREFIX = "com.arjuna.ats.properties:module=";
    private static final String MAPPINGS_FILENAME_SUFFIX = "-properties.mappings";
    private static final String COMMENT_PREFIX = "#";
    private PropertyManagerPluginInterface _pm = null;
    private ArrayList _attributeMapping = new ArrayList();
    private MBeanInfo _info = null;
    private Hashtable _comment = new Hashtable();
    private ArrayList _propertyMapping = new ArrayList();

    PropertyServiceMBeanWrapper(PropertyManagerPluginInterface pm) throws MappingsNotFoundException {
        this._pm = pm;
        this.retrievePropertyToAttributeMappings(pm.getName());
    }

    public void save() throws IOException, SavePropertiesException, ClassNotFoundException {
        this._pm.save(null, null);
    }

    private void retrievePropertyToAttributeMappings(String name) throws MappingsNotFoundException {
        InputStream mappingsIn = Thread.currentThread().getContextClassLoader().getResourceAsStream(name + MAPPINGS_FILENAME_SUFFIX);
        if (mappingsIn != null) {
            try {
                String mapping;
                BufferedReader in = new BufferedReader(new InputStreamReader(mappingsIn));
                String comment = null;
                while ((mapping = in.readLine()) != null) {
                    if (mapping.startsWith(COMMENT_PREFIX)) {
                        if (mapping.length() <= 1) continue;
                        comment = mapping.substring(1);
                        continue;
                    }
                    if (mapping.indexOf(61) == -1) {
                        throw new MappingsNotFoundException("A valid property-to-attribute was not found (" + name + MAPPINGS_FILENAME_SUFFIX + ")");
                    }
                    this._propertyMapping.add(mapping.substring(0, mapping.indexOf(61)));
                    this._attributeMapping.add(mapping.substring(mapping.indexOf(61) + 1));
                    if (comment != null) {
                        this._comment.put(mapping.substring(0, mapping.indexOf(61)), comment);
                    }
                    comment = null;
                }
                in.close();
            }
            catch (IOException e) {
                throw new MappingsNotFoundException("Failed to load property-to-attribute mappings (" + name + MAPPINGS_FILENAME_SUFFIX + ")", e);
            }
        } else {
            throw new MappingsNotFoundException("Failed to find property-to-attribute mappings (" + name + MAPPINGS_FILENAME_SUFFIX + ")");
        }
    }

    private String getPropertyForAttribute(String attributeName) {
        String property = null;
        int index = this._attributeMapping.indexOf(attributeName);
        if (index != -1) {
            property = (String)this._propertyMapping.get(index);
        }
        return property;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        String property;
        if (this._attributeMapping.contains(attribute.getName())) {
            property = this.getPropertyForAttribute(attribute.getName());
            if (property == null) {
                throw new AttributeNotFoundException("Attribute-to-property mapping not found for: " + attribute.getName());
            }
        } else {
            throw new AttributeNotFoundException("Attribute '" + attribute.getName() + "' does not exist within this property manager");
        }
        this._pm.setProperty(property, (String)attribute.getValue());
    }

    @Override
    public AttributeList setAttributes(AttributeList attributeList) {
        AttributeList returnList = new AttributeList();
        for (int count = 0; count < attributeList.size(); ++count) {
            Attribute attribute = (Attribute)attributeList.get(count);
            if (!this._attributeMapping.contains(attribute.getName())) continue;
            try {
                this.setAttribute(attribute);
                returnList.add(attribute);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return returnList;
    }

    @Override
    public Object getAttribute(String s) throws AttributeNotFoundException, MBeanException, ReflectionException {
        String returnValue = null;
        if (this._attributeMapping.contains(s)) {
            returnValue = this._pm.getProperty(this.getPropertyForAttribute(s), null);
        }
        if (returnValue == null) {
            throw new AttributeNotFoundException("The attribute '" + s + "' is not defined");
        }
        return returnValue;
    }

    @Override
    public AttributeList getAttributes(String[] strings) {
        AttributeList returnList = new AttributeList(strings.length);
        for (int count = 0; count < strings.length; ++count) {
            try {
                returnList.add(new Attribute(strings[count], this.getAttribute(strings[count])));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return returnList;
    }

    @Override
    public Object invoke(String methodName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (methodName.equals("save") && params.length == 0) {
            try {
                this.save();
            }
            catch (Exception e) {
                throw new MBeanException(e);
            }
        }
        return null;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        if (this._info == null) {
            this._info = new MBeanInfo(this.getClass().getName(), "This is a mbean representing the properties stored in '" + this._pm.getName() + "'", this.getAttributeInfo(), null, this.getOperationInfo(), null);
        }
        return this._info;
    }

    private MBeanOperationInfo[] getOperationInfo() {
        MBeanOperationInfo saveOperation = null;
        try {
            saveOperation = new MBeanOperationInfo("Save the properties", this.getClass().getMethod("save", null));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return new MBeanOperationInfo[]{saveOperation};
    }

    private MBeanAttributeInfo[] getAttributeInfo() {
        ArrayList<MBeanAttributeInfo> attributes = new ArrayList<MBeanAttributeInfo>();
        Properties p = new Properties();
        p.putAll((Map<?, ?>)this._pm.getLocalProperties());
        Enumeration<Object> e = p.keys();
        while (e.hasMoreElements()) {
            int index;
            String propertyName = (String)e.nextElement();
            if (!this._propertyMapping.contains(propertyName) || (index = this._propertyMapping.indexOf(propertyName)) == -1) continue;
            String comment = (String)this._comment.get(propertyName);
            attributes.add(new MBeanAttributeInfo((String)this._attributeMapping.get(index), String.class.getName(), comment, true, true, false));
        }
        MBeanAttributeInfo[] attrInfo = new MBeanAttributeInfo[attributes.size()];
        attributes.toArray(attrInfo);
        return attrInfo;
    }

    public ObjectName getObjectName() throws MalformedObjectNameException {
        return new ObjectName(PROPERTY_FILE_MBEAN_OBJECT_NAME_PREFIX + this._pm.getName());
    }
}

