/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.common.internal.util.propertyservice;

import com.arjuna.common.util.exceptions.LoadPropertiesException;
import com.arjuna.common.util.exceptions.ManagementPluginException;
import com.arjuna.common.util.exceptions.SavePropertiesException;
import com.arjuna.common.util.propertyservice.plugins.PropertyManagementPlugin;
import com.arjuna.common.util.propertyservice.plugins.PropertyManagerIOPlugin;
import com.arjuna.common.util.propertyservice.propertycontainer.PropertyManagerPluginInterface;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public class PropertyManagerImpl
implements PropertyManagerPluginInterface {
    protected static boolean _verbose = false;
    protected Properties _properties;
    protected String _name;
    protected String _associatedUri = null;
    private String _associatedPluginClassname;

    public PropertyManagerImpl(String name) {
        this._name = name;
        this._properties = new Properties();
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getUri() {
        return this._associatedUri;
    }

    @Override
    public void setUri(String uri) {
        this._associatedUri = uri;
    }

    @Override
    public String getIOPluginClassname() {
        return this._associatedPluginClassname;
    }

    @Override
    public void setIOPluginClassname(String classname) {
        this._associatedPluginClassname = classname;
    }

    @Override
    public String getProperty(String name) {
        String value = System.getProperty(name);
        value = value != null ? value : this._properties.getProperty(name);
        return value;
    }

    @Override
    public String getProperty(String name, String defaultValue) {
        String value = this.getProperty(name);
        return value == null ? defaultValue : value;
    }

    @Override
    public String setProperty(String name, String value) {
        return this.setProperty(name, value, true);
    }

    @Override
    public String setProperty(String name, String value, boolean setSystemProperty) {
        if (setSystemProperty && System.getProperty(name) != null) {
            System.setProperty(name, value);
        }
        String oldValue = this._properties.getProperty(name);
        this._properties.setProperty(name, value);
        return oldValue;
    }

    @Override
    public String removeProperty(String name) {
        String oldValue;
        if (System.getProperty(name) != null) {
            System.getProperties().remove(name);
        }
        if ((oldValue = this._properties.getProperty(name)) != null) {
            this._properties.remove(name);
        }
        return oldValue;
    }

    @Override
    public Properties getLocalProperties() {
        return this._properties;
    }

    @Override
    public Properties getProperties() {
        Properties returnProps = (Properties)this._properties.clone();
        returnProps.putAll((Map<?, ?>)System.getProperties());
        return returnProps;
    }

    @Override
    public Enumeration propertyNames() {
        return this.getProperties().keys();
    }

    @Override
    public synchronized void load(String pluginClassname, String uri) throws IOException, ClassNotFoundException, LoadPropertiesException {
        try {
            String existingUri = this.getUri();
            if (existingUri != null && !existingUri.equals(uri)) {
                throw new LoadPropertiesException("Not allowed to reload from a different uri! [existing: " + existingUri + ", requested: " + uri + "]");
            }
            String classname = System.getProperty("com.arjuna.common.util.propertyservice.pluginclassname");
            classname = classname == null ? pluginClassname : classname;
            PropertyManagerIOPlugin plugin = (PropertyManagerIOPlugin)Thread.currentThread().getContextClassLoader().loadClass(classname).newInstance();
            plugin.load(uri, this, _verbose);
            this.setUri(uri);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LoadPropertiesException("Failed to instantiate plugin: " + e, e);
        }
    }

    @Override
    public synchronized void save(String pluginClassname, String uri) throws IOException, ClassNotFoundException, SavePropertiesException {
        try {
            String classname;
            if (pluginClassname == null) {
                pluginClassname = this._associatedPluginClassname;
            }
            classname = (classname = System.getProperty("com.arjuna.common.util.propertyservice.pluginclassname")) == null ? pluginClassname : classname;
            PropertyManagerIOPlugin plugin = (PropertyManagerIOPlugin)Thread.currentThread().getContextClassLoader().loadClass(pluginClassname).newInstance();
            plugin.save(uri, this);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new SavePropertiesException("Failed to instantiate plugin: " + e, e);
        }
    }

    @Override
    public boolean verbose() {
        return _verbose;
    }

    @Override
    public void addManagementPlugin(PropertyManagementPlugin plugin) throws IOException, ManagementPluginException {
        try {
            plugin.initialise(this);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ManagementPluginException(e.toString(), e);
        }
    }
}

