/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.common.internal.util.propertyservice.plugins.io;

import com.arjuna.common.util.exceptions.LoadPropertiesException;
import com.arjuna.common.util.exceptions.SavePropertiesException;
import com.arjuna.common.util.propertyservice.StringPropertyReplacer;
import com.arjuna.common.util.propertyservice.plugins.PropertyManagerIOPlugin;
import com.arjuna.common.util.propertyservice.propertycontainer.PropertyManagerPluginInterface;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;

public class XMLFilePlugin
implements PropertyManagerIOPlugin {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(String uri, PropertyManagerPluginInterface pcm, boolean verbose) throws LoadPropertiesException, IOException {
        try {
            InputStream inputStream = null;
            Properties propertiesFromSource = new Properties();
            inputStream = new File(uri).exists() ? new FileInputStream(uri) : new URL(uri).openStream();
            try {
                propertiesFromSource.loadFromXML(inputStream);
            }
            finally {
                inputStream.close();
            }
            Enumeration<?> namesEnumeration = propertiesFromSource.propertyNames();
            while (namesEnumeration.hasMoreElements()) {
                String propertyName = (String)namesEnumeration.nextElement();
                String propertyValue = propertiesFromSource.getProperty(propertyName);
                propertyValue = propertyValue.trim();
                propertyValue = StringPropertyReplacer.replaceProperties(propertyValue);
                pcm.setProperty(propertyName, propertyValue);
            }
        }
        catch (Exception e) {
            throw new LoadPropertiesException("Failed to load properties: " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(String uri, PropertyManagerPluginInterface pcm) throws SavePropertiesException, IOException {
        String string = uri = uri != null ? null : pcm.getUri();
        if (uri == null) {
            throw new SavePropertiesException("No uri is associated with this property manager");
        }
        Properties props = pcm.getLocalProperties();
        try {
            FileOutputStream out = new FileOutputStream(uri);
            try {
                props.storeToXML(out, null);
            }
            finally {
                out.close();
            }
        }
        catch (Exception e) {
            throw new SavePropertiesException("Failed to save properties: " + e, e);
        }
    }
}

