/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.common.util.logging;

import com.arjuna.common.internal.util.logging.AbstractLogInterface;
import com.arjuna.common.internal.util.logging.LogFactoryInterface;
import com.arjuna.common.internal.util.logging.LogImpl;
import com.arjuna.common.internal.util.logging.LogInterface;
import com.arjuna.common.internal.util.logging.LogNoi18nImpl;
import com.arjuna.common.internal.util.logging.commonPropertyManager;
import com.arjuna.common.util.exceptions.LogConfigurationException;
import com.arjuna.common.util.logging.LogNoi18n;
import com.arjuna.common.util.logging.Logi18n;
import java.lang.reflect.Constructor;

public class LogFactory {
    @Deprecated
    public static final String LOGGER_PROPERTY = "com.arjuna.common.util.logger";
    @Deprecated
    public static final String DEBUG_LEVEL = "com.arjuna.common.util.logging.DebugLevel";
    @Deprecated
    public static final String FACILITY_LEVEL = "com.arjuna.common.util.logging.FacilityLevel";
    @Deprecated
    public static final String VISIBILITY_LEVEL = "com.arjuna.common.util.logging.VisibilityLevel";
    private static final String JAKARTA_LOGGER = "jakarta";
    private static final String LOG4J = "log4j";
    private static final String JDK14 = "jdk14";
    private static final String SIMPLE = "simple";
    private static final String NOOP = "noop";
    private static final String RELEVELER = "log4j_releveler";
    private static LogFactoryInterface m_logFactory = null;
    private static boolean m_isInitialized = false;
    private static long m_debugLevel = 0L;
    private static long m_visLevel = -1L;
    private static long m_facLevel = -1L;

    public static LogNoi18n getLogNoi18n(String name) {
        LogNoi18nImpl log = null;
        LogFactory.setupLogSystem();
        AbstractLogInterface logInterface = m_logFactory.getLog(name);
        if (!(logInterface instanceof LogInterface)) {
            throw new RuntimeException("non i18n loggers are not supported for CSF!");
        }
        log = new LogNoi18nImpl((LogInterface)logInterface);
        log.setLevels(m_debugLevel, m_visLevel, m_facLevel);
        return log;
    }

    public static Logi18n getLogi18n(Class clazz) {
        LogImpl log = null;
        LogFactory.setupLogSystem();
        AbstractLogInterface logInterface = m_logFactory.getLog(clazz);
        log = new LogImpl((LogInterface)logInterface);
        log.setLevels(m_debugLevel, m_visLevel, m_facLevel);
        return log;
    }

    public static Logi18n getLogi18n(String name) {
        LogImpl log = null;
        LogFactory.setupLogSystem();
        AbstractLogInterface logInterface = m_logFactory.getLog(name);
        log = new LogImpl((LogInterface)logInterface, name);
        log.setLevels(m_debugLevel, m_visLevel, m_facLevel);
        return log;
    }

    public static Logi18n getLogi18n(Class clazz, String resBundle) {
        LogImpl log = null;
        LogFactory.setupLogSystem();
        AbstractLogInterface logInterface = m_logFactory.getLog(clazz);
        log = new LogImpl((LogInterface)logInterface, resBundle);
        log.setLevels(m_debugLevel, m_visLevel, m_facLevel);
        return log;
    }

    public static Logi18n getLogi18n(String name, String resBundle) {
        LogImpl log = null;
        LogFactory.setupLogSystem();
        AbstractLogInterface logInterface = m_logFactory.getLog(name);
        log = new LogImpl((LogInterface)logInterface, resBundle);
        log.setLevels(m_debugLevel, m_visLevel, m_facLevel);
        return log;
    }

    private static synchronized void setupLogSystem() {
        if (m_isInitialized) {
            return;
        }
        String debugLevel = "0xffffffff";
        String facLevel = "0xfffffff";
        String visLevel = "0xfffffff";
        String logSystem = NOOP;
        try {
            try {
                logSystem = commonPropertyManager.getLoggingEnvironmentBean().getLoggingSystem();
                debugLevel = commonPropertyManager.getLoggingEnvironmentBean().getDebugLevel();
                facLevel = commonPropertyManager.getLoggingEnvironmentBean().getFacilityLevel();
                visLevel = commonPropertyManager.getLoggingEnvironmentBean().getVisibilityLevel();
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                m_debugLevel = Long.decode(debugLevel);
            }
            catch (NumberFormatException nfe) {
                m_debugLevel = 0L;
            }
            try {
                m_facLevel = Long.decode(facLevel);
            }
            catch (NumberFormatException nfe) {
                m_debugLevel = 0xFFFFFFFL;
            }
            try {
                m_visLevel = Long.decode(visLevel);
            }
            catch (NumberFormatException nfe) {
                m_debugLevel = 0xFFFFFFFL;
            }
            m_logFactory = logSystem.equals(LOG4J) ? LogFactory.loadFactory("com.arjuna.common.internal.util.logging.jakarta.JakartaLogFactory", "com.arjuna.common.internal.util.logging.jakarta.Log4JLogger") : (logSystem.equals(JDK14) ? LogFactory.loadFactory("com.arjuna.common.internal.util.logging.jakarta.JakartaLogFactory", "org.apache.commons.logging.impl.Jdk14Logger") : (logSystem.equals(SIMPLE) ? LogFactory.loadFactory("com.arjuna.common.internal.util.logging.jakarta.JakartaLogFactory", "org.apache.commons.logging.impl.SimpleLog") : (logSystem.equals(NOOP) ? LogFactory.loadFactory("com.arjuna.common.internal.util.logging.jakarta.JakartaLogFactory", "org.apache.commons.logging.impl.NoOpLog") : (logSystem.equals(RELEVELER) ? LogFactory.loadFactory("com.arjuna.common.internal.util.logging.jakarta.JakartaRelevelingLogFactory", "com.arjuna.common.internal.util.logging.jakarta.Log4JLogger") : (logSystem.equals(JAKARTA_LOGGER) ? LogFactory.loadFactory("com.arjuna.common.internal.util.logging.jakarta.JakartaLogFactory", null) : LogFactory.loadFactory("com.arjuna.common.internal.util.logging.jakarta.JakartaLogFactory", null))))));
        }
        catch (LogConfigurationException e) {
            throw new RuntimeException("An unexpected exception occurred while creating the logger factory: " + e.getMessage(), e);
        }
        m_isInitialized = true;
    }

    private static LogFactoryInterface loadFactory(String classname, String arg) throws LogConfigurationException {
        try {
            Class<?> factoryClass = Thread.currentThread().getContextClassLoader().loadClass(classname);
            LogFactoryInterface logFactoryInterface = null;
            if (arg == null) {
                logFactoryInterface = (LogFactoryInterface)factoryClass.newInstance();
            } else {
                Constructor<?> ctor = factoryClass.getConstructor(String.class);
                logFactoryInterface = (LogFactoryInterface)ctor.newInstance(arg);
            }
            return logFactoryInterface;
        }
        catch (Exception e) {
            throw new LogConfigurationException(e);
        }
    }
}

