/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.orbportability;

import com.arjuna.orbportability.ORBData;
import com.arjuna.orbportability.ORBType;
import com.arjuna.orbportability.internal.utils.SimpleXMLParser;
import com.arjuna.orbportability.logging.opLogger;
import java.text.MessageFormat;

public class ORBInfo {
    private static final String NAME_ELEMENT = "name";
    private static final String VERSION_ELEMENT = "version";
    private static final String CORBA_VERSION_ELEMENT = "corba-version";
    private static final String MAJOR_ELEMENT = "major";
    private static final String MINOR_ELEMENT = "minor";
    private static ORBData _theData = null;
    private static SimpleXMLParser _xml = null;
    private static final String _versionPackage = "com.arjuna.orbportability.internal.orbspecific.versions";

    public static final String getInfo() {
        return _theData.getORBdata();
    }

    public static final int getOrbEnumValue() {
        return ORBType.getORBEnum(ORBInfo.getOrbName());
    }

    public static final String getOrbName() {
        String name = "";
        try {
            name = _xml.getElementString(NAME_ELEMENT);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }

    public static final int getOrbMajorVersion() {
        int majorVersion = -1;
        try {
            SimpleXMLParser versionParser = _xml.getElementParser(VERSION_ELEMENT);
            majorVersion = Integer.parseInt(versionParser.getElementString(MAJOR_ELEMENT));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return majorVersion;
    }

    public static final int getOrbMinorVersion() {
        int minorVersion = -1;
        try {
            SimpleXMLParser versionParser = _xml.getElementParser(VERSION_ELEMENT);
            minorVersion = Integer.parseInt(versionParser.getElementString(MINOR_ELEMENT));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return minorVersion;
    }

    public static final int getCorbaMajorVersion() {
        int majorVersion = -1;
        try {
            SimpleXMLParser versionParser = _xml.getElementParser(CORBA_VERSION_ELEMENT);
            majorVersion = Integer.parseInt(versionParser.getElementString(MAJOR_ELEMENT));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return majorVersion;
    }

    public static final int getCorbaMinorVersion() {
        int minorVersion = -1;
        try {
            SimpleXMLParser versionParser = _xml.getElementParser(CORBA_VERSION_ELEMENT);
            minorVersion = Integer.parseInt(versionParser.getElementString(MINOR_ELEMENT));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return minorVersion;
    }

    public static final ORBData orbData() {
        return _theData;
    }

    static {
        String className = null;
        try {
            Thread.currentThread().getContextClassLoader().loadClass("org.jacorb.orb.ORB");
            className = "com.arjuna.orbportability.internal.orbspecific.versions.jacorb_2_0";
        }
        catch (ClassNotFoundException je) {
            try {
                Thread.currentThread().getContextClassLoader().loadClass("com.sun.corba.se.internal.Interceptors.PIORB");
                className = "com.arjuna.orbportability.internal.orbspecific.versions.javaidl_1_4";
            }
            catch (ClassNotFoundException joe) {
                if (opLogger.loggerI18N.isFatalEnabled()) {
                    opLogger.loggerI18N.fatal("com.arjuna.orbportability.ORBInfo.unsupportedorb", joe);
                }
                throw new ExceptionInInitializerError(opLogger.logMesg.getString("com.arjuna.orbportability.ORBInfo.unsupportedorb"));
            }
        }
        try {
            Class<?> c = Thread.currentThread().getContextClassLoader().loadClass(className);
            _theData = (ORBData)c.newInstance();
            _xml = new SimpleXMLParser(_theData.getORBdata());
        }
        catch (Exception e) {
            if (opLogger.loggerI18N.isFatalEnabled()) {
                opLogger.loggerI18N.fatal("com.arjuna.orbportability.ORBInfo.creationfailed", new Object[]{e});
            }
            throw new ExceptionInInitializerError(MessageFormat.format(opLogger.logMesg.getString("com.arjuna.orbportability.ORBInfo.creationfailed"), e));
        }
    }
}

