/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna;

import com.arjuna.ats.arjuna.ArjunaNames;
import com.arjuna.ats.arjuna.CadaverRecord;
import com.arjuna.ats.arjuna.StateManager;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.gandiva.ClassName;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ObjectStore;
import com.arjuna.ats.arjuna.objectstore.ObjectStoreType;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import java.io.IOException;
import java.io.PrintWriter;

public class DisposeRecord
extends CadaverRecord {
    private Uid objectUid;
    private String typeName;
    private ObjectStore store;

    public DisposeRecord(ObjectStore objStore, StateManager sm) {
        super(null, objStore, sm);
        this.store = objStore;
        if (sm != null) {
            this.objectUid = sm.get_uid();
            this.typeName = sm.type();
        } else {
            this.objectUid = Uid.nullUid();
            this.typeName = null;
        }
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(1L, 4L, 8L, "DisposeRecord::DisposeRecord(" + objStore + ", " + this.objectUid + ")");
        }
    }

    @Override
    public boolean propagateOnAbort() {
        return false;
    }

    @Override
    public int typeIs() {
        return 211;
    }

    @Override
    public ClassName className() {
        return ArjunaNames.Implementation_AbstractRecord_CadaverRecord_DisposeRecord();
    }

    @Override
    public int nestedAbort() {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 8L, "DisposeRecord::nestedAbort() for " + this.order());
        }
        return 7;
    }

    @Override
    public int nestedCommit() {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 8L, "DisposeRecord::nestedCommit() for " + this.order());
        }
        return 7;
    }

    @Override
    public int nestedPrepare() {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 8L, "DisposeRecord::nestedPrepare() for " + this.order());
        }
        if (this.store != null && this.objectUid.notEquals(Uid.nullUid())) {
            return 0;
        }
        return 1;
    }

    @Override
    public int topLevelAbort() {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 8L, "DisposeRecord::topLevelAbort() for " + this.order());
        }
        return 7;
    }

    @Override
    public int topLevelCommit() {
        block6: {
            if (tsLogger.arjLogger.debugAllowed()) {
                tsLogger.arjLogger.debug(16L, 4L, 8L, "DisposeRecord::topLevelCommit() for " + this.order());
            }
            if (this.store != null && this.objectUid.notEquals(Uid.nullUid())) {
                try {
                    if (this.store.remove_committed(this.objectUid, this.typeName)) {
                        if (this.objectAddr != null) {
                            this.objectAddr.destroyed();
                        }
                        return 7;
                    }
                }
                catch (Exception e) {
                    if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block6;
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.DisposeRecord_5", new Object[]{e});
                }
            }
        }
        return 8;
    }

    @Override
    public int topLevelPrepare() {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 8L, "DisposeRecord::topLevelPrepare() for " + this.order());
        }
        if (this.store != null && this.objectUid.notEquals(Uid.nullUid())) {
            return 0;
        }
        return 1;
    }

    @Override
    public void print(PrintWriter strm) {
        strm.println("Dispose for:");
        super.print(strm);
    }

    @Override
    public boolean doSave() {
        return true;
    }

    @Override
    public boolean save_state(OutputObjectState os, int ot) {
        boolean res = true;
        if (this.store != null && this.objectUid.notEquals(Uid.nullUid())) {
            if (!ObjectStoreType.valid(this.store.typeIs())) {
                if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.DisposeRecord_1");
                }
                res = false;
            } else {
                try {
                    os.packInt(this.store.typeIs());
                    this.store.pack(os);
                    this.objectUid.pack(os);
                    os.packString(this.typeName);
                }
                catch (IOException e) {
                    if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.DisposeRecord_2");
                    }
                    res = false;
                }
            }
        } else {
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.DisposeRecord_3");
            }
            res = false;
        }
        return res;
    }

    @Override
    public boolean restore_state(InputObjectState os, int ot) {
        boolean res = true;
        int objStoreType = 0;
        try {
            objStoreType = os.unpackInt();
            if (ObjectStoreType.valid(objStoreType)) {
                this.store = null;
                this.store = new ObjectStore(ObjectStoreType.typeToClassName(objStoreType));
                this.store.unpack(os);
                this.objectUid.unpack(os);
                this.typeName = os.unpackString();
            } else {
                if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.DisposeRecord_4", new Object[]{Integer.toString(objStoreType)});
                }
                res = false;
            }
        }
        catch (IOException e) {
            res = false;
        }
        return res;
    }

    @Override
    public String type() {
        return "/StateManager/AbstractRecord/RecoveryRecord/PersistenceRecord/CadaverRecord/DisposeRecord";
    }

    @Override
    public boolean shouldAdd(AbstractRecord a) {
        return false;
    }

    @Override
    public boolean shouldMerge(AbstractRecord a) {
        return false;
    }

    @Override
    public boolean shouldReplace(AbstractRecord a) {
        return false;
    }

    @Override
    public boolean shouldAlter(AbstractRecord a) {
        return false;
    }

    public static AbstractRecord create() {
        return new DisposeRecord();
    }

    protected DisposeRecord() {
        this.objectUid = new Uid(Uid.nullUid());
        this.typeName = null;
        this.store = null;
    }
}

