/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna;

import com.arjuna.ats.arjuna.ArjunaNames;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.coordinator.OnePhaseResource;
import com.arjuna.ats.arjuna.gandiva.ClassName;
import com.arjuna.ats.arjuna.logging.tsLogger;
import java.io.PrintWriter;

public class LastResourceRecord
extends AbstractRecord {
    private OnePhaseResource _lro;
    private static final Uid ONE_PHASE_RESOURCE_UID = Uid.lastResourceUid();
    private static final boolean ALLOW_MULTIPLE_LAST_RESOURCES;
    private static boolean _disableMLRWarning;
    private static boolean _issuedWarning;

    public LastResourceRecord(OnePhaseResource opr) {
        super(ONE_PHASE_RESOURCE_UID);
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(1L, 4L, 8L, "LastResourceRecord()");
        }
        this._lro = opr;
    }

    @Override
    public boolean propagateOnCommit() {
        return false;
    }

    @Override
    public int typeIs() {
        return Integer.MAX_VALUE;
    }

    @Override
    public ClassName className() {
        return ArjunaNames.Implementation_AbstractRecord_LastResourceRecord();
    }

    @Override
    public int nestedAbort() {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 8L, "LastResourceRecord::nestedAbort() for " + this.order());
        }
        return 7;
    }

    @Override
    public int nestedCommit() {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 8L, "LastResourceRecord::nestedCommit() for " + this.order());
        }
        return 8;
    }

    @Override
    public int nestedPrepare() {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 8L, "LastResourceRecord::nestedPrepare() for " + this.order());
        }
        return 1;
    }

    @Override
    public int topLevelAbort() {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 8L, "LastResourceRecord::topLevelAbort() for " + this.order());
        }
        if (this._lro != null) {
            return this._lro.rollback();
        }
        return 7;
    }

    @Override
    public int topLevelCommit() {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 8L, "LastResourceRecord::topLevelCommit() for " + this.order());
        }
        return 7;
    }

    @Override
    public int topLevelPrepare() {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 8L, "LastResourceRecord::topLevelPrepare() for " + this.order());
        }
        if (this._lro != null && this._lro.commit() == 7) {
            return 0;
        }
        return 1;
    }

    @Override
    public void print(PrintWriter strm) {
        strm.println("LastResource for:");
        super.print(strm);
    }

    @Override
    public String type() {
        return "/StateManager/AbstractRecord/LastResourceRecord";
    }

    @Override
    public boolean shouldAdd(AbstractRecord a) {
        if (a.typeIs() == this.typeIs()) {
            if (ALLOW_MULTIPLE_LAST_RESOURCES) {
                if (tsLogger.arjLoggerI18N.isWarnEnabled() && (!_disableMLRWarning || _disableMLRWarning && !_issuedWarning)) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.lastResource.multipleWarning", new Object[]{a});
                    _issuedWarning = true;
                }
                return true;
            }
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.lastResource.disallow", new Object[]{a});
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean shouldMerge(AbstractRecord a) {
        return false;
    }

    @Override
    public boolean shouldReplace(AbstractRecord a) {
        return false;
    }

    @Override
    public boolean shouldAlter(AbstractRecord a) {
        return false;
    }

    @Override
    public void merge(AbstractRecord a) {
    }

    @Override
    public void alter(AbstractRecord a) {
    }

    @Override
    public Object value() {
        return this._lro;
    }

    @Override
    public void setValue(Object o) {
    }

    public static AbstractRecord create() {
        return new LastResourceRecord();
    }

    protected LastResourceRecord() {
        this._lro = null;
    }

    static {
        _disableMLRWarning = false;
        _issuedWarning = false;
        ALLOW_MULTIPLE_LAST_RESOURCES = arjPropertyManager.getCoreEnvironmentBean().isAllowMultipleLastResources();
        if (ALLOW_MULTIPLE_LAST_RESOURCES && tsLogger.arjLoggerI18N.isWarnEnabled()) {
            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.lastResource.startupWarning");
        }
        _disableMLRWarning = arjPropertyManager.getCoreEnvironmentBean().isDisableMultipleLastResourcesWarning();
        if (arjPropertyManager.getCoreEnvironmentBean().isDisableMultipleLastResourcesWarning()) {
            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.lastResource.disableWarning");
            _disableMLRWarning = true;
        }
    }
}

