/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna;

import com.arjuna.ats.arjuna.ActivationRecord;
import com.arjuna.ats.arjuna.ArjunaNames;
import com.arjuna.ats.arjuna.CadaverActivationRecord;
import com.arjuna.ats.arjuna.CadaverRecord;
import com.arjuna.ats.arjuna.DisposeRecord;
import com.arjuna.ats.arjuna.PersistenceRecord;
import com.arjuna.ats.arjuna.RecoveryRecord;
import com.arjuna.ats.arjuna.StateManagerAttribute;
import com.arjuna.ats.arjuna.common.Mutex;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.arjuna.exceptions.FatalError;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.gandiva.ObjectName;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ObjectStore;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.arjuna.utils.Utility;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public class StateManager {
    protected StateManagerAttribute smAttributes;
    protected ObjectName objectName;
    protected Hashtable modifyingActions;
    protected Hashtable usingActions;
    protected Uid objectUid;
    private boolean activated;
    private boolean currentlyActivated;
    private int currentStatus;
    private int initialStatus;
    private int myType;
    private ObjectStore objectStore;
    private String storeRoot;
    private Mutex mutex = new Mutex();
    private static final String marker = "#ARJUNA#";

    public boolean save_state(OutputObjectState os, int ot) {
        if (ot == 1) {
            try {
                BasicAction action = BasicAction.Current();
                if (action == null) {
                    this.packHeader(os, null, Utility.getProcessUid());
                } else {
                    this.packHeader(os, action.get_uid(), Utility.getProcessUid());
                }
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    public boolean restore_state(InputObjectState os, int ot) {
        if (ot == 1) {
            try {
                Uid txId = new Uid(Uid.nullUid());
                Uid processUid = new Uid(Uid.nullUid());
                this.unpackHeader(os, txId, processUid);
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    public void finalize() throws Throwable {
        BasicAction action;
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(2L, 4L, 32L, "StateManager.finalize() for object-id " + this.get_uid() + " type " + this.type());
        }
        if (this.currentStatus == 3 && (action = BasicAction.Current()) != null && action.status() == 0) {
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.StateManager_1");
            }
            this.cleanup(false);
        }
    }

    public boolean activate() {
        return this.activate(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean activate(String rootName) {
        boolean forceAR;
        boolean result;
        int oldStatus;
        BasicAction action;
        block22: {
            block21: {
                if (tsLogger.arjLogger.debugAllowed()) {
                    tsLogger.arjLogger.debug(16L, 4L, 32L, "StateManager::activate( " + (rootName != null ? rootName : "null") + ") for object-id " + this.objectUid);
                }
                if (this.myType == 2) {
                    return true;
                }
                if (this.currentStatus == 4) {
                    return false;
                }
                action = null;
                oldStatus = this.currentStatus;
                result = true;
                forceAR = false;
                action = BasicAction.Current();
                if (action != null && action.status() == 0) {
                    Hashtable hashtable = this.usingActions;
                    synchronized (hashtable) {
                        if (this.usingActions.get(action.topLevelAction().get_uid()) == null) {
                            this.usingActions.put(action.topLevelAction().get_uid(), action.topLevelAction());
                            forceAR = true;
                        }
                    }
                }
                if (!forceAR && this.currentStatus != 0) {
                    if (this.currentStatus != 1) return result;
                }
                if (this.loadObjectState()) {
                    this.setupStore(rootName);
                }
                if (this.currentStatus != 0) break block21;
                if (this.loadObjectState()) {
                    InputObjectState oldState = null;
                    try {
                        oldState = this.objectStore.read_committed(this.objectUid, this.type());
                    }
                    catch (ObjectStoreException e) {
                        oldState = null;
                    }
                    if (oldState == null) {
                        if (!tsLogger.arjLoggerI18N.isWarnEnabled()) return false;
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.StateManager_2", new Object[]{this.objectUid, this.type()});
                        return false;
                    }
                    result = this.restore_state(oldState, 1);
                    if (result) {
                        this.currentStatus = 2;
                    }
                    oldState = null;
                    break block22;
                } else {
                    this.currentStatus = this.currentStatus == 1 ? 3 : 2;
                }
                break block22;
            }
            this.currentStatus = this.currentStatus == 1 ? 3 : 2;
        }
        if (!forceAR) {
            if (this.currentStatus != 2) {
                if (this.currentStatus != 1) return result;
            }
            if (action == null) return result;
        }
        int arStatus = 2;
        ActivationRecord ar = new ActivationRecord(oldStatus, this, action.topLevelAction());
        arStatus = action.add(ar);
        if (arStatus == 2) {
            this.activated = true;
            this.currentlyActivated = true;
            return result;
        }
        ar = null;
        if (forceAR) {
            Hashtable hashtable = this.usingActions;
            synchronized (hashtable) {
                this.usingActions.remove(action.topLevelAction().get_uid());
            }
        }
        if (arStatus != 3) return result;
        return false;
    }

    public boolean deactivate() {
        return this.deactivate(null, true);
    }

    public boolean deactivate(String rootName) {
        return this.deactivate(rootName, true);
    }

    public synchronized boolean deactivate(String rootName, boolean commit) {
        boolean result;
        block11: {
            if (tsLogger.arjLogger.debugAllowed()) {
                tsLogger.arjLogger.debug(16L, 4L, 32L, "StateManager::deactivate(" + (rootName != null ? rootName : "null") + ", " + commit + ") for object-id " + this.objectUid);
            }
            result = false;
            if (this.currentlyActivated && this.myType == 1 || this.loadObjectState()) {
                this.setupStore(rootName);
                if (this.currentStatus == 3 || this.currentStatus == 2) {
                    String tn = this.type();
                    OutputObjectState newState = new OutputObjectState(this.objectUid, tn);
                    if (this.save_state(newState, this.myType)) {
                        try {
                            if (commit) {
                                result = this.objectStore.write_committed(this.objectUid, tn, newState);
                                break block11;
                            }
                            result = this.objectStore.write_uncommitted(this.objectUid, tn, newState);
                        }
                        catch (ObjectStoreException e) {
                            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.StateManager_3", e);
                            }
                            result = false;
                        }
                    } else if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.StateManager_4");
                    }
                }
            } else {
                result = true;
            }
        }
        return result;
    }

    public synchronized int status() {
        return this.currentStatus;
    }

    public synchronized int ObjectType() {
        return this.myType;
    }

    public final Uid get_uid() {
        return this.objectUid;
    }

    public synchronized boolean destroy() {
        if (tsLogger.arjLoggerI18N.debugAllowed()) {
            tsLogger.arjLoggerI18N.debug(16L, 4L, 32L, "com.arjuna.ats.arjuna.StateManager_5", new Object[]{this.objectUid});
        }
        boolean result = false;
        if (this.objectStore != null) {
            BasicAction action = BasicAction.Current();
            if (action != null) {
                DisposeRecord dr = new DisposeRecord(this.objectStore, this);
                if (action.add(dr) != 2) {
                    dr = null;
                    if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.StateManager_6");
                    }
                } else {
                    result = true;
                }
            } else {
                try {
                    result = this.objectStore.remove_committed(this.get_uid(), this.type());
                    if (result) {
                        this.destroyed();
                    }
                }
                catch (Exception e) {
                    if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.StateManager_7", e);
                    }
                    result = false;
                }
            }
        } else if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.StateManager_8");
        }
        return result;
    }

    public synchronized void disable() {
        this.myType = 2;
    }

    public void print(PrintWriter strm) {
        strm.println("Uid: " + this.objectUid);
        strm.println("Type: " + this.type());
    }

    public String type() {
        return "/StateManager";
    }

    public final String getStoreRoot() {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 32L, "StateManager::getStoreRoot ()");
        }
        return this.storeRoot;
    }

    public ObjectStore getStore() {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 32L, "StateManager::getStore ()");
        }
        if (this.objectStore == null) {
            this.setupStore();
        }
        return this.objectStore;
    }

    public Object attributes() {
        return this.smAttributes;
    }

    protected void packHeader(OutputObjectState os, Uid txId, Uid processUid) throws IOException {
        try {
            os.packString(marker);
            if (txId != null) {
                txId.pack(os);
                processUid.pack(os);
            } else {
                Uid.nullUid().pack(os);
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception e) {
            IOException ioException = new IOException(e.toString());
            ioException.initCause(e);
            throw ioException;
        }
    }

    protected void unpackHeader(InputObjectState os, Uid txId, Uid processUid) throws IOException {
        block6: {
            try {
                String myState = os.unpackString();
                if (myState.equals(marker)) {
                    txId.unpack(os);
                    if (!txId.equals(Uid.nullUid())) {
                        processUid.unpack(os);
                    }
                    break block6;
                }
                if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.StateManager_9");
                }
                throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.StateManager_15"));
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Exception e) {
                IOException ioException = new IOException(e.toString());
                ioException.initCause(e);
                throw ioException;
            }
        }
    }

    protected void terminate() {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 2L, 32L, "StateManager::terminate() for object-id " + this.get_uid());
        }
        this.cleanup(true);
    }

    protected final synchronized void setStatus(int s) {
        this.currentStatus = s;
    }

    protected StateManager(Uid objUid) {
        this(objUid, 1, null);
    }

    protected StateManager(Uid objUid, ObjectName attr) {
        this(objUid, 1, attr);
    }

    protected StateManager(Uid objUid, int ot) {
        this(objUid, ot, null);
    }

    protected StateManager(Uid objUid, int ot, ObjectName objName) {
        this.objectName = objName;
        this.parseObjectName();
        if (ot == 2) {
            this.modifyingActions = null;
            this.usingActions = null;
        } else {
            this.modifyingActions = new Hashtable();
            this.usingActions = new Hashtable();
        }
        this.activated = false;
        this.currentlyActivated = false;
        this.currentStatus = 0;
        this.initialStatus = 0;
        this.myType = ot;
        this.objectStore = null;
        this.storeRoot = null;
        this.objectUid = objUid;
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(1L, 2L, 32L, "StateManager::StateManager( " + this.get_uid() + " )");
        }
    }

    protected StateManager() {
        this(0, null);
    }

    protected StateManager(int ot) {
        this(ot, null);
    }

    protected StateManager(int ot, ObjectName objName) {
        this.objectName = objName;
        this.parseObjectName();
        if (ot == 2) {
            this.modifyingActions = null;
            this.usingActions = null;
        } else {
            this.modifyingActions = new Hashtable();
            this.usingActions = new Hashtable();
        }
        this.activated = false;
        this.currentlyActivated = false;
        this.initialStatus = this.currentStatus = this.smAttributes.objectModel == 0 && ot == 0 ? 2 : 1;
        this.myType = ot;
        this.objectStore = null;
        this.storeRoot = null;
        this.objectUid = new Uid();
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(1L, 2L, 32L, "StateManager::StateManager( " + ot + " )");
        }
    }

    protected StateManager(ObjectName objName) {
        this.objectName = objName;
        this.parseObjectName();
        if (this.myType == 2) {
            this.modifyingActions = null;
            this.usingActions = null;
        } else {
            this.modifyingActions = new Hashtable();
            this.usingActions = new Hashtable();
        }
        this.activated = false;
        this.currentlyActivated = false;
        this.currentStatus = 0;
        this.initialStatus = 0;
        this.objectStore = null;
        this.storeRoot = null;
        if (this.objectUid == null) {
            this.objectUid = new Uid();
        }
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(1L, 2L, 32L, "StateManager::StateManager( " + objName + " )");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean modified() {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 2L, 32L, "StateManager::modified() for object-id " + this.get_uid());
        }
        BasicAction action = BasicAction.Current();
        RecoveryRecord record = null;
        if (this.myType == 2 || this.currentStatus == 4) {
            return true;
        }
        if (this.currentStatus == 0) {
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.StateManager_10");
            }
            this.activate();
        }
        if (this.currentStatus == 1) {
            this.currentStatus = 3;
        }
        if (action != null) {
            Hashtable hashtable = this.modifyingActions;
            synchronized (hashtable) {
                if (this.modifyingActions.size() > 0 && this.modifyingActions.get(action.get_uid()) != null) {
                    return true;
                }
                this.modifyingActions.put(action.get_uid(), action);
            }
            OutputObjectState state = new OutputObjectState(this.objectUid, this.type());
            int rStatus = 2;
            if (this.save_state(state, 0)) {
                record = this.myType == 0 && this.smAttributes.objectModel == 0 ? new RecoveryRecord(state, this) : new PersistenceRecord(state, this.objectStore, this);
                rStatus = action.add(record);
                if (rStatus != 2) {
                    Hashtable hashtable2 = this.modifyingActions;
                    synchronized (hashtable2) {
                        this.modifyingActions.remove(action.get_uid());
                    }
                    record = null;
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    protected final synchronized void persist() {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 2L, 32L, "StateManager::persist() for object-id " + this.get_uid());
        }
        if (this.currentStatus == 2) {
            this.currentStatus = 1;
            this.myType = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final synchronized void cleanup(boolean fromTerminate) {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 2L, 32L, "StateManager::cleanup() for object-id " + this.get_uid());
        }
        if (this.myType == 2) {
            return;
        }
        BasicAction action = null;
        Hashtable hashtable = this.usingActions;
        synchronized (hashtable) {
            if (this.usingActions != null) {
                Enumeration e = this.usingActions.keys();
                while (e.hasMoreElements()) {
                    action = (BasicAction)this.usingActions.remove(e.nextElement());
                    if (action == null) continue;
                    AbstractRecord record = null;
                    int rStatus = 2;
                    if (this.currentStatus == 3 || this.currentStatus == 2) {
                        OutputObjectState state = null;
                        if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.StateManager_11", new Object[]{this.objectUid, this.type()});
                        }
                        if (fromTerminate) {
                            state = new OutputObjectState(this.objectUid, this.type());
                            if (!this.save_state(state, this.myType)) {
                                if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.StateManager_12");
                                }
                                action.preventCommit();
                            }
                        } else {
                            action.preventCommit();
                        }
                        this.setupStore(this.storeRoot);
                        record = new CadaverRecord(state, this.objectStore, this);
                        rStatus = action.add(record);
                        if (rStatus != 2) {
                            record = null;
                        }
                    }
                    if (!this.currentlyActivated || this.currentStatus == 4) continue;
                    record = new CadaverActivationRecord(this);
                    rStatus = action.add(record);
                    if (rStatus == 2) {
                        this.currentStatus = 0;
                        continue;
                    }
                    record = null;
                }
            }
        }
        if (this.currentStatus == 3) {
            this.currentStatus = this.myType == 0 && this.smAttributes.objectModel == 0 ? 2 : 0;
        }
        this.currentlyActivated = false;
    }

    protected final void setupStore() {
        this.setupStore(null);
    }

    protected synchronized void setupStore(String rootName) {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 2L, 32L, "StateManager::setupStore ( " + (rootName != null ? rootName : "null") + " )");
        }
        if (!this.loadObjectState()) {
            return;
        }
        if (this.objectStore != null) {
            return;
        }
        if (rootName == null) {
            rootName = this.smAttributes.objectStoreRoot != null ? this.smAttributes.objectStoreRoot : "";
        }
        if (this.storeRoot != null) {
            if (rootName == null || rootName.compareTo("") == 0 || rootName.compareTo(this.storeRoot) == 0) {
                return;
            }
            this.objectStore = null;
        }
        if (rootName == null) {
            rootName = "";
        }
        this.storeRoot = new String(rootName);
        if (this.myType == 1 || this.myType == 2) {
            int sharedStatus = this.smAttributes.objectModel == 0 ? 14 : 13;
            ObjectName osObjName = null;
            if (this.objectName != null) {
                try {
                    osObjName = this.objectName.getObjectNameAttribute(ArjunaNames.ObjectStore_implementationObjectName());
                }
                catch (Exception ex) {
                    osObjName = null;
                }
            }
            this.objectStore = osObjName == null ? new ObjectStore(this.smAttributes.objectStoreType, this.storeRoot, sharedStatus) : new ObjectStore(this.smAttributes.objectStoreType, osObjName);
        } else {
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.StateManager_13");
            }
            throw new FatalError(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.StateManager_14"));
        }
        this.objectStore.initialise(this.get_uid(), this.type());
    }

    protected final boolean loadObjectState() {
        boolean load;
        boolean bl = load = this.smAttributes.objectModel != 0;
        if (!load && this.myType != 0 && !this.activated) {
            load = true;
        }
        return load;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final synchronized boolean forgetAction(BasicAction action, boolean committed, int recordType) {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 2L, 32L, "StateManager::forgetAction(" + (action != null ? action.get_uid() : Uid.nullUid()) + ")" + " for object-id " + this.objectUid);
        }
        Hashtable hashtable = this.modifyingActions;
        synchronized (hashtable) {
            this.modifyingActions.remove(action.get_uid());
        }
        if (recordType != 101) {
            hashtable = this.usingActions;
            synchronized (hashtable) {
                if (this.usingActions != null) {
                    this.usingActions.remove(action.get_uid());
                    if (this.usingActions.size() == 0) {
                        if (committed) {
                            if (this.myType == 0 && this.smAttributes.objectModel == 0) {
                                this.currentStatus = 2;
                                this.initialStatus = 2;
                            } else {
                                this.currentStatus = 0;
                                this.initialStatus = 0;
                            }
                        } else {
                            this.currentStatus = this.initialStatus;
                        }
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final synchronized boolean rememberAction(BasicAction action, int recordType) {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 2L, 32L, "StateManager::rememberAction(" + (action != null ? action.get_uid() : Uid.nullUid()) + ")" + " for object-id " + this.objectUid);
        }
        boolean result = false;
        if (recordType != 101 && action != null && action.status() == 0) {
            Hashtable hashtable = this.usingActions;
            synchronized (hashtable) {
                if (this.usingActions.get(action.get_uid()) == null) {
                    this.usingActions.put(action.get_uid(), action);
                }
            }
        }
        result = true;
        return result;
    }

    protected final Mutex getMutex() {
        return this.mutex;
    }

    protected final boolean lockMutex() {
        return this.mutex.lock() == 0;
    }

    protected final boolean unlockMutex() {
        return this.mutex.unlock() == 1;
    }

    protected final boolean tryLockMutex() {
        return this.mutex.tryLock() == 0;
    }

    final synchronized void destroyed() {
        this.currentStatus = 4;
    }

    private void parseObjectName() {
        this.smAttributes = new StateManagerAttribute();
        if (this.objectName != null) {
            try {
                this.objectUid = this.objectName.getUidAttribute(ArjunaNames.StateManager_uid());
            }
            catch (Exception e) {
                this.objectUid = null;
            }
            try {
                this.myType = (int)this.objectName.getLongAttribute(ArjunaNames.StateManager_objectType());
            }
            catch (Exception e) {
                this.myType = 1;
            }
            try {
                this.smAttributes.objectModel = (int)this.objectName.getLongAttribute(ArjunaNames.StateManager_objectModel());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.smAttributes.objectStoreType = this.objectName.getClassNameAttribute("com.arjuna.ats.arjuna.objectstore.objectStoreType");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.smAttributes.objectStoreRoot = this.objectName.getStringAttribute(ArjunaNames.StateManager_objectStoreRoot());
            }
            catch (Exception exception) {}
        } else {
            this.objectUid = null;
        }
    }
}

