/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.orbspecific.jacorb.recoverycoordinators;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.arjuna.objectstore.ObjectStore;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.jts.ORBManager;
import com.arjuna.ats.internal.jts.orbspecific.jacorb.recoverycoordinators.JacOrbRCDefaultServant;
import com.arjuna.ats.internal.jts.orbspecific.jacorb.recoverycoordinators.ORBRunner;
import com.arjuna.ats.internal.jts.recovery.RecoveryORBManager;
import com.arjuna.ats.internal.jts.recovery.recoverycoordinators.GenericRecoveryCreator;
import com.arjuna.ats.internal.jts.recovery.recoverycoordinators.RecoveryServiceInit;
import com.arjuna.ats.jts.common.jtsPropertyManager;
import com.arjuna.ats.jts.logging.jtsLogger;
import com.arjuna.orbportability.OA;
import com.arjuna.orbportability.RootOA;
import com.arjuna.orbportability.internal.InternalORB;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CosTransactions.RecoveryCoordinatorHelper;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantRetentionPolicyValue;

public class JacOrbRCServiceInit
implements RecoveryServiceInit {
    private static final String POA_NAME_PREFIX = "RcvCo-";
    protected static POA _poa = null;
    protected static com.arjuna.orbportability.ORB _orb = null;
    protected static RootOA _oa = null;
    protected static String RecoveryIdStore = "RecoveryCoordinatorIdStore";
    protected static String RecoveryCoordStore = "RecoveryCoordinator";
    private static final String orbNamePrefix = "ots_";
    private static final String orbName = "arjuna.portable_interceptor.";
    private ObjectStore currentStore;
    protected static String uid4Recovery = "52e38d0c:c91:4140398c:0";

    static POA getRCPOA(String domainName) {
        String rcServiceName = GenericRecoveryCreator.getRecCoordServiceName();
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 2048L, "JacOrbRCServiceInit.getRCPOA " + rcServiceName);
        }
        if (_poa == null) {
            String poaName = POA_NAME_PREFIX + rcServiceName + domainName;
            boolean oaInit = true;
            String oaPort = "OAPort";
            String oaAddr = "OAIAddr";
            String oldPort = System.getProperty(oaPort, "");
            String oldAddr = System.getProperty(oaAddr, "");
            if (!RecoveryORBManager.isInitialised()) {
                InputStream is;
                _orb = InternalORB.getInstance("RecoveryServer");
                String[] params = null;
                String recoveryManagerPort = "" + jtsPropertyManager.getJTSEnvironmentBean().getRecoveryManagerPort();
                String recoveryManagerAddr = jtsPropertyManager.getJTSEnvironmentBean().getRecoveryManagerAddress();
                if (recoveryManagerAddr == null) {
                    recoveryManagerAddr = "";
                }
                if (jtsLogger.loggerI18N.isInfoEnabled()) {
                    jtsLogger.loggerI18N.info("com.arjuna.ats.internal.jts.orbspecific.jacorb.recoverycoordinators.JacOrbRCServiceInit_6", new java.lang.Object[]{recoveryManagerPort, recoveryManagerAddr});
                }
                Properties p = new Properties();
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                if (contextClassLoader != null && (is = contextClassLoader.getResourceAsStream("jacorb.properties")) != null) {
                    try {
                        p.load(is);
                    }
                    catch (IOException ioe) {
                        p.clear();
                    }
                }
                p.setProperty(oaPort, recoveryManagerPort);
                if (recoveryManagerAddr.length() != 0) {
                    p.setProperty(oaAddr, recoveryManagerAddr);
                    System.setProperty(oaAddr, oldAddr);
                }
                _orb.initORB(params, p);
                _oa = OA.getRootOA(_orb);
                if (oldPort == null) {
                    oldPort = "";
                }
                System.setProperty(oaPort, oldPort);
                RecoveryORBManager.setORB(_orb);
                RecoveryORBManager.setPOA(_oa);
            } else {
                _orb = RecoveryORBManager.getORB();
                _oa = (RootOA)RecoveryORBManager.getPOA();
                oaInit = false;
                if (jtsLogger.loggerI18N.isInfoEnabled()) {
                    jtsLogger.loggerI18N.info("com.arjuna.ats.internal.jts.orbspecific.jacorb.recoverycoordinators.JacOrbRCServiceInit_6a", new java.lang.Object[]{oldPort});
                }
            }
            try {
                if (oaInit) {
                    _oa.initOA();
                }
                if (domainName.equals("recovery_coordinator") && !ORBManager.isInitialised()) {
                    try {
                        ORBManager.setORB(_orb);
                        ORBManager.setPOA(_oa);
                    }
                    catch (Exception ex) {
                        jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.orbspecific.jacorb.recoverycoordinators.JacOrbRCServiceInit_7", ex);
                    }
                }
                ORB theORB = _orb.orb();
                POA rootPOA = _oa.rootPoa();
                Policy[] policies = null;
                policies = new Policy[]{rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), rootPOA.create_servant_retention_policy(ServantRetentionPolicyValue.NON_RETAIN), rootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), rootPOA.create_id_uniqueness_policy(IdUniquenessPolicyValue.MULTIPLE_ID), rootPOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_DEFAULT_SERVANT)};
                _poa = rootPOA.create_POA(poaName, rootPOA.the_POAManager(), policies);
            }
            catch (Exception ex) {
                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.orbspecific.jacorb.recoverycoordinators.JacOrbRCServiceInit_1", ex);
            }
        }
        return _poa;
    }

    @Override
    public boolean startRCservice() {
        POA ourPOA = JacOrbRCServiceInit.getRCPOA("recovery_coordinator");
        try {
            JacOrbRCDefaultServant theButler = new JacOrbRCDefaultServant(_orb.orb());
            ourPOA.set_servant((Servant)theButler);
            Object obj = ourPOA.create_reference_with_id("RecoveryManager".getBytes(), RecoveryCoordinatorHelper.id());
            String reference = _orb.orb().object_to_string(obj);
            try {
                if (this.currentStore == null) {
                    this.currentStore = TxControl.getStore();
                }
                OutputObjectState oState = new OutputObjectState();
                oState.packString(reference);
                this.currentStore.write_committed(new Uid(uid4Recovery), JacOrbRCServiceInit.type(), oState);
            }
            catch (SecurityException sex) {
                jtsLogger.loggerI18N.fatal("com.arjuna.ats.internal.jts.orbspecific.jacorb.recoverycoordinators.JacOrbRCServiceInit_5");
            }
            if (jtsLogger.loggerI18N.isDebugEnabled()) {
                jtsLogger.loggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.jts.orbspecific.jacorb.recoverycoordinators.JacOrbRCServiceInit_2");
            }
            _oa.rootPoa().the_POAManager().activate();
            ORBRunner _runOA = new ORBRunner();
            return true;
        }
        catch (Exception ex) {
            jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.orbspecific.jacorb.recoverycoordinators.JacOrbRCServiceInit_3", ex);
            return false;
        }
    }

    public static void shutdownRCService() {
        _poa = null;
    }

    public static String type() {
        return "/RecoveryCoordinator";
    }
}

