/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.recovery.transactions;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.internal.jts.recovery.transactions.RecoveringTransaction;
import com.arjuna.ats.internal.jts.recovery.transactions.RecoveryStatus;
import com.arjuna.ats.internal.jts.recovery.transactions.TransactionCacheItem;
import com.arjuna.ats.jts.common.jtsPropertyManager;
import com.arjuna.ats.jts.logging.jtsLogger;
import java.util.Hashtable;
import org.omg.CORBA.SystemException;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;

public class TransactionCache {
    private static Hashtable _theCache = new Hashtable();
    private static int attemptsBeforeConversion = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Status get_status(Uid actionUid, String theType) throws SystemException {
        Status theStatus = Status.StatusUnknown;
        TransactionCacheItem cacheItem = TransactionCache.get(actionUid, theType);
        if (cacheItem != null) {
            TransactionCacheItem transactionCacheItem = cacheItem;
            synchronized (transactionCacheItem) {
                RecoveringTransaction theTransaction = cacheItem.freshTransaction();
                if (theTransaction != null) {
                    theStatus = theTransaction.get_status();
                    cacheItem.setStatus(theStatus);
                }
            }
        }
        return theStatus;
    }

    public static Status getCachedStatus(Uid actionUid) throws SystemException {
        TransactionCacheItem cacheItem = TransactionCache.getKnown(actionUid);
        if (cacheItem != null) {
            return cacheItem.getStatus();
        }
        return Status.StatusNoTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Status getOriginalStatus(Uid actionUid, String theType) throws SystemException {
        Status theStatus = Status.StatusUnknown;
        TransactionCacheItem cacheItem = TransactionCache.get(actionUid, theType);
        if (cacheItem != null) {
            TransactionCacheItem transactionCacheItem = cacheItem;
            synchronized (transactionCacheItem) {
                RecoveringTransaction theTransaction = cacheItem.freshTransaction();
                if (theTransaction != null) {
                    if (jtsLogger.loggerI18N.isDebugEnabled()) {
                        jtsLogger.loggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.jts.recovery.transactions.TransactionCache_1");
                    }
                    theStatus = theTransaction.getOriginalStatus();
                } else if (jtsLogger.loggerI18N.isDebugEnabled()) {
                    jtsLogger.loggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.jts.recovery.transactions.TransactionCache_2");
                }
            }
        }
        return theStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getRecoveryStatus(Uid actionUid, String theType) {
        int theRecoveryStatus = RecoveryStatus.NEW;
        TransactionCacheItem cacheItem = TransactionCache.get(actionUid, theType);
        if (cacheItem != null) {
            TransactionCacheItem transactionCacheItem = cacheItem;
            synchronized (transactionCacheItem) {
                RecoveringTransaction theTransaction = cacheItem.transaction();
                if (theTransaction != null) {
                    theRecoveryStatus = theTransaction.getRecoveryStatus();
                }
            }
        }
        return theRecoveryStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addResourceRecord(Uid actionUid, String theType, Uid rcUid, Resource r) {
        TransactionCacheItem cacheItem = TransactionCache.get(actionUid, theType);
        if (cacheItem != null) {
            TransactionCacheItem transactionCacheItem = cacheItem;
            synchronized (transactionCacheItem) {
                RecoveringTransaction theTransaction = cacheItem.freshTransaction();
                if (theTransaction != null) {
                    if (theTransaction.getRecoveryStatus() != RecoveryStatus.ACTIVATE_FAILED) {
                        theTransaction.addResourceRecord(rcUid, r);
                    }
                    cacheItem.resetAttemptCount();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replayPhase2(Uid actionUid, String theType) {
        TransactionCacheItem cacheItem = TransactionCache.get(actionUid, theType);
        if (cacheItem != null) {
            TransactionCacheItem transactionCacheItem = cacheItem;
            synchronized (transactionCacheItem) {
                boolean fullyCompleted = false;
                RecoveringTransaction theTransaction = cacheItem.freshTransaction();
                if (theTransaction != null && theTransaction.getRecoveryStatus() != RecoveryStatus.ACTIVATE_FAILED) {
                    int previousAttempts;
                    boolean converting = false;
                    if (cacheItem.getStatus() == Status.StatusCommitted && (previousAttempts = cacheItem.countAttempts()) >= attemptsBeforeConversion && (converting = theTransaction.assumeComplete()) && jtsLogger.loggerI18N.isDebugEnabled()) {
                        jtsLogger.loggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.jts.recovery.transactions.TransactionCache_3", new Object[]{actionUid});
                    }
                    theTransaction.replayPhase2();
                    cacheItem.setStatus(theTransaction.get_status());
                    fullyCompleted = theTransaction.allCompleted();
                    if (converting && !fullyCompleted) {
                        if (jtsLogger.loggerI18N.isInfoEnabled()) {
                            jtsLogger.loggerI18N.info("com.arjuna.ats.internal.jts.recovery.transactions.TransactionCache_4", new Object[]{actionUid});
                        }
                        theTransaction.removeOldStoreEntry();
                        cacheItem.updateType();
                    }
                }
                if (fullyCompleted) {
                    if (jtsLogger.loggerI18N.isInfoEnabled()) {
                        jtsLogger.loggerI18N.info("com.arjuna.ats.internal.jts.recovery.transactions.TransactionCache_5", new Object[]{actionUid});
                    }
                    TransactionCache.remove(actionUid);
                } else {
                    cacheItem.clearTransaction();
                }
            }
        }
    }

    private static synchronized TransactionCacheItem getKnown(Uid theUid) {
        TransactionCacheItem cacheItem = (TransactionCacheItem)_theCache.get(theUid);
        return cacheItem;
    }

    private static synchronized TransactionCacheItem get(Uid theUid, String theType) {
        TransactionCacheItem cacheItem = (TransactionCacheItem)_theCache.get(theUid);
        if (cacheItem == null) {
            cacheItem = new TransactionCacheItem(theUid, theType);
            _theCache.put(theUid, cacheItem);
        }
        return cacheItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void remove(Uid theUid) {
        TransactionCacheItem cacheItem = (TransactionCacheItem)_theCache.get(theUid);
        if (cacheItem == null) {
            if (jtsLogger.loggerI18N.isDebugEnabled()) {
                jtsLogger.loggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.jts.recovery.transactions.TransactionCache_6", new Object[]{theUid});
            }
        } else {
            TransactionCacheItem transactionCacheItem = cacheItem;
            synchronized (transactionCacheItem) {
                _theCache.remove(theUid);
            }
            if (jtsLogger.loggerI18N.isDebugEnabled()) {
                jtsLogger.loggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.jts.recovery.transactions.TransactionCache_7", new Object[]{theUid});
            }
        }
    }

    static {
        attemptsBeforeConversion = jtsPropertyManager.getJTSEnvironmentBean().getCommitedTransactionRetryLimit();
    }
}

