/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.recovery.transactions;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.objectstore.ObjectStore;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.internal.jts.recovery.transactions.CachedRecoveredTransaction;
import com.arjuna.ats.jts.logging.jtsLogger;
import com.arjuna.ats.jts.utils.Utility;
import java.util.Enumeration;
import java.util.Vector;
import org.omg.CosTransactions.Status;

public abstract class TransactionRecoveryModule {
    protected String _transactionType = null;
    protected static ObjectStore _transactionStore = null;
    protected Vector _transactionUidVector;

    public TransactionRecoveryModule() {
        if (jtsLogger.loggerI18N.isDebugEnabled()) {
            jtsLogger.loggerI18N.debug(1L, 4L, 2048L, "com.arjuna.ats.internal.jts.recovery.transactions.TransactionRecoveryModule_1");
        }
        if (_transactionStore == null) {
            _transactionStore = TxControl.getStore();
        }
    }

    protected void periodicWorkFirstPass() {
        if (jtsLogger.logger.isInfoEnabled()) {
            jtsLogger.logger.info("TransactionRecoveryModule.periodicWorkFirstPass()");
        }
        if (this._transactionType == null) {
            jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.recovery.transactions.TransactionRecoveryModule_2");
            return;
        }
        this._transactionUidVector = new Vector();
        InputObjectState uids = new InputObjectState();
        boolean anyTransactions = false;
        try {
            if (jtsLogger.loggerI18N.isDebugEnabled()) {
                jtsLogger.loggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.jts.recovery.transactions.TransactionRecoveryModule_3", new Object[]{this._transactionType});
            }
            anyTransactions = _transactionStore.allObjUids(this._transactionType, uids);
        }
        catch (ObjectStoreException e1) {
            jtsLogger.loggerI18N.warn("om.hp.mwlabs.ts.jts.recovery.transactions.TransactionRecoveryModule_4", e1);
        }
        if (anyTransactions) {
            Uid theUid = new Uid(Uid.nullUid());
            boolean moreUids = true;
            while (moreUids) {
                try {
                    theUid.unpack(uids);
                    if (theUid.equals(Uid.nullUid())) {
                        moreUids = false;
                        continue;
                    }
                    Uid newUid = new Uid(theUid);
                    if (jtsLogger.loggerI18N.isDebugEnabled()) {
                        jtsLogger.loggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.jts.recovery.transactions.TransactionRecoveryModule_5", new Object[]{newUid});
                    }
                    this._transactionUidVector.addElement(newUid);
                }
                catch (Exception e2) {
                    moreUids = false;
                }
            }
        }
    }

    protected void periodicWorkSecondPass() {
        if (jtsLogger.logger.isInfoEnabled()) {
            jtsLogger.logger.info("TransactionRecoveryModule.periodicWorkSecondPass()");
        }
        Enumeration transactionUidEnum = this._transactionUidVector.elements();
        while (transactionUidEnum.hasMoreElements()) {
            Uid currentUid = (Uid)transactionUidEnum.nextElement();
            try {
                if (_transactionStore.currentState(currentUid, this._transactionType) != 0) {
                    if (jtsLogger.loggerI18N.isInfoEnabled()) {
                        jtsLogger.loggerI18N.info("com.arjuna.ats.internal.jts.recovery.transactions.TransactionRecoveryModule_6", new Object[]{currentUid});
                    }
                    this.recoverTransaction(currentUid);
                    continue;
                }
                if (!jtsLogger.loggerI18N.isDebugEnabled()) continue;
                jtsLogger.loggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.jts.recovery.transactions.TransactionRecoveryModule_7", new Object[]{currentUid});
            }
            catch (ObjectStoreException e4) {
                if (!jtsLogger.loggerI18N.isDebugEnabled()) continue;
                jtsLogger.loggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.jts.recovery.transactions.TransactionRecoveryModule_8", new Object[]{currentUid});
            }
        }
    }

    protected void initialise() {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 2048L, "TransactionRecoveryModule.initialise()");
        }
    }

    private void recoverTransaction(Uid tranUid) {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 2048L, "TransactionRecoveryModule.recoverTransaction(" + tranUid + ")");
        }
        Status currentStatus = Status.StatusUnknown;
        CachedRecoveredTransaction cachedRecoveredTransaction = new CachedRecoveredTransaction(tranUid, this._transactionType);
        currentStatus = cachedRecoveredTransaction.get_status();
        if (jtsLogger.loggerI18N.isDebugEnabled()) {
            jtsLogger.loggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.jts.recovery.transactions.TransactionRecoveryModule_9", new Object[]{tranUid, Utility.stringStatus(currentStatus)});
        }
        if (cachedRecoveredTransaction.originalBusy()) {
            if (jtsLogger.loggerI18N.isDebugEnabled()) {
                jtsLogger.loggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.jts.recovery.transactions.TransactionRecoveryModule_10", new Object[]{tranUid});
            }
            return;
        }
        cachedRecoveredTransaction.replayPhase2();
        cachedRecoveredTransaction = null;
    }
}

