/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.common.internal.util.logging.jakarta;

import com.arjuna.common.internal.util.logging.AbstractLogInterface;
import com.arjuna.common.internal.util.logging.LogFactoryInterface;
import com.arjuna.common.internal.util.logging.LogInterface;
import com.arjuna.common.internal.util.logging.jakarta.JakartaLogger;
import com.arjuna.common.util.exceptions.LogConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JakartaLogFactory
implements LogFactoryInterface {
    private String logImpl = null;

    public JakartaLogFactory(String logImpl) {
        this.logImpl = logImpl;
    }

    @Override
    public AbstractLogInterface getLog(Class clazz) throws LogConfigurationException {
        Object oldConfig = null;
        try {
            oldConfig = this.configureFactory();
            LogInterface logInterface = this.createLogWrapper(LogFactory.getLog((Class)clazz));
            return logInterface;
        }
        catch (org.apache.commons.logging.LogConfigurationException lce) {
            throw new LogConfigurationException(lce.getMessage(), lce);
        }
        finally {
            this.resetFactory(oldConfig);
        }
    }

    @Override
    public AbstractLogInterface getLog(String name) throws LogConfigurationException {
        Object oldConfig = null;
        try {
            oldConfig = this.configureFactory();
            LogInterface logInterface = this.createLogWrapper(LogFactory.getLog((String)name));
            return logInterface;
        }
        catch (org.apache.commons.logging.LogConfigurationException lce) {
            throw new LogConfigurationException(lce.getMessage(), lce);
        }
        finally {
            this.resetFactory(oldConfig);
        }
    }

    protected LogInterface createLogWrapper(Log log) {
        return new JakartaLogger(log);
    }

    private Object configureFactory() {
        Object oldValue = LogFactory.getFactory().getAttribute("org.apache.commons.logging.Log");
        LogFactory.getFactory().setAttribute("org.apache.commons.logging.Log", (Object)this.logImpl);
        return oldValue;
    }

    private void resetFactory(Object value) {
        LogFactory.getFactory().setAttribute("org.apache.commons.logging.Log", value);
    }
}

