/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.orbportability.recovery;

import com.arjuna.orbportability.ORB;
import com.arjuna.orbportability.common.opPropertyManager;
import com.arjuna.orbportability.logging.opLogger;
import com.arjuna.orbportability.recovery.DefaultIORRecovery;
import com.arjuna.orbportability.recovery.IORRecovery;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;

public class RebindFactory {
    public static IORRecovery getRecovery(ORB orb, String name, Object obj) throws SystemException {
        if (name == null && obj == null) {
            throw new BAD_PARAM();
        }
        String recoveryClassName = null;
        if (name != null && (recoveryClassName = opPropertyManager.getPropertyManager().getProperty(name)) != null) {
            return RebindFactory.createRecoveryClass(recoveryClassName);
        }
        if (obj != null) {
            try {
                String ior = orb.orb().object_to_string(obj);
                recoveryClassName = opPropertyManager.getPropertyManager().getProperty(ior);
                if (recoveryClassName != null) {
                    return RebindFactory.createRecoveryClass(recoveryClassName);
                }
            }
            catch (SystemException e1) {
                if (opLogger.logger.isWarnEnabled()) {
                    opLogger.logger.warn(e1.toString());
                }
                throw e1;
            }
            catch (Exception e2) {
                if (opLogger.logger.isWarnEnabled()) {
                    opLogger.logger.warn(e2.toString());
                }
                throw new BAD_OPERATION(e2.toString());
            }
        }
        return new DefaultIORRecovery();
    }

    private static final IORRecovery createRecoveryClass(String className) throws SystemException {
        try {
            Class<?> c = Thread.currentThread().getContextClassLoader().loadClass(className);
            return (IORRecovery)c.newInstance();
        }
        catch (Exception e) {
            throw new BAD_OPERATION(e.toString());
        }
    }
}

