/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jts.orbspecific.javaidl.interceptors.context;

import com.arjuna.ats.internal.jts.ControlWrapper;
import com.arjuna.ats.internal.jts.ORBManager;
import com.arjuna.ats.internal.jts.OTSImpleManager;
import com.arjuna.ats.jts.OTSManager;
import com.arjuna.ats.jts.common.InterceptorInfo;
import com.arjuna.ats.jts.logging.jtsLogger;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CORBA.UNKNOWN;
import org.omg.CosTransactions.TransactionalObjectHelper;
import org.omg.IOP.Codec;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.InvalidSlot;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

class ContextServerRequestInterceptorImpl
extends LocalObject
implements ServerRequestInterceptor {
    private Codec _codec;
    private int _dataSlot;

    public void destroy() {
    }

    public ContextServerRequestInterceptorImpl(int dataSlot, Codec codec) {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(1L, 4L, 16640L, "ContextServerRequestInterceptorImpl ( " + dataSlot + " )");
        }
        this._dataSlot = dataSlot;
        this._codec = codec;
    }

    public String name() {
        return "OTS_Context";
    }

    public void receive_request_service_contexts(ServerRequestInfo request_info) throws SystemException {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 16640L, "ContextServerRequestInterceptorImpl::receive_request_service_contexts ( " + request_info.operation() + " )");
        }
        try {
            try {
                if (!InterceptorInfo.getAlwaysPropagate() && !request_info.target_is_a(TransactionalObjectHelper.id())) {
                    throw new BAD_PARAM();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                ServiceContext serviceContext = null;
                try {
                    serviceContext = request_info.get_request_service_context(-559038737);
                }
                catch (BAD_PARAM bp) {
                    serviceContext = null;
                }
                if (serviceContext != null) {
                    Any receivedData = this._codec.decode_value(serviceContext.context_data, ORBManager.getORB().orb().get_primitive_tc(TCKind.tk_string));
                    request_info.set_slot(this._dataSlot, receivedData);
                } else if (InterceptorInfo.getNeedTranContext()) {
                    throw new TRANSACTION_REQUIRED();
                }
            }
            catch (TRANSACTION_REQUIRED ex) {
                ex.printStackTrace();
                throw ex;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (BAD_PARAM ex) {
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public void receive_request(ServerRequestInfo request_info) throws SystemException {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 16640L, "ContextServerRequestInterceptorImpl.receive_request ( " + request_info.operation() + " )");
        }
    }

    public void send_reply(ServerRequestInfo request_info) throws SystemException {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 16640L, "ContextServerRequestInterceptorImpl::send_reply ( " + request_info.operation() + " )");
        }
        try {
            this.suspendContext(request_info);
        }
        catch (SystemException ex) {
            if (jtsLogger.loggerI18N.isWarnEnabled()) {
                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.orbspecific.javaidl.interceptors.context.srie", new Object[]{"ContextServerRequestInterceptorImpl::send_reply", ex});
            }
            throw ex;
        }
        catch (Exception e) {
            jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.orbspecific.javaidl.interceptors.context.srie", new Object[]{"ContextServerRequestInterceptorImpl::send_reply", e});
            throw new BAD_OPERATION(e.toString());
        }
    }

    public void send_exception(ServerRequestInfo request_info) throws SystemException {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 16640L, "ContextServerRequestInterceptorImpl::send_exception ( " + request_info.operation() + " )");
        }
        try {
            this.suspendContext(request_info);
        }
        catch (SystemException e1) {
            if (jtsLogger.loggerI18N.isWarnEnabled()) {
                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.orbspecific.javaidl.interceptors.context.srie", new Object[]{"ContextServerRequestInterceptorImpl::send_exception", e1});
            }
            throw e1;
        }
        catch (Exception e2) {
            if (jtsLogger.loggerI18N.isWarnEnabled()) {
                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.orbspecific.javaidl.interceptors.context.srie", new Object[]{"ContextServerRequestInterceptorImpl::send_exception", e2});
            }
            throw new BAD_OPERATION(e2.toString());
        }
    }

    public void send_other(ServerRequestInfo request_info) throws SystemException {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 16640L, "ContextServerRequestInterceptorImpl.send_other ( " + request_info.operation() + " )");
        }
        try {
            this.suspendContext(request_info);
        }
        catch (SystemException ex) {
            if (jtsLogger.loggerI18N.isWarnEnabled()) {
                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.orbspecific.javaidl.interceptors.context.srie", new Object[]{"ContextServerRequestInterceptorImpl::send_other", ex});
            }
            throw ex;
        }
        catch (Exception e) {
            if (jtsLogger.loggerI18N.isWarnEnabled()) {
                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.orbspecific.javaidl.interceptors.context.srie", new Object[]{"ContextServerRequestInterceptorImpl::send_other", e});
            }
            throw new BAD_OPERATION(e.toString());
        }
    }

    private void suspendContext(ServerRequestInfo request_info) throws SystemException, InvalidSlot {
        Any data;
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 16640L, "ContextServerRequestInterceptorImpl.suspendContext ( " + request_info.operation() + " )");
        }
        if ((data = request_info.get_slot(this._dataSlot)) != null && data.type().kind().value() != 0) {
            block7: {
                String threadId = null;
                try {
                    threadId = data.extract_string();
                    if (threadId == null) break block7;
                    ControlWrapper ctx = OTSImpleManager.current().contextManager().popAction(threadId);
                    OTSImpleManager.current().contextManager().purgeActions(threadId);
                    if (ctx == null) break block7;
                    try {
                        OTSManager.destroyControl(ctx.getControl());
                        ctx = null;
                    }
                    catch (Exception e) {
                        if (jtsLogger.loggerI18N.isWarnEnabled()) {
                            jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.orbspecific.javaidl.interceptors.context.srie", new Object[]{"ContextServerRequestInterceptorImpl.suspendContext", e});
                        }
                        throw new UNKNOWN(e.toString());
                    }
                }
                catch (BAD_OPERATION be) {
                    // empty catch block
                }
            }
            request_info.set_slot(this._dataSlot, null);
        }
    }
}

