/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.addressing.soap;

import java.net.URI;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.addressing.AddressingBuilder;
import javax.xml.ws.addressing.AddressingException;
import javax.xml.ws.addressing.soap.SOAPAddressingBuilder;
import javax.xml.ws.addressing.soap.SOAPAddressingProperties;
import org.jboss.logging.Logger;

public class SOAPClientHandler
extends GenericHandler {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$ws$addressing$soap$SOAPClientHandler == null ? (class$org$jboss$ws$addressing$soap$SOAPClientHandler = SOAPClientHandler.class$("org.jboss.ws.addressing.soap.SOAPClientHandler")) : class$org$jboss$ws$addressing$soap$SOAPClientHandler));
    public static final String CLIENT_ADDRESSING_REQUEST_ACTION = "javax.xml.ws.addressing.action.inbound";
    public static final String CLIENT_ADDRESSING_REQUEST_TO = "javax.xml.ws.addressing.to.inbound";
    public static final String CLIENT_ADDRESSING_REQUEST_MESSAGE_ID = "javax.xml.ws.addressing.messageId.inbound";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$org$jboss$ws$addressing$soap$SOAPClientHandler;

    public QName[] getHeaders() {
        return new QName[0];
    }

    public boolean handleRequest(MessageContext msgContext) {
        boolean hasClientProps;
        log.debug((Object)"handleRequest");
        URI wsaTo = (URI)msgContext.getProperty(CLIENT_ADDRESSING_REQUEST_TO);
        URI wsaAction = (URI)msgContext.getProperty(CLIENT_ADDRESSING_REQUEST_ACTION);
        URI wsaMessageId = (URI)msgContext.getProperty(CLIENT_ADDRESSING_REQUEST_MESSAGE_ID);
        SOAPAddressingProperties addrProps = (SOAPAddressingProperties)msgContext.getProperty("javax.xml.ws.addressing.context.outbound");
        AddressingBuilder builder = AddressingBuilder.getAddressingBuilder();
        boolean bl = hasClientProps = wsaTo != null || wsaAction != null || wsaMessageId != null;
        if (addrProps == null && hasClientProps) {
            addrProps = (SOAPAddressingProperties)builder.newAddressingProperties();
        }
        if (addrProps != null) {
            if (wsaTo != null) {
                addrProps.setTo(builder.newURI(wsaTo));
            }
            if (wsaAction != null) {
                addrProps.setAction(builder.newURI(wsaAction));
            }
            if (wsaMessageId != null) {
                addrProps.setMessageID(builder.newURI(wsaMessageId));
            }
            SOAPMessage soapMessage = ((SOAPMessageContext)msgContext).getMessage();
            addrProps.writeHeaders(soapMessage);
        }
        return true;
    }

    public boolean handleResponse(MessageContext msgContext) {
        log.debug((Object)"handleResponse");
        try {
            SOAPMessage soapMessage = ((SOAPMessageContext)msgContext).getMessage();
            if (soapMessage.getSOAPPart().getEnvelope() != null) {
                SOAPAddressingBuilder builder = (SOAPAddressingBuilder)SOAPAddressingBuilder.getAddressingBuilder();
                SOAPAddressingProperties addrProps = (SOAPAddressingProperties)builder.newAddressingProperties();
                addrProps.readHeaders(soapMessage);
                msgContext.setProperty("javax.xml.ws.addressing.context.inbound", (Object)addrProps);
            }
        }
        catch (SOAPException ex) {
            throw new AddressingException("Cannot handle response", ex);
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

