/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.binding.soap;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.invocation.OnewayInvocation;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.util.xml.DOMWriter;
import org.w3c.dom.Node;

public class SOAPMessageMarshaller
implements Marshaller {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$ws$binding$soap$SOAPMessageMarshaller == null ? (class$org$jboss$ws$binding$soap$SOAPMessageMarshaller = SOAPMessageMarshaller.class$("org.jboss.ws.binding.soap.SOAPMessageMarshaller")) : class$org$jboss$ws$binding$soap$SOAPMessageMarshaller));
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$org$jboss$ws$binding$soap$SOAPMessageMarshaller;

    public void write(Object dataObject, OutputStream output) throws IOException {
        if (dataObject instanceof InvocationRequest) {
            dataObject = ((InvocationRequest)dataObject).getParameter();
        }
        if (dataObject instanceof OnewayInvocation) {
            dataObject = ((OnewayInvocation)dataObject).getParameters()[0];
        }
        if (!(dataObject instanceof SOAPMessage)) {
            throw new IllegalArgumentException("Not a SOAPMessage: " + dataObject);
        }
        try {
            SOAPMessage soapMessage = (SOAPMessage)dataObject;
            if (log.isTraceEnabled()) {
                SOAPEnvelope soapEnv = soapMessage.getSOAPPart().getEnvelope();
                String envStr = DOMWriter.printNode((Node)soapEnv, (boolean)true);
                log.trace((Object)("Outgoing SOAPMessage\n" + envStr));
            }
            soapMessage.writeTo(output);
        }
        catch (SOAPException e) {
            log.error((Object)"Cannot marshall SOAPMessage", (Throwable)e);
            throw new IOException(e.toString());
        }
    }

    public Marshaller cloneMarshaller() throws CloneNotSupportedException {
        return new SOAPMessageMarshaller();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

