/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.eventing;

import java.net.URI;
import java.rmi.RemoteException;
import java.util.Date;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.ws.addressing.AddressingProperties;
import org.jboss.ws.Constants;
import org.jboss.ws.eventing.EventingConstants;
import org.jboss.ws.eventing.EventingEndpointBase;
import org.jboss.ws.eventing.SubscriptionManagerEndpoint;
import org.jboss.ws.eventing.element.RenewRequest;
import org.jboss.ws.eventing.element.RenewResponse;
import org.jboss.ws.eventing.element.StatusRequest;
import org.jboss.ws.eventing.element.StatusResponse;
import org.jboss.ws.eventing.element.UnsubscribeRequest;
import org.jboss.ws.eventing.mgmt.SubscriptionError;
import org.jboss.ws.soap.MessageContextAssociation;
import org.jboss.ws.soap.SOAPMessageContextImpl;

public class SubscriptionManagerEndpointImpl
extends EventingEndpointBase
implements SubscriptionManagerEndpoint {
    public StatusResponse getStatusOp(StatusRequest request) throws RemoteException {
        this.setReplyAction(EventingConstants.buildURI("http://schemas.xmlsoap.org/ws/2004/08/eventing/GetStatusResponse"));
        URI identifier = this.retrieveSubscriptionId();
        try {
            Date leaseTime = this.getSubscriptionManager().getStatus(identifier);
            StatusResponse response = new StatusResponse();
            response.setExpires(leaseTime);
            return response;
        }
        catch (SubscriptionError e) {
            throw new SOAPFaultException(this.buildFaultQName(e.getSubcode()), e.getReason(), null, null);
        }
    }

    public RenewResponse renewOp(RenewRequest request) throws RemoteException {
        this.setReplyAction(EventingConstants.buildURI("http://schemas.xmlsoap.org/ws/2004/08/eventing/RenewResponse"));
        URI identifier = this.retrieveSubscriptionId();
        try {
            Date newLeaseTime = this.getSubscriptionManager().renew(identifier, request.getExpires());
            RenewResponse response = new RenewResponse();
            response.setExpires(newLeaseTime);
            return response;
        }
        catch (SubscriptionError e) {
            throw new SOAPFaultException(this.buildFaultQName(e.getSubcode()), e.getReason(), null, null);
        }
    }

    public void unsubscribeOp(UnsubscribeRequest request) throws RemoteException {
        this.setReplyAction(EventingConstants.buildURI("http://schemas.xmlsoap.org/ws/2004/08/eventing/UnsubscribeResponse"));
        URI identifier = this.retrieveSubscriptionId();
        try {
            this.getSubscriptionManager().unsubscribe(identifier);
        }
        catch (SubscriptionError e) {
            throw new SOAPFaultException(this.buildFaultQName(e.getSubcode()), e.getReason(), null, null);
        }
    }

    private URI retrieveSubscriptionId() {
        SOAPMessageContextImpl msgContext = MessageContextAssociation.peekMessageContext();
        AddressingProperties addrProps = (AddressingProperties)msgContext.getProperty("javax.xml.ws.addressing.context.inbound");
        if (addrProps == null) {
            throw new SOAPFaultException(Constants.SOAP11_FAULT_CODE_CLIENT, "The message is not valid and cannot be processed:Cannot obtain addressing properties.", null, null);
        }
        URI identifier = (URI)msgContext.getProperty("subscriptionId");
        if (identifier == null) {
            throw new SOAPFaultException(this.buildFaultQName("InvalidMessage"), "The message is not valid and cannot be processed.Cannot obtain subscription identifier.", null, null);
        }
        return identifier;
    }
}

