/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.eventing.mgmt;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap;
import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.jboss.logging.Logger;
import org.jboss.naming.Util;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.ws.WSException;
import org.jboss.ws.eventing.deployment.EventSourceConfig;
import org.jboss.ws.eventing.deployment.EventSourceDesc;
import org.jboss.ws.eventing.element.EndpointReference;
import org.jboss.ws.eventing.element.ReferenceParameters;
import org.jboss.ws.eventing.mgmt.DispatchJob;
import org.jboss.ws.eventing.mgmt.DispatcherDelegate;
import org.jboss.ws.eventing.mgmt.EventDispatcher;
import org.jboss.ws.eventing.mgmt.EventSource;
import org.jboss.ws.eventing.mgmt.EventingBuilder;
import org.jboss.ws.eventing.mgmt.Filter;
import org.jboss.ws.eventing.mgmt.Subscription;
import org.jboss.ws.eventing.mgmt.SubscriptionError;
import org.jboss.ws.eventing.mgmt.SubscriptionManagerMBean;
import org.jboss.ws.eventing.mgmt.SubscriptionTicket;
import org.w3c.dom.Element;

public class SubscriptionManager
extends ServiceMBeanSupport
implements SubscriptionManagerMBean,
EventDispatcher {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$ws$eventing$mgmt$SubscriptionManager == null ? (class$org$jboss$ws$eventing$mgmt$SubscriptionManager = SubscriptionManager.class$("org.jboss.ws.eventing.mgmt.SubscriptionManager")) : class$org$jboss$ws$eventing$mgmt$SubscriptionManager));
    private ConcurrentMap<URI, EventSource> eventSourceMapping = new ConcurrentHashMap();
    private ConcurrentMap<URI, List<Subscription>> subscriptionMapping = new ConcurrentHashMap();
    private BlockingQueue<Runnable> eventQueue = new LinkedBlockingQueue();
    private ThreadPoolExecutor threadPool;
    private WatchDog watchDog;
    private static int nextSubscriberId = 0;
    private EventSourceConfig eventSourceConfig;
    private static EventingBuilder builder = EventingBuilder.createEventingBuilder();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$org$jboss$ws$eventing$mgmt$SubscriptionManager;

    protected void startService() throws Exception {
        super.startService();
        EventSourceDesc[] eventSourceDescArray = this.eventSourceConfig.getDescriptors();
        int n = 0;
        int n2 = eventSourceDescArray.length;
        while (n < n2) {
            EventSourceDesc desc = eventSourceDescArray[n];
            this.registerEventSource(desc);
            ++n;
        }
        this.threadPool = new ThreadPoolExecutor(5, 15, 5000L, TimeUnit.MILLISECONDS, this.eventQueue);
        this.watchDog = new WatchDog(this.subscriptionMapping);
        this.watchDog.startup();
        Util.rebind((Context)new InitialContext(), (String)"EventDispatcher", (Object)new DispatcherDelegate("localhost"));
        log.info((Object)"Bound event dispatcher to java:comp/env/EventDispatcher");
    }

    protected void stopService() throws Exception {
        super.stopService();
        Util.unbind((Context)new InitialContext(), (String)"EventDispatcher");
        this.threadPool.shutdown();
        this.watchDog.shutdown();
        Iterator iterator = this.eventSourceMapping.keySet().iterator();
        while (iterator.hasNext()) {
            URI eventSourceNS = (URI)iterator.next();
            this.removeEventSource(eventSourceNS);
        }
    }

    private static URI newSubscriberID(URI eventSourceNS) {
        try {
            return new URI(String.valueOf(eventSourceNS.toString()) + "#" + nextSubscriberId++);
        }
        catch (URISyntaxException e) {
            throw new WSException(e.getMessage());
        }
    }

    private void registerEventSource(EventSourceDesc descriptor) {
        if (this.eventSourceMapping.containsKey((Object)descriptor.getName())) {
            throw new IllegalArgumentException("EventSource " + descriptor.getName() + " already registered");
        }
        EventSource source = builder.newEventSource(descriptor);
        this.eventSourceMapping.put((Object)source.getNameSpace(), (Object)source);
        this.subscriptionMapping.put((Object)source.getNameSpace(), (Object)new CopyOnWriteArrayList());
        source.setState(EventSource.State.STARTED);
        log.debug((Object)("Registered: " + source));
    }

    private void removeEventSource(URI eventSourceNS) {
        if (this.eventSourceMapping.containsKey((Object)eventSourceNS)) {
            List subscriptions = (List)this.subscriptionMapping.get((Object)eventSourceNS);
            Iterator iterator = subscriptions.iterator();
            while (iterator.hasNext()) {
                Subscription s = (Subscription)iterator.next();
                s.end("http://schemas.xmlsoap.org/ws/2004/08/eventing/SourceShuttingDown");
            }
            subscriptions.clear();
            this.eventSourceMapping.remove((Object)eventSourceNS);
            log.debug((Object)("Event source " + eventSourceNS + " removed"));
        }
    }

    public SubscriptionTicket subscribe(URI eventSourceNS, EndpointReference notifyTo, EndpointReference endTo, Date expires, Filter filter) throws SubscriptionError {
        log.debug((Object)("Subscription request for " + eventSourceNS));
        if (this.eventSourceMapping.get((Object)eventSourceNS) == null) {
            throw new SubscriptionError("EventSourceUnableToProcess", "EventSource '" + eventSourceNS + "' not registered");
        }
        if (expires != null) {
            this.assertLeaseConstraints(expires);
        } else {
            expires = new Date(System.currentTimeMillis() + 300000L);
        }
        if (filter != null) {
            EventSource es = (EventSource)this.eventSourceMapping.get((Object)eventSourceNS);
            if (es.getSupportedFilterDialects().isEmpty()) {
                throw new SubscriptionError("FilteringNotSupported", "Filtering is not supported.");
            }
            boolean filterAvailable = false;
            Iterator<URI> iterator = es.getSupportedFilterDialects().iterator();
            while (iterator.hasNext()) {
                URI supportedDialect = iterator.next();
                if (!filter.getDialect().equals(supportedDialect)) continue;
                filterAvailable = true;
                break;
            }
            if (!filterAvailable) {
                throw new SubscriptionError("FilteringRequestedUnavailable", "The requested filter dialect is not supported.");
            }
        }
        EndpointReference endpointReference = new EndpointReference();
        endpointReference.setAddress(builder.newManagerEndpointURI());
        endpointReference.setReferenceParams(new ReferenceParameters(SubscriptionManager.newSubscriberID(eventSourceNS)));
        Subscription subscription = new Subscription(endpointReference, notifyTo, endTo, expires, filter);
        ((List)this.subscriptionMapping.get((Object)eventSourceNS)).add(subscription);
        log.debug((Object)("Registered subscription " + subscription.getIdentifier()));
        return new SubscriptionTicket(endpointReference, subscription.getExpires());
    }

    private void assertLeaseConstraints(Date expireDate) throws SubscriptionError {
        long expires = expireDate.getTime() - System.currentTimeMillis();
        if (expires < 0L || 600000L < expires) {
            throw new SubscriptionError("InvalidExpirationTime", "The expiration time requested is invalid: " + expires + "ms");
        }
    }

    public Date renew(URI identifier, Date lease) throws SubscriptionError {
        Subscription subscription = this.subscriberForID(identifier);
        if (subscription == null) {
            throw new SubscriptionError("UnableToRenew", "Subscription " + identifier + " does not exist");
        }
        if (lease != null) {
            this.assertLeaseConstraints(lease);
        } else {
            lease = new Date(System.currentTimeMillis() + 300000L);
        }
        subscription.setExpires(lease);
        return lease;
    }

    public final Date getStatus(URI identifier) throws SubscriptionError {
        Subscription subscription = this.subscriberForID(identifier);
        if (subscription == null) {
            throw new SubscriptionError("EventSourceUnableToProcess", "Subscription " + identifier + " does not exist");
        }
        return subscription.getExpires();
    }

    public void unsubscribe(URI identifier) throws SubscriptionError {
        Iterator iterator = this.subscriptionMapping.values().iterator();
        block0: while (iterator.hasNext()) {
            List subscriptions = (List)iterator.next();
            Iterator iterator2 = subscriptions.iterator();
            while (iterator2.hasNext()) {
                Subscription s = (Subscription)iterator2.next();
                if (!identifier.equals(s.getIdentifier())) continue;
                subscriptions.remove(s);
                log.debug((Object)("Removed subscription " + s));
                continue block0;
            }
        }
    }

    public String showEventsourceTable() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("<h3>Deployed Eventsources</h3>");
        pw.println("<table>");
        pw.println("<tr><td>Name</td><td>NS</td></tr>");
        Iterator iterator = this.eventSourceMapping.values().iterator();
        while (iterator.hasNext()) {
            EventSource source = (EventSource)iterator.next();
            pw.println("<tr><td>" + source.getName() + "</td><td>" + source.getNameSpace() + "</td></tr>");
        }
        pw.println("</table>");
        pw.close();
        return sw.toString();
    }

    public String showSubscriptionTable() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("<h3>Registered Subscriptions</h3>");
        pw.println("<table>");
        pw.println("<tr><td>Identifier</td><td>Expires</td><td>Filter</td></tr>");
        Iterator iterator = this.subscriptionMapping.values().iterator();
        while (iterator.hasNext()) {
            List subscriptions = (List)iterator.next();
            Iterator iterator2 = subscriptions.iterator();
            while (iterator2.hasNext()) {
                Subscription s = (Subscription)iterator2.next();
                pw.println("<tr><td>" + s.getIdentifier() + "</td><td>" + s.getExpires() + "</td><td>" + s.getFilter().getExpression() + "</td></tr>");
            }
        }
        pw.println("</table>");
        pw.close();
        return sw.toString();
    }

    private Subscription subscriberForID(URI id) {
        Subscription subscription = null;
        Iterator iterator = this.subscriptionMapping.values().iterator();
        block0: while (iterator.hasNext()) {
            List subscriptions = (List)iterator.next();
            Iterator iterator2 = subscriptions.iterator();
            while (iterator2.hasNext()) {
                Subscription s = (Subscription)iterator2.next();
                if (!id.equals(s.getIdentifier())) continue;
                subscription = s;
                continue block0;
            }
        }
        return subscription;
    }

    public void dispatch(URI eventSourceNS, Element payload) {
        DispatchJob dispatchJob = new DispatchJob(eventSourceNS, payload, this.subscriptionMapping);
        this.threadPool.execute((Runnable)dispatchJob);
    }

    public int getCorePoolSize() {
        return this.threadPool.getCorePoolSize();
    }

    public int getMaximumPoolSize() {
        return this.threadPool.getMaximumPoolSize();
    }

    public int getLargestPoolSize() {
        return this.threadPool.getLargestPoolSize();
    }

    public int getActiveCount() {
        return this.threadPool.getActiveCount();
    }

    public long getCompletedTaskCount() {
        return this.threadPool.getCompletedTaskCount();
    }

    public void setCorePoolSize(int corePoolSize) {
        this.threadPool.setCorePoolSize(corePoolSize);
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.threadPool.setMaximumPoolSize(maxPoolSize);
    }

    public void setEventKeepAlive(long millies) {
        this.threadPool.setKeepAliveTime(millies, TimeUnit.MILLISECONDS);
    }

    public void setEventSourceConfig(EventSourceConfig eventSourceConfig) {
        this.eventSourceConfig = eventSourceConfig;
    }

    public EventSourceConfig getEventSourceConfig() {
        return this.eventSourceConfig;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WatchDog
    implements Runnable {
        private ConcurrentMap<URI, List<Subscription>> subscriptions;
        private boolean active = true;
        private Thread worker;

        public WatchDog(ConcurrentMap<URI, List<Subscription>> subscriptions) {
            this.subscriptions = subscriptions;
        }

        @Override
        public void run() {
            while (this.active) {
                for (List subscriptions : SubscriptionManager.this.subscriptionMapping.values()) {
                    for (Subscription s : subscriptions) {
                        if (!s.isExpired()) continue;
                        s.end("http://schemas.xmlsoap.org/ws/2004/08/eventing/SourceCanceling");
                        subscriptions.remove(s);
                    }
                }
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    log.error((Object)e);
                }
            }
        }

        public void startup() {
            this.worker = new Thread((Runnable)this, "SubscriptionWatchDog");
            this.worker.start();
        }

        public void shutdown() {
            this.active = false;
        }
    }
}

