/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.Handler;
import javax.xml.rpc.handler.HandlerChain;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPPart;
import org.jboss.logging.Logger;
import org.jboss.util.xml.DOMWriter;
import org.jboss.ws.Constants;
import org.jboss.ws.handler.HandlerWrapper;
import org.jboss.ws.soap.SOAPEnvelopeImpl;
import org.jboss.ws.soap.SOAPMessageContextImpl;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HandlerChainBaseImpl
implements HandlerChain {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$ws$handler$HandlerChainBaseImpl == null ? (class$org$jboss$ws$handler$HandlerChainBaseImpl = HandlerChainBaseImpl.class$("org.jboss.ws.handler.HandlerChainBaseImpl")) : class$org$jboss$ws$handler$HandlerChainBaseImpl));
    public static final int STATE_DOES_NOT_EXIST = 0;
    public static final int STATE_CREATED = 1;
    public static final int STATE_READY = 2;
    public static final int STATE_DESTROYED = 3;
    protected List<HandlerEntry> handlers = new ArrayList<HandlerEntry>();
    protected Set<String> roles = new HashSet<String>();
    protected int falseIndex = -1;
    protected int state;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$org$jboss$ws$handler$HandlerChainBaseImpl;

    public HandlerChainBaseImpl(List infos, Set roles) {
        log.debug((Object)new StringBuffer("Create a handler chain for roles: ").append(roles).toString());
        this.addHandlersToChain(infos, roles);
    }

    public List<HandlerInfo> getHandlerInfos() {
        ArrayList<HandlerInfo> list = new ArrayList<HandlerInfo>();
        int i = 0;
        while (i < this.handlers.size()) {
            HandlerEntry entry = this.handlers.get(i);
            list.add(entry.info);
            ++i;
        }
        return list;
    }

    private void addHandlersToChain(List infos, Set roleSet) {
        try {
            if (infos != null) {
                int i = 0;
                while (i < infos.size()) {
                    HandlerInfo info = (HandlerInfo)infos.get(i);
                    HandlerWrapper handler = new HandlerWrapper((Handler)info.getHandlerClass().newInstance());
                    this.handlers.add(new HandlerEntry(handler, info));
                    ++i;
                }
            }
            if (roleSet != null) {
                this.roles.addAll(roleSet);
            }
        }
        catch (Exception e) {
            throw new JAXRPCException("Cannot initialize handler chain", (Throwable)e);
        }
        this.state = 1;
    }

    public int getState() {
        return this.state;
    }

    public void init(Map config) {
        log.debug((Object)new StringBuffer("init: [config=").append(config).append("]").toString());
        int i = 0;
        while (i < this.handlers.size()) {
            HandlerEntry entry = this.handlers.get(i);
            entry.handler.init(entry.info);
            ++i;
        }
        this.state = 2;
    }

    public void destroy() {
        log.debug((Object)"destroy");
        int i = 0;
        while (i < this.handlers.size()) {
            HandlerEntry entry = this.handlers.get(i);
            entry.handler.destroy();
            ++i;
        }
        this.handlers.clear();
        this.state = 3;
    }

    public String[] getRoles() {
        String[] arr = new String[this.roles.size()];
        this.roles.toArray(arr);
        return arr;
    }

    public void setRoles(String[] soapActorNames) {
        List<String> newRoles = Arrays.asList(soapActorNames);
        log.debug((Object)new StringBuffer("setRoles: ").append(newRoles).toString());
        this.roles.clear();
        this.roles.addAll(newRoles);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleRequest(MessageContext msgContext) {
        boolean doNext = true;
        if (this.handlers.size() <= 0) return doNext;
        log.debug((Object)"Enter: handleRequest");
        this.replaceDirtyHandlers();
        int handlerIndex = 0;
        Handler currHandler = null;
        try {
            try {
                while (doNext) {
                    SOAPPart soapPart;
                    SOAPMessageContextImpl msgCtx;
                    if (handlerIndex >= this.handlers.size()) {
                        return doNext;
                    }
                    String lastMessageTrace = null;
                    if (log.isTraceEnabled()) {
                        msgCtx = (SOAPMessageContextImpl)msgContext;
                        soapPart = msgCtx.getMessage().getSOAPPart();
                        lastMessageTrace = this.traceSOAPPart(soapPart, lastMessageTrace);
                    }
                    currHandler = this.handlers.get(handlerIndex).getHandler();
                    log.debug((Object)new StringBuffer("Handle request: ").append(currHandler).toString());
                    doNext = currHandler.handleRequest(msgContext);
                    if (log.isTraceEnabled()) {
                        msgCtx = (SOAPMessageContextImpl)msgContext;
                        soapPart = msgCtx.getMessage().getSOAPPart();
                        lastMessageTrace = this.traceSOAPPart(soapPart, lastMessageTrace);
                    }
                    ++handlerIndex;
                }
                return doNext;
            }
            catch (RuntimeException e) {
                log.error((Object)"RuntimeException in request handler", (Throwable)e);
                doNext = false;
                throw e;
            }
        }
        finally {
            if (!doNext) {
                this.falseIndex = handlerIndex - 1;
            }
            log.debug((Object)new StringBuffer("Exit: handleRequest with status: ").append(doNext).toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleResponse(MessageContext msgContext) {
        boolean doNext = true;
        if (this.handlers.size() <= 0) return doNext;
        log.debug((Object)"Enter: handleResponse");
        int handlerIndex = this.handlers.size() - 1;
        if (this.falseIndex != -1) {
            handlerIndex = this.falseIndex;
        }
        Handler currHandler = null;
        try {
            try {
                while (doNext) {
                    SOAPPart soapPart;
                    SOAPMessageContextImpl msgCtx;
                    if (handlerIndex < 0) {
                        return doNext;
                    }
                    String lastMessageTrace = null;
                    if (log.isTraceEnabled()) {
                        msgCtx = (SOAPMessageContextImpl)msgContext;
                        soapPart = msgCtx.getMessage().getSOAPPart();
                        lastMessageTrace = this.traceSOAPPart(soapPart, lastMessageTrace);
                    }
                    currHandler = this.handlers.get(handlerIndex).getHandler();
                    log.debug((Object)new StringBuffer("Handle response: ").append(currHandler).toString());
                    doNext = currHandler.handleResponse(msgContext);
                    if (log.isTraceEnabled()) {
                        msgCtx = (SOAPMessageContextImpl)msgContext;
                        soapPart = msgCtx.getMessage().getSOAPPart();
                        lastMessageTrace = this.traceSOAPPart(soapPart, lastMessageTrace);
                    }
                    --handlerIndex;
                }
                return doNext;
            }
            catch (RuntimeException rte) {
                log.error((Object)"RuntimeException in response handler", (Throwable)rte);
                doNext = false;
                throw rte;
            }
        }
        finally {
            if (!doNext) {
                this.falseIndex = handlerIndex - 1;
            }
            log.debug((Object)new StringBuffer("Exit: handleResponse with status: ").append(doNext).toString());
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleFault(MessageContext msgContext) {
        boolean doNext = true;
        if (this.handlers.size() <= 0) return doNext;
        log.debug((Object)"Enter: handleFault");
        try {
            block7: {
                Handler currHandler;
                int handlerIndex;
                block6: {
                    handlerIndex = this.handlers.size() - 1;
                    if (this.falseIndex != -1) {
                        handlerIndex = this.falseIndex;
                    }
                    currHandler = null;
                    if (!true) break block6;
                    if (!doNext) return doNext;
                    if (handlerIndex < 0) break block7;
                }
                do {
                    currHandler = this.handlers.get(handlerIndex).getHandler();
                    log.debug((Object)new StringBuffer("Handle fault: ").append(currHandler).toString());
                    doNext = currHandler.handleFault(msgContext);
                    --handlerIndex;
                    if (!doNext) return doNext;
                } while (handlerIndex >= 0);
            }
            return doNext;
        }
        finally {
            log.debug((Object)new StringBuffer("Exit: handleFault with status: ").append(doNext).toString());
        }
    }

    protected String traceSOAPPart(SOAPPart soapPart, String lastMessageTrace) {
        try {
            SOAPEnvelopeImpl soapEnv = (SOAPEnvelopeImpl)soapPart.getEnvelope();
            String envString = DOMWriter.printNode((Node)((Object)soapEnv), (boolean)true);
            if (!envString.equals(lastMessageTrace)) {
                log.debug((Object)envString);
                lastMessageTrace = envString;
            }
            return lastMessageTrace;
        }
        catch (SOAPException e) {
            log.error((Object)"Cannot get SOAPEnvelope", (Throwable)e);
            return null;
        }
    }

    protected void replaceDirtyHandlers() {
        int i = 0;
        while (i < this.handlers.size()) {
            HandlerEntry entry = this.handlers.get(i);
            if (entry.handler.getState() == 0) {
                log.debug((Object)new StringBuffer("Replacing dirty handler: ").append(entry.handler).toString());
                try {
                    HandlerWrapper handler = new HandlerWrapper((Handler)entry.info.getHandlerClass().newInstance());
                    entry.handler = handler;
                    handler.init(entry.info);
                }
                catch (Exception exception) {
                    log.error((Object)new StringBuffer("Cannot create handler instance for: ").append(entry.info).toString());
                }
            }
            ++i;
        }
    }

    protected Handler getHandlerAt(int pos) {
        if (pos < 0 || this.handlers.size() <= pos) {
            throw new IllegalArgumentException(new StringBuffer("No handler at position: ").append(pos).toString());
        }
        HandlerEntry entry = this.handlers.get(pos);
        return entry.handler;
    }

    protected void checkMustUnderstand(MessageContext msgContext) {
        SOAPHeaderElement mustUnderstandHeaderElement = null;
        try {
            SOAPMessageContext msgCtx = (SOAPMessageContext)msgContext;
            SOAPEnvelope soapEnvelope = msgCtx.getMessage().getSOAPPart().getEnvelope();
            if (soapEnvelope != null && soapEnvelope.getHeader() != null) {
                Iterator it = soapEnvelope.getHeader().examineAllHeaderElements();
                while (it.hasNext() && mustUnderstandHeaderElement == null) {
                    SOAPHeaderElement soapHeaderElement = (SOAPHeaderElement)it.next();
                    if (!soapHeaderElement.getMustUnderstand()) continue;
                    String actor = soapHeaderElement.getActor();
                    boolean noActor = actor == null || actor.length() == 0;
                    boolean nextActor = "http://schemas.xmlsoap.org/soap/actor/next".equals(actor);
                    if (!noActor && !nextActor && !this.roles.contains(actor)) continue;
                    mustUnderstandHeaderElement = soapHeaderElement;
                }
            }
        }
        catch (SOAPException e) {
            log.error((Object)"Cannot check mustUnderstand for headers", (Throwable)e);
        }
        if (mustUnderstandHeaderElement != null) {
            QName faultCode = Constants.SOAP11_FAULT_CODE_MUST_UNDERSTAND;
            String faultString = new StringBuffer("Unprocessed 'mustUnderstand' header element: ").append(mustUnderstandHeaderElement.getElementName()).toString();
            throw new SOAPFaultException(faultCode, faultString, null, null);
        }
    }

    public boolean remove(Object o) {
        return this.handlers.remove(o);
    }

    public boolean containsAll(Collection c) {
        return this.handlers.containsAll(c);
    }

    public boolean removeAll(Collection c) {
        return this.handlers.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        return this.handlers.retainAll(c);
    }

    public int hashCode() {
        return this.handlers.hashCode();
    }

    public boolean equals(Object o) {
        return this.handlers.equals(o);
    }

    public Iterator iterator() {
        return this.handlers.iterator();
    }

    public List subList(int fromIndex, int toIndex) {
        return this.handlers.subList(fromIndex, toIndex);
    }

    public ListIterator listIterator() {
        return this.handlers.listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.handlers.listIterator(index);
    }

    public int size() {
        return this.handlers.size();
    }

    public void clear() {
        this.handlers.clear();
    }

    public boolean isEmpty() {
        return this.handlers.isEmpty();
    }

    public Object[] toArray() {
        return this.handlers.toArray();
    }

    public Object get(int index) {
        return this.handlers.get(index);
    }

    public Object remove(int index) {
        return this.handlers.remove(index);
    }

    public void add(int index, Object element) {
        this.handlers.add(index, (HandlerEntry)element);
    }

    public int indexOf(Object elem) {
        return this.handlers.indexOf(elem);
    }

    public int lastIndexOf(Object elem) {
        return this.handlers.lastIndexOf(elem);
    }

    public boolean add(Object o) {
        return this.handlers.add((HandlerEntry)o);
    }

    public boolean contains(Object elem) {
        return this.handlers.contains(elem);
    }

    public boolean addAll(int index, Collection c) {
        return this.handlers.addAll(index, c);
    }

    public boolean addAll(Collection c) {
        return this.handlers.addAll(c);
    }

    public Object set(int index, Object element) {
        return this.handlers.set(index, (HandlerEntry)element);
    }

    public Object[] toArray(Object[] a) {
        return this.handlers.toArray(a);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class HandlerEntry {
        private HandlerWrapper handler;
        private HandlerInfo info;

        public HandlerEntry(HandlerWrapper handler, HandlerInfo info) {
            this.handler = handler;
            this.info = info;
        }

        public Handler getHandler() {
            return this.handler;
        }

        public HandlerInfo getInfo() {
            return this.info;
        }
    }
}

