/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.jaxb;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.xerces.xs.XSModel;
import org.jboss.logging.Logger;
import org.jboss.util.NotImplementedException;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaXmlTypeMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.PackageMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.VariableMapping;
import org.jboss.ws.WSException;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.metadata.ClassMetaData;
import org.jboss.xb.binding.metadata.PackageMetaData;
import org.jboss.xb.binding.metadata.PropertyMetaData;
import org.jboss.xb.binding.sunday.unmarshalling.AttributeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultSchemaResolver;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ModelGroupBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.TermBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.XsdBinder;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class JAXBUnmarshallerImpl
implements Unmarshaller {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$ws$jaxb$JAXBUnmarshallerImpl == null ? (class$org$jboss$ws$jaxb$JAXBUnmarshallerImpl = JAXBUnmarshallerImpl.class$("org.jboss.ws.jaxb.JAXBUnmarshallerImpl")) : class$org$jboss$ws$jaxb$JAXBUnmarshallerImpl));
    private HashMap<String, Object> properties = new HashMap();
    private SchemaBinding schemaBinding;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$org$jboss$ws$jaxb$JAXBUnmarshallerImpl;

    public Object unmarshal(InputStream is) throws JAXBException {
        this.assertRequiredProperties();
        org.jboss.xb.binding.Unmarshaller unm = UnmarshallerFactory.newInstance().newUnmarshaller();
        this.initSchemaBinding();
        try {
            return unm.unmarshal(is, this.schemaBinding);
        }
        catch (JBossXBException e) {
            throw new JAXBException(e.getMessage(), (Throwable)e);
        }
    }

    public UnmarshallerHandler getUnmarshallerHandler() {
        throw new NotImplementedException();
    }

    public Object unmarshal(File file) throws JAXBException {
        this.assertRequiredProperties();
        try {
            return this.unmarshal(file.toURL());
        }
        catch (MalformedURLException e) {
            throw new WSException("Malformed URL for file " + file.toString() + ": " + e.getMessage());
        }
    }

    public Object unmarshal(InputSource source) throws JAXBException {
        this.assertRequiredProperties();
        org.jboss.xb.binding.Unmarshaller unm = UnmarshallerFactory.newInstance().newUnmarshaller();
        this.initSchemaBinding();
        try {
            if (source.getByteStream() != null) {
                return unm.unmarshal(source.getByteStream(), this.schemaBinding);
            }
            if (source.getCharacterStream() != null) {
                return unm.unmarshal(source.getCharacterStream(), this.schemaBinding);
            }
            if (source.getSystemId() != null) {
                return unm.unmarshal(source.getSystemId(), this.schemaBinding);
            }
            throw new WSException("InputSource instance does not contain any source information.");
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (JBossXBException e) {
            throw new JAXBException(e.getMessage(), (Throwable)e);
        }
    }

    public Object unmarshal(Node node) {
        throw new NotImplementedException();
    }

    public Object unmarshal(Source source) throws JAXBException {
        this.assertRequiredProperties();
        org.jboss.xb.binding.Unmarshaller unm = UnmarshallerFactory.newInstance().newUnmarshaller();
        this.initSchemaBinding();
        try {
            return unm.unmarshal(source.getSystemId(), this.schemaBinding);
        }
        catch (JBossXBException e) {
            throw new JAXBException(e.getMessage(), (Throwable)e);
        }
    }

    public Object unmarshal(URL url) throws JAXBException {
        this.assertRequiredProperties();
        org.jboss.xb.binding.Unmarshaller unm = UnmarshallerFactory.newInstance().newUnmarshaller();
        this.initSchemaBinding();
        try {
            return unm.unmarshal(url.toString(), this.schemaBinding);
        }
        catch (JBossXBException e) {
            throw new JAXBException(e.getMessage(), (Throwable)e);
        }
    }

    public ValidationEventHandler getEventHandler() {
        throw new NotImplementedException();
    }

    public void setEventHandler(ValidationEventHandler handler) {
        throw new NotImplementedException();
    }

    public Object getProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name parameter is null");
        }
        return this.properties.get(name);
    }

    public void setProperty(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("name parameter is null");
        }
        this.properties.put(name, value);
    }

    public boolean isValidating() {
        return false;
    }

    public void setValidating(boolean validating) {
        if (validating) {
            throw new NotImplementedException();
        }
    }

    private void initSchemaBinding() {
        if (this.schemaBinding == null) {
            QName rootType;
            QName xmlType;
            QName xmlName = (QName)this.getProperty("org.jboss.jaxb.root.qname");
            if (xmlName == null) {
                throw new WSException("Cannot obtain root element name");
            }
            String nsURI = xmlName.getNamespaceURI();
            if (nsURI.length() == 0 && (xmlType = (QName)this.getProperty("org.jboss.jaxb.type.qname")) != null) {
                nsURI = xmlType.getNamespaceURI();
            }
            XSModel model = (XSModel)this.getProperty("org.jboss.jaxb.xsd.xsmodel");
            this.schemaBinding = XsdBinder.bind((XSModel)model, (SchemaBindingResolver)new DefaultSchemaResolver());
            this.schemaBinding.setIgnoreLowLine(false);
            this.schemaBinding.setIgnoreUnresolvedFieldOrClass(false);
            this.schemaBinding.setUnmarshalListsToArrays(true);
            this.schemaBinding.setSimpleContentProperty("_value");
            JavaWsdlMapping wsdlMapping = (JavaWsdlMapping)this.getProperty("org.jboss.jaxb.java.mapping");
            if (wsdlMapping != null) {
                this.bindSchemaToJava(this.schemaBinding, wsdlMapping);
            }
            if ((rootType = (QName)this.getProperty("org.jboss.jaxb.type.qname")) != null) {
                TypeBinding type = rootType.getLocalPart().startsWith(">") ? this.getAnonymousTypeBinding(this.schemaBinding, rootType.getLocalPart()) : this.schemaBinding.getType(rootType);
                if (type == null) {
                    throw new WSException("Root type " + rootType + " not found in the schema.");
                }
                QName rootElement = (QName)this.getProperty("org.jboss.jaxb.root.qname");
                if (rootElement == null) {
                    throw new WSException("Root type QName specified (" + rootType + ") but root element name is not!");
                }
                this.schemaBinding.addElement(rootElement, type);
            }
        }
    }

    private void bindSchemaToJava(SchemaBinding schema, JavaWsdlMapping wsdlMapping) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("bindSchemaToJava: " + schema));
        }
        PackageMapping[] packageMappingArray = wsdlMapping.getPackageMappings();
        int n = 0;
        int n2 = packageMappingArray.length;
        while (n < n2) {
            PackageMapping packageMapping = packageMappingArray[n];
            this.processPackageMapping(schema, packageMapping);
            ++n;
        }
        packageMappingArray = wsdlMapping.getJavaXmlTypeMappings();
        n = 0;
        n2 = packageMappingArray.length;
        while (n < n2) {
            PackageMapping typeMapping = packageMappingArray[n];
            this.processJavaXmlTypeMapping(schema, (JavaXmlTypeMapping)typeMapping);
            ++n;
        }
    }

    private void processPackageMapping(SchemaBinding schema, PackageMapping packageMapping) {
        PackageMetaData packageMetaData = schema.getPackageMetaData();
        if (packageMetaData == null) {
            packageMetaData = new PackageMetaData();
            schema.setPackageMetaData(packageMetaData);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Bound namespace " + packageMapping.getNamespaceURI() + " to package " + packageMapping.getPackageType()));
        }
        packageMetaData.setName(packageMapping.getPackageType());
    }

    private void processJavaXmlTypeMapping(SchemaBinding schema, JavaXmlTypeMapping typeMapping) {
        String javaType = typeMapping.getJavaType();
        if (javaType.endsWith("[]")) {
            this.processArrayType(schema, typeMapping);
        } else {
            this.processNonArrayType(schema, typeMapping);
        }
    }

    private void processArrayType(SchemaBinding schema, JavaXmlTypeMapping typeMapping) {
        QName xmlType = this.getXmlType(typeMapping);
        log.trace((Object)("Ignore array type: " + xmlType));
    }

    private void processNonArrayType(SchemaBinding schema, JavaXmlTypeMapping typeMapping) {
        QName xmlType = this.getXmlType(typeMapping);
        String javaType = typeMapping.getJavaType();
        log.trace((Object)("processNonArrayType: [xmlType=" + xmlType + ",javaType=" + javaType + "]"));
        TypeBinding typeBinding = this.getTypeBinding(schema, typeMapping);
        if (typeBinding != null) {
            VariableMapping[] variableMappings;
            ClassMetaData classMetaData = typeBinding.getClassMetaData();
            if (classMetaData == null) {
                classMetaData = new ClassMetaData();
                typeBinding.setClassMetaData(classMetaData);
            }
            classMetaData.setImpl(javaType);
            if (log.isTraceEnabled()) {
                QName typeQName = typeBinding.getQName();
                log.trace((Object)("Bound: [xmlType=" + typeQName + ",javaType=" + javaType + "]"));
            }
            VariableMapping[] variableMappingArray = variableMappings = typeMapping.getVariableMappings();
            int n = 0;
            int n2 = variableMappingArray.length;
            while (n < n2) {
                VariableMapping varMapping = variableMappingArray[n];
                if (varMapping.getXmlElementName() != null) {
                    this.processXmlElementName(typeBinding, varMapping);
                } else if (varMapping.getXmlAttributeName() != null) {
                    this.processXmlAttributeName(typeBinding, varMapping);
                } else {
                    throw new IllegalArgumentException("XML wildcard is not supported in variable-mapping");
                }
                ++n;
            }
        } else {
            log.warn((Object)("Cannot obtain type binding for: " + xmlType));
        }
    }

    private void processXmlAttributeName(TypeBinding typeBinding, VariableMapping varMapping) {
        String xmlAttrName = varMapping.getXmlAttributeName();
        log.trace((Object)("processXmlAttributeName: " + xmlAttrName));
        QName xmlName = new QName(xmlAttrName);
        AttributeBinding attr = typeBinding.getAttribute(xmlName);
        if (attr == null) {
            String nsURI = typeBinding.getQName().getNamespaceURI();
            if ("mustUnderstand".equals(xmlAttrName) || "actor".equals(xmlAttrName) || "role".equals(xmlAttrName)) {
                nsURI = "http://schemas.xmlsoap.org/soap/envelope/";
            }
            xmlName = new QName(nsURI, xmlAttrName);
            attr = typeBinding.getAttribute(xmlName);
        }
        if (attr == null) {
            QName typeQName = typeBinding.getQName();
            throw new WSException("Attribute " + xmlName + " found in jaxrpc-mapping but not in the schema: " + typeQName);
        }
        String javaVariableName = varMapping.getJavaVariableName();
        PropertyMetaData prop = new PropertyMetaData();
        prop.setName(javaVariableName);
        attr.setPropertyMetaData(prop);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Bound attribute " + xmlName + " to property " + prop.getName()));
        }
    }

    private void processXmlElementName(TypeBinding typeBinding, VariableMapping varMapping) {
        TermBinding term;
        ParticleBinding particle;
        QName xmlName = new QName(varMapping.getXmlElementName());
        log.trace((Object)("processXmlElementName: " + xmlName));
        ElementBinding element = typeBinding.getElement(xmlName);
        QName typeQName = typeBinding.getQName();
        if (element == null && typeQName != null) {
            String nsURI = typeQName.getNamespaceURI();
            xmlName = new QName(nsURI, varMapping.getXmlElementName());
            element = typeBinding.getElement(xmlName);
        }
        if (element == null && (particle = typeBinding.getParticle()) != null && (term = particle.getTerm()) instanceof ModelGroupBinding) {
            Iterator iterator = ((ModelGroupBinding)term).getParticles().iterator();
            element = this.findLocalPathElement(iterator, new String[]{varMapping.getXmlElementName()}, 0);
        }
        if (element == null) {
            throw new WSException("Element " + xmlName + " found in jaxrpc-mapping but not in the schema: " + typeQName);
        }
        String javaVariableName = varMapping.getJavaVariableName();
        if (javaVariableName != null) {
            PropertyMetaData prop = new PropertyMetaData();
            prop.setName(javaVariableName);
            element.setPropertyMetaData(prop);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Bound element " + xmlName + " to property " + prop.getName()));
            }
        }
    }

    private TypeBinding getTypeBinding(SchemaBinding schema, JavaXmlTypeMapping typeMapping) {
        String qnameScope = typeMapping.getQnameScope();
        QName anonymousTypeQName = typeMapping.getAnonymousTypeQName();
        if (anonymousTypeQName != null) {
            return this.getAnonymousTypeBinding(schema, anonymousTypeQName.getLocalPart());
        }
        QName xmlType = typeMapping.getRootTypeQName();
        TypeBinding typeBinding = null;
        if ("complexType".equals(qnameScope) || "simpleType".equals(qnameScope)) {
            typeBinding = schema.getType(xmlType);
            if (typeBinding == null) {
                log.warn((Object)("Type definition not found in schema: " + xmlType));
            }
        } else if ("element".equals(qnameScope)) {
            ElementBinding element = schema.getElement(xmlType);
            if (element != null) {
                typeBinding = element.getType();
            } else {
                log.warn((Object)("Global element not found in schema: " + xmlType));
            }
        } else {
            throw new WSException("Unexpected qname-scope for " + typeMapping.getJavaType() + ": " + qnameScope);
        }
        return typeBinding;
    }

    private TypeBinding getAnonymousTypeBinding(SchemaBinding schema, String expression) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Searching for anonymous expression: " + expression));
        }
        ArrayList<String> list = new ArrayList<String>(10);
        int i = 0;
        int begin = -1;
        while (i < expression.length()) {
            if (expression.charAt(i) == '>') {
                if (begin != -1) {
                    list.add(expression.substring(begin, i));
                    begin = -1;
                }
            } else if (begin == -1) {
                begin = i;
            } else if (i == expression.length() - 1) {
                list.add(expression.substring(begin));
            }
            ++i;
        }
        ElementBinding element = this.findLocalPathElement(schema.getElements(), list.toArray(new String[0]));
        if (element == null) {
            element = this.findLocalPathElementInTypes(schema.getTypes(), list.toArray(new String[0]));
        }
        if (element == null) {
            return null;
        }
        return element.getType();
    }

    private ElementBinding findLocalPathElement(Iterator elements, String[] path) {
        while (elements.hasNext()) {
            ElementBinding element = (ElementBinding)elements.next();
            if ((element = this.findLocalPathElement(element, path, 0)) == null) continue;
            return element;
        }
        return null;
    }

    private ElementBinding findLocalPathElementInTypes(Iterator types, String[] path) {
        while (types.hasNext()) {
            TermBinding term;
            ParticleBinding particle;
            TypeBinding type = (TypeBinding)types.next();
            if (!type.getQName().getLocalPart().equals(path[0]) || (particle = type.getParticle()) == null || !(term = particle.getTerm()).isModelGroup()) continue;
            return this.findLocalPathElement(((ModelGroupBinding)term).getParticles().iterator(), path, 1);
        }
        return null;
    }

    private ElementBinding findLocalPathElement(ElementBinding element, String[] path, int pos) {
        String name = path[pos];
        if (!name.equals(element.getQName().getLocalPart())) {
            return null;
        }
        if (path.length - 1 == pos) {
            return element;
        }
        ParticleBinding particle = element.getType().getParticle();
        if (particle == null) {
            return null;
        }
        TermBinding term = particle.getTerm();
        if (!term.isModelGroup()) {
            return null;
        }
        ModelGroupBinding group = (ModelGroupBinding)term;
        Iterator i = group.getParticles().iterator();
        return this.findLocalPathElement(i, path, pos + 1);
    }

    private ElementBinding findLocalPathElement(Iterator particles, String[] path, int pos) {
        while (particles.hasNext()) {
            Iterator i;
            ElementBinding element;
            TermBinding term = ((ParticleBinding)particles.next()).getTerm();
            if (term instanceof ElementBinding) {
                ElementBinding element2 = (ElementBinding)term;
                if ((element2 = this.findLocalPathElement(element2, path, pos)) == null) continue;
                return element2;
            }
            if (!(term instanceof ModelGroupBinding) || (element = this.findLocalPathElement(i = ((ModelGroupBinding)term).getParticles().iterator(), path, pos)) == null) continue;
            return element;
        }
        return null;
    }

    private QName getXmlType(JavaXmlTypeMapping typeMapping) {
        QName xmlType = typeMapping.getRootTypeQName();
        if (xmlType == null && typeMapping.getAnonymousTypeQName() != null) {
            xmlType = typeMapping.getAnonymousTypeQName();
        }
        return xmlType;
    }

    private void assertRequiredProperties() {
        if (this.getProperty("org.jboss.jaxb.xsd.xsmodel") == null) {
            throw new WSException("Cannot find required property: org.jboss.jaxb.xsd.xsmodel");
        }
        if (this.getProperty("org.jboss.jaxb.java.mapping") == null) {
            throw new WSException("Cannot find required property: org.jboss.jaxb.java.mapping");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

