/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.jaxrpc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;
import javax.xml.rpc.soap.SOAPFaultException;
import org.jboss.ws.WSException;
import org.jboss.ws.jaxrpc.CallImpl;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.utils.JavaUtils;

public class CallProxy
implements InvocationHandler {
    private CallImpl call;
    private List stubMethods;
    private List objectMethods;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$org$jboss$ws$jaxrpc$StubExt;
    static /* synthetic */ Class class$org$jboss$ws$jaxrpc$CallImpl;
    static /* synthetic */ Class class$java$lang$Object;

    public CallProxy(CallImpl call) {
        this.call = call;
        this.stubMethods = Arrays.asList((class$org$jboss$ws$jaxrpc$StubExt == null ? (class$org$jboss$ws$jaxrpc$StubExt = CallProxy.class$("org.jboss.ws.jaxrpc.StubExt")) : class$org$jboss$ws$jaxrpc$StubExt).getMethods());
        this.objectMethods = Arrays.asList((class$java$lang$Object == null ? (class$java$lang$Object = CallProxy.class$("java.lang.Object")) : class$java$lang$Object).getMethods());
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (this.stubMethods.contains(method)) {
            if (methodName.equals("_getPropertyNames")) {
                return this.call.getPropertyNames();
            }
            if (methodName.equals("_getProperty")) {
                return this.call.getProperty((String)args[0]);
            }
            if (methodName.equals("_setProperty")) {
                this.call.setProperty((String)args[0], args[1]);
                return null;
            }
            Method callMethod = (class$org$jboss$ws$jaxrpc$CallImpl == null ? (class$org$jboss$ws$jaxrpc$CallImpl = CallProxy.class$("org.jboss.ws.jaxrpc.CallImpl")) : class$org$jboss$ws$jaxrpc$CallImpl).getMethod(methodName, method.getParameterTypes());
            return callMethod.invoke((Object)this.call, args);
        }
        if (this.objectMethods.contains(method)) {
            Method callMethod = (class$org$jboss$ws$jaxrpc$CallImpl == null ? (class$org$jboss$ws$jaxrpc$CallImpl = CallProxy.class$("org.jboss.ws.jaxrpc.CallImpl")) : class$org$jboss$ws$jaxrpc$CallImpl).getMethod(methodName, method.getParameterTypes());
            return callMethod.invoke((Object)this.call, args);
        }
        EndpointMetaData epMetaData = this.call.getEndpointMetaData();
        OperationMetaData opMetaData = epMetaData.getOperation(method);
        if (opMetaData == null) {
            throw new WSException("Cannot obtain operation meta data for: " + methodName);
        }
        this.call.setOperationName(opMetaData.getXmlName());
        try {
            Object retObj = this.call.invoke(args);
            if (retObj != null) {
                Class<?> retType = method.getReturnType();
                if (retType == null) {
                    throw new WSException("Return value not supported by: " + opMetaData);
                }
                if (JavaUtils.isPrimitive(retType)) {
                    retObj = JavaUtils.getPrimitiveValue(retObj);
                }
            }
            return retObj;
        }
        catch (Exception ex) {
            this.handleException(ex);
            return null;
        }
    }

    private void handleException(Exception ex) throws Throwable {
        SOAPFaultException faultEx;
        Throwable th = ex;
        if (ex instanceof RemoteException && ex.getCause() instanceof SOAPFaultException && (faultEx = (SOAPFaultException)ex.getCause()).getCause() != null) {
            th = faultEx.getCause();
        }
        throw th;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

