/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.jaxrpc;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.List;
import net.sf.cglib.beans.BeanGenerator;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.jaxrpc.ParameterStyle;
import org.jboss.ws.jaxrpc.Style;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.metadata.ParameterMetaData;
import org.jboss.ws.metadata.TypeMappingMetaData;
import org.jboss.ws.metadata.TypesMetaData;
import org.jboss.ws.utils.JavaUtils;

public class ParameterWrapping {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$ws$jaxrpc$ParameterWrapping == null ? (class$org$jboss$ws$jaxrpc$ParameterWrapping = ParameterWrapping.class$("org.jboss.ws.jaxrpc.ParameterWrapping")) : class$org$jboss$ws$jaxrpc$ParameterWrapping));
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$org$jboss$ws$jaxrpc$ParameterWrapping$WrapperType;
    static /* synthetic */ Class class$org$jboss$ws$jaxrpc$ParameterWrapping;

    private static void assertOperationMetaData(OperationMetaData opMetaData) {
        if (opMetaData.getStyle() != Style.DOCUMENT) {
            throw new WSException("Unexpected style: " + opMetaData.getStyle());
        }
        if (opMetaData.getNonHeaderParameters().size() != 1) {
            throw new WSException("Unexpected number of input parameters: " + opMetaData.getParameters().size());
        }
        if (opMetaData.getReturnParameter() == null && !opMetaData.isOneWayOperation()) {
            throw new WSException("Unexpected null return parameter");
        }
        if (opMetaData.getParameterStyle() != ParameterStyle.WRAPPED) {
            throw new WSException("Unexpected parameter style: " + opMetaData.getParameterStyle());
        }
    }

    public static boolean matchRequestParameters(OperationMetaData opMetaData, Class[] paramTypes) {
        ParameterWrapping.assertOperationMetaData(opMetaData);
        ParameterMetaData paramMetaData = opMetaData.getParameters().get(0);
        List<String> varNames = paramMetaData.getWrappedVariables();
        Class reqStructType = paramMetaData.getJavaType();
        log.debug((Object)("matchRequestParameters: " + reqStructType.getName()));
        try {
            boolean pass = true;
            int i = 0;
            while (pass && i < varNames.size()) {
                String varName = varNames.get(i);
                PropertyDescriptor pd = new PropertyDescriptor(varName, reqStructType);
                Method method = pd.getWriteMethod();
                Class<?> methodType = method.getParameterTypes()[0];
                Class paramType = paramTypes[i];
                pass = JavaUtils.isAssignableFrom(methodType, paramType);
                ++i;
            }
            return pass;
        }
        catch (Exception ex) {
            log.debug((Object)("Invalid request wrapper: " + ex));
            return false;
        }
    }

    public static Object wrapRequestParameters(OperationMetaData opMetaData, Object[] inParams) {
        ParameterWrapping.assertOperationMetaData(opMetaData);
        ParameterMetaData paramMetaData = opMetaData.getParameters().get(0);
        List<String> varNames = paramMetaData.getWrappedVariables();
        Class reqStructType = paramMetaData.getJavaType();
        log.debug((Object)("wrapRequestParameters: " + reqStructType.getName()));
        try {
            Object reqStruct = reqStructType.newInstance();
            int i = 0;
            while (i < varNames.size()) {
                String varName = varNames.get(i);
                PropertyDescriptor pd = new PropertyDescriptor(varName, reqStructType);
                Method method = pd.getWriteMethod();
                Object value = inParams[i];
                log.debug((Object)(" " + method.getName() + ": " + (value != null ? value.getClass().getName() : null)));
                method.invoke(reqStruct, value);
                ++i;
            }
            return reqStruct;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new WSException("Cannot wrap request structure: " + e);
        }
    }

    public static Object[] unwrapRequestParameters(OperationMetaData opMetaData, Object reqStruct) {
        ParameterWrapping.assertOperationMetaData(opMetaData);
        if (reqStruct == null) {
            throw new IllegalArgumentException("Request struct cannot be null");
        }
        ParameterMetaData paramMetaData = opMetaData.getParameters().get(0);
        List<String> varNames = paramMetaData.getWrappedVariables();
        Class<?> reqStructType = reqStruct.getClass();
        log.debug((Object)("unwrapRequestParameters: " + reqStructType.getName()));
        Object[] inParams = new Object[varNames.size()];
        try {
            int i = 0;
            while (i < varNames.size()) {
                String varName = varNames.get(i);
                PropertyDescriptor pd = new PropertyDescriptor(varName, reqStructType);
                Method method = pd.getReadMethod();
                Object value = method.invoke(reqStruct, new Object[0]);
                log.debug((Object)(" " + method.getName() + ": " + (value != null ? value.getClass().getName() : null)));
                inParams[i] = value;
                ++i;
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot unwrap request structure: " + e);
        }
        return inParams;
    }

    public static Object wrapResponseParameter(OperationMetaData opMetaData, Object outParam) {
        ParameterWrapping.assertOperationMetaData(opMetaData);
        ParameterMetaData paramMetaData = opMetaData.getReturnParameter();
        List<String> varNames = paramMetaData.getWrappedVariables();
        Class resStructType = paramMetaData.getJavaType();
        if (outParam != null && outParam.getClass() == resStructType) {
            log.debug((Object)("Response parameter already wrapped" + resStructType.getName()));
            return outParam;
        }
        log.debug((Object)("wrapResponseParameter: " + resStructType.getName()));
        try {
            Object resStruct = resStructType.newInstance();
            if (varNames.size() > 0) {
                String varName = varNames.get(0);
                PropertyDescriptor pd = new PropertyDescriptor(varName, resStructType);
                Method method = pd.getWriteMethod();
                Object value = outParam;
                log.debug((Object)(" " + method.getName() + ": " + (value != null ? value.getClass().getName() : null)));
                method.invoke(resStruct, value);
            }
            return resStruct;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new WSException("Cannot wrap response structure: " + e);
        }
    }

    public static Object unwrapResponseParameter(OperationMetaData opMetaData, Object resStruct) {
        ParameterWrapping.assertOperationMetaData(opMetaData);
        Object retValue = null;
        if (resStruct != null) {
            ParameterMetaData paramMetaData = opMetaData.getReturnParameter();
            List<String> varNames = paramMetaData.getWrappedVariables();
            Class<?> resStructType = resStruct.getClass();
            log.debug((Object)("unwrapResponseParameter: " + resStructType.getName()));
            try {
                if (varNames.size() > 0) {
                    String varName = varNames.get(0);
                    PropertyDescriptor pd = new PropertyDescriptor(varName, resStructType);
                    Method method = pd.getReadMethod();
                    Object value = method.invoke(resStruct, new Object[0]);
                    log.debug((Object)(" " + method.getName() + ": " + (value != null ? value.getClass().getName() : null)));
                    retValue = value;
                }
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot unwrap request structure: " + e);
            }
        }
        return retValue;
    }

    public static void generateWrapper(ParameterMetaData pmd, boolean addTypeMapping) throws IllegalStateException {
        List<String> wrappedTypes = pmd.getWrappedTypes();
        List<String> wrappedVariables = pmd.getWrappedVariables();
        ClassLoader loader = pmd.getOperationMetaData().getEndpointMetaData().getServiceMetaData().getUnifiedMetaData().getClassLoader();
        if (!pmd.isGeneratedWrapper()) {
            throw new WSException("This ParameterMetaData does not allow type generation");
        }
        if (wrappedTypes == null) {
            throw new WSException("Cannot generate a type when their is no type information");
        }
        BeanGenerator gen = new BeanGenerator();
        gen.setSuperclass(class$org$jboss$ws$jaxrpc$ParameterWrapping$WrapperType == null ? (class$org$jboss$ws$jaxrpc$ParameterWrapping$WrapperType = ParameterWrapping.class$("org.jboss.ws.jaxrpc.ParameterWrapping$WrapperType")) : class$org$jboss$ws$jaxrpc$ParameterWrapping$WrapperType);
        gen.setClassLoader(loader);
        int i = 0;
        while (i < wrappedTypes.size()) {
            Class type;
            String typeName = wrappedTypes.get(i);
            String name = wrappedVariables.get(i);
            try {
                type = JavaUtils.loadJavaType(typeName, loader);
            }
            catch (ClassNotFoundException e) {
                throw new WSException(e);
            }
            gen.addProperty(name, type);
            ++i;
        }
        Class wrapperType = (Class)gen.createClass();
        String wrapperName = wrapperType.getName();
        if (addTypeMapping) {
            TypesMetaData typesMetaData = pmd.getOperationMetaData().getEndpointMetaData().getServiceMetaData().getTypesMetaData();
            TypeMappingMetaData tmMetaData = new TypeMappingMetaData(typesMetaData, pmd.getXmlType(), wrapperName);
            typesMetaData.addTypeMapping(tmMetaData);
        }
        pmd.setJavaTypeName(wrapperName);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class WrapperType {
    }
}

