/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.jaxrpc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import javax.xml.rpc.handler.HandlerChain;
import javax.xml.rpc.handler.HandlerRegistry;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.webservice.metadata.serviceref.ServiceRefMetaData;
import org.jboss.ws.jaxrpc.CallImpl;
import org.jboss.ws.jaxrpc.CallProxy;
import org.jboss.ws.jaxrpc.HandlerRegistryImpl;
import org.jboss.ws.jaxrpc.MetaDataSynchronization;
import org.jboss.ws.jaxrpc.ServiceDesc;
import org.jboss.ws.jaxrpc.ServiceExt;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.JSR109ClientMetaDataBuilder;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.metadata.ServiceMetaData;
import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;

public class ServiceImpl
implements ServiceExt {
    private ServiceDesc serviceDesc;
    private URL wsdlLocation;
    private HandlerRegistryImpl handlerRegistry;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$org$jboss$ws$jaxrpc$StubExt;
    static /* synthetic */ Class class$java$rmi$Remote;

    ServiceImpl(QName serviceName) {
        this.serviceDesc = new ServiceDesc(serviceName);
        this.handlerRegistry = new HandlerRegistryImpl();
    }

    ServiceImpl(QName serviceName, URL wsdlURL, URL mappingURL, URL securityURL) {
        this.wsdlLocation = wsdlURL;
        JSR109ClientMetaDataBuilder builder = new JSR109ClientMetaDataBuilder();
        ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
        builder.setResourceLoader(new URLClassLoader(new URL[0], ctxClassLoader));
        builder.setClassLoader(ctxClassLoader);
        ServiceMetaData serviceMetaData = builder.buildMetaData(serviceName, wsdlURL, mappingURL, securityURL, null);
        this.serviceDesc = new ServiceDesc(serviceMetaData);
        this.handlerRegistry = new HandlerRegistryImpl();
    }

    ServiceImpl(QName serviceName, URL wsdlURL, JavaWsdlMapping mappingURL, WSSecurityConfiguration securityConfig, ServiceRefMetaData serviceRefMetaData) {
        this.wsdlLocation = wsdlURL;
        JSR109ClientMetaDataBuilder builder = new JSR109ClientMetaDataBuilder();
        ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
        builder.setResourceLoader(new URLClassLoader(new URL[0], ctxClassLoader));
        builder.setClassLoader(ctxClassLoader);
        ServiceMetaData serviceMetaData = builder.buildMetaData(serviceName, wsdlURL, mappingURL, securityConfig, serviceRefMetaData);
        this.serviceDesc = new ServiceDesc(serviceMetaData);
        this.handlerRegistry = new HandlerRegistryImpl();
    }

    public ServiceDesc getServiceDesc() {
        return this.serviceDesc;
    }

    public URL getWSDLDocumentLocation() {
        return this.wsdlLocation;
    }

    public QName getServiceName() {
        return this.serviceDesc.getServiceName();
    }

    public Call createCall(QName endpointName) throws ServiceException {
        String nsURI = endpointName.getNamespaceURI();
        this.serviceDesc.assertTargetNamespace(nsURI);
        return new CallImpl(this, endpointName, null);
    }

    public Call createCall(QName endpointName, String operationName) throws ServiceException {
        String nsURI = endpointName.getNamespaceURI();
        this.serviceDesc.assertTargetNamespace(nsURI);
        QName opName = new QName(nsURI, operationName);
        return new CallImpl(this, endpointName, opName);
    }

    public Call createCall(QName endpointName, QName opName) throws ServiceException {
        this.serviceDesc.assertTargetNamespace(endpointName.getNamespaceURI());
        this.serviceDesc.assertTargetNamespace(opName.getNamespaceURI());
        return new CallImpl(this, endpointName, opName);
    }

    public Call createCall() throws ServiceException {
        return new CallImpl(this);
    }

    public Call[] getCalls(QName epName) throws ServiceException {
        EndpointMetaData epMetaData = this.serviceDesc.getServiceMetaData().getEndpoint(epName);
        if (epMetaData == null) {
            throw new ServiceException("Cannot find endpoint for name: " + epName);
        }
        ArrayList<Call> calls = new ArrayList<Call>();
        Iterator<OperationMetaData> iterator = epMetaData.getOperations().iterator();
        while (iterator.hasNext()) {
            OperationMetaData opMetaData = iterator.next();
            Call call = this.createCall(epName, opMetaData.getXmlName());
            calls.add(call);
        }
        Call[] callArr = new Call[calls.size()];
        calls.toArray(callArr);
        return callArr;
    }

    public HandlerRegistry getHandlerRegistry() {
        throw new UnsupportedOperationException("Components should not use the getHandlerRegistry() method.");
    }

    public HandlerRegistry getDynamicHandlerRegistry() {
        return this.handlerRegistry;
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        throw new UnsupportedOperationException("Components should not use the getTypeMappingRegistry() method.");
    }

    public Iterator getPorts() throws ServiceException {
        ArrayList<QName> list = new ArrayList<QName>();
        ServiceMetaData serviceMetaData = this.serviceDesc.getServiceMetaData();
        if (serviceMetaData != null) {
            Iterator<EndpointMetaData> iterator = serviceMetaData.getEndpoints().iterator();
            while (iterator.hasNext()) {
                EndpointMetaData epMetaData = iterator.next();
                list.add(epMetaData.getName());
            }
        }
        return list.iterator();
    }

    public Remote getPort(Class seiClass) throws ServiceException {
        if (seiClass == null) {
            throw new IllegalArgumentException("SEI class cannot be null");
        }
        String seiName = seiClass.getName();
        if (!(class$java$rmi$Remote == null ? (class$java$rmi$Remote = ServiceImpl.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(seiClass)) {
            throw new ServiceException("SEI does not implement java.rmi.Remote: " + seiName);
        }
        ServiceMetaData serviceMetaData = this.serviceDesc.getServiceMetaData();
        if (serviceMetaData == null) {
            throw new ServiceException("Service meta data not available");
        }
        EndpointMetaData epMetaData = serviceMetaData.getEndpointByServiceEndpointInterface(seiName);
        if (epMetaData == null && serviceMetaData.getEndpoints().size() == 1) {
            epMetaData = serviceMetaData.getEndpoints().get(0);
            epMetaData.setServiceEndpointInterfaceName(seiName);
        }
        if (epMetaData == null) {
            throw new ServiceException("Cannot find endpoint meta data for: " + seiName);
        }
        return this.createProxy(seiClass, epMetaData);
    }

    public Remote getPort(QName endpointName, Class seiClass) throws ServiceException {
        if (seiClass == null) {
            throw new IllegalArgumentException("SEI class cannot be null");
        }
        ServiceMetaData serviceMetaData = this.serviceDesc.getServiceMetaData();
        if (serviceMetaData == null) {
            throw new ServiceException("Service meta data not available");
        }
        String seiName = seiClass.getName();
        if (!(class$java$rmi$Remote == null ? (class$java$rmi$Remote = ServiceImpl.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(seiClass)) {
            throw new ServiceException("SEI does not implement java.rmi.Remote: " + seiName);
        }
        EndpointMetaData epMetaData = serviceMetaData.getEndpoint(endpointName);
        if (epMetaData == null) {
            throw new ServiceException("Cannot obtain endpoint meta data for: " + endpointName);
        }
        if (epMetaData.getServiceEndpointInterfaceName() == null) {
            epMetaData.setServiceEndpointInterfaceName(seiName);
        }
        return this.createProxy(seiClass, epMetaData);
    }

    private Remote createProxy(Class seiClass, EndpointMetaData epMetaData) throws ServiceException {
        try {
            MetaDataSynchronization.synchronizeServiceEndpointInterface(epMetaData, seiClass);
            CallImpl call = new CallImpl(this, epMetaData);
            CallProxy handler = new CallProxy(call);
            ClassLoader cl = epMetaData.getClassLoader();
            Remote proxy = (Remote)Proxy.newProxyInstance(cl, new Class[]{seiClass, class$org$jboss$ws$jaxrpc$StubExt == null ? (class$org$jboss$ws$jaxrpc$StubExt = ServiceImpl.class$("org.jboss.ws.jaxrpc.StubExt")) : class$org$jboss$ws$jaxrpc$StubExt}, (InvocationHandler)handler);
            return proxy;
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ServiceException("Cannot create proxy", (Throwable)ex);
        }
    }

    public HandlerChain getHandlerChain(QName epName) {
        return this.handlerRegistry.getHandlerChainInstance(epName);
    }

    public void registerHandlerChain(QName epName, List infos, Set roles) {
        this.handlerRegistry.registerClientHandlerChain(epName, infos, roles);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

