/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.jaxrpc;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.HandlerInfo;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanProxy;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.webservice.metadata.serviceref.HandlerMetaData;
import org.jboss.webservice.metadata.serviceref.InitParamMetaData;
import org.jboss.webservice.metadata.serviceref.PortComponentRefMetaData;
import org.jboss.webservice.metadata.serviceref.ServiceRefMetaData;
import org.jboss.ws.WSException;
import org.jboss.ws.jaxrpc.ServiceImpl;
import org.jboss.ws.jaxrpc.ServiceProxy;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.ServiceMetaData;
import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
import org.jboss.ws.server.ServiceEndpoint;
import org.jboss.ws.server.ServiceEndpointManagerMBean;

public class ServiceObjectFactory
implements ObjectFactory {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$ws$jaxrpc$ServiceObjectFactory == null ? (class$org$jboss$ws$jaxrpc$ServiceObjectFactory = ServiceObjectFactory.class$("org.jboss.ws.jaxrpc.ServiceObjectFactory")) : class$org$jboss$ws$jaxrpc$ServiceObjectFactory));
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$org$jboss$ws$server$ServiceEndpointManagerMBean;
    static /* synthetic */ Class class$org$jboss$ws$jaxrpc$ServiceExt;
    static /* synthetic */ Class class$java$rmi$Remote;
    static /* synthetic */ Class class$javax$xml$rpc$Service;
    static /* synthetic */ Class class$org$jboss$ws$jaxrpc$ServiceObjectFactory;

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        try {
            Class<?> siClass;
            ClassLoader contextCL;
            ByteArrayInputStream bais;
            ServiceRefMetaData serviceRefMetaData;
            Reference ref;
            block24: {
                ref = (Reference)obj;
                serviceRefMetaData = null;
                RefAddr metaRefAddr = ref.get("SERVICE_REF_META_DATA");
                bais = new ByteArrayInputStream((byte[])metaRefAddr.getContent());
                try {
                    ObjectInputStream ois = new ObjectInputStream(bais);
                    serviceRefMetaData = (ServiceRefMetaData)ois.readObject();
                    ois.close();
                }
                catch (IOException e) {
                    throw new NamingException("Cannot unmarshall service ref meta data, cause: " + e.toString());
                }
                contextCL = Thread.currentThread().getContextClassLoader();
                URL url = new URL((String)ref.get("DEPLOYMENT_URL").getContent());
                URLClassLoader resourceCL = new URLClassLoader(new URL[]{url}, contextCL);
                serviceRefMetaData.setResourceCL(resourceCL);
                String configFile = serviceRefMetaData.getConfigFile();
                if (configFile != null) {
                    try {
                        new URL(configFile);
                    }
                    catch (MalformedURLException malformedURLException) {
                        URL configURL = resourceCL.getResource(configFile);
                        if (configURL == null) break block24;
                        configFile = configURL.toExternalForm();
                        serviceRefMetaData.setConfigFile(configFile);
                    }
                }
            }
            WSSecurityConfiguration securityConfig = null;
            RefAddr wsseRefAddr = ref.get("SECURITY_CONFIG");
            if (wsseRefAddr != null) {
                bais = new ByteArrayInputStream((byte[])wsseRefAddr.getContent());
                try {
                    ObjectInputStream ois = new ObjectInputStream(bais);
                    securityConfig = (WSSecurityConfiguration)ois.readObject();
                    ois.close();
                }
                catch (IOException e) {
                    throw new NamingException("Cannot unmarshall security config, cause: " + e.toString());
                }
            }
            ServiceImpl jaxrpcService = null;
            URL wsdlURL = serviceRefMetaData.getWsdlURL();
            if (wsdlURL != null) {
                log.debug((Object)"Create jaxrpc service from wsdl");
                QName serviceName = serviceRefMetaData.getServiceQName();
                JavaWsdlMapping javaWsdlMapping = serviceRefMetaData.getJavaWsdlMapping();
                jaxrpcService = new ServiceImpl(serviceName, wsdlURL, javaWsdlMapping, securityConfig, serviceRefMetaData);
                ServiceMetaData serviceMetaData = jaxrpcService.getServiceDesc().getServiceMetaData();
                PortComponentRefMetaData[] portComponentRefMetaDataArray = serviceRefMetaData.getPortComponentRefs();
                int n = 0;
                int n2 = portComponentRefMetaDataArray.length;
                while (n < n2) {
                    PortComponentRefMetaData pcRefMetaData = portComponentRefMetaDataArray[n];
                    String seiName = pcRefMetaData.getServiceEndpointInterface();
                    Iterator<EndpointMetaData> iterator = serviceMetaData.getEndpoints().iterator();
                    while (iterator.hasNext()) {
                        EndpointMetaData epMetaData = iterator.next();
                        String epSEIName = epMetaData.getServiceEndpointInterfaceName();
                        if (!seiName.equals(epSEIName) && epSEIName != null) continue;
                        epMetaData.setServiceEndpointInterfaceName(seiName);
                        epMetaData.setProperties(pcRefMetaData.getCallProperties());
                    }
                    ++n;
                }
            } else {
                log.debug((Object)"Create jaxrpc service with no wsdl");
                jaxrpcService = new ServiceImpl(new QName("http://www.jboss.org/jbossws", "AnonymousService"));
            }
            ServiceMetaData serviceMetaData = jaxrpcService.getServiceDesc().getServiceMetaData();
            serviceMetaData.setProperties(serviceRefMetaData.getCallProperties());
            RefAddr pcLinkRef = ref.get("PORT_COMPONENT_LINK");
            if (pcLinkRef != null) {
                String pcLink = (String)pcLinkRef.getContent();
                log.debug((Object)("Resolving port-component-link: " + pcLink));
                String endpointAddress = null;
                try {
                    MBeanServer server = MBeanServerLocator.locateJBoss();
                    ServiceEndpointManagerMBean manager = (ServiceEndpointManagerMBean)MBeanProxy.get((Class)(class$org$jboss$ws$server$ServiceEndpointManagerMBean == null ? (class$org$jboss$ws$server$ServiceEndpointManagerMBean = ServiceObjectFactory.class$("org.jboss.ws.server.ServiceEndpointManagerMBean")) : class$org$jboss$ws$server$ServiceEndpointManagerMBean), (ObjectName)ServiceEndpointManagerMBean.OBJECT_NAME, (MBeanServer)server);
                    ServiceEndpoint serviceEndpoint = manager.resolvePortComponentLink(pcLink);
                    if (serviceEndpoint == null) {
                        throw new WSException("Cannot resolve port-component-link: " + pcLink);
                    }
                    endpointAddress = serviceEndpoint.getServiceEndpointInfo().getEndpointMetaData().getEndpointAddress();
                }
                catch (Exception exception) {}
                if (endpointAddress == null) {
                    String servletPath = (String)ref.get("PORT_COMPONENT_LINK_SERVLET").getContent();
                    servletPath = String.valueOf(servletPath) + "?pcLink=" + URLEncoder.encode(pcLink, "UTF-8");
                    InputStream is = new URL(servletPath).openStream();
                    BufferedReader br = new BufferedReader(new InputStreamReader(is));
                    endpointAddress = br.readLine();
                    is.close();
                }
                log.debug((Object)("Resolved to: " + endpointAddress));
                if (serviceMetaData.getEndpoints().size() == 1) {
                    EndpointMetaData epMetaData = serviceMetaData.getEndpoints().get(0);
                    epMetaData.setEndpointAddress(endpointAddress);
                } else {
                    log.warn((Object)"Cannot set endpoint address for port-component-link, unsuported number of endpoints");
                }
            }
            if (!(class$javax$xml$rpc$Service == null ? (class$javax$xml$rpc$Service = ServiceObjectFactory.class$("javax.xml.rpc.Service")) : class$javax$xml$rpc$Service).isAssignableFrom(siClass = contextCL.loadClass(serviceRefMetaData.getServiceInterface()))) {
                throw new JAXRPCException("The service interface does not implement javax.xml.rpc.Service: " + siClass.getName());
            }
            PortComponentRefMetaData[] pcrArray = serviceRefMetaData.getPortComponentRefs();
            int i = 0;
            while (i < pcrArray.length) {
                PortComponentRefMetaData pcr;
                Class seiClass;
                if (!(class$java$rmi$Remote == null ? ServiceObjectFactory.class$("java.rmi.Remote") : class$java$rmi$Remote).isAssignableFrom(seiClass = (pcr = pcrArray[i]).getServiceEndpointInterfaceClass())) {
                    throw new IllegalArgumentException("The SEI does not implement java.rmi.Remote: " + seiClass.getName());
                }
                ++i;
            }
            this.setupHandlerChain(jaxrpcService, serviceRefMetaData);
            ServiceProxy handler = new ServiceProxy(jaxrpcService, siClass);
            return Proxy.newProxyInstance(contextCL, new Class[]{siClass, class$org$jboss$ws$jaxrpc$ServiceExt == null ? (class$org$jboss$ws$jaxrpc$ServiceExt = ServiceObjectFactory.class$("org.jboss.ws.jaxrpc.ServiceExt")) : class$org$jboss$ws$jaxrpc$ServiceExt}, (InvocationHandler)handler);
        }
        catch (Exception ex) {
            log.error((Object)"Cannot create service", (Throwable)ex);
            throw ex;
        }
    }

    private void setupHandlerChain(ServiceImpl jaxrpcService, ServiceRefMetaData serviceRefMetaData) throws Exception {
        List<EndpointMetaData> endpoints = jaxrpcService.getServiceDesc().getServiceMetaData().getEndpoints();
        Iterator<EndpointMetaData> iterator = endpoints.iterator();
        while (iterator.hasNext()) {
            EndpointMetaData epMetaData = iterator.next();
            QName epName = epMetaData.getName();
            HashSet handlerRoles = new HashSet();
            ArrayList<HandlerInfo> handlerInfos = new ArrayList<HandlerInfo>();
            Iterator<HandlerMetaData> iterator2 = epMetaData.getHandlers().iterator();
            while (iterator2.hasNext()) {
                HandlerMetaData hMetaData = iterator2.next();
                handlerRoles.addAll(Arrays.asList(hMetaData.getSoapRoles()));
                ClassLoader cl = epMetaData.getClassLoader();
                Class<?> hClass = cl.loadClass(hMetaData.getHandlerClass());
                HashMap<String, String> hConfig = new HashMap<String, String>();
                InitParamMetaData[] params = hMetaData.getInitParams();
                int k = 0;
                while (k < params.length) {
                    InitParamMetaData param = params[k];
                    hConfig.put(param.getParamName(), param.getParamValue());
                    ++k;
                }
                QName[] hHeaders = hMetaData.getSoapHeaders();
                HandlerInfo info = new HandlerInfo(hClass, hConfig, hHeaders);
                log.debug((Object)("Adding client side handler to endpoint '" + epName + "': " + info));
                handlerInfos.add(info);
                if (handlerInfos.size() <= 0) continue;
                jaxrpcService.registerHandlerChain(epName, handlerInfos, handlerRoles);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

