/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.jaxrpc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.xml.rpc.JAXRPCException;
import org.jboss.logging.Logger;
import org.jboss.ws.jaxrpc.ServiceImpl;

public class ServiceProxy
implements InvocationHandler {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$ws$jaxrpc$ServiceProxy == null ? (class$org$jboss$ws$jaxrpc$ServiceProxy = ServiceProxy.class$("org.jboss.ws.jaxrpc.ServiceProxy")) : class$org$jboss$ws$jaxrpc$ServiceProxy));
    private ServiceImpl jaxrpcService;
    private List objectMethods = new ArrayList();
    private List jaxrpcServiceMethods = new ArrayList();
    private List serviceInterfaceMethods = new ArrayList();
    private Method getPortMethod;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$org$jboss$ws$jaxrpc$ServiceProxy;
    static /* synthetic */ Class class$org$jboss$ws$jaxrpc$ServiceExt;
    static /* synthetic */ Class class$javax$xml$rpc$Service;
    static /* synthetic */ Class class$java$lang$Object;

    public ServiceProxy(ServiceImpl service, Class siClass) {
        this.jaxrpcService = service;
        this.objectMethods.addAll((Collection)Arrays.asList((class$java$lang$Object == null ? (class$java$lang$Object = ServiceProxy.class$("java.lang.Object")) : class$java$lang$Object).getMethods()));
        this.jaxrpcServiceMethods.addAll((Collection)Arrays.asList((class$org$jboss$ws$jaxrpc$ServiceExt == null ? (class$org$jboss$ws$jaxrpc$ServiceExt = ServiceProxy.class$("org.jboss.ws.jaxrpc.ServiceExt")) : class$org$jboss$ws$jaxrpc$ServiceExt).getMethods()));
        if (!siClass.getName().equals("javax.xml.rpc.Service")) {
            this.serviceInterfaceMethods.addAll((Collection)Arrays.asList(siClass.getDeclaredMethods()));
        }
        try {
            this.getPortMethod = (class$javax$xml$rpc$Service == null ? (class$javax$xml$rpc$Service = ServiceProxy.class$("javax.xml.rpc.Service")) : class$javax$xml$rpc$Service).getMethod("getPort", class$java$lang$Class == null ? (class$java$lang$Class = ServiceProxy.class$("java.lang.Class")) : class$java$lang$Class);
        }
        catch (NoSuchMethodException e) {
            throw new JAXRPCException(e.toString());
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        try {
            Object retObj = null;
            if (this.jaxrpcServiceMethods.contains(method)) {
                log.debug((Object)("Invoke on jaxrpc service: " + methodName));
                if (method.getName().equals("getPort")) {
                    Remote port = (Remote)method.invoke((Object)this.jaxrpcService, args);
                    return port;
                }
                retObj = method.invoke((Object)this.jaxrpcService, args);
                return retObj;
            }
            if (this.serviceInterfaceMethods.contains(method)) {
                log.debug((Object)("Invoke on service interface: " + methodName));
                Class<?> seiClass = method.getReturnType();
                retObj = this.getPortMethod.invoke((Object)this.jaxrpcService, seiClass);
                return retObj;
            }
            if (this.objectMethods.contains(method)) {
                log.debug((Object)("Invoke on object: " + methodName));
                retObj = method.invoke((Object)this.jaxrpcService, args);
                return retObj;
            }
            throw new JAXRPCException("Don't know how to invoke: " + method);
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    private void handleException(Exception ex) throws Throwable {
        Throwable th = ex;
        if (ex instanceof InvocationTargetException) {
            th = ((InvocationTargetException)ex).getTargetException();
        }
        log.error((Object)"Service error", th);
        throw th;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

