/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.jaxrpc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.URL;
import javax.management.MBeanServer;
import javax.naming.BinaryRefAddr;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.metadata.WebMetaData;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.webservice.metadata.serviceref.PortComponentRefMetaData;
import org.jboss.webservice.metadata.serviceref.ServiceRefMetaData;
import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
import org.jboss.ws.metadata.wsse.WSSecurityConfigurationFactory;
import org.jboss.ws.server.ServiceEndpointManagerMBean;

public class ServiceReferenceable
implements Referenceable {
    public static final String SERVICE_REF_META_DATA = "SERVICE_REF_META_DATA";
    public static final String DEPLOYMENT_URL = "DEPLOYMENT_URL";
    public static final String SECURITY_CONFIG = "SECURITY_CONFIG";
    public static final String DESCRIPTOR_LOC = "DESCRIPTOR_LOC";
    public static final String PORT_COMPONENT_LINK = "PORT_COMPONENT_LINK";
    public static final String PORT_COMPONENT_LINK_SERVLET = "PORT_COMPONENT_LINK_SERVLET";
    private ServiceRefMetaData refMetaData;
    private DeploymentInfo di;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$org$jboss$ws$jaxrpc$ServiceObjectFactory;
    static /* synthetic */ Class class$org$jboss$ws$jaxrpc$ServiceReferenceable;

    public ServiceReferenceable(ServiceRefMetaData refMetaData, DeploymentInfo di) {
        this.refMetaData = refMetaData;
        this.di = di;
    }

    public Reference getReference() throws NamingException {
        Reference myRef = new Reference((class$org$jboss$ws$jaxrpc$ServiceReferenceable == null ? (class$org$jboss$ws$jaxrpc$ServiceReferenceable = ServiceReferenceable.class$("org.jboss.ws.jaxrpc.ServiceReferenceable")) : class$org$jboss$ws$jaxrpc$ServiceReferenceable).getName(), (class$org$jboss$ws$jaxrpc$ServiceObjectFactory == null ? (class$org$jboss$ws$jaxrpc$ServiceObjectFactory = ServiceReferenceable.class$("org.jboss.ws.jaxrpc.ServiceObjectFactory")) : class$org$jboss$ws$jaxrpc$ServiceObjectFactory).getName(), null);
        URL deploymentURL = this.di.localUrl != null ? this.di.localUrl : this.di.url;
        myRef.add(new StringRefAddr(DEPLOYMENT_URL, deploymentURL.toExternalForm()));
        myRef.add(new BinaryRefAddr(SERVICE_REF_META_DATA, this.marshallServiceRef()));
        if (this.getSecurityConfigURL() != null) {
            myRef.add(new BinaryRefAddr(SECURITY_CONFIG, this.marshallSecurityConfig()));
        }
        PortComponentRefMetaData[] pcrArr = this.refMetaData.getPortComponentRefs();
        int i = 0;
        while (i < pcrArr.length) {
            PortComponentRefMetaData pcr = pcrArr[i];
            String pcLink = pcr.getPortComponentLink();
            if (pcLink != null) {
                myRef.add(new StringRefAddr(PORT_COMPONENT_LINK, pcLink));
                try {
                    MBeanServer server = MBeanServerLocator.locateJBoss();
                    String host = (String)server.getAttribute(ServiceEndpointManagerMBean.OBJECT_NAME, "WebServiceHost");
                    int port = (Integer)server.getAttribute(ServiceEndpointManagerMBean.OBJECT_NAME, "WebServicePort");
                    String servletURL = "http://" + host + ":" + port + "/jbossws/pclink";
                    myRef.add(new StringRefAddr(PORT_COMPONENT_LINK_SERVLET, servletURL));
                }
                catch (Exception ex) {
                    throw new NamingException("Cannot obtain path to PortComponentLinkServlet: " + ex);
                }
            }
            ++i;
        }
        return myRef;
    }

    private byte[] marshallServiceRef() throws NamingException {
        this.refMetaData.getJavaWsdlMapping();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.refMetaData);
            oos.close();
        }
        catch (IOException e) {
            throw new NamingException("Cannot marshall service ref meta data, cause: " + e.toString());
        }
        return baos.toByteArray();
    }

    private byte[] marshallSecurityConfig() throws NamingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            URL securityURL = this.getSecurityConfigURL();
            WSSecurityConfiguration securityConfig = WSSecurityConfigurationFactory.newInstance().parse(securityURL);
            oos.writeObject(securityConfig);
            oos.close();
        }
        catch (IOException e) {
            throw new NamingException("Cannot marshall security config, cause: " + e.toString());
        }
        return baos.toByteArray();
    }

    private URL getSecurityConfigURL() {
        ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
        String descriptorLoc = this.di.metaData instanceof WebMetaData ? "WEB-INF" : "META-INF";
        URL securityURL = ctxClassLoader.getResource(String.valueOf(descriptorLoc) + "/" + WSSecurityConfigurationFactory.CLIENT_RESOURCE_NAME);
        return securityURL;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

