/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.jaxrpc.encoding;

import java.io.IOException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.util.xml.DOMUtils;
import org.jboss.ws.binding.BindingException;
import org.jboss.ws.jaxrpc.encoding.DeserializerSupport;
import org.jboss.ws.jaxrpc.encoding.SerializationContextImpl;
import org.jboss.xb.binding.NamespaceRegistry;
import org.jboss.xb.binding.SimpleTypeBindings;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class QNameDeserializer
extends DeserializerSupport {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$ws$jaxrpc$encoding$QNameDeserializer == null ? (class$org$jboss$ws$jaxrpc$encoding$QNameDeserializer = QNameDeserializer.class$("org.jboss.ws.jaxrpc.encoding.QNameDeserializer")) : class$org$jboss$ws$jaxrpc$encoding$QNameDeserializer));
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$org$jboss$ws$jaxrpc$encoding$QNameDeserializer;

    public Object deserialize(QName xmlName, QName xmlType, String xmlFragment, SerializationContextImpl serContext) throws BindingException {
        log.debug((Object)("deserialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]"));
        QName value = null;
        NamespaceRegistry nsRegistry = serContext.getNamespaceRegistry();
        String valueStr = this.unwrapValueStr(xmlFragment, nsRegistry);
        if (valueStr != null) {
            value = SimpleTypeBindings.unmarshalQName((String)valueStr, (NamespaceContext)nsRegistry);
        }
        return value;
    }

    protected String unwrapValueStr(String xmlFragment, NamespaceRegistry nsRegistry) {
        if (!this.isEmptyElement(xmlFragment)) {
            try {
                Element el = DOMUtils.parse((String)xmlFragment);
                NamedNodeMap attribs = el.getAttributes();
                int i = 0;
                while (i < attribs.getLength()) {
                    Node attr = attribs.item(i);
                    String nodeName = attr.getNodeName();
                    if (nodeName.startsWith("xmlns:")) {
                        String prefix = nodeName.substring(6);
                        String nsURI = attr.getNodeValue();
                        nsRegistry.registerURI(nsURI, prefix);
                    }
                    ++i;
                }
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Cannot parse xmlFragment: " + xmlFragment);
            }
        }
        return super.unwrapValueStr(xmlFragment);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

