/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.jaxrpc.encoding;

import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.Constants;
import org.jboss.ws.WSException;
import org.jboss.ws.binding.BindingException;
import org.jboss.ws.jaxrpc.TypeMappingImpl;
import org.jboss.ws.jaxrpc.encoding.NullValueSerializer;
import org.jboss.ws.jaxrpc.encoding.SerializationContextImpl;
import org.jboss.ws.jaxrpc.encoding.SerializerFactoryBase;
import org.jboss.ws.jaxrpc.encoding.SerializerSupport;
import org.jboss.ws.metadata.ParameterMetaData;
import org.jboss.ws.utils.JavaUtils;
import org.w3c.dom.NamedNodeMap;

public class SOAPArraySerializer
extends SerializerSupport {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$ws$jaxrpc$encoding$SOAPArraySerializer == null ? (class$org$jboss$ws$jaxrpc$encoding$SOAPArraySerializer = SOAPArraySerializer.class$("org.jboss.ws.jaxrpc.encoding.SOAPArraySerializer")) : class$org$jboss$ws$jaxrpc$encoding$SOAPArraySerializer));
    private SerializerSupport compSerializer;
    private NullValueSerializer nullSerializer = new NullValueSerializer();
    private boolean isArrayComponentType;
    private boolean xsiNamespaceInserted;
    private StringBuffer xmlFragment;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$org$jboss$ws$jaxrpc$encoding$SOAPArraySerializer;
    static /* synthetic */ Class array$Ljava$lang$Byte;

    public String serialize(QName xmlName, QName xmlType, Object value, SerializationContextImpl serContext, NamedNodeMap attributes) throws BindingException {
        log.debug((Object)("serialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + ",valueType=" + value.getClass().getName() + "]"));
        try {
            String arrayDim;
            Object[] objArr;
            ParameterMetaData paramMetaData = (ParameterMetaData)serContext.getProperty("org.jboss.ws.metadata.ParameterMetaData");
            QName compXmlType = paramMetaData.getSOAPArrayCompType();
            QName compXmlName = paramMetaData.getXmlName();
            Class javaType = paramMetaData.getJavaType();
            Class<?> compJavaType = javaType.getComponentType();
            this.isArrayComponentType = this.isArrayJavaType(compJavaType) && this.isArrayXmlType(compXmlType);
            while (compJavaType.getComponentType() != null && !this.isArrayComponentType) {
                boolean bl = this.isArrayComponentType = this.isArrayJavaType(compJavaType = compJavaType.getComponentType()) && this.isArrayXmlType(compXmlType);
            }
            TypeMappingImpl typeMapping = serContext.getTypeMapping();
            if (compXmlType == null) {
                compXmlType = typeMapping.getXMLType(compJavaType);
                paramMetaData.setSOAPArrayCompType(compXmlType);
            }
            if (compXmlType == null) {
                throw new WSException("Cannot obtain component xmlType for: " + compJavaType);
            }
            log.debug((Object)("Get component serializer for: [javaType=" + compJavaType.getName() + ",xmlType=" + compXmlType + "]"));
            SerializerFactoryBase compSerializerFactory = (SerializerFactoryBase)typeMapping.getSerializer(compJavaType, compXmlType);
            if (compSerializerFactory == null) {
                log.warn((Object)("Cannot obtain component serializer for: [javaType=" + compJavaType.getName() + ",xmlType=" + compXmlType + "]"));
                compSerializerFactory = (SerializerFactoryBase)typeMapping.getSerializer(null, compXmlType);
            }
            if (compSerializerFactory == null) {
                throw new WSException("Cannot obtain component serializer for: " + compXmlType);
            }
            this.compSerializer = compSerializerFactory.getSerializer();
            if (JavaUtils.isPrimitive(value.getClass())) {
                value = JavaUtils.getWrapperValue(value);
            }
            this.xmlFragment = new StringBuffer("<soap11-enc:Array ");
            if (value instanceof Object[]) {
                objArr = (Object[])value;
                arrayDim = "" + objArr.length;
                Object[] subArr = (Object[])value;
                while (!this.isArrayComponentType && subArr.length > 0 && subArr[0] instanceof Object[]) {
                    subArr = (Object[])subArr[0];
                    arrayDim = String.valueOf(arrayDim) + "," + subArr.length;
                }
            } else {
                throw new WSException("Unsupported array type: " + javaType);
            }
            compXmlType = serContext.getNamespaceRegistry().registerQName(compXmlType);
            String arrayType = "soap11-enc:arrayType='" + compXmlType.getPrefix() + ":" + compXmlType.getLocalPart() + "[" + arrayDim + "]'";
            this.xmlFragment.append(String.valueOf(arrayType) + ">");
            this.serializeArrayComponents(compXmlName, compXmlType, serContext, objArr);
            this.xmlFragment.append("</soap11-enc:Array>");
            log.debug((Object)("serialized: " + this.xmlFragment));
            return this.xmlFragment.toString();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BindingException(e);
        }
    }

    private void serializeArrayComponents(QName compXmlName, QName compXmlType, SerializationContextImpl serContext, Object[] objArr) throws BindingException {
        Object[] objectArray = objArr;
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            Object compValue = objectArray[n];
            if (!this.isArrayComponentType && compValue instanceof Object[]) {
                this.serializeArrayComponents(compXmlName, compXmlType, serContext, (Object[])compValue);
            } else {
                SerializerSupport ser = this.compSerializer;
                if (compValue == null) {
                    ser = this.nullSerializer;
                    if (!this.xsiNamespaceInserted) {
                        this.xsiNamespaceInserted = true;
                        int insIndex = "<soap11-enc:Array ".length();
                        this.xmlFragment.insert(insIndex, "xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' ");
                    }
                }
                String compFragment = ser.serialize(compXmlName, compXmlType, compValue, serContext, null);
                this.xmlFragment.append(compFragment);
            }
            ++n;
        }
    }

    private boolean isArrayXmlType(QName xmlType) {
        boolean isArrayType = Constants.TYPE_SOAP11_BASE64.equals(xmlType);
        isArrayType = isArrayType || Constants.TYPE_SOAP11_BASE64.equals(xmlType);
        isArrayType = isArrayType || Constants.TYPE_SOAP11_BASE64BINARY.equals(xmlType);
        isArrayType = isArrayType || Constants.TYPE_SOAP11_HEXBINARY.equals(xmlType);
        isArrayType = isArrayType || Constants.TYPE_SOAP11_NMTOKENS.equals(xmlType);
        isArrayType = isArrayType || Constants.TYPE_LITERAL_BASE64BINARY.equals(xmlType);
        isArrayType = isArrayType || Constants.TYPE_LITERAL_HEXBINARY.equals(xmlType);
        isArrayType = isArrayType || Constants.TYPE_LITERAL_NMTOKENS.equals(xmlType);
        return isArrayType;
    }

    private boolean isArrayJavaType(Class javaType) {
        boolean isBinaryType = (array$Ljava$lang$String == null ? (array$Ljava$lang$String = SOAPArraySerializer.class$("[Ljava.lang.String;")) : array$Ljava$lang$String).equals(javaType) || (array$Ljava$lang$Byte == null ? (array$Ljava$lang$Byte = SOAPArraySerializer.class$("[Ljava.lang.Byte;")) : array$Ljava$lang$Byte).equals(javaType) || (array$B == null ? (array$B = SOAPArraySerializer.class$("[B")) : array$B).equals(javaType);
        return isBinaryType;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

