/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.ServerEndpointMetaData;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLService;

public abstract class AbstractMetaDataBuilder {
    private final Logger log = Logger.getLogger((Class)(class$org$jboss$ws$metadata$AbstractMetaDataBuilder == null ? (class$org$jboss$ws$metadata$AbstractMetaDataBuilder = AbstractMetaDataBuilder.class$("org.jboss.ws.metadata.AbstractMetaDataBuilder")) : class$org$jboss$ws$metadata$AbstractMetaDataBuilder));
    protected ClassLoader classLoader;
    protected URLClassLoader resourceLoader;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$org$jboss$ws$metadata$AbstractMetaDataBuilder;

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setResourceLoader(URLClassLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    protected String getServiceEndpointID(DeploymentInfo di, EndpointMetaData epMetaData) {
        String epLocalName = epMetaData.getName().getLocalPart();
        String serviceLocalName = epMetaData.getServiceMetaData().getName().getLocalPart();
        String serviceEndpointID = String.valueOf(di.getCanonicalName()) + "#" + serviceLocalName + "/" + epLocalName;
        return serviceEndpointID;
    }

    public String getServiceEndpointAddress(String uriScheme, String servicePath) {
        if (servicePath == null || servicePath.length() == 0) {
            throw new WSException("Service path cannot be null");
        }
        if (servicePath.endsWith("/*")) {
            servicePath = servicePath.substring(0, servicePath.length() - 2);
        }
        if (uriScheme == null) {
            uriScheme = "http";
        }
        int port = 0;
        String host = null;
        try {
            ObjectName objectName = ObjectNameFactory.create((String)"jboss.ws:service=ServiceEndpointManager");
            MBeanServer server = MBeanServerLocator.locateJBoss();
            host = (String)server.getAttribute(objectName, "WebServiceHost");
            port = (Integer)server.getAttribute(objectName, "WebServicePort");
            if ("https".equals(uriScheme)) {
                port = (Integer)server.getAttribute(objectName, "WebServiceSecurePort");
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Cannot obtain attribute from ServiceEndpointManager, cause: " + e.toString()));
        }
        String urlStr = String.valueOf(uriScheme) + "://" + host + ":" + port + servicePath;
        try {
            return new URL(urlStr).toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            throw new WSException("Malformed URL: " + urlStr);
        }
    }

    protected void replaceAddressLocation(ServerEndpointMetaData epMetaData) {
        WSDLDefinitions wsdlDefinitions = epMetaData.getServiceMetaData().getWsdlDefinitions();
        QName epName = epMetaData.getName();
        boolean endpointFound = false;
        WSDLService[] wSDLServiceArray = wsdlDefinitions.getServices();
        int n = 0;
        int n2 = wSDLServiceArray.length;
        while (n < n2) {
            WSDLService wsdlService = wSDLServiceArray[n];
            WSDLEndpoint[] wSDLEndpointArray = wsdlService.getEndpoints();
            int n3 = 0;
            int n4 = wSDLEndpointArray.length;
            while (n3 < n4) {
                WSDLEndpoint wsdlEndpoint = wSDLEndpointArray[n3];
                QName wsdlPortName = wsdlEndpoint.getQName();
                if (wsdlPortName.equals(epName)) {
                    endpointFound = true;
                    String orgAddress = wsdlEndpoint.getAddress();
                    String uriScheme = this.getUriScheme(orgAddress);
                    String transportGuarantee = epMetaData.getTransportGuarantee();
                    if ("CONFIDENTIAL".equals(transportGuarantee)) {
                        uriScheme = "https";
                    }
                    String servicePath = String.valueOf(epMetaData.getContextRoot()) + epMetaData.getURLPattern();
                    String serviceEndpointURL = this.getServiceEndpointAddress(uriScheme, servicePath);
                    boolean alwaysModify = false;
                    try {
                        ObjectName objectName = ObjectNameFactory.create((String)"jboss.ws:service=ServiceEndpointManager");
                        MBeanServer server = MBeanServerLocator.locateJBoss();
                        alwaysModify = (Boolean)server.getAttribute(objectName, "AlwaysModifySOAPAddress");
                    }
                    catch (Exception ex) {
                        this.log.error((Object)("Cannot obtain attribute from ServiceEndpointManager, cause: " + ex));
                    }
                    if (alwaysModify || uriScheme == null || orgAddress.indexOf("REPLACE_WITH_ACTUAL_URL") >= 0) {
                        this.log.debug((Object)("Replace service endpoint address '" + orgAddress + "' with '" + serviceEndpointURL + "'"));
                        wsdlEndpoint.setAddress(serviceEndpointURL);
                        epMetaData.setEndpointAddress(serviceEndpointURL);
                        if (wsdlDefinitions.getWsdlOneOneDefinition() != null) {
                            this.replaceWSDL11SOAPAddress(wsdlDefinitions, epName, serviceEndpointURL);
                        }
                    } else {
                        this.log.debug((Object)("Don't replace service endpoint address '" + orgAddress + "'"));
                        try {
                            epMetaData.setEndpointAddress(new URL(orgAddress).toExternalForm());
                        }
                        catch (MalformedURLException malformedURLException) {
                            throw new WSException("Malformed URL: " + orgAddress);
                        }
                    }
                }
                ++n3;
            }
            ++n;
        }
        if (!endpointFound) {
            throw new WSException("Cannot find service endpoint '" + epName + "' in wsdl document");
        }
    }

    private void replaceWSDL11SOAPAddress(WSDLDefinitions wsdlDefinitions, QName portQName, String serviceEndpointURL) {
        Port wsdlOneOnePort = null;
        Definition wsdlOneOneDefinition = wsdlDefinitions.getWsdlOneOneDefinition();
        String tnsURI = wsdlOneOneDefinition.getTargetNamespace();
        Iterator itServices = wsdlOneOneDefinition.getServices().values().iterator();
        while (itServices.hasNext()) {
            Service wsdlOneOneService = (Service)itServices.next();
            Map wsdlOneOnePorts = wsdlOneOneService.getPorts();
            Iterator itPorts = wsdlOneOnePorts.keySet().iterator();
            while (itPorts.hasNext()) {
                String portLocalName = (String)itPorts.next();
                if (!portQName.equals(new QName(tnsURI, portLocalName))) continue;
                wsdlOneOnePort = (Port)wsdlOneOnePorts.get(portLocalName);
                Iterator itElements = wsdlOneOnePort.getExtensibilityElements().iterator();
                while (itElements.hasNext()) {
                    Object obj = itElements.next();
                    if (!(obj instanceof SOAPAddress)) continue;
                    SOAPAddress address = (SOAPAddress)obj;
                    address.setLocationURI(serviceEndpointURL);
                }
            }
        }
        if (wsdlOneOnePort == null) {
            throw new IllegalArgumentException("Cannot find port with name '" + portQName + "' in wsdl document");
        }
    }

    private String getUriScheme(String addrStr) {
        try {
            URI addrURI = new URI(addrStr);
            String scheme = addrURI.getScheme();
            return scheme;
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

