/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.jws.HandlerChain;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.InitParam;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPMessageHandler;
import javax.jws.soap.SOAPMessageHandlers;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import net.sf.retrotranslator.runtime.java.lang._Class;
import net.sf.retrotranslator.runtime.java.lang.annotation.Annotation_;
import net.sf.retrotranslator.runtime.java.lang.reflect._Method;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.logging.Logger;
import org.jboss.system.server.ServerConfig;
import org.jboss.system.server.ServerConfigLocator;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.webservice.metadata.serviceref.HandlerMetaData;
import org.jboss.webservice.metadata.serviceref.InitParamMetaData;
import org.jboss.ws.WSException;
import org.jboss.ws.annotation.PortComponent;
import org.jboss.ws.jaxrpc.ParameterStyle;
import org.jboss.ws.jaxrpc.ParameterWrapping;
import org.jboss.ws.jaxrpc.Style;
import org.jboss.ws.jaxrpc.TypeMappingImpl;
import org.jboss.ws.jaxrpc.TypeMappingRegistryImpl;
import org.jboss.ws.jaxrpc.Use;
import org.jboss.ws.metadata.AbstractMetaDataBuilder;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.FaultMetaData;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.metadata.ParameterMetaData;
import org.jboss.ws.metadata.ServerEndpointMetaData;
import org.jboss.ws.metadata.ServiceMetaData;
import org.jboss.ws.metadata.TypeMappingMetaData;
import org.jboss.ws.metadata.TypesMetaData;
import org.jboss.ws.metadata.UnifiedMetaData;
import org.jboss.ws.metadata.jsr181.HandlerChainMetaData;
import org.jboss.ws.metadata.jsr181.HandlerConfigFactory;
import org.jboss.ws.metadata.jsr181.HandlerConfigMetaData;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.ws.tools.JavaToWSDL;
import org.jboss.ws.utils.HolderUtils;
import org.jboss.ws.utils.IOUtils;
import org.jboss.ws.utils.ToolsUtils;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotationsMetaDataBuilder
extends AbstractMetaDataBuilder {
    private final Logger log = Logger.getLogger((Class)(class$org$jboss$ws$metadata$AnnotationsMetaDataBuilder == null ? (class$org$jboss$ws$metadata$AnnotationsMetaDataBuilder = AnnotationsMetaDataBuilder.class$("org.jboss.ws.metadata.AnnotationsMetaDataBuilder")) : class$org$jboss$ws$metadata$AnnotationsMetaDataBuilder));
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$javax$xml$rpc$holders$Holder;
    static /* synthetic */ Class class$javax$jws$WebMethod;
    static /* synthetic */ Class class$javax$jws$soap$SOAPBinding;
    static /* synthetic */ Class class$org$jboss$ws$annotation$PortComponent;
    static /* synthetic */ Class class$javax$jws$HandlerChain;
    static /* synthetic */ Class class$org$jboss$ws$metadata$AnnotationsMetaDataBuilder;
    static /* synthetic */ Class class$javax$jws$soap$SOAPMessageHandlers;
    static /* synthetic */ Class class$javax$jws$WebService;
    static /* synthetic */ Class class$javax$jws$Oneway;
    static /* synthetic */ Class class$java$rmi$RemoteException;
    static /* synthetic */ Class class$javax$jws$WebResult;

    protected ServerEndpointMetaData setupEndpointFromAnnotations(UnifiedMetaData wsMetaData, DeploymentInfo di, Class annotatedClass, String linkName) throws ClassNotFoundException {
        String portTypeName;
        String targetNS;
        WebService anWebService = (WebService)_Class.getAnnotation((Class)annotatedClass, (Class)(class$javax$jws$WebService == null ? (class$javax$jws$WebService = AnnotationsMetaDataBuilder.class$("javax.jws.WebService")) : class$javax$jws$WebService));
        if (anWebService == null) {
            throw new WSException(new StringBuffer("Cannot obtain @WebService annotaion from: ").append(annotatedClass.getName()).toString());
        }
        WSDLUtils wsdlUtils = WSDLUtils.getInstance();
        String serviceName = anWebService.serviceName();
        if (serviceName.length() == 0) {
            serviceName = new StringBuffer(String.valueOf(wsdlUtils.getJustClassName(annotatedClass.getName()))).append("Service").toString();
        }
        if ((targetNS = anWebService.targetNamespace()).length() == 0) {
            targetNS = wsdlUtils.getTypeNamespace(annotatedClass);
        }
        if ((portTypeName = anWebService.name()).length() == 0) {
            portTypeName = wsdlUtils.getJustClassName(annotatedClass.getName());
        }
        ServiceMetaData serviceMetaData = new ServiceMetaData(wsMetaData, new QName(targetNS, serviceName));
        wsMetaData.addService(serviceMetaData);
        QName epName = new QName(targetNS, new StringBuffer(String.valueOf(portTypeName)).append("Port").toString());
        ServerEndpointMetaData epMetaData = new ServerEndpointMetaData(serviceMetaData, epName);
        epMetaData.setLinkName(linkName);
        epMetaData.setAnnotated(true);
        epMetaData.setServiceEndpointInterfaceName(annotatedClass.getName());
        serviceMetaData.addEndpoint(epMetaData);
        String serviceEndpointID = this.getServiceEndpointID(di, epMetaData);
        epMetaData.setEndpointID(serviceEndpointID);
        if (_Class.isAnnotationPresent((Class)annotatedClass, (Class)(class$javax$jws$soap$SOAPBinding == null ? (class$javax$jws$soap$SOAPBinding = AnnotationsMetaDataBuilder.class$("javax.jws.soap.SOAPBinding")) : class$javax$jws$soap$SOAPBinding))) {
            this.processSOAPBinding(annotatedClass, epMetaData);
        }
        Method[] methodArray = annotatedClass.getMethods();
        int n = 0;
        int n2 = methodArray.length;
        while (n < n2) {
            Method method = methodArray[n];
            if (_Method.isAnnotationPresent((Method)method, (Class)(class$javax$jws$WebMethod == null ? AnnotationsMetaDataBuilder.class$("javax.jws.WebMethod") : class$javax$jws$WebMethod))) {
                this.processWebMethod(epMetaData, method);
            }
            ++n;
        }
        if (_Class.isAnnotationPresent((Class)annotatedClass, (Class)(class$javax$jws$HandlerChain == null ? (class$javax$jws$HandlerChain = AnnotationsMetaDataBuilder.class$("javax.jws.HandlerChain")) : class$javax$jws$HandlerChain))) {
            this.processHandlerChain(annotatedClass, epMetaData);
        }
        if (_Class.isAnnotationPresent((Class)annotatedClass, (Class)(class$javax$jws$soap$SOAPMessageHandlers == null ? (class$javax$jws$soap$SOAPMessageHandlers = AnnotationsMetaDataBuilder.class$("javax.jws.soap.SOAPMessageHandlers")) : class$javax$jws$soap$SOAPMessageHandlers))) {
            this.processSOAPMessageHandlers(annotatedClass, epMetaData);
        }
        this.processOrGenerateWSDL(annotatedClass, serviceMetaData, epMetaData);
        WSDLDefinitions wsdlDefinitions = serviceMetaData.getWsdlDefinitions();
        JBossXSModel schemaModel = wsdlDefinitions.getWsdlTypes().getSchemaModel();
        serviceMetaData.getTypesMetaData().setSchemaModel(schemaModel);
        this.processPortComponent(di, annotatedClass, linkName, epMetaData);
        return epMetaData;
    }

    private void processSOAPBinding(Class annotatedClass, ServerEndpointMetaData epMetaData) {
        SOAPBinding anSoapBinding = (SOAPBinding)_Class.getAnnotation((Class)annotatedClass, (Class)(class$javax$jws$soap$SOAPBinding == null ? (class$javax$jws$soap$SOAPBinding = AnnotationsMetaDataBuilder.class$("javax.jws.soap.SOAPBinding")) : class$javax$jws$soap$SOAPBinding));
        SOAPBinding.Style attrStyle = anSoapBinding.style();
        Style style = attrStyle == SOAPBinding.Style.RPC ? Style.RPC : Style.DOCUMENT;
        epMetaData.setStyle(style);
        SOAPBinding.Use attrUse = anSoapBinding.use();
        Use use = attrUse == SOAPBinding.Use.ENCODED ? Use.ENCODED : Use.LITERAL;
        epMetaData.setUse(use);
        SOAPBinding.ParameterStyle attrParamStyle = anSoapBinding.parameterStyle();
        ParameterStyle paramStyle = attrParamStyle == SOAPBinding.ParameterStyle.BARE ? ParameterStyle.BARE : ParameterStyle.WRAPPED;
        epMetaData.setParameterStyle(paramStyle);
    }

    private void processOrGenerateWSDL(Class annotatedClass, ServiceMetaData serviceMetaData, EndpointMetaData endpointMetaData) {
        WebService anWebService = (WebService)_Class.getAnnotation((Class)annotatedClass, (Class)(class$javax$jws$WebService == null ? (class$javax$jws$WebService = AnnotationsMetaDataBuilder.class$("javax.jws.WebService")) : class$javax$jws$WebService));
        String wsdlLocation = anWebService.wsdlLocation();
        if (wsdlLocation.length() > 0) {
            serviceMetaData.setWsdlFile(wsdlLocation);
        } else {
            ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
            try {
                try {
                    UnifiedMetaData wsMetaData = serviceMetaData.getUnifiedMetaData();
                    Thread.currentThread().setContextClassLoader(wsMetaData.getClassLoader());
                    String serviceName = serviceMetaData.getName().getLocalPart();
                    JavaToWSDL javaToWSDL = new JavaToWSDL("http://schemas.xmlsoap.org/wsdl/");
                    javaToWSDL.setUnifiedMetaData(wsMetaData);
                    javaToWSDL.setWsdlStyle(endpointMetaData.getStyle() == Style.RPC ? "RPC/Literal" : "Document/Literal");
                    javaToWSDL.setQualifiedElements(true);
                    WSDLDefinitions wsdlDefinitions = javaToWSDL.generate(annotatedClass);
                    JavaWsdlMapping mapping = javaToWSDL.getJavaWsdlMapping();
                    String fakeMappingName = new StringBuffer(String.valueOf(serviceName)).append("-annotation-generated").toString();
                    serviceMetaData.setJaxrpcMappingFile(fakeMappingName);
                    serviceMetaData.getUnifiedMetaData().addMappingDefinition(fakeMappingName, mapping);
                    ServerConfig config = ServerConfigLocator.locate();
                    File tmpdir = new File(new StringBuffer(String.valueOf(config.getServerTempDir().getCanonicalPath())).append("/jbossws").toString());
                    tmpdir.mkdirs();
                    File wsdlTmpFile = File.createTempFile(serviceName, ".wsdl", tmpdir);
                    wsdlTmpFile.deleteOnExit();
                    Writer writer = IOUtils.getCharsetFileWriter(wsdlTmpFile, "UTF-8");
                    wsdlDefinitions.write(writer, "UTF-8");
                    writer.close();
                    serviceMetaData.setWsdlFile(wsdlTmpFile.toURL().toExternalForm());
                }
                catch (RuntimeException rte) {
                    throw rte;
                }
                catch (IOException e) {
                    throw new WSException("Cannot write generated wsdl", e);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(ctxLoader);
            }
        }
    }

    private void processPortComponent(DeploymentInfo di, Class annotatedClass, String linkName, ServerEndpointMetaData epMetaData) {
        PortComponent anPortComponent = (PortComponent)_Class.getAnnotation((Class)annotatedClass, (Class)(class$org$jboss$ws$annotation$PortComponent == null ? (class$org$jboss$ws$annotation$PortComponent = AnnotationsMetaDataBuilder.class$("org.jboss.ws.annotation.PortComponent")) : class$org$jboss$ws$annotation$PortComponent));
        if (anPortComponent != null) {
            String contextRoot;
            if (anPortComponent.contextRoot().length() > 0) {
                contextRoot = anPortComponent.contextRoot();
            } else {
                String shortName = di.shortName;
                contextRoot = new StringBuffer("/").append(shortName.substring(0, shortName.indexOf(46))).toString();
            }
            epMetaData.setContextRoot(contextRoot);
            String urlPattern = anPortComponent.urlPattern().length() > 0 ? anPortComponent.urlPattern() : new StringBuffer("/").append(linkName).toString();
            epMetaData.setURLPattern(urlPattern);
            String servicePath = new StringBuffer(String.valueOf(contextRoot)).append(urlPattern).toString();
            epMetaData.setEndpointAddress(this.getServiceEndpointAddress(null, servicePath));
        } else {
            String shortName = di.shortName;
            String contextRoot = new StringBuffer("/").append(shortName.substring(0, shortName.indexOf(46))).toString();
            epMetaData.setContextRoot(contextRoot);
            String urlPattern = new StringBuffer("/").append(linkName).toString();
            epMetaData.setURLPattern(urlPattern);
            String servicePath = new StringBuffer(String.valueOf(contextRoot)).append(urlPattern).toString();
            epMetaData.setEndpointAddress(this.getServiceEndpointAddress(null, servicePath));
        }
        this.replaceAddressLocation(epMetaData);
    }

    private WebParam getWebParamAnnotation(Method method, int pos) {
        Annotation_[] annotation_Array = _Method.getParameterAnnotations((Method)method)[pos];
        int n = 0;
        int n2 = annotation_Array.length;
        while (n < n2) {
            Annotation_ annotation = annotation_Array[n];
            if (annotation instanceof WebParam) {
                return (WebParam)annotation;
            }
            ++n;
        }
        return null;
    }

    private void processWebMethod(ServerEndpointMetaData epMetaData, Method method) {
        ServiceMetaData serviceMetaData = epMetaData.getServiceMetaData();
        TypesMetaData typesMetaData = serviceMetaData.getTypesMetaData();
        String targetNS = epMetaData.getName().getNamespaceURI();
        WebMethod anWebMethod = (WebMethod)_Method.getAnnotation((Method)method, (Class)(class$javax$jws$WebMethod == null ? (class$javax$jws$WebMethod = AnnotationsMetaDataBuilder.class$("javax.jws.WebMethod")) : class$javax$jws$WebMethod));
        String operationName = anWebMethod.operationName();
        if (operationName.length() == 0) {
            operationName = method.getName();
        }
        String javaName = method.getName();
        OperationMetaData opMetaData = new OperationMetaData(epMetaData, new QName(targetNS, operationName), javaName);
        opMetaData.setOneWayOperation(_Method.isAnnotationPresent((Method)method, (Class)(class$javax$jws$Oneway == null ? (class$javax$jws$Oneway = AnnotationsMetaDataBuilder.class$("javax.jws.Oneway")) : class$javax$jws$Oneway)));
        opMetaData.setSOAPAction(anWebMethod.action());
        epMetaData.addOperation(opMetaData);
        HashMap<String, Integer> typeIndexes = new HashMap<String, Integer>();
        ArrayList<QName> wrappedElementNames = null;
        ArrayList<String> wrappedVariables = null;
        ArrayList<String> wrappedTypes = null;
        ParameterMetaData wrappedParameter = null;
        String encStyle = opMetaData.getUse().toURI();
        TypeMappingRegistryImpl tmRegistry = new TypeMappingRegistryImpl();
        TypeMappingImpl typeMapping = (TypeMappingImpl)tmRegistry.getTypeMapping(encStyle);
        QName xmlName = null;
        QName xmlType = null;
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (opMetaData.isDocumentWrapped()) {
            xmlName = opMetaData.getXmlName();
            xmlType = opMetaData.getXmlName();
            method.getDeclaringClass().getPackage().getName();
            String epName = epMetaData.getName().getLocalPart();
            if (epName.endsWith("Port")) {
                epName = epName.substring(0, epName.lastIndexOf("Port"));
            }
            wrappedParameter = new ParameterMetaData(opMetaData, xmlName, xmlType, null);
            wrappedElementNames = new ArrayList<QName>(parameterTypes.length);
            wrappedVariables = new ArrayList<String>(parameterTypes.length);
            wrappedTypes = new ArrayList<String>(parameterTypes.length);
            wrappedParameter.setGeneratedWrapper(true);
            wrappedParameter.setWrappedElementNames(wrappedElementNames);
            wrappedParameter.setWrappedVariables(wrappedVariables);
            wrappedParameter.setWrappedTypes(wrappedTypes);
            opMetaData.addParameter(wrappedParameter);
            if (!opMetaData.isOneWayOperation()) {
                xmlName = new QName(targetNS, new StringBuffer(String.valueOf(operationName)).append("Response").toString());
                xmlType = new QName(targetNS, new StringBuffer(String.valueOf(operationName)).append("Response").toString());
                ParameterMetaData retMetaData = new ParameterMetaData(opMetaData, xmlName, xmlType, null);
                retMetaData.setGeneratedWrapper(true);
                retMetaData.setWrappedVariables(new ArrayList<String>(1));
                retMetaData.setWrappedElementNames(new ArrayList<QName>(1));
                retMetaData.setWrappedTypes(new ArrayList<String>(1));
                opMetaData.setReturnParameter(retMetaData);
            }
        }
        int i = 0;
        while (i < parameterTypes.length) {
            Class javaType = parameterTypes[i];
            String javaTypeName = javaType.getName();
            WebParam anWebParam = this.getWebParamAnnotation(method, i);
            boolean isWrapped = opMetaData.isDocumentWrapped() && (anWebParam == null || !anWebParam.header());
            if ((class$javax$xml$rpc$holders$Holder == null ? AnnotationsMetaDataBuilder.class$("javax.xml.rpc.holders.Holder") : class$javax$xml$rpc$holders$Holder).isAssignableFrom(javaType)) {
                javaType = HolderUtils.getValueType(javaType);
                javaTypeName = javaType.getName();
            }
            if ((xmlType = typeMapping.getXMLType(javaType)) == null) {
                xmlType = this.getWebParamType(opMetaData, javaType);
            }
            TypeMappingMetaData tmMetaData = new TypeMappingMetaData(typesMetaData, xmlType, javaTypeName);
            typesMetaData.addTypeMapping(tmMetaData);
            if (isWrapped) {
                QName wrappedElementName = this.getWebParamName(opMetaData, typeIndexes, javaType, anWebParam);
                wrappedElementNames.add(wrappedElementName);
                String variable = wrappedElementName.getLocalPart();
                if (variable.length() == 0) {
                    throw new WSException("A web parameter had a name with 0 length");
                }
                variable = this.convertToProperty(variable);
                wrappedVariables.add(variable);
                wrappedTypes.add(javaTypeName);
            } else {
                xmlName = this.getWebParamName(opMetaData, typeIndexes, javaType, anWebParam);
                xmlType = typeMapping.getXMLType(javaType);
                if (xmlType == null) {
                    xmlType = this.getWebParamType(opMetaData, javaType);
                }
                ParameterMetaData paramMetaData = new ParameterMetaData(opMetaData, xmlName, xmlType, javaTypeName);
                if (anWebParam != null) {
                    if (anWebParam.mode() == WebParam.Mode.INOUT) {
                        paramMetaData.setMode(ParameterMode.INOUT);
                    }
                    if (anWebParam.mode() == WebParam.Mode.OUT) {
                        paramMetaData.setMode(ParameterMode.OUT);
                    }
                    if (anWebParam.header()) {
                        paramMetaData.setInHeader(true);
                    }
                }
                opMetaData.addParameter(paramMetaData);
            }
            ++i;
        }
        Class<?> returnType = method.getReturnType();
        String returnTypeName = returnType.getName();
        if (returnType != Void.TYPE) {
            if (opMetaData.isOneWayOperation()) {
                throw new IllegalArgumentException(new StringBuffer("[JSR-181 2.5.1] The method '").append(method.getName()).append("' can not have a return value if it is marked OneWay").toString());
            }
            xmlType = typeMapping.getXMLType(returnType);
            if (xmlType == null) {
                xmlType = this.getWebResultType(targetNS, returnType);
            }
            TypeMappingMetaData tmMetaData = new TypeMappingMetaData(typesMetaData, xmlType, returnTypeName);
            typesMetaData.addTypeMapping(tmMetaData);
            if (opMetaData.isDocumentWrapped()) {
                QName elementName = this.getWebResultName(opMetaData, returnType, (WebResult)_Method.getAnnotation((Method)method, (Class)(class$javax$jws$WebResult == null ? (class$javax$jws$WebResult = AnnotationsMetaDataBuilder.class$("javax.jws.WebResult")) : class$javax$jws$WebResult)));
                ParameterMetaData retMetaData = opMetaData.getReturnParameter();
                retMetaData.getWrappedElementNames().add(elementName);
                retMetaData.getWrappedVariables().add(this.convertToProperty(elementName.getLocalPart()));
                retMetaData.getWrappedTypes().add(returnTypeName);
            } else {
                xmlName = this.getWebResultName(opMetaData, returnType, (WebResult)_Method.getAnnotation((Method)method, (Class)(class$javax$jws$WebResult == null ? (class$javax$jws$WebResult = AnnotationsMetaDataBuilder.class$("javax.jws.WebResult")) : class$javax$jws$WebResult)));
                ParameterMetaData retMetaData = new ParameterMetaData(opMetaData, xmlName, xmlType, returnTypeName);
                opMetaData.setReturnParameter(retMetaData);
            }
        }
        if (opMetaData.isDocumentWrapped()) {
            ParameterWrapping.generateWrapper(wrappedParameter, false);
            if (!opMetaData.isOneWayOperation()) {
                ParameterWrapping.generateWrapper(opMetaData.getReturnParameter(), false);
            }
        }
        Class<?>[] classArray = method.getExceptionTypes();
        int n = 0;
        int n2 = classArray.length;
        while (n < n2) {
            Class<?> exception;
            if (!(class$java$rmi$RemoteException == null ? AnnotationsMetaDataBuilder.class$("java.rmi.RemoteException") : class$java$rmi$RemoteException).isAssignableFrom(exception = classArray[n])) {
                this.addFault(opMetaData, typesMetaData, exception);
            }
            ++n;
        }
    }

    private String convertToProperty(String variable) {
        if (Character.isUpperCase(variable.charAt(0))) {
            char c = Character.toLowerCase(variable.charAt(0));
            StringBuffer builder = new StringBuffer(variable);
            builder.setCharAt(0, c);
            variable = builder.toString();
        }
        return variable;
    }

    private void processHandlerChain(Class annotatedClass, ServerEndpointMetaData epMetaData) {
        if (_Class.isAnnotationPresent((Class)annotatedClass, (Class)(class$javax$jws$soap$SOAPMessageHandlers == null ? (class$javax$jws$soap$SOAPMessageHandlers = AnnotationsMetaDataBuilder.class$("javax.jws.soap.SOAPMessageHandlers")) : class$javax$jws$soap$SOAPMessageHandlers))) {
            throw new WSException("Cannot combine @HandlerChain with @SOAPMessageHandlers");
        }
        HandlerChain anHandlerChain = (HandlerChain)_Class.getAnnotation((Class)annotatedClass, (Class)(class$javax$jws$HandlerChain == null ? (class$javax$jws$HandlerChain = AnnotationsMetaDataBuilder.class$("javax.jws.HandlerChain")) : class$javax$jws$HandlerChain));
        String handlerChainFile = anHandlerChain.file();
        try {
            HandlerConfigMetaData handlerConfigMetaData = null;
            URL fileURL = new URL(handlerChainFile);
            InputStream is = fileURL.openStream();
            try {
                Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
                HandlerConfigFactory factory = new HandlerConfigFactory(fileURL);
                handlerConfigMetaData = (HandlerConfigMetaData)unmarshaller.unmarshal(is, (ObjectModelFactory)factory, null);
            }
            finally {
                is.close();
            }
            HandlerChainMetaData[] handlerChainMetaDataArray = handlerConfigMetaData.getHandlerChains();
            int n = 0;
            int n2 = handlerChainMetaDataArray.length;
            while (n < n2) {
                HandlerChainMetaData handlerChainMetaData = handlerChainMetaDataArray[n];
                String hcName = handlerChainMetaData.getHandlerChainName();
                if (hcName.equals(anHandlerChain.name()) || anHandlerChain.name() == null) {
                    HandlerMetaData[] handlerMetaDataArray = handlerChainMetaData.getHandlers();
                    int n3 = 0;
                    int n4 = handlerMetaDataArray.length;
                    while (n3 < n4) {
                        HandlerMetaData handlerMetaData = handlerMetaDataArray[n3];
                        epMetaData.addHandler(handlerMetaData);
                        ++n3;
                    }
                }
                ++n;
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new WSException(new StringBuffer("Cannot process handler chain: ").append(handlerChainFile).toString(), ex);
        }
    }

    private void processSOAPMessageHandlers(Class annotatedClass, ServerEndpointMetaData epMetaData) {
        if (_Class.isAnnotationPresent((Class)annotatedClass, (Class)(class$javax$jws$HandlerChain == null ? (class$javax$jws$HandlerChain = AnnotationsMetaDataBuilder.class$("javax.jws.HandlerChain")) : class$javax$jws$HandlerChain))) {
            throw new WSException("Cannot combine @SOAPMessageHandlers with @HandlerChain");
        }
        SOAPMessageHandlers anSOAPMessageHandlers = (SOAPMessageHandlers)_Class.getAnnotation((Class)annotatedClass, (Class)(class$javax$jws$soap$SOAPMessageHandlers == null ? (class$javax$jws$soap$SOAPMessageHandlers = AnnotationsMetaDataBuilder.class$("javax.jws.soap.SOAPMessageHandlers")) : class$javax$jws$soap$SOAPMessageHandlers));
        SOAPMessageHandler[] sOAPMessageHandlerArray = anSOAPMessageHandlers.value();
        int n = 0;
        int n2 = sOAPMessageHandlerArray.length;
        while (n < n2) {
            SOAPMessageHandler handler = sOAPMessageHandlerArray[n];
            HandlerMetaData handlerMetaData = new HandlerMetaData();
            handlerMetaData.setHandlerName(handler.name());
            handlerMetaData.setHandlerClass(handler.className());
            Object[] objectArray = handler.initParams();
            int n3 = 0;
            int n4 = objectArray.length;
            while (n3 < n4) {
                InitParam initParam = objectArray[n3];
                InitParamMetaData initParamMetaData = new InitParamMetaData();
                initParamMetaData.setParamName(initParam.name());
                initParamMetaData.setParamValue(initParam.value());
                handlerMetaData.addInitParam(initParamMetaData);
                ++n3;
            }
            objectArray = handler.roles();
            n3 = 0;
            n4 = objectArray.length;
            while (n3 < n4) {
                Object role = objectArray[n3];
                handlerMetaData.addSoapRole((String)role);
                ++n3;
            }
            objectArray = handler.headers();
            n3 = 0;
            n4 = objectArray.length;
            while (n3 < n4) {
                Object header = objectArray[n3];
                handlerMetaData.addSoapHeader(QName.valueOf((String)header));
                ++n3;
            }
            epMetaData.addHandler(handlerMetaData);
            ++n;
        }
    }

    private QName getWebParamName(OperationMetaData opMetaData, Map<String, Integer> typeIndexes, Class javaType, WebParam webParam) {
        String shortName;
        WSDLUtils wsdlUtils;
        QName xmlName = null;
        String namespaceURI = opMetaData.getXmlName().getNamespaceURI();
        if (webParam != null) {
            if (webParam.targetNamespace().length() > 0) {
                namespaceURI = webParam.targetNamespace();
            }
            if (webParam.name().length() > 0) {
                xmlName = opMetaData.getStyle() != Style.RPC ? new QName(namespaceURI, webParam.name()) : new QName(webParam.name());
            }
        }
        if (xmlName == null && opMetaData.isDocumentBare()) {
            wsdlUtils = WSDLUtils.getInstance();
            shortName = wsdlUtils.getJustClassName(javaType);
            xmlName = new QName(namespaceURI, shortName);
        }
        if (xmlName == null) {
            wsdlUtils = WSDLUtils.getInstance();
            shortName = wsdlUtils.getJustClassName(javaType);
            Integer index = typeIndexes.get(shortName);
            index = index != null ? new Integer(index + 1) : new Integer(1);
            typeIndexes.put(shortName, index);
            xmlName = opMetaData.isDocumentWrapped() ? new QName(namespaceURI, new StringBuffer(String.valueOf(shortName)).append("_").append(index).toString()) : new QName(new StringBuffer(String.valueOf(shortName)).append("_").append(index).toString());
        }
        return xmlName;
    }

    private QName getWebParamType(OperationMetaData opMetaData, Class javaType) {
        String namespaceURI = opMetaData.getXmlName().getNamespaceURI();
        return ToolsUtils.getXMLType(javaType, namespaceURI);
    }

    private QName getWebResultName(OperationMetaData opMetaData, Class javaType, WebResult anWebResult) {
        QName xmlName = null;
        String namespaceURI = opMetaData.getXmlName().getNamespaceURI();
        if (anWebResult != null) {
            if (anWebResult.targetNamespace().length() > 0) {
                namespaceURI = anWebResult.targetNamespace();
            }
            if (anWebResult.name().length() > 0) {
                xmlName = opMetaData.getStyle() != Style.RPC ? new QName(namespaceURI, anWebResult.name()) : new QName(anWebResult.name());
            }
        }
        if (xmlName == null && opMetaData.isDocumentBare()) {
            WSDLUtils wsdlUtils = WSDLUtils.getInstance();
            String shortName = wsdlUtils.getJustClassName(javaType);
            xmlName = new QName(namespaceURI, shortName);
        }
        if (xmlName == null) {
            xmlName = new QName("result");
        }
        return xmlName;
    }

    private void addFault(OperationMetaData omd, TypesMetaData tmd, Class<?> exception) {
        if (omd.isOneWayOperation()) {
            throw new IllegalStateException("JSR-181 4.3.1 - A JSR-181 processor is REQUIRED to report an error if an operation marked @Oneway has a return value, declares any checked exceptions or has any INOUT or OUT parameters.");
        }
        String name = WSDLUtils.getInstance().getJustClassName(exception);
        QName xmlName = new QName(omd.getXmlName().getNamespaceURI(), name);
        FaultMetaData fmd = new FaultMetaData(omd, xmlName, xmlName, exception.getName());
        omd.addFault(fmd);
        TypeMappingMetaData mapping = new TypeMappingMetaData(tmd, xmlName, exception.getName());
        tmd.addTypeMapping(mapping);
    }

    private QName getWebResultType(String defaultNS, Class javaType) {
        return ToolsUtils.getXMLType(javaType, defaultNS);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

