/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.webservice.metadata.serviceref.HandlerMetaData;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.metadata.ServiceMetaData;
import org.jboss.ws.metadata.config.WSClientConfig;
import org.jboss.ws.metadata.config.WSConfig;
import org.jboss.ws.metadata.config.WSConfigFactory;
import org.jboss.ws.metadata.config.WSHandlerChainConfig;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientEndpointMetaData
extends EndpointMetaData {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$ws$metadata$ClientEndpointMetaData == null ? (class$org$jboss$ws$metadata$ClientEndpointMetaData = ClientEndpointMetaData.class$("org.jboss.ws.metadata.ClientEndpointMetaData")) : class$org$jboss$ws$metadata$ClientEndpointMetaData));
    private WSClientConfig clientConfig;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$org$jboss$ws$metadata$ClientEndpointMetaData;

    public ClientEndpointMetaData(ServiceMetaData service, QName qname) {
        super(service, qname);
        this.setConfigName("Standard Client");
        this.setConfigFile("META-INF/standard-jbossws-client-config.xml");
    }

    public WSClientConfig getClientConfig() {
        if (this.clientConfig == null) {
            WSConfig wsConfig;
            ClassLoader cl;
            String configName = this.getConfigName();
            String configFile = this.getConfigFile();
            log.debug((Object)new StringBuffer("getClientConfig: [name=").append(configName).append(",url=").append(configFile).append("]").toString());
            URL configURL = null;
            try {
                configURL = new URL(configFile);
            }
            catch (MalformedURLException malformedURLException) {}
            if (configURL == null && (configURL = (cl = Thread.currentThread().getContextClassLoader()).getResource(configFile)) == null) {
                throw new WSException(new StringBuffer("Cannot get resource: ").append(configFile).toString());
            }
            try {
                WSConfigFactory factory = WSConfigFactory.newInstance();
                wsConfig = factory.parseWithObjectModelFactory(configURL);
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (Exception ex) {
                throw new WSException("Cannot parse client config", ex);
            }
            this.clientConfig = wsConfig.getClientConfigByName(configName);
            if (this.clientConfig == null) {
                throw new WSException(new StringBuffer("Cannot obtain client config: ").append(configName).toString());
            }
            if (!configName.equals(this.clientConfig.getConfigName())) {
                configName = this.clientConfig.getConfigName();
                log.debug((Object)new StringBuffer("Using config name: ").append(configName).toString());
                this.setConfigName(configName);
            }
        }
        return this.clientConfig;
    }

    @Override
    public List<HandlerMetaData> getHandlers() {
        ArrayList<HandlerMetaData> handlers = new ArrayList<HandlerMetaData>();
        WSHandlerChainConfig preHandlerConfig = this.getClientConfig().getPreHandlerChain();
        if (preHandlerConfig != null) {
            handlers.addAll(preHandlerConfig.getHandlers());
        }
        handlers.addAll(super.getHandlers());
        WSHandlerChainConfig postHandlerConfig = this.getClientConfig().getPostHandlerChain();
        if (postHandlerConfig != null) {
            handlers.addAll(postHandlerConfig.getHandlers());
        }
        return handlers;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("\nClientEndpointMetaData:");
        buffer.append(new StringBuffer("\n name=").append(this.getName()).toString());
        buffer.append(new StringBuffer("\n address=").append(this.getEndpointAddress()).toString());
        buffer.append(new StringBuffer("\n seiName=").append(this.getServiceEndpointInterfaceName()).toString());
        buffer.append(new StringBuffer("\n configFile=").append(this.getConfigFile()).toString());
        buffer.append(new StringBuffer("\n configName=").append(this.getConfigName()).toString());
        buffer.append(new StringBuffer("\n authMethod=").append(this.getAuthMethod()).toString());
        buffer.append(new StringBuffer("\n transportGuarantee=").append(this.getTransportGuarantee()).toString());
        buffer.append(new StringBuffer("\n properties=").append(this.getProperties()).toString());
        for (OperationMetaData opMetaData : this.getOperations()) {
            buffer.append(new StringBuffer("\n").append(opMetaData).toString());
        }
        for (HandlerMetaData hdlMetaData : this.getHandlers()) {
            buffer.append(new StringBuffer("\n").append(hdlMetaData).toString());
        }
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

