/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata;

import javax.xml.namespace.QName;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.utils.JavaUtils;

public class FaultMetaData {
    private OperationMetaData operation;
    private QName xmlName;
    private QName xmlType;
    private String javaTypeName;
    private Class javaType;

    public FaultMetaData(OperationMetaData operation, QName xmlName, QName xmlType, String javaTypeName) {
        if (xmlName == null) {
            throw new IllegalArgumentException("Invalid null xmlName argument");
        }
        if (xmlType == null) {
            throw new IllegalArgumentException("Invalid null xmlType argument, for: " + xmlName);
        }
        if (javaTypeName == null) {
            throw new IllegalArgumentException("Invalid null javaTypeName argument, for: " + xmlName);
        }
        this.operation = operation;
        this.xmlName = xmlName;
        this.xmlType = xmlType;
        this.javaTypeName = javaTypeName;
    }

    public OperationMetaData getOperationMetaData() {
        return this.operation;
    }

    public QName getXmlName() {
        return this.xmlName;
    }

    public QName getXmlType() {
        return this.xmlType;
    }

    public String getJavaTypeName() {
        return this.javaTypeName;
    }

    public Class getJavaType() {
        ClassLoader loader = this.operation.getEndpointMetaData().getServiceMetaData().getUnifiedMetaData().getClassLoader();
        if (loader == null) {
            throw new WSException("ClassLoader not available");
        }
        if (this.javaTypeName == null) {
            return null;
        }
        if (this.javaType == null || !this.javaType.isPrimitive() && this.javaType.getClassLoader() != loader) {
            try {
                this.javaType = JavaUtils.loadJavaType(this.javaTypeName, loader);
            }
            catch (ClassNotFoundException ex) {
                throw new WSException("Cannot load java type: " + this.javaTypeName, ex);
            }
        }
        return this.javaType;
    }

    public void eagerInitialize() {
        this.getJavaType();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("\nFaultMetaData");
        buffer.append("\n xmlName=" + this.xmlName);
        buffer.append("\n xmlType=" + this.xmlType);
        buffer.append("\n javaType=" + this.javaTypeName);
        return buffer.toString();
    }
}

