/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata;

import java.util.ArrayList;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jboss.logging.Logger;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaXmlTypeMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.MethodParamPartsMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.ServiceEndpointInterfaceMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.ServiceEndpointMethodMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.VariableMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.WsdlMessageMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.WsdlReturnValueMapping;
import org.jboss.ws.Constants;
import org.jboss.ws.WSException;
import org.jboss.ws.jaxrpc.LiteralTypeMapping;
import org.jboss.ws.jaxrpc.ParameterStyle;
import org.jboss.ws.jaxrpc.Style;
import org.jboss.ws.jaxrpc.TypeMappingImpl;
import org.jboss.ws.jaxrpc.TypeMappingRegistryImpl;
import org.jboss.ws.jaxrpc.UnqualifiedFaultException;
import org.jboss.ws.jaxrpc.Use;
import org.jboss.ws.metadata.AbstractMetaDataBuilder;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.FaultMetaData;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.metadata.ParameterMetaData;
import org.jboss.ws.metadata.ServiceMetaData;
import org.jboss.ws.metadata.TypeMappingMetaData;
import org.jboss.ws.metadata.TypesMetaData;
import org.jboss.ws.metadata.wsdl.NCName;
import org.jboss.ws.metadata.wsdl.WSDLBinding;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperation;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLInterface;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceFault;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationInput;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutfault;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationPart;
import org.jboss.ws.metadata.wsdl.WSDLProperty;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.metadata.wsdl.WSDLTypes;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.ws.utils.JavaUtils;

public abstract class JSR109MetaDataBuilder
extends AbstractMetaDataBuilder {
    final Logger log = Logger.getLogger((Class)(class$org$jboss$ws$metadata$JSR109MetaDataBuilder == null ? (class$org$jboss$ws$metadata$JSR109MetaDataBuilder = JSR109MetaDataBuilder.class$("org.jboss.ws.metadata.JSR109MetaDataBuilder")) : class$org$jboss$ws$metadata$JSR109MetaDataBuilder));
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$org$jboss$ws$metadata$JSR109MetaDataBuilder;

    protected void setupTypesMetaData(ServiceMetaData serviceMetaData) {
        WSDLDefinitions wsdlDefinitions = serviceMetaData.getWsdlDefinitions();
        JavaWsdlMapping javaWsdlMapping = serviceMetaData.getJavaWsdlMapping();
        TypesMetaData typesMetaData = serviceMetaData.getTypesMetaData();
        if (wsdlDefinitions != null) {
            WSDLTypes wsdlTypes = wsdlDefinitions.getWsdlTypes();
            typesMetaData.setSchemaModel(wsdlTypes.getSchemaModel());
        }
        if (javaWsdlMapping != null) {
            JavaXmlTypeMapping[] javaXmlTypeMappingArray = javaWsdlMapping.getJavaXmlTypeMappings();
            int n = 0;
            int n2 = javaXmlTypeMappingArray.length;
            while (n < n2) {
                String nsURI;
                JavaXmlTypeMapping xmlTypeMapping = javaXmlTypeMappingArray[n];
                String javaTypeName = xmlTypeMapping.getJavaType();
                String qnameScope = xmlTypeMapping.getQnameScope();
                QName xmlType = xmlTypeMapping.getRootTypeQName();
                QName anonymousXMLType = xmlTypeMapping.getAnonymousTypeQName();
                if (xmlType == null && anonymousXMLType != null) {
                    xmlType = anonymousXMLType;
                }
                if (!"http://www.w3.org/2001/XMLSchema".equals(nsURI = xmlType.getNamespaceURI()) && !"http://schemas.xmlsoap.org/soap/encoding/".equals(nsURI)) {
                    TypeMappingMetaData tmMetaData = new TypeMappingMetaData(typesMetaData, xmlType, javaTypeName);
                    tmMetaData.setQNameScope(qnameScope);
                    typesMetaData.addTypeMapping(tmMetaData);
                }
                ++n;
            }
            javaXmlTypeMappingArray = javaWsdlMapping.getExceptionMappings();
            n = 0;
            n2 = javaXmlTypeMappingArray.length;
            while (n < n2) {
                JavaXmlTypeMapping exceptionMapping = javaXmlTypeMappingArray[n];
                QName xmlType = exceptionMapping.getWsdlMessage();
                String javaTypeName = exceptionMapping.getExceptionType();
                TypeMappingMetaData tmMetaData = new TypeMappingMetaData(typesMetaData, xmlType, javaTypeName);
                typesMetaData.addTypeMapping(tmMetaData);
                ++n;
            }
        }
    }

    protected void setupOperationsFromWSDL(EndpointMetaData epMetaData, WSDLEndpoint wsdlEndpoint, ServiceEndpointInterfaceMapping seiMapping) {
        WSDLDefinitions wsdlDefinitions = wsdlEndpoint.getInterface().getWsdlDefinitions();
        WSDLInterface wsdlInterface = wsdlEndpoint.getInterface();
        WSDLInterfaceOperation[] wSDLInterfaceOperationArray = wsdlInterface.getOperations();
        int n = 0;
        int n2 = wSDLInterfaceOperationArray.length;
        while (n < n2) {
            WSDLBinding wsdlBinding;
            WSDLBindingOperation wsdlBindingOperation;
            WSDLInterfaceOperation wsdlOperation = wSDLInterfaceOperationArray[n];
            String opName = wsdlOperation.getName().toString();
            QName opQName = wsdlOperation.getQName();
            String javaName = String.valueOf(opName.substring(0, 1).toLowerCase()) + opName.substring(1);
            ServiceEndpointMethodMapping seiMethodMapping = null;
            if (seiMapping != null) {
                epMetaData.setServiceEndpointInterfaceName(seiMapping.getServiceEndpointInterface());
                seiMethodMapping = seiMapping.getServiceEndpointMethodMappingByWsdlOperation(opName);
                if (seiMethodMapping == null) {
                    throw new WSException("Cannot obtain method maping for: " + opName);
                }
                javaName = seiMethodMapping.getJavaMethodName();
            }
            OperationMetaData opMetaData = new OperationMetaData(epMetaData, opQName, javaName);
            epMetaData.addOperation(opMetaData);
            String style = wsdlOperation.getStyle();
            epMetaData.setStyle(Style.valueOf(style));
            if ("http://www.w3.org/2004/08/wsdl/in-only".equals(wsdlOperation.getPattern())) {
                opMetaData.setOneWayOperation(true);
            }
            if ((wsdlBindingOperation = (wsdlBinding = wsdlDefinitions.getBindingByInterfaceName(wsdlInterface.getQName())).getOperationByRef(opQName)) != null) {
                opMetaData.setSOAPAction(wsdlBindingOperation.getSOAPAction());
            }
            String encStyle = epMetaData.getUse().toURI();
            TypeMappingRegistryImpl tmRegistry = new TypeMappingRegistryImpl();
            TypeMappingImpl typeMapping = (TypeMappingImpl)tmRegistry.getTypeMapping(encStyle);
            if (opMetaData.getStyle() == Style.RPC) {
                this.buildParameterMetaDataRpc(opMetaData, wsdlOperation, seiMethodMapping, typeMapping);
            } else {
                this.buildParameterMetaDataDoc(opMetaData, wsdlOperation, seiMethodMapping, typeMapping);
            }
            this.buildFaultMetaData(opMetaData, wsdlOperation, seiMapping);
            ++n;
        }
    }

    private void buildParameterMetaDataRpc(OperationMetaData opMetaData, WSDLInterfaceOperation wsdlOperation, ServiceEndpointMethodMapping seiMethodMapping, TypeMappingImpl typeMapping) {
        this.log.trace((Object)("buildParameterMetaDataRpc: " + opMetaData.getXmlName()));
        TypesMetaData typesMetaData = opMetaData.getEndpointMetaData().getServiceMetaData().getTypesMetaData();
        WSDLInterfaceOperationPart[] wSDLInterfaceOperationPartArray = wsdlOperation.getInputs();
        int n = 0;
        int n2 = wSDLInterfaceOperationPartArray.length;
        while (n < n2) {
            String nsURI;
            String packageName;
            WSDLInterfaceOperationInput opInput = wSDLInterfaceOperationPartArray[n];
            QName xmlName = opInput.getElement();
            QName xmlType = opInput.getXMLType();
            String partName = opInput.getProperty("http://www.jboss.org/jbossws/partname").getValue();
            String javaTypeName = typeMapping.getJavaTypeName(xmlType);
            if (seiMethodMapping != null) {
                MethodParamPartsMapping paramMapping = seiMethodMapping.getMethodParamPartsMappingByPartName(partName);
                if (paramMapping == null) {
                    throw new WSException("Cannot obtain method parameter mapping for message part '" + partName + "' in wsdl operation: " + seiMethodMapping.getWsdlOperation());
                }
                javaTypeName = paramMapping.getParamType();
            }
            JavaWsdlMapping javaWsdlMapping = opMetaData.getEndpointMetaData().getServiceMetaData().getJavaWsdlMapping();
            if (javaTypeName == null && javaWsdlMapping != null && (packageName = javaWsdlMapping.getPackageNameForNamespaceURI(xmlType.getNamespaceURI())) != null) {
                javaTypeName = String.valueOf(packageName) + "." + xmlType.getLocalPart();
                this.log.warn((Object)("Guess java type from package mapping: [xmlType=" + xmlType + ",javaType=" + javaTypeName + "]"));
            }
            if (javaTypeName == null) {
                throw new WSException("Cannot obtain java type mapping for: " + xmlType);
            }
            ParameterMetaData inMetaData = new ParameterMetaData(opMetaData, xmlName, xmlType, javaTypeName);
            opMetaData.addParameter(inMetaData);
            if (typesMetaData.getTypeMappingByXMLType(xmlType) == null && !"http://www.w3.org/2001/XMLSchema".equals(nsURI = xmlType.getNamespaceURI()) && !"http://schemas.xmlsoap.org/soap/encoding/".equals(nsURI)) {
                TypeMappingMetaData tmMetaData = new TypeMappingMetaData(typesMetaData, xmlType, javaTypeName);
                typesMetaData.addTypeMapping(tmMetaData);
            }
            this.setupAttachmentParameter(opInput, inMetaData);
            boolean inHeader = opInput.getProperty("http://www.w3.org/2004/08/wsdl/feature/AD/data") != null;
            inMetaData.setInHeader(inHeader);
            this.setupSOAPArrayParameter(inMetaData, javaTypeName);
            ++n;
        }
        wSDLInterfaceOperationPartArray = wsdlOperation.getOutputs();
        n = 0;
        n2 = wSDLInterfaceOperationPartArray.length;
        while (n < n2) {
            WSDLInterfaceOperationPart opOutput = wSDLInterfaceOperationPartArray[n];
            String partName = opOutput.getProperty("http://www.jboss.org/jbossws/partname").getValue();
            QName xmlName = opOutput.getElement();
            ParameterMetaData outMetaData = opMetaData.getParameter(xmlName);
            if (outMetaData != null && wsdlOperation.getInputByPartName(partName) != null) {
                outMetaData.setMode(ParameterMode.INOUT);
            } else {
                String packageName;
                boolean hasReturnMapping;
                QName xmlType = opOutput.getXMLType();
                String javaTypeName = typeMapping.getJavaTypeName(xmlType);
                boolean inHeader = opOutput.getProperty("http://www.w3.org/2004/08/wsdl/feature/AD/data") != null;
                boolean bl = hasReturnMapping = !inHeader;
                if (seiMethodMapping != null) {
                    WsdlReturnValueMapping returnMapping = seiMethodMapping.getWsdlReturnValueMapping();
                    if (returnMapping != null) {
                        javaTypeName = returnMapping.getMethodReturnValue();
                        hasReturnMapping = true;
                    } else {
                        MethodParamPartsMapping paramMapping = seiMethodMapping.getMethodParamPartsMappingByPartName(partName);
                        if (paramMapping != null) {
                            javaTypeName = paramMapping.getParamType();
                            hasReturnMapping = false;
                        }
                    }
                }
                JavaWsdlMapping javaWsdlMapping = opMetaData.getEndpointMetaData().getServiceMetaData().getJavaWsdlMapping();
                if (javaTypeName == null && javaWsdlMapping != null && (packageName = javaWsdlMapping.getPackageNameForNamespaceURI(xmlType.getNamespaceURI())) != null) {
                    javaTypeName = String.valueOf(packageName) + "." + xmlType.getLocalPart();
                    this.log.warn((Object)("Guess java type from package mapping: [xmlType=" + xmlType + ",javaType=" + javaTypeName + "]"));
                }
                if (javaTypeName == null) {
                    throw new WSException("Cannot obtain java type mapping for: " + xmlType);
                }
                if (hasReturnMapping) {
                    String nsURI;
                    outMetaData = new ParameterMetaData(opMetaData, xmlName, xmlType, javaTypeName);
                    opMetaData.setReturnParameter(outMetaData);
                    if (typesMetaData.getTypeMappingByXMLType(xmlType) == null && !"http://www.w3.org/2001/XMLSchema".equals(nsURI = xmlType.getNamespaceURI()) && !"http://schemas.xmlsoap.org/soap/encoding/".equals(nsURI)) {
                        TypeMappingMetaData tmMetaData = new TypeMappingMetaData(typesMetaData, xmlType, javaTypeName);
                        typesMetaData.addTypeMapping(tmMetaData);
                    }
                    this.setupAttachmentParameter(opOutput, outMetaData);
                } else {
                    outMetaData = new ParameterMetaData(opMetaData, xmlName, xmlType, javaTypeName);
                    outMetaData.setMode(ParameterMode.OUT);
                    opMetaData.addParameter(outMetaData);
                    this.setupAttachmentParameter(opOutput, outMetaData);
                    outMetaData.setInHeader(inHeader);
                }
                this.setupSOAPArrayParameter(outMetaData, javaTypeName);
            }
            ++n;
        }
    }

    private void setupAttachmentParameter(WSDLInterfaceOperationPart wsdlOperationPart, ParameterMetaData paramMetaData) {
        String simpleTypeName;
        XSComplexTypeDefinition xsComplexType;
        WSDLInterfaceOperation wsdlOperation;
        WSDLTypes wsdlTypes;
        JBossXSModel schemaModel;
        XSTypeDefinition xsType;
        QName xmlType = paramMetaData.getXmlType();
        paramMetaData.getXmlName();
        WSDLProperty mimeTypeProp = wsdlOperationPart.getProperty("http://www.jboss.org/jbossws/attachment/mimetype");
        if (mimeTypeProp != null) {
            String mimeTypes = mimeTypeProp.getValue();
            paramMetaData.setMimeTypes(mimeTypes);
            paramMetaData.setSwA(true);
        }
        if ((xsType = (schemaModel = (wsdlTypes = (wsdlOperation = wsdlOperationPart.getWsdlOperation()).getWsdlInterface().getWsdlDefinitions().getWsdlTypes()).getSchemaModel()).getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI())) instanceof XSComplexTypeDefinition && (xsComplexType = (XSComplexTypeDefinition)xsType).getSimpleType() != null && ("base64Binary".equals(simpleTypeName = xsComplexType.getSimpleType().getName()) || "hexBinary".equals(simpleTypeName))) {
            paramMetaData.setXOP(true);
        }
    }

    private void setupSOAPArrayParameter(ParameterMetaData paramMetaData, String javaTypeName) {
        Use use = paramMetaData.getOperationMetaData().getUse();
        String xmlTypeLocalPart = paramMetaData.getXmlType().getLocalPart();
        if (use == Use.ENCODED && xmlTypeLocalPart.indexOf("ArrayOf") >= 0) {
            paramMetaData.setSOAPArrayParam(true);
            try {
                Class javaType = JavaUtils.loadJavaType(javaTypeName);
                Class<?> compJavaType = javaType.getComponentType();
                if (xmlTypeLocalPart.indexOf("ArrayOfArrayOf") >= 0) {
                    compJavaType = compJavaType.getComponentType();
                }
                QName compXMLType = new LiteralTypeMapping().getXMLType(compJavaType);
                paramMetaData.setSOAPArrayCompType(compXMLType);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
    }

    private void buildParameterMetaDataDoc(OperationMetaData opMetaData, WSDLInterfaceOperation wsdlOperation, ServiceEndpointMethodMapping seiMethodMapping, TypeMappingImpl typeMapping) {
        this.log.trace((Object)("buildParameterMetaDataDoc: " + opMetaData.getXmlName()));
        EndpointMetaData epMetaData = opMetaData.getEndpointMetaData();
        ServiceMetaData serviceMetaData = epMetaData.getServiceMetaData();
        TypesMetaData typesMetaData = serviceMetaData.getTypesMetaData();
        WSDLDefinitions wsdlDefinitions = wsdlOperation.getWsdlInterface().getWsdlDefinitions();
        WSDLTypes wsdlTypes = wsdlDefinitions.getWsdlTypes();
        WSDLInterfaceOperationPart[] wSDLInterfaceOperationPartArray = wsdlOperation.getInputs();
        int n = 0;
        int n2 = wSDLInterfaceOperationPartArray.length;
        while (n < n2) {
            VariableMapping[] paramType;
            MethodParamPartsMapping[] partsMappings;
            WSDLInterfaceOperationInput opInput = wSDLInterfaceOperationPartArray[n];
            QName xmlName = opInput.getElement();
            QName xmlType = opInput.getXMLType();
            String javaTypeName = typeMapping.getJavaTypeName(xmlType);
            if (typesMetaData.getTypeMappingByXMLType(xmlType) != null) {
                javaTypeName = typesMetaData.getTypeMappingByXMLType(xmlType).getJavaTypeName();
            }
            if (javaTypeName == null) {
                throw new WSException("Cannot obtain java type mapping for: " + xmlType);
            }
            boolean isWrapParameters = seiMethodMapping != null ? seiMethodMapping.isWrappedElement() : false;
            this.log.trace((Object)("isWrapParameters based on wrapped-element: " + isWrapParameters));
            if (!isWrapParameters && seiMethodMapping != null && (partsMappings = seiMethodMapping.getMethodParamPartsMappings()).length > 0) {
                boolean matchingPartFound = false;
                MethodParamPartsMapping[] methodParamPartsMappingArray = partsMappings;
                int n3 = 0;
                int n4 = methodParamPartsMappingArray.length;
                while (n3 < n4) {
                    MethodParamPartsMapping partsMapping = methodParamPartsMappingArray[n3];
                    String paramTypeName = partsMapping.getParamType();
                    if (paramTypeName.equals(javaTypeName)) {
                        matchingPartFound = true;
                        break;
                    }
                    try {
                        paramType = JavaUtils.loadJavaType(paramTypeName);
                        Class javaType = JavaUtils.loadJavaType(javaTypeName);
                        if (JavaUtils.isAssignableFrom(javaType, (Class)paramType)) {
                            javaTypeName = paramTypeName;
                            matchingPartFound = true;
                            break;
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                    ++n3;
                }
                isWrapParameters = !matchingPartFound;
                this.log.trace((Object)("isWrapParameters based on matching parts: " + isWrapParameters));
            }
            ParameterMetaData inMetaData = new ParameterMetaData(opMetaData, xmlName, xmlType, javaTypeName);
            epMetaData.setParameterStyle(isWrapParameters ? ParameterStyle.WRAPPED : ParameterStyle.BARE);
            opMetaData.addParameter(inMetaData);
            if (opMetaData.isDocumentWrapped()) {
                if (seiMethodMapping == null) {
                    throw new IllegalArgumentException("Cannot wrap parameters without SEI method mapping");
                }
                ServiceEndpointInterfaceMapping seiMapping = seiMethodMapping.getServiceEndpointInterfaceMapping();
                JavaXmlTypeMapping javaXmlTypeMapping = seiMapping.getJavaWsdlMapping().getTypeMappingForQName(xmlType);
                if (javaXmlTypeMapping == null) {
                    throw new WSException("Cannot obtain java/xml type mapping for: " + xmlType);
                }
                ArrayList<String> variableNames = new ArrayList<String>();
                paramType = javaXmlTypeMapping.getVariableMappings();
                int n5 = 0;
                int paramTypeName = paramType.length;
                while (n5 < paramTypeName) {
                    VariableMapping varMapping = paramType[n5];
                    variableNames.add(varMapping.getJavaVariableName());
                    ++n5;
                }
                inMetaData.setWrappedVariables(variableNames);
            }
            ++n;
        }
        wSDLInterfaceOperationPartArray = wsdlOperation.getOutputs();
        n = 0;
        n2 = wSDLInterfaceOperationPartArray.length;
        while (n < n2) {
            WSDLInterfaceOperationPart opOutput = wSDLInterfaceOperationPartArray[n];
            String partName = opOutput.getProperty("http://www.jboss.org/jbossws/partname").getValue();
            QName xmlName = opOutput.getElement();
            ParameterMetaData paramMetaData = opMetaData.getParameter(xmlName);
            if (paramMetaData != null && wsdlOperation.getInputByPartName(partName) != null) {
                paramMetaData.setMode(ParameterMode.INOUT);
            } else {
                boolean hasReturnMapping;
                QName xmlType = opOutput.getXMLType();
                String javaTypeName = typeMapping.getJavaTypeName(xmlType);
                boolean inHeader = opOutput.getProperty("http://www.w3.org/2004/08/wsdl/feature/AD/data") != null;
                boolean bl = hasReturnMapping = !inHeader;
                if (typesMetaData.getTypeMappingByXMLType(xmlType) != null) {
                    javaTypeName = typesMetaData.getTypeMappingByXMLType(xmlType).getJavaTypeName();
                }
                if (javaTypeName == null) {
                    throw new WSException("Cannot obtain java/xml type mapping for: " + xmlType);
                }
                if (hasReturnMapping) {
                    WsdlReturnValueMapping returnValueMapping;
                    if (seiMethodMapping != null && ((returnValueMapping = seiMethodMapping.getWsdlReturnValueMapping()) == null || !returnValueMapping.getMethodReturnValue().equals(javaTypeName)) && xmlType.equals(Constants.TYPE_LITERAL_ANYTYPE)) {
                        javaTypeName = returnValueMapping.getMethodReturnValue();
                    }
                    ParameterMetaData retMetaData = new ParameterMetaData(opMetaData, xmlName, xmlType, javaTypeName);
                    opMetaData.setReturnParameter(retMetaData);
                    this.setupAttachmentParameter(opOutput, retMetaData);
                    if (opMetaData.getParameterStyle() == ParameterStyle.WRAPPED) {
                        if (seiMethodMapping == null) {
                            throw new IllegalArgumentException("Cannot wrap parameters without SEI method mapping");
                        }
                        ServiceEndpointInterfaceMapping seiMapping = seiMethodMapping.getServiceEndpointInterfaceMapping();
                        JavaWsdlMapping javaWsdlMapping = seiMapping.getJavaWsdlMapping();
                        JavaXmlTypeMapping javaXmlTypeMapping = javaWsdlMapping.getTypeMappingForQName(xmlType);
                        if (typeMapping == null) {
                            throw new WSException("Cannot obtain java/xml type mapping for: " + xmlType);
                        }
                        ArrayList<String> variableNames = new ArrayList<String>();
                        VariableMapping[] variableMappingArray = javaXmlTypeMapping.getVariableMappings();
                        int n6 = 0;
                        int n7 = variableMappingArray.length;
                        while (n6 < n7) {
                            VariableMapping varMapping = variableMappingArray[n6];
                            variableNames.add(varMapping.getJavaVariableName());
                            ++n6;
                        }
                        retMetaData.setWrappedVariables(variableNames);
                    }
                } else {
                    ParameterMetaData outMetaData = new ParameterMetaData(opMetaData, xmlName, xmlType, javaTypeName);
                    opMetaData.addParameter(outMetaData);
                    outMetaData.setMode(ParameterMode.OUT);
                    this.setupAttachmentParameter(opOutput, outMetaData);
                    outMetaData.setInHeader(inHeader);
                }
            }
            ++n;
        }
        if (seiMethodMapping != null && wsdlDefinitions.getWsdlOneOneDefinition() != null) {
            MethodParamPartsMapping[] mppMappings = seiMethodMapping.getMethodParamPartsMappings();
            int i = 0;
            while (i < mppMappings.length) {
                MethodParamPartsMapping mppMapping = mppMappings[i];
                String javaTypeName = mppMapping.getParamType();
                WsdlMessageMapping wmMapping = mppMapping.getWsdlMessageMapping();
                if (wmMapping.isSoapHeader()) {
                    QName wsdlMessageName = wmMapping.getWsdlMessage();
                    String partName = wmMapping.getWsdlMessagePartName();
                    Message wsdl11Message = wsdlDefinitions.getWsdlOneOneDefinition().getMessage(wsdlMessageName);
                    Part wsdl11Part = wsdl11Message.getPart(partName);
                    QName xmlName = wsdl11Part.getElementName();
                    if (opMetaData.getParameter(xmlName) == null) {
                        String mode = wmMapping.getParameterMode();
                        QName xmlType = wsdlTypes.getXMLType(xmlName);
                        ParameterMetaData headerMetaData = new ParameterMetaData(opMetaData, xmlName, xmlType, javaTypeName);
                        opMetaData.addParameter(headerMetaData);
                        headerMetaData.setInHeader(true);
                        headerMetaData.setMode(mode);
                    }
                }
                ++i;
            }
        }
    }

    private void buildFaultMetaData(OperationMetaData opMetaData, WSDLInterfaceOperation wsdlOperation, ServiceEndpointInterfaceMapping seiMapping) {
        TypesMetaData typesMetaData = opMetaData.getEndpointMetaData().getServiceMetaData().getTypesMetaData();
        WSDLInterface wsdlInterface = wsdlOperation.getWsdlInterface();
        WSDLInterfaceOperationOutfault[] wSDLInterfaceOperationOutfaultArray = wsdlOperation.getOutfaults();
        int n = 0;
        int n2 = wSDLInterfaceOperationOutfaultArray.length;
        while (n < n2) {
            WSDLInterfaceOperationOutfault outFault = wSDLInterfaceOperationOutfaultArray[n];
            QName ref = outFault.getRef();
            WSDLInterfaceFault wsdlFault = wsdlInterface.getFault(new NCName(ref.getLocalPart()));
            QName xmlName = wsdlFault.getXmlName();
            QName xmlType = wsdlFault.getXmlType();
            String javaTypeName = null;
            if (typesMetaData.getTypeMappingByXMLType(xmlType) != null) {
                javaTypeName = typesMetaData.getTypeMappingByXMLType(xmlType).getJavaTypeName();
            }
            if (javaTypeName == null) {
                this.log.warn((Object)("Cannot obtain java type mapping for: " + xmlType));
                javaTypeName = new UnqualifiedFaultException(xmlType).getClass().getName();
            }
            FaultMetaData faultMetaData = new FaultMetaData(opMetaData, xmlName, xmlType, javaTypeName);
            opMetaData.addFault(faultMetaData);
            ++n;
        }
    }

    protected void initEndpointEncodingStyle(EndpointMetaData epMetaData) {
        WSDLDefinitions wsdlDefinitions = epMetaData.getServiceMetaData().getWsdlDefinitions();
        WSDLService[] wSDLServiceArray = wsdlDefinitions.getServices();
        int n = 0;
        int n2 = wSDLServiceArray.length;
        while (n < n2) {
            WSDLService wsdlService = wSDLServiceArray[n];
            WSDLEndpoint[] wSDLEndpointArray = wsdlService.getEndpoints();
            int n3 = 0;
            int n4 = wSDLEndpointArray.length;
            while (n3 < n4) {
                WSDLEndpoint wsdlEndpoint = wSDLEndpointArray[n3];
                if (epMetaData.getName().equals(wsdlEndpoint.getQName())) {
                    QName bindQName = wsdlEndpoint.getBinding();
                    NCName ncName = new NCName(bindQName.getLocalPart());
                    WSDLBinding wsdlBinding = wsdlDefinitions.getBinding(ncName);
                    if (wsdlBinding == null) {
                        throw new WSException("Cannot obtain binding: " + ncName);
                    }
                    WSDLBindingOperation[] wSDLBindingOperationArray = wsdlBinding.getOperations();
                    int n5 = 0;
                    int n6 = wSDLBindingOperationArray.length;
                    while (n5 < n6) {
                        WSDLBindingOperation wsdlBindingOperation = wSDLBindingOperationArray[n5];
                        String encStyle = wsdlBindingOperation.getEncodingStyle();
                        epMetaData.setUse(Use.valueOf(encStyle));
                        ++n5;
                    }
                }
                ++n3;
            }
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

