/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.logging.Logger;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.EjbPortComponentMetaData;
import org.jboss.metadata.WebMetaData;
import org.jboss.util.xml.DOMUtils;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.ServiceEndpointInterfaceMapping;
import org.jboss.webservice.metadata.serviceref.HandlerMetaData;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.JSR109MetaDataBuilder;
import org.jboss.ws.metadata.ServerEndpointMetaData;
import org.jboss.ws.metadata.ServiceMetaData;
import org.jboss.ws.metadata.UnifiedMetaData;
import org.jboss.ws.metadata.jsr109.PortComponentMetaData;
import org.jboss.ws.metadata.jsr109.WebserviceDescriptionMetaData;
import org.jboss.ws.metadata.jsr109.WebservicesFactory;
import org.jboss.ws.metadata.jsr109.WebservicesMetaData;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
import org.jboss.ws.metadata.wsse.WSSecurityConfigurationFactory;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JSR109ServerMetaDataBuilder
extends JSR109MetaDataBuilder {
    final Logger log = Logger.getLogger((Class)(class$org$jboss$ws$metadata$JSR109ServerMetaDataBuilder == null ? (class$org$jboss$ws$metadata$JSR109ServerMetaDataBuilder = JSR109ServerMetaDataBuilder.class$("org.jboss.ws.metadata.JSR109ServerMetaDataBuilder")) : class$org$jboss$ws$metadata$JSR109ServerMetaDataBuilder));
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$org$jboss$ws$metadata$JSR109ServerMetaDataBuilder;

    public UnifiedMetaData buildMetaData(DeploymentInfo di, URL webservicesURL) {
        this.log.debug((Object)("START buildMetaData: [url=" + webservicesURL + "]"));
        try {
            WebserviceDescriptionMetaData[] wsDescriptionArr;
            WebservicesMetaData webservices = null;
            InputStream is = webservicesURL.openStream();
            try {
                Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
                WebservicesFactory factory = new WebservicesFactory(webservicesURL);
                webservices = (WebservicesMetaData)unmarshaller.unmarshal(is, (ObjectModelFactory)factory, null);
            }
            finally {
                is.close();
            }
            WSSecurityConfiguration securityConfiguration = this.getWsSecurityConfiguration(di);
            UnifiedMetaData wsMetaData = new UnifiedMetaData();
            wsMetaData.setResourceLoader(this.resourceLoader);
            wsMetaData.setClassLoader(this.classLoader);
            WebserviceDescriptionMetaData[] webserviceDescriptionMetaDataArray = wsDescriptionArr = webservices.getWebserviceDescriptions();
            int n = 0;
            int n2 = webserviceDescriptionMetaDataArray.length;
            while (n < n2) {
                PortComponentMetaData[] pcMetaDataArr;
                WebserviceDescriptionMetaData wsdMetaData = webserviceDescriptionMetaDataArray[n];
                ServiceMetaData serviceMetaData = new ServiceMetaData(wsMetaData, null);
                serviceMetaData.setWebserviceDescriptionName(wsdMetaData.getWebserviceDescriptionName());
                wsMetaData.addService(serviceMetaData);
                serviceMetaData.setWsdlFile(wsdMetaData.getWsdlFile());
                WSDLDefinitions wsdlDefinitions = serviceMetaData.getWsdlDefinitions();
                serviceMetaData.setJaxrpcMappingFile(wsdMetaData.getJaxrpcMappingFile());
                JavaWsdlMapping javaWsdlMapping = serviceMetaData.getJavaWsdlMapping();
                this.setupTypesMetaData(serviceMetaData);
                serviceMetaData.setSecurityConfiguration(securityConfiguration);
                PortComponentMetaData[] portComponentMetaDataArray = pcMetaDataArr = wsdMetaData.getPortComponents();
                int n3 = 0;
                int n4 = portComponentMetaDataArray.length;
                while (n3 < n4) {
                    PortComponentMetaData pcMetaData = portComponentMetaDataArray[n3];
                    WSDLEndpoint wsdlEndpoint = null;
                    QName epName = pcMetaData.getWsdlPort();
                    WSDLService[] wSDLServiceArray = wsdlDefinitions.getServices();
                    int n5 = 0;
                    int n6 = wSDLServiceArray.length;
                    while (n5 < n6) {
                        WSDLService wsdlService = wSDLServiceArray[n5];
                        wsdlEndpoint = wsdlService.getEndpoint(epName);
                        if (wsdlEndpoint != null) {
                            serviceMetaData.setName(wsdlService.getQName());
                            break;
                        }
                        ++n5;
                    }
                    if (wsdlEndpoint == null) {
                        throw new WSException("Cannot find port in wsdl: " + epName);
                    }
                    ServerEndpointMetaData epMetaData = new ServerEndpointMetaData(serviceMetaData, epName);
                    epMetaData.setPortComponentName(pcMetaData.getPortComponentName());
                    String ejbLink = pcMetaData.getEjbLink();
                    String servletLink = pcMetaData.getServletLink();
                    epMetaData.setLinkName(servletLink != null ? servletLink : ejbLink);
                    serviceMetaData.addEndpoint(epMetaData);
                    this.initEndpointEncodingStyle(epMetaData);
                    String serviceEndpointID = this.getServiceEndpointID(di, epMetaData);
                    epMetaData.setEndpointID(serviceEndpointID);
                    if (di.metaData instanceof ApplicationMetaData) {
                        EjbPortComponentMetaData bpcMetaData;
                        String configFile;
                        ApplicationMetaData applMetaData = (ApplicationMetaData)di.metaData;
                        BeanMetaData beanMetaData = applMetaData.getBeanByEjbName(ejbLink);
                        if (beanMetaData == null) {
                            throw new WSException("Cannot obtain BeanMetaData for: " + ejbLink);
                        }
                        String configName = applMetaData.getConfigName();
                        if (configName != null) {
                            epMetaData.setConfigName(configName);
                        }
                        if ((configFile = applMetaData.getConfigFile()) != null) {
                            epMetaData.setConfigFile(configFile);
                        }
                        if ((bpcMetaData = beanMetaData.getPortComponent()) != null) {
                            if (bpcMetaData.getAuthMethod() != null) {
                                String authMethod = bpcMetaData.getAuthMethod();
                                epMetaData.setAuthMethod(authMethod);
                            }
                            if (bpcMetaData.getTransportGuarantee() != null) {
                                String transportGuarantee = bpcMetaData.getTransportGuarantee();
                                epMetaData.setTransportGuarantee(transportGuarantee);
                            }
                        }
                        this.initServicePathEJB(di, epMetaData, ejbLink);
                    } else if (di.metaData instanceof WebMetaData) {
                        String configFile;
                        WebMetaData webMetaData = (WebMetaData)di.metaData;
                        String configName = webMetaData.getConfigName();
                        if (configName != null) {
                            epMetaData.setConfigName(configName);
                        }
                        if ((configFile = webMetaData.getConfigFile()) != null) {
                            epMetaData.setConfigFile(configFile);
                        }
                        this.initServicePathJSE(di, epMetaData, servletLink);
                        this.initTransportGuaranteeJSE(di, epMetaData, servletLink);
                    }
                    epMetaData.getEndpointConfig();
                    this.replaceAddressLocation(epMetaData);
                    String seiName = pcMetaData.getServiceEndpointInterface();
                    epMetaData.setServiceEndpointInterfaceName(seiName);
                    ServiceEndpointInterfaceMapping seiMapping = javaWsdlMapping.getServiceEndpointInterfaceMapping(seiName);
                    if (seiMapping == null) {
                        this.log.warn((Object)("Cannot obtain SEI mapping for: " + seiName));
                    }
                    this.setupOperationsFromWSDL(epMetaData, wsdlEndpoint, seiMapping);
                    HandlerMetaData[] handlerMetaDataArray = pcMetaData.getHandlers();
                    int n7 = 0;
                    int n8 = handlerMetaDataArray.length;
                    while (n7 < n8) {
                        HandlerMetaData handlerMetaData = handlerMetaDataArray[n7];
                        List<String> portNames = Arrays.asList(handlerMetaData.getPortNames());
                        if (portNames.size() == 0 || portNames.contains(epName.getLocalPart())) {
                            epMetaData.addHandler(handlerMetaData);
                        }
                        ++n7;
                    }
                    ++n3;
                }
                ++n;
            }
            this.log.debug((Object)("END buildMetaData: " + wsMetaData));
            return wsMetaData;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new WSException("Cannot build meta data: " + ex.getMessage(), ex);
        }
    }

    private void initServicePathEJB(DeploymentInfo di, ServerEndpointMetaData epMetaData, String ejbLink) {
        ApplicationMetaData applMetaData = (ApplicationMetaData)di.metaData;
        BeanMetaData beanMetaData = applMetaData.getBeanByEjbName(ejbLink);
        if (beanMetaData == null) {
            throw new WSException("Cannot obtain meta data for ejb link: " + ejbLink);
        }
        String contextRoot = applMetaData.getWebServiceContextRoot();
        if (contextRoot == null) {
            String shortName = di.shortName;
            contextRoot = shortName.substring(0, shortName.indexOf(46));
            contextRoot = "/" + contextRoot;
        }
        epMetaData.setContextRoot(contextRoot);
        EjbPortComponentMetaData ejbpcMetaData = beanMetaData.getPortComponent();
        String urlPattern = ejbpcMetaData != null && ejbpcMetaData.getPortComponentURI() != null ? ejbpcMetaData.getPortComponentURI() : "/" + ejbLink;
        epMetaData.setURLPattern(urlPattern);
    }

    private void initServicePathJSE(DeploymentInfo di, ServerEndpointMetaData epMetaData, String servletLink) {
        WebMetaData webMetaData = (WebMetaData)di.metaData;
        HashMap servletMappings = webMetaData.getServletMappings();
        String contextRoot = webMetaData.getContextRoot();
        if (contextRoot == null) {
            String shortName = di.shortName;
            contextRoot = shortName.substring(0, shortName.indexOf(46));
            contextRoot = "/" + contextRoot;
        }
        epMetaData.setContextRoot(contextRoot);
        String urlPattern = (String)servletMappings.get(servletLink);
        if (urlPattern == null) {
            throw new WSException("Cannot obtain servlet mapping for servlet link: " + servletLink);
        }
        if (!urlPattern.startsWith("/")) {
            urlPattern = "/" + urlPattern;
        }
        epMetaData.setURLPattern(urlPattern);
    }

    private WSSecurityConfiguration getWsSecurityConfiguration(DeploymentInfo di) throws IOException {
        WSSecurityConfiguration config = null;
        String resource = WSSecurityConfigurationFactory.SERVER_RESOURCE_NAME;
        resource = di.metaData instanceof WebMetaData ? "WEB-INF/" + resource : "META-INF/" + resource;
        URL location = this.resourceLoader.getResource(resource);
        if (location != null) {
            config = WSSecurityConfigurationFactory.newInstance().parse(location);
            if (config.getKeyStoreFile() != null && (location = this.resourceLoader.getResource(config.getKeyStoreFile())) != null) {
                config.setKeyStoreURL(location);
            }
            if (config.getTrustStoreFile() != null && (location = this.resourceLoader.getResource(config.getTrustStoreFile())) != null) {
                config.setTrustStoreURL(location);
            }
        }
        return config;
    }

    protected void initTransportGuaranteeJSE(DeploymentInfo di, EndpointMetaData epMetaData, String servletLink) throws IOException {
        File warFile = new File(di.localUrl.getFile());
        if (!warFile.isDirectory()) {
            throw new WSException("Expected a war directory: " + di.localUrl);
        }
        File webXML = new File(String.valueOf(di.localUrl.getFile()) + "/WEB-INF/web.xml");
        if (!webXML.isFile()) {
            throw new WSException("Cannot find web.xml: " + webXML);
        }
        Element rootElement = DOMUtils.parse((InputStream)new FileInputStream(webXML));
        Element elServletMapping = null;
        Iterator itServlet = DOMUtils.getChildElements((Node)rootElement, (String)"servlet-mapping");
        while (itServlet.hasNext() && elServletMapping == null) {
            Element elAux = (Element)itServlet.next();
            String servletName = DOMUtils.getTextContent((Node)DOMUtils.getFirstChildElement((Node)elAux, (String)"servlet-name"));
            if (!servletLink.equals(servletName)) continue;
            elServletMapping = elAux;
        }
        if (elServletMapping != null) {
            String urlPattern = DOMUtils.getTextContent((Node)DOMUtils.getFirstChildElement(elServletMapping, (String)"url-pattern"));
            if (urlPattern == null) {
                throw new WSException("Cannot find <url-pattern> for servlet-name: " + servletLink);
            }
            Iterator itSecConstraint = DOMUtils.getChildElements((Node)rootElement, (String)"security-constraint");
            while (itSecConstraint.hasNext()) {
                Element elSecurityConstraint = (Element)itSecConstraint.next();
                Iterator itWebResourceCollection = DOMUtils.getChildElements((Node)elSecurityConstraint, (String)"web-resource-collection");
                while (itWebResourceCollection.hasNext()) {
                    Element elUserDataConstraint;
                    Element elWebResourceCollection = (Element)itWebResourceCollection.next();
                    String wrcurlPattern = DOMUtils.getTextContent((Node)DOMUtils.getFirstChildElement((Node)elWebResourceCollection, (String)"url-pattern"));
                    if (!urlPattern.equals(wrcurlPattern) || (elUserDataConstraint = DOMUtils.getFirstChildElement((Node)elSecurityConstraint, (String)"user-data-constraint")) == null) continue;
                    String transportGuarantee = DOMUtils.getTextContent((Node)DOMUtils.getFirstChildElement((Node)elUserDataConstraint, (String)"transport-guarantee"));
                    epMetaData.setTransportGuarantee(transportGuarantee);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

