/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.jaxrpc.ParameterStyle;
import org.jboss.ws.jaxrpc.ParameterWrapping;
import org.jboss.ws.jaxrpc.Style;
import org.jboss.ws.jaxrpc.Use;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.FaultMetaData;
import org.jboss.ws.metadata.ParameterMetaData;
import org.jboss.ws.metadata.ServerEndpointMetaData;
import org.jboss.ws.metadata.ServiceMetaData;
import org.jboss.ws.metadata.UnifiedMetaData;
import org.jboss.ws.utils.HolderUtils;
import org.jboss.ws.utils.JavaUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationMetaData {
    private final Logger log = Logger.getLogger((Class)(class$org$jboss$ws$metadata$OperationMetaData == null ? (class$org$jboss$ws$metadata$OperationMetaData = OperationMetaData.class$("org.jboss.ws.metadata.OperationMetaData")) : class$org$jboss$ws$metadata$OperationMetaData));
    private EndpointMetaData endpoint;
    private QName xmlName;
    private QName responseName;
    private String javaName;
    private Method javaMethod;
    private boolean oneWayOperation;
    private String soapAction;
    private List<ParameterMetaData> parameters = new ArrayList<ParameterMetaData>();
    private List<FaultMetaData> faults = new ArrayList<FaultMetaData>();
    private ParameterMetaData returnParam;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$org$jboss$ws$metadata$OperationMetaData;
    static /* synthetic */ Class class$org$w3c$dom$Element;

    public OperationMetaData(QName xmlName, String javaName) {
        UnifiedMetaData umd = new UnifiedMetaData();
        ServiceMetaData smd = new ServiceMetaData(umd, new QName("mock-service"));
        ServerEndpointMetaData epmd = new ServerEndpointMetaData(smd, new QName("mock-endpoint"));
        this.initOperationMetaData(epmd, xmlName, javaName);
    }

    public OperationMetaData(EndpointMetaData epMetaData, QName xmlName, String javaName) {
        this.log.trace((Object)new StringBuffer("new OperationMetaData: [xmlName=").append(xmlName).append(",javaName=").append(javaName).append("]").toString());
        this.initOperationMetaData(epMetaData, xmlName, javaName);
    }

    private void initOperationMetaData(EndpointMetaData epMetaData, QName xmlName, String javaName) {
        this.endpoint = epMetaData;
        this.xmlName = xmlName;
        this.javaName = javaName;
        if (xmlName == null) {
            throw new IllegalArgumentException("Invalid null xmlName argument");
        }
        if (javaName == null) {
            throw new IllegalArgumentException(new StringBuffer("Invalid null javaName argument, for: ").append(xmlName).toString());
        }
        String nsURI = xmlName.getNamespaceURI();
        String localPart = xmlName.getLocalPart();
        this.responseName = new QName(nsURI, new StringBuffer(String.valueOf(localPart)).append("Response").toString());
    }

    public EndpointMetaData getEndpointMetaData() {
        return this.endpoint;
    }

    public QName getXmlName() {
        return this.xmlName;
    }

    public QName getResponseName() {
        return this.responseName;
    }

    public String getSOAPAction() {
        return this.soapAction;
    }

    public void setSOAPAction(String soapAction) {
        this.soapAction = soapAction;
    }

    public Style getStyle() {
        return this.endpoint.getStyle();
    }

    public Use getUse() {
        return this.endpoint.getUse();
    }

    public ParameterStyle getParameterStyle() {
        return this.endpoint.getParameterStyle();
    }

    public boolean isDocumentBare() {
        return this.getStyle() == Style.DOCUMENT && this.getParameterStyle() == ParameterStyle.BARE;
    }

    public boolean isDocumentWrapped() {
        return this.getStyle() == Style.DOCUMENT && this.getParameterStyle() == ParameterStyle.WRAPPED;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public Method getJavaMethod() {
        ClassLoader loader = this.getEndpointMetaData().getServiceMetaData().getUnifiedMetaData().getClassLoader();
        if (this.javaMethod == null || !this.javaMethod.getDeclaringClass().getClassLoader().equals(loader)) {
            this.javaMethod = null;
            try {
                Class seiClass = this.endpoint.getServiceEndpointInterface();
                if (seiClass == null) {
                    throw new WSException("ServiceEndpointInterface not available");
                }
                Method[] methodArray = seiClass.getMethods();
                int n = 0;
                int n2 = methodArray.length;
                while (n < n2) {
                    Method method = methodArray[n];
                    String methodName = method.getName();
                    Class[] methodTypes = method.getParameterTypes();
                    if (this.javaName.equals(methodName)) {
                        this.log.debug((Object)new StringBuffer("Found java method: ").append(method).toString());
                        if (this.isDocumentWrapped() && ParameterWrapping.matchRequestParameters(this, methodTypes)) {
                            this.log.debug((Object)new StringBuffer("Found wrapped java method: ").append(method).toString());
                            this.javaMethod = method;
                            break;
                        }
                        if (this.compareMethodParams(methodTypes, true)) {
                            this.log.debug((Object)new StringBuffer("Found best matching java method: ").append(method).toString());
                            this.javaMethod = method;
                            break;
                        }
                        if (this.compareMethodParams(methodTypes, false)) {
                            if (this.javaMethod != null) {
                                throw new WSException(new StringBuffer("Umbiguous javaMethod: ").append(method).toString());
                            }
                            this.log.debug((Object)new StringBuffer("Found possible matching java method: ").append(method).toString());
                            this.javaMethod = method;
                            break;
                        }
                    }
                    ++n;
                }
                if (this.javaMethod == null) {
                    throw new WSException(new StringBuffer("Cannot find java method: ").append(this.javaName).toString());
                }
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (Exception exception) {
                throw new WSException(new StringBuffer("Cannot load java method: ").append(this.javaName).toString());
            }
        }
        return this.javaMethod;
    }

    public boolean isMessageEndpoint() {
        ParameterMetaData inParam;
        boolean isMessageEndpoint = false;
        if (this.parameters.size() == 1 && JavaUtils.isAssignableFrom(class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = OperationMetaData.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element, (inParam = this.parameters.get(0)).getJavaType())) {
            isMessageEndpoint = true;
        }
        return isMessageEndpoint;
    }

    private boolean compareMethodParams(Class[] methodTypes, boolean matchByTypeName) {
        boolean pass;
        this.log.debug((Object)new StringBuffer("Compare method params by type name: ").append(matchByTypeName).toString());
        boolean bl = pass = this.parameters.size() == methodTypes.length;
        if (!pass) {
            this.log.debug((Object)new StringBuffer("Unmatched parameter count: ").append(this.parameters.size()).append("!=").append(methodTypes.length).toString());
        }
        int i = 0;
        while (pass && i < methodTypes.length) {
            ParameterMetaData paramMetaData = this.parameters.get(i);
            Class methodType = methodTypes[i];
            if (paramMetaData.getMode() != ParameterMode.IN) {
                if (HolderUtils.isHolderType(methodType)) {
                    methodType = HolderUtils.getValueType(methodType);
                } else {
                    pass = false;
                    break;
                }
            }
            if (matchByTypeName) {
                String javaTypeName = methodType.getName();
                String paramTypeName = paramMetaData.getJavaTypeName();
                pass = javaTypeName.equals(paramTypeName);
            } else {
                Class paramType = paramMetaData.getJavaType();
                pass = JavaUtils.isAssignableFrom(methodType, paramType);
            }
            String name = matchByTypeName ? paramMetaData.getJavaTypeName() : paramMetaData.getJavaType().getName();
            this.log.debug((Object)new StringBuffer(String.valueOf(pass ? "Matched" : "Unmatched")).append(" parameter: ").append(name).append(" == ").append(methodType.getName()).toString());
            ++i;
        }
        return pass;
    }

    public boolean isOneWayOperation() {
        return this.oneWayOperation;
    }

    public void setOneWayOperation(boolean oneWayOperation) {
        this.oneWayOperation = oneWayOperation;
        this.assertOneWayOperation();
    }

    public ParameterMetaData getParameter(QName xmlName) {
        ParameterMetaData paramMetaData = null;
        int i = 0;
        while (paramMetaData == null && i < this.parameters.size()) {
            ParameterMetaData aux = this.parameters.get(i);
            if (xmlName.equals(aux.getXmlName())) {
                paramMetaData = aux;
            }
            ++i;
        }
        return paramMetaData;
    }

    public List<ParameterMetaData> getInputParameters() {
        ArrayList<ParameterMetaData> retList = new ArrayList<ParameterMetaData>();
        for (ParameterMetaData paramMetaData : this.parameters) {
            ParameterMode mode = paramMetaData.getMode();
            if (mode != ParameterMode.IN && mode != ParameterMode.INOUT) continue;
            retList.add(paramMetaData);
        }
        return retList;
    }

    public List<ParameterMetaData> getOutputParameters() {
        ArrayList<ParameterMetaData> retList = new ArrayList<ParameterMetaData>();
        for (ParameterMetaData paramMetaData : this.parameters) {
            ParameterMode mode = paramMetaData.getMode();
            if (mode != ParameterMode.OUT && mode != ParameterMode.INOUT) continue;
            retList.add(paramMetaData);
        }
        return retList;
    }

    public List<ParameterMetaData> getNonHeaderParameters() {
        ArrayList<ParameterMetaData> retList = new ArrayList<ParameterMetaData>();
        for (ParameterMetaData paramMetaData : this.parameters) {
            if (paramMetaData.isInHeader()) continue;
            retList.add(paramMetaData);
        }
        return retList;
    }

    public List<ParameterMetaData> getParameters() {
        return new ArrayList<ParameterMetaData>(this.parameters);
    }

    public void addParameter(ParameterMetaData paramMetaData) {
        this.log.trace((Object)new StringBuffer("addParameter: ").append(paramMetaData).toString());
        this.parameters.add(paramMetaData);
        this.assertOneWayOperation();
    }

    public void removeAllParameters() {
        this.parameters.clear();
    }

    public ParameterMetaData getReturnParameter() {
        return this.returnParam;
    }

    public void setReturnParameter(ParameterMetaData returnParam) {
        this.log.trace((Object)new StringBuffer("setReturnParameter: ").append(returnParam).toString());
        returnParam.setMode(ParameterMode.OUT);
        this.returnParam = returnParam;
        this.assertOneWayOperation();
    }

    public List<FaultMetaData> getFaults() {
        return new ArrayList<FaultMetaData>(this.faults);
    }

    public FaultMetaData getFault(QName xmlName) {
        FaultMetaData faultMetaData = null;
        int i = 0;
        while (faultMetaData == null && i < this.faults.size()) {
            FaultMetaData aux = this.faults.get(i);
            if (aux.getXmlName().equals(xmlName)) {
                faultMetaData = aux;
            }
            ++i;
        }
        return faultMetaData;
    }

    public FaultMetaData getFault(Class javaType) {
        FaultMetaData faultMetaData = null;
        for (FaultMetaData aux : this.faults) {
            if (!aux.getJavaType().equals(javaType)) continue;
            faultMetaData = aux;
            break;
        }
        return faultMetaData;
    }

    public void addFault(FaultMetaData fault) {
        this.log.trace((Object)new StringBuffer("addFault: ").append(fault).toString());
        this.faults.add(fault);
        this.assertOneWayOperation();
    }

    private void assertOneWayOperation() {
        if (this.oneWayOperation) {
            if (this.returnParam != null) {
                throw new WSException("OneWay operations cannot have a return parameter");
            }
            if (this.faults.size() > 0) {
                throw new WSException("OneWay operations cannot have checked exceptions");
            }
            for (ParameterMetaData paramMetaData : this.parameters) {
                if (paramMetaData.getMode() == ParameterMode.IN) continue;
                throw new WSException("OneWay operations cannot have INOUT or OUT parameters");
            }
        }
    }

    public void eagerInitialize() {
        for (ParameterMetaData parameter : this.parameters) {
            parameter.eagerInitialize();
        }
        if (this.returnParam != null) {
            this.returnParam.eagerInitialize();
        }
        for (FaultMetaData fault : this.faults) {
            fault.eagerInitialize();
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("\nOperationMetaData:");
        buffer.append(new StringBuffer("\n xmlName=").append(this.xmlName).toString());
        buffer.append(new StringBuffer("\n javaName=").append(this.javaName).toString());
        buffer.append(new StringBuffer("\n style=").append(this.getStyle()).append("/").append(this.getUse()).append(this.getStyle() == Style.DOCUMENT ? new StringBuffer("/").append(this.getParameterStyle()).toString() : "").toString());
        buffer.append(new StringBuffer("\n oneWay=").append(this.oneWayOperation).toString());
        buffer.append(new StringBuffer("\n soapAction=").append(this.soapAction).toString());
        for (ParameterMetaData param : this.parameters) {
            buffer.append(param);
        }
        if (this.returnParam != null) {
            buffer.append(this.returnParam.toString());
        }
        for (FaultMetaData fault : this.faults) {
            buffer.append(fault);
        }
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

