/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import org.jboss.ws.WSException;
import org.jboss.ws.jaxrpc.ParameterWrapping;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.utils.JavaUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterMetaData {
    private OperationMetaData opMetaData;
    private QName xmlName;
    private QName xmlType;
    private String javaTypeName;
    private Class javaType;
    private ParameterMode mode;
    private Set<String> mimeTypes;
    private boolean inHeader;
    private boolean isSwA;
    private boolean isXOP;
    private List<String> wrappedVariables;
    private List<String> wrappedTypes;
    private List<QName> wrappedElementNames;
    private boolean generatedWrapper;
    private boolean soapArrayParam;
    private QName soapArrayCompType;

    public ParameterMetaData(OperationMetaData opMetaData, QName xmlName, QName xmlType, String javaTypeName) {
        this.xmlName = xmlName;
        this.xmlType = xmlType;
        this.opMetaData = opMetaData;
        this.mode = ParameterMode.IN;
        this.javaTypeName = javaTypeName;
        if (xmlName == null) {
            throw new IllegalArgumentException("Invalid null xmlName argument");
        }
        if (xmlType == null) {
            throw new IllegalArgumentException(new StringBuffer("Invalid null xmlType argument, for: ").append(xmlName).toString());
        }
        if (xmlName.getNamespaceURI().length() > 0) {
            this.xmlName = new QName(xmlName.getNamespaceURI(), xmlName.getLocalPart());
        }
        if (xmlType.getNamespaceURI().length() > 0) {
            this.xmlType = new QName(xmlType.getNamespaceURI(), xmlType.getLocalPart());
        }
        if ("http://www.jboss.org/jbossws/attachment/mimetype".equals(xmlType.getNamespaceURI())) {
            String mimeType = this.convertXmlTypeToMimeType(xmlType);
            this.setMimeTypes(mimeType);
            this.isSwA = true;
        }
    }

    public OperationMetaData getOperationMetaData() {
        return this.opMetaData;
    }

    public QName getXmlName() {
        return this.xmlName;
    }

    public QName getXmlType() {
        return this.xmlType;
    }

    public String getJavaTypeName() {
        return this.javaTypeName;
    }

    public void setJavaTypeName(String javaTypeName) {
        this.javaTypeName = javaTypeName;
    }

    public Class getJavaType() {
        ClassLoader loader = this.opMetaData.getEndpointMetaData().getServiceMetaData().getUnifiedMetaData().getClassLoader();
        if (loader == null) {
            throw new WSException("ClassLoader not available");
        }
        if (this.javaTypeName == null) {
            return null;
        }
        if (this.javaType == null || !this.javaType.isPrimitive() && this.javaType.getClassLoader() != loader) {
            try {
                this.javaType = JavaUtils.loadJavaType(this.javaTypeName, loader);
            }
            catch (ClassNotFoundException ex) {
                throw new WSException(new StringBuffer("Cannot load java type: ").append(this.javaTypeName).toString(), ex);
            }
        }
        return this.javaType;
    }

    public ParameterMode getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        if ("IN".equals(mode)) {
            this.setMode(ParameterMode.IN);
        } else if ("INOUT".equals(mode)) {
            this.setMode(ParameterMode.INOUT);
        } else if ("OUT".equals(mode)) {
            this.setMode(ParameterMode.OUT);
        } else {
            throw new IllegalArgumentException(new StringBuffer("Invalid mode: ").append(mode).toString());
        }
    }

    public void setMode(ParameterMode mode) {
        this.mode = mode;
    }

    public Set<String> getMimeTypes() {
        return this.mimeTypes;
    }

    public void setMimeTypes(String mimeStr) {
        this.mimeTypes = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(mimeStr, ",");
        while (st.hasMoreTokens()) {
            this.mimeTypes.add(st.nextToken().trim());
        }
    }

    public boolean isInHeader() {
        return this.inHeader;
    }

    public void setInHeader(boolean inHeader) {
        this.inHeader = inHeader;
    }

    public boolean isSwA() {
        return this.isSwA;
    }

    public void setSwA(boolean isSwA) {
        this.isSwA = isSwA;
    }

    public boolean isXOP() {
        return this.isXOP;
    }

    public void setXOP(boolean isXOP) {
        this.isXOP = isXOP;
    }

    public List<String> getWrappedVariables() {
        return this.wrappedVariables;
    }

    public void setWrappedVariables(List<String> wrappedVariables) {
        this.wrappedVariables = wrappedVariables;
    }

    public List<QName> getWrappedElementNames() {
        return this.wrappedElementNames;
    }

    public void setWrappedElementNames(List<QName> wrappedElementNames) {
        this.wrappedElementNames = wrappedElementNames;
    }

    public boolean isSOAPArrayParam() {
        return this.soapArrayParam;
    }

    public void setSOAPArrayParam(boolean soapArrayParam) {
        this.soapArrayParam = soapArrayParam;
    }

    public QName getSOAPArrayCompType() {
        return this.soapArrayCompType;
    }

    public void setSOAPArrayCompType(QName xmlType) {
        this.soapArrayCompType = xmlType;
    }

    private String convertXmlTypeToMimeType(QName xmlType) {
        StringBuffer mimeName = new StringBuffer(xmlType.getLocalPart());
        int pos = mimeName.indexOf("_");
        if (pos == -1) {
            throw new IllegalArgumentException(new StringBuffer("Invalid mime type: ").append(xmlType).toString());
        }
        mimeName.setCharAt(pos, '/');
        return mimeName.toString();
    }

    public List<String> getWrappedTypes() {
        return this.wrappedTypes;
    }

    public void setWrappedTypes(List<String> wrappedTypes) {
        this.wrappedTypes = wrappedTypes;
    }

    public boolean isGeneratedWrapper() {
        return this.generatedWrapper;
    }

    public void setGeneratedWrapper(boolean generatedWrapper) {
        if (generatedWrapper && !this.opMetaData.isDocumentWrapped()) {
            throw new IllegalArgumentException("Wrapper generation requires a doc/literal wrapped style");
        }
        this.generatedWrapper = generatedWrapper;
    }

    public void eagerInitialize() {
        if (this.generatedWrapper) {
            ParameterWrapping.generateWrapper(this, true);
        }
        this.getJavaType();
    }

    public String toString() {
        boolean isReturn = this.opMetaData.getReturnParameter() == this;
        StringBuffer buffer = new StringBuffer(new StringBuffer("\n").append(isReturn ? "ReturnMetaData:" : "ParameterMetaData:").toString());
        buffer.append(new StringBuffer("\n xmlName=").append(this.getXmlName()).toString());
        buffer.append(new StringBuffer("\n xmlType=").append(this.getXmlType()).toString());
        buffer.append(new StringBuffer("\n javaType=").append(this.getJavaTypeName()).toString());
        buffer.append(new StringBuffer("\n mode=").append(this.getMode()).toString());
        buffer.append(new StringBuffer("\n inHeader=").append(this.isInHeader()).toString());
        if (this.soapArrayParam) {
            buffer.append(new StringBuffer("\n soapArrayCompType=").append(this.soapArrayCompType).toString());
        }
        if (this.wrappedVariables != null) {
            buffer.append(new StringBuffer("\n wrappedVariables=").append(this.wrappedVariables).toString());
        }
        if (this.wrappedTypes != null) {
            buffer.append(new StringBuffer("\n wrappedTypes=").append(this.wrappedTypes).toString());
        }
        if (this.wrappedElementNames != null) {
            buffer.append(new StringBuffer("\n wrappedElementNames=").append(this.wrappedElementNames).toString());
        }
        if (this.isSwA()) {
            buffer.append(new StringBuffer("\n isSwA=").append(this.isSwA()).toString());
            buffer.append(new StringBuffer("\n mimeTypes=").append(this.getMimeTypes()).toString());
        }
        if (this.isXOP()) {
            buffer.append(new StringBuffer("\n isXOP=").append(this.isXOP()).toString());
            buffer.append(new StringBuffer("\n mimeTypes=").append(this.getMimeTypes()).toString());
        }
        return buffer.toString();
    }
}

