/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.webservice.metadata.serviceref.HandlerMetaData;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.metadata.ServiceMetaData;
import org.jboss.ws.metadata.config.WSConfig;
import org.jboss.ws.metadata.config.WSConfigFactory;
import org.jboss.ws.metadata.config.WSEndpointConfig;
import org.jboss.ws.metadata.config.WSHandlerChainConfig;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerEndpointMetaData
extends EndpointMetaData {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$ws$metadata$ServerEndpointMetaData == null ? (class$org$jboss$ws$metadata$ServerEndpointMetaData = ServerEndpointMetaData.class$("org.jboss.ws.metadata.ServerEndpointMetaData")) : class$org$jboss$ws$metadata$ServerEndpointMetaData));
    private WSEndpointConfig endpointConfig;
    private String linkName;
    private String portComponentName;
    private String implName;
    private String endpointID;
    private String contextRoot;
    private String urlPattern;
    private boolean annotated = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$org$jboss$ws$metadata$ServerEndpointMetaData;

    public ServerEndpointMetaData(ServiceMetaData service, QName qname) {
        super(service, qname);
        this.setConfigName("Standard Endpoint");
        this.setConfigFile("META-INF/standard-jbossws-endpoint-config.xml");
    }

    public WSEndpointConfig getEndpointConfig() {
        if (this.endpointConfig == null) {
            WSConfig wsConfig;
            ClassLoader cl;
            String configName = this.getConfigName();
            String configFile = this.getConfigFile();
            log.debug((Object)new StringBuffer("getEndpointConfig: [name=").append(configName).append(",url=").append(configFile).append("]").toString());
            URL configURL = null;
            try {
                configURL = new URL(configFile);
            }
            catch (MalformedURLException malformedURLException) {}
            if (configURL == null && (configURL = (cl = Thread.currentThread().getContextClassLoader()).getResource(configFile)) == null) {
                throw new WSException(new StringBuffer("Cannot get resource: ").append(configFile).toString());
            }
            try {
                WSConfigFactory factory = WSConfigFactory.newInstance();
                wsConfig = factory.parseWithObjectModelFactory(configURL);
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (Exception ex) {
                throw new WSException("Cannot parse client config", ex);
            }
            this.endpointConfig = wsConfig.getEndpointConfigByName(configName);
            if (this.endpointConfig == null) {
                throw new WSException(new StringBuffer("Cannot obtain endpoint config: ").append(configName).toString());
            }
            if (!configName.equals(this.endpointConfig.getConfigName())) {
                configName = this.endpointConfig.getConfigName();
                log.debug((Object)new StringBuffer("Using config name: ").append(configName).toString());
                this.setConfigName(configName);
            }
        }
        return this.endpointConfig;
    }

    public String getLinkName() {
        return this.linkName;
    }

    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }

    public String getPortComponentName() {
        return this.portComponentName;
    }

    public void setPortComponentName(String portComponentName) {
        this.portComponentName = portComponentName;
    }

    public String getEndpointImplementationName() {
        return this.implName;
    }

    public void setEndpointImplementationName(String endpointImpl) {
        this.implName = endpointImpl;
    }

    public String getEndpointID() {
        return this.endpointID;
    }

    public void setEndpointID(String endpointID) {
        this.endpointID = endpointID;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
    }

    public String getURLPattern() {
        return this.urlPattern;
    }

    public void setURLPattern(String urlPattern) {
        this.urlPattern = urlPattern;
    }

    public boolean isAnnotated() {
        return this.annotated;
    }

    public void setAnnotated(boolean isAnnotated) {
        this.annotated = isAnnotated;
    }

    @Override
    public List<HandlerMetaData> getHandlers() {
        ArrayList<HandlerMetaData> handlers = new ArrayList<HandlerMetaData>();
        WSHandlerChainConfig preHandlerConfig = this.getEndpointConfig().getPreHandlerChain();
        if (preHandlerConfig != null) {
            handlers.addAll(preHandlerConfig.getHandlers());
        }
        handlers.addAll(super.getHandlers());
        WSHandlerChainConfig postHandlerConfig = this.getEndpointConfig().getPostHandlerChain();
        if (postHandlerConfig != null) {
            handlers.addAll(postHandlerConfig.getHandlers());
        }
        return handlers;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("\nServerEndpointMetaData:");
        buffer.append(new StringBuffer("\n name=").append(this.getName()).toString());
        buffer.append(new StringBuffer("\n id=").append(this.getEndpointID()).toString());
        buffer.append(new StringBuffer("\n address=").append(this.getEndpointAddress()).toString());
        buffer.append(new StringBuffer("\n linkName=").append(this.getLinkName()).toString());
        buffer.append(new StringBuffer("\n implName=").append(this.getEndpointImplementationName()).toString());
        buffer.append(new StringBuffer("\n seiName=").append(this.getServiceEndpointInterfaceName()).toString());
        buffer.append(new StringBuffer("\n annotated=").append(this.annotated).toString());
        buffer.append(new StringBuffer("\n portComponentName=").append(this.getPortComponentName()).toString());
        buffer.append(new StringBuffer("\n contextRoot=").append(this.getContextRoot()).toString());
        buffer.append(new StringBuffer("\n urlPattern=").append(this.getURLPattern()).toString());
        buffer.append(new StringBuffer("\n configFile=").append(this.getConfigFile()).toString());
        buffer.append(new StringBuffer("\n configName=").append(this.getConfigName()).toString());
        buffer.append(new StringBuffer("\n authMethod=").append(this.getAuthMethod()).toString());
        buffer.append(new StringBuffer("\n transportGuarantee=").append(this.getTransportGuarantee()).toString());
        buffer.append(new StringBuffer("\n properties=").append(this.getProperties()).toString());
        for (OperationMetaData opMetaData : this.getOperations()) {
            buffer.append(new StringBuffer("\n").append(opMetaData).toString());
        }
        for (HandlerMetaData hdlMetaData : this.getHandlers()) {
            buffer.append(new StringBuffer("\n").append(hdlMetaData).toString());
        }
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

