/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaWsdlMappingFactory;
import org.jboss.ws.WSException;
import org.jboss.ws.jaxrpc.Use;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.TypesMetaData;
import org.jboss.ws.metadata.UnifiedMetaData;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLDefinitionsFactory;
import org.jboss.ws.metadata.wsdl.WSDLTypes;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceMetaData {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$ws$metadata$ServiceMetaData == null ? (class$org$jboss$ws$metadata$ServiceMetaData = ServiceMetaData.class$("org.jboss.ws.metadata.ServiceMetaData")) : class$org$jboss$ws$metadata$ServiceMetaData));
    private UnifiedMetaData wsMetaData;
    private TypesMetaData types;
    private QName name;
    private String wsdName;
    private String wsdlFile;
    private String jaxrpcMappingFile;
    private String wsdlPublishLocation;
    private Properties properties;
    private WSSecurityConfiguration securityConfiguration;
    private Map<QName, EndpointMetaData> endpoints = new LinkedHashMap<QName, EndpointMetaData>();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$org$jboss$ws$metadata$ServiceMetaData;

    public ServiceMetaData(UnifiedMetaData wsMetaData, QName name) {
        this.wsMetaData = wsMetaData;
        this.name = name;
        this.types = new TypesMetaData(this);
    }

    public UnifiedMetaData getUnifiedMetaData() {
        return this.wsMetaData;
    }

    public void setName(QName name) {
        this.name = name;
    }

    public QName getName() {
        return this.name;
    }

    public String getWebserviceDescriptionName() {
        return this.wsdName;
    }

    public void setWebserviceDescriptionName(String wsdName) {
        this.wsdName = wsdName;
    }

    public String getWsdlFile() {
        return this.wsdlFile;
    }

    public void setWsdlFile(String wsdlFile) {
        this.wsdlFile = wsdlFile;
    }

    public String getWsdlPublishLocation() {
        return this.wsdlPublishLocation;
    }

    public void setWsdlPublishLocation(String wsdlPublishLocation) {
        this.wsdlPublishLocation = wsdlPublishLocation;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public TypesMetaData getTypesMetaData() {
        return this.types;
    }

    public List<EndpointMetaData> getEndpoints() {
        return new ArrayList<EndpointMetaData>(this.endpoints.values());
    }

    public EndpointMetaData getEndpoint(QName epName) {
        return this.endpoints.get(epName);
    }

    public EndpointMetaData getEndpointByServiceEndpointInterface(String seiName) {
        EndpointMetaData epMetaData = null;
        for (EndpointMetaData epmd : this.endpoints.values()) {
            if (!seiName.equals(epmd.getServiceEndpointInterfaceName())) continue;
            if (epMetaData != null) {
                log.warn((Object)new StringBuffer("Multiple possible endpoints implementing SEI: ").append(seiName).toString());
            }
            epMetaData = epmd;
        }
        return epMetaData;
    }

    public void addEndpoint(EndpointMetaData epMetaData) {
        QName epName = epMetaData.getName();
        if (this.endpoints.get(epName) != null) {
            throw new WSException(new StringBuffer("EndpointMetaData name must be unique: ").append(epName).toString());
        }
        this.endpoints.put(epName, epMetaData);
    }

    public String getJaxrpcMappingFile() {
        return this.jaxrpcMappingFile;
    }

    public void setJaxrpcMappingFile(String jaxrpcMappingFile) {
        this.jaxrpcMappingFile = jaxrpcMappingFile;
    }

    public JavaWsdlMapping getJavaWsdlMapping() {
        JavaWsdlMapping javaWsdlMapping = this.wsMetaData.getMappingDefinition(this.jaxrpcMappingFile);
        if (javaWsdlMapping == null && this.jaxrpcMappingFile != null) {
            URL mappingLocation = null;
            try {
                mappingLocation = new URL(this.jaxrpcMappingFile);
            }
            catch (MalformedURLException malformedURLException) {}
            if (mappingLocation == null) {
                mappingLocation = this.wsMetaData.getResourceLoader().getResource(this.jaxrpcMappingFile);
            }
            if (mappingLocation == null) {
                throw new IllegalArgumentException(new StringBuffer("Cannot find jaxrpc-mapping.xml in deployment: ").append(this.jaxrpcMappingFile).toString());
            }
            try {
                JavaWsdlMappingFactory mappingFactory = JavaWsdlMappingFactory.newInstance();
                javaWsdlMapping = mappingFactory.parse(mappingLocation);
                this.wsMetaData.addMappingDefinition(this.jaxrpcMappingFile, javaWsdlMapping);
            }
            catch (IOException e) {
                throw new WSException("Cannot parse jaxrpc-mapping.xml", e);
            }
        }
        return javaWsdlMapping;
    }

    public WSDLDefinitions getWsdlDefinitions() {
        WSDLDefinitions wsdlDefinitions = this.wsMetaData.getWSDLDefinition(this.wsdlFile);
        if (wsdlDefinitions == null && this.wsdlFile != null) {
            URL wsdlLocation = null;
            try {
                wsdlLocation = new URL(this.wsdlFile);
            }
            catch (MalformedURLException malformedURLException) {}
            if (wsdlLocation == null) {
                wsdlLocation = this.wsMetaData.getResourceLoader().getResource(this.wsdlFile);
            }
            if (wsdlLocation == null) {
                throw new IllegalArgumentException(new StringBuffer("Cannot find wsdl in deployment: ").append(this.wsdlFile).toString());
            }
            WSDLDefinitionsFactory factory = WSDLDefinitionsFactory.newInstance();
            wsdlDefinitions = factory.parse(wsdlLocation);
            this.wsMetaData.addWSDLDefinition(this.wsdlFile, wsdlDefinitions);
        }
        return wsdlDefinitions;
    }

    public WSSecurityConfiguration getSecurityConfiguration() {
        return this.securityConfiguration;
    }

    public void setSecurityConfiguration(WSSecurityConfiguration securityConfiguration) {
        this.securityConfiguration = securityConfiguration;
    }

    public Use getEncodingStyle() {
        Use use = null;
        if (this.endpoints.size() > 0) {
            for (EndpointMetaData epMetaData : this.endpoints.values()) {
                if (use == null) {
                    use = epMetaData.getUse();
                    continue;
                }
                if (use.equals(epMetaData.getUse())) continue;
                throw new WSException("Conflicting encoding styles not supported");
            }
        } else {
            use = Use.getDefaultUse();
        }
        return use;
    }

    public void setEncodingStyle(String encodingStyle) {
    }

    public void eagerInitialize() {
        JBossXSModel model;
        WSDLTypes types;
        WSDLDefinitions definitions = this.getWsdlDefinitions();
        if (definitions != null && (types = definitions.getWsdlTypes()) != null && (model = types.getSchemaModel()) != null) {
            model.eagerInitialize();
        }
        this.getJavaWsdlMapping();
        for (EndpointMetaData endpoint : this.endpoints.values()) {
            endpoint.eagerInitialize();
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("\nServiceMetaData:");
        buffer.append(new StringBuffer("\n name=").append(this.name).toString());
        buffer.append(new StringBuffer("\n wsdName=").append(this.wsdName).toString());
        buffer.append(new StringBuffer("\n wsdlFile=").append(this.wsdlFile).toString());
        buffer.append(new StringBuffer("\n jaxrpcFile=").append(this.jaxrpcMappingFile).toString());
        buffer.append(new StringBuffer("\n publishLocation=").append(this.wsdlPublishLocation).toString());
        buffer.append(new StringBuffer("\n properties=").append(this.properties).toString());
        buffer.append(new StringBuffer("\n").append(this.types).toString());
        for (EndpointMetaData epMetaData : this.endpoints.values()) {
            buffer.append(new StringBuffer("\n").append(epMetaData).toString());
        }
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

