/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.wsdl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.util.xml.DOMUtils;
import org.jboss.util.xml.DOMWriter;
import org.jboss.ws.WSException;
import org.jboss.ws.jaxrpc.Style;
import org.jboss.ws.metadata.wsdl.NCName;
import org.jboss.ws.metadata.wsdl.WSDLBinding;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperation;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLInterface;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceFault;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationInput;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutfault;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutput;
import org.jboss.ws.metadata.wsdl.WSDLProperty;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.metadata.wsdl.WSDLTypes;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.ws.metadata.wsdl.xsd.SchemaUtils;
import org.jboss.ws.tools.JavaToXSD;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class WSDL11Reader {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$ws$metadata$wsdl$WSDL11Reader == null ? (class$org$jboss$ws$metadata$wsdl$WSDL11Reader = WSDL11Reader.class$("org.jboss.ws.metadata.wsdl.WSDL11Reader")) : class$org$jboss$ws$metadata$wsdl$WSDL11Reader));
    private URL wsdlLocation;
    private WSDLDefinitions destWsdl;
    private Definition srcWsdl;
    private Map<String, QName> messagePartToElementMap = new HashMap<String, QName>();
    private Map<String, URL> schemaLocationsMap = new HashMap<String, URL>();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$org$jboss$ws$metadata$wsdl$WSDL11Reader;

    public WSDLDefinitions process(Definition srcWsdl, URL wsdlLoc) {
        this.wsdlLocation = wsdlLoc;
        this.destWsdl = new WSDLDefinitions();
        this.srcWsdl = srcWsdl;
        this.destWsdl.setWsdlOneOneDefinition(srcWsdl);
        this.destWsdl.setWsdlNamespace("http://schemas.xmlsoap.org/wsdl/");
        this.processNamespaces();
        this.processTypes(srcWsdl);
        this.processServices(srcWsdl);
        return this.destWsdl;
    }

    private void processNamespaces() {
        String targetNS = this.srcWsdl.getTargetNamespace();
        this.destWsdl.setTargetNamespace(targetNS);
        Map nsMap = this.srcWsdl.getNamespaces();
        Iterator iter = nsMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String prefix = (String)entry.getKey();
            String nsURI = (String)entry.getValue();
            this.destWsdl.registerNamespaceURI(nsURI, prefix);
        }
    }

    private void processTypes(Definition srcWsdl) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("BEGIN processTypes: " + srcWsdl.getDocumentBaseURI()));
        }
        WSDLTypes destTypes = this.destWsdl.getWsdlTypes();
        Types srcTypes = srcWsdl.getTypes();
        if (srcTypes != null && srcTypes.getExtensibilityElements().size() > 0) {
            List extElements = srcTypes.getExtensibilityElements();
            int len = extElements.size();
            int i = 0;
            while (i < len) {
                block17: {
                    Element domElement;
                    ExtensibilityElement extElement = (ExtensibilityElement)extElements.get(i);
                    if (extElement instanceof Schema) {
                        domElement = ((Schema)extElement).getElement();
                    } else if (extElement instanceof UnknownExtensibilityElement) {
                        domElement = ((UnknownExtensibilityElement)extElement).getElement();
                    } else {
                        throw new WSException("Unsupported extensibility element: " + extElement);
                    }
                    Element domElementClone = (Element)domElement.cloneNode(true);
                    this.copyParentNamespaceDeclarations(domElementClone, domElement);
                    String localname = domElementClone.getLocalName();
                    try {
                        if ("import".equals(localname)) {
                            this.processSchemaImport(destTypes, this.wsdlLocation, domElementClone);
                            break block17;
                        }
                        if ("schema".equals(localname)) {
                            this.processSchemaInclude(destTypes, this.wsdlLocation, domElementClone);
                            break block17;
                        }
                        throw new IllegalArgumentException("Unsuported schema element: " + localname);
                    }
                    catch (IOException e) {
                        throw new WSException("Cannot extract schema definition", e);
                    }
                }
                ++i;
            }
            if (len > 0) {
                Collection<URL> col = this.schemaLocationsMap.values();
                JavaToXSD jxsd = new JavaToXSD();
                ArrayList<String> strlist = new ArrayList<String>();
                Iterator<URL> iterator = col.iterator();
                while (iterator.hasNext()) {
                    URL uri = iterator.next();
                    strlist.add(uri.toExternalForm());
                }
                JBossXSModel xsmodel = jxsd.parseSchema(this.schemaLocationsMap);
                destTypes.addSchemaModel(this.destWsdl.getTargetNamespace(), xsmodel);
            }
        } else {
            log.debug((Object)"Empty wsdl types element, processing imports");
            Iterator it = srcWsdl.getImports().values().iterator();
            while (it.hasNext()) {
                List srcImports = (List)it.next();
                Iterator iterator = srcImports.iterator();
                while (iterator.hasNext()) {
                    Import srcImport = (Import)iterator.next();
                    Definition importDefinition = srcImport.getDefinition();
                    this.processTypes(importDefinition);
                }
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("END processTypes: " + srcWsdl.getDocumentBaseURI() + "\n" + destTypes));
        }
    }

    private void copyParentNamespaceDeclarations(Element destElement, Element srcElement) {
        Node parent = srcElement.getParentNode();
        while (parent != null) {
            if (parent.hasAttributes()) {
                NamedNodeMap attributes = parent.getAttributes();
                int i = 0;
                while (i < attributes.getLength()) {
                    Attr attr = (Attr)attributes.item(i);
                    String name = attr.getName();
                    String value = attr.getValue();
                    if (name.startsWith("xmlns:") && !destElement.hasAttribute(name)) {
                        destElement.setAttribute(name, value);
                    }
                    ++i;
                }
            }
            parent = parent.getParentNode();
        }
    }

    private void processSchemaImport(WSDLTypes types, URL parentURL, Element importEl) throws IOException {
        Element rootElement;
        if (parentURL == null) {
            throw new IllegalArgumentException("Cannot process import, parent location not set");
        }
        String location = importEl.getAttribute("schemaLocation");
        if (location == null || location.length() == 0) {
            throw new IllegalArgumentException("schemaLocation is null for xsd:import");
        }
        URL locationURL = this.getLocationURL(parentURL, location);
        URL newloc = this.processSchemaInclude(types, locationURL, rootElement = DOMUtils.parse((InputStream)locationURL.openStream()));
        if (newloc != null) {
            importEl.setAttribute("schemaLocation", newloc.toExternalForm());
        }
    }

    private URL processSchemaInclude(WSDLTypes types, URL parentURL, Element schemaEl) throws IOException {
        File tmpFile = null;
        if (parentURL == null) {
            throw new IllegalArgumentException("Cannot process include, parent location not set");
        }
        String schemaPrefix = schemaEl.getPrefix();
        String importTag = schemaPrefix == null ? "import" : String.valueOf(schemaPrefix) + ":import";
        Element importElement = schemaEl.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", importTag);
        importElement.setAttribute("namespace", "http://schemas.xmlsoap.org/soap/encoding/");
        schemaEl.insertBefore(importElement, DOMUtils.getFirstChildElement((Node)schemaEl));
        Iterator it = DOMUtils.getChildElements((Node)schemaEl, (QName)new QName("http://www.w3.org/2001/XMLSchema", "include"));
        while (it.hasNext()) {
            Element rootElement;
            Element includeEl = (Element)it.next();
            String location = includeEl.getAttribute("schemaLocation");
            if (location == null || location.length() == 0) {
                throw new IllegalArgumentException("schemaLocation is null for xsd:include");
            }
            URL locationURL = this.getLocationURL(parentURL, location);
            URL newloc = this.processSchemaInclude(types, locationURL, rootElement = DOMUtils.parse((InputStream)locationURL.openStream()));
            if (newloc == null) continue;
            includeEl.setAttribute("schemaLocation", newloc.toExternalForm());
        }
        String targetNS = schemaEl.getAttribute("targetNamespace");
        if (targetNS.length() > 0) {
            log.debug((Object)("processSchemaInclude: [targetNS=" + targetNS + ",parentURL=" + parentURL + "]"));
            tmpFile = SchemaUtils.getSchemaTempFile(targetNS);
            tmpFile.deleteOnExit();
            FileWriter fwrite = new FileWriter(tmpFile);
            new DOMWriter((Writer)fwrite).setPrettyprint(true).print((Node)schemaEl);
            fwrite.close();
            this.schemaLocationsMap.put(targetNS, tmpFile.toURL());
        }
        if (targetNS.length() == 0) {
            log.debug((Object)("Schema element without target namespace in: " + parentURL));
        }
        this.handleSchemaImports(schemaEl);
        return tmpFile != null ? tmpFile.toURL() : null;
    }

    private URL getLocationURL(URL parentURL, String location) throws MalformedURLException {
        log.debug((Object)("getLocationURL: [location=" + location + ",parent=" + parentURL + "]"));
        URL locationURL = null;
        try {
            locationURL = new URL(location);
        }
        catch (MalformedURLException malformedURLException) {}
        if (locationURL == null) {
            String parentProtocol = parentURL.getProtocol();
            if (parentProtocol.equals("file") && !location.startsWith("/")) {
                String path = parentURL.toExternalForm();
                path = path.substring(0, path.lastIndexOf("/"));
                locationURL = new URL(String.valueOf(path) + "/" + location);
            } else if (parentProtocol.startsWith("http") && location.startsWith("/")) {
                String path = String.valueOf(parentProtocol) + "://" + parentURL.getHost() + ":" + parentURL.getPort();
                locationURL = new URL(String.valueOf(path) + location);
            } else if (parentProtocol.equals("jar") && !location.startsWith("/")) {
                String path = parentURL.toExternalForm();
                path = path.substring(0, path.lastIndexOf("/"));
                locationURL = new URL(String.valueOf(path) + "/" + location);
            } else {
                throw new WSException("Unsupported schemaLocation: " + location);
            }
        }
        log.debug((Object)("Modified schemaLocation: " + locationURL));
        return locationURL;
    }

    private void processPortType(PortType srcPortType) {
        QName qname = srcPortType.getQName();
        NCName ncName = new NCName(qname);
        if (this.destWsdl.getInterface(ncName) == null) {
            WSDLInterface destInterface = new WSDLInterface(this.destWsdl);
            destInterface.setName(ncName);
            destInterface.setQName(qname);
            this.destWsdl.addInterface(destInterface);
            this.processPortTypeOperations(destInterface, srcPortType);
        }
    }

    private void processPortTypeOperations(WSDLInterface destInterface, PortType srcPortType) {
        Iterator itOperations = srcPortType.getOperations().iterator();
        while (itOperations.hasNext()) {
            Output srcOutput;
            String value;
            QName xmlType;
            WSDLProperty wsdlProperty;
            QName elementName;
            Part srcPart;
            Iterator itMessageParts;
            Operation srcOperation = (Operation)itOperations.next();
            WSDLInterfaceOperation destOperation = new WSDLInterfaceOperation(destInterface);
            destOperation.setName(new NCName(srcOperation.getName()));
            destInterface.addOperation(destOperation);
            Input srcInput = srcOperation.getInput();
            if (srcInput != null) {
                Message srcMessage = srcInput.getMessage();
                List paramOrder = srcOperation.getParameterOrdering();
                itMessageParts = srcMessage.getOrderedParts(paramOrder).iterator();
                while (itMessageParts.hasNext()) {
                    srcPart = (Part)itMessageParts.next();
                    WSDLInterfaceOperationInput destInput = new WSDLInterfaceOperationInput(destOperation);
                    elementName = this.translateMessagePartToElementName(srcPortType, srcOperation, srcMessage, srcPart);
                    destInput.setElement(elementName);
                    destOperation.addInput(destInput);
                    destInput.addProperty(new WSDLProperty("http://www.jboss.org/jbossws/messagename", srcMessage.getQName().getLocalPart()));
                    wsdlProperty = new WSDLProperty("http://www.jboss.org/jbossws/partname", srcPart.getName());
                    destInput.addProperty(wsdlProperty);
                    xmlType = srcPart.getTypeName();
                    if (xmlType == null) continue;
                    xmlType = this.destWsdl.registerQName(xmlType);
                    value = String.valueOf(xmlType.getPrefix()) + ":" + xmlType.getLocalPart();
                    wsdlProperty = new WSDLProperty("http://www.jboss.org/jbossws/rpc/xmltype", value);
                    destInput.addProperty(wsdlProperty);
                }
            }
            if ((srcOutput = srcOperation.getOutput()) != null) {
                destOperation.setPattern("http://www.w3.org/2004/08/wsdl/in-out");
                Message srcMessage = srcOutput.getMessage();
                itMessageParts = srcMessage.getOrderedParts(null).iterator();
                while (itMessageParts.hasNext()) {
                    srcPart = (Part)itMessageParts.next();
                    WSDLInterfaceOperationOutput destOutput = new WSDLInterfaceOperationOutput(destOperation);
                    elementName = this.translateMessagePartToElementName(srcPortType, srcOperation, srcMessage, srcPart);
                    destOutput.setElement(elementName);
                    destOperation.addOutput(destOutput);
                    destOutput.addProperty(new WSDLProperty("http://www.jboss.org/jbossws/messagename", srcMessage.getQName().getLocalPart()));
                    wsdlProperty = new WSDLProperty("http://www.jboss.org/jbossws/partname", srcPart.getName());
                    destOutput.addProperty(wsdlProperty);
                    xmlType = srcPart.getTypeName();
                    if (xmlType == null) continue;
                    xmlType = this.destWsdl.registerQName(xmlType);
                    value = String.valueOf(xmlType.getPrefix()) + ":" + xmlType.getLocalPart();
                    wsdlProperty = new WSDLProperty("http://www.jboss.org/jbossws/rpc/xmltype", value);
                    destOutput.addProperty(wsdlProperty);
                }
            } else {
                destOperation.setPattern("http://www.w3.org/2004/08/wsdl/in-only");
            }
            Map faults = srcOperation.getFaults();
            Iterator itFaults = faults.entrySet().iterator();
            while (itFaults.hasNext()) {
                Map.Entry entry = itFaults.next();
                String faultName = (String)entry.getKey();
                Fault srcFault = (Fault)entry.getValue();
                WSDLInterfaceFault destFault = new WSDLInterfaceFault(destInterface);
                NCName ncName = new NCName(faultName);
                destFault.setName(ncName);
                Message message = srcFault.getMessage();
                QName messageName = message.getQName();
                Map partsMap = message.getParts();
                if (partsMap.size() != 1) {
                    throw new WSException("Unsupported number of fault parts in message " + messageName);
                }
                Part part = (Part)partsMap.values().iterator().next();
                QName xmlName = part.getElementName();
                QName xmlType2 = part.getTypeName();
                destFault.setXmlType(xmlType2);
                if (xmlName != null) {
                    destFault.setXmlName(xmlName);
                } else {
                    destFault.setXmlName(messageName);
                    log.warn((Object)("Unsupported fault message part in message: " + messageName));
                }
                WSDLInterfaceFault prevFault = destInterface.getFault(ncName);
                if (prevFault != null && !prevFault.getName().equals(ncName)) {
                    throw new WSException("Fault name must be unique: " + faultName);
                }
                destInterface.addFault(destFault);
                WSDLInterfaceOperationOutfault opOutFault = new WSDLInterfaceOperationOutfault(destOperation);
                opOutFault.setRef(new QName(this.destWsdl.getTargetNamespace(), faultName));
                destOperation.addOutfault(opOutFault);
            }
        }
    }

    private QName translateMessagePartToElementName(PortType srcPortType, Operation srcOperation, Message srcMessage, Part srcPart) {
        QName xmlName = srcPart.getElementName();
        if (xmlName != null) {
            xmlName = this.destWsdl.registerQName(xmlName);
        }
        if (xmlName == null) {
            BindingOutput srcBindingOutput;
            xmlName = new QName(srcPart.getName());
            Binding srcBinding = null;
            Iterator itBindings = this.getServiceReachableBindings().values().iterator();
            while (srcBinding == null && itBindings.hasNext()) {
                Binding binding = (Binding)itBindings.next();
                if (!binding.getPortType().equals(srcPortType)) continue;
                srcBinding = binding;
            }
            if (srcBinding == null) {
                throw new WSException("Cannot find binding for: " + srcPortType.getQName());
            }
            String srcOperationName = srcOperation.getName();
            BindingOperation srcBindingOperation = srcBinding.getBindingOperation(srcOperationName, null, null);
            if (srcBindingOperation == null) {
                throw new WSException("Cannot find binding operation for: " + srcOperationName);
            }
            BindingInput srcBindingInput = srcBindingOperation.getBindingInput();
            if (srcBindingInput != null) {
                Iterator itExt = srcBindingInput.getExtensibilityElements().iterator();
                while (itExt.hasNext()) {
                    String namespaceURI;
                    ExtensibilityElement extEl = (ExtensibilityElement)itExt.next();
                    if (!(extEl instanceof SOAPHeader)) continue;
                    SOAPHeader header = (SOAPHeader)extEl;
                    QName messageQName = header.getMessage();
                    String partName = header.getPart();
                    if (!messageQName.equals(srcMessage.getQName()) || !partName.equals(srcPart.getName()) || (namespaceURI = header.getNamespaceURI()) == null) continue;
                    xmlName = new QName(namespaceURI, partName);
                    xmlName = this.destWsdl.registerQName(xmlName);
                }
            }
            if ((srcBindingOutput = srcBindingOperation.getBindingOutput()) != null) {
                Iterator itExt = srcBindingOutput.getExtensibilityElements().iterator();
                while (itExt.hasNext()) {
                    String namespaceURI;
                    ExtensibilityElement extEl = (ExtensibilityElement)itExt.next();
                    if (!(extEl instanceof SOAPHeader)) continue;
                    SOAPHeader header = (SOAPHeader)extEl;
                    QName messageQName = header.getMessage();
                    String partName = header.getPart();
                    if (!messageQName.equals(srcMessage.getQName()) || !partName.equals(srcPart.getName()) || (namespaceURI = header.getNamespaceURI()) == null) continue;
                    xmlName = new QName(namespaceURI, partName);
                    xmlName = this.destWsdl.registerQName(xmlName);
                }
            }
        }
        String key = srcMessage.getQName() + "->" + srcPart.getName();
        this.messagePartToElementMap.put(key, xmlName);
        return xmlName;
    }

    private void processBinding(Binding srcBinding) {
        NCName ncName = new NCName(srcBinding.getQName());
        if (this.destWsdl.getBinding(ncName) == null) {
            PortType srcPortType = srcBinding.getPortType();
            this.processPortType(srcPortType);
            WSDLBinding destBinding = new WSDLBinding(this.destWsdl);
            destBinding.setName(ncName);
            destBinding.setInterfaceName(srcPortType.getQName());
            String bindingStyle = Style.getDefaultStyle().toString();
            List extList = srcBinding.getExtensibilityElements();
            int i = 0;
            while (i < extList.size()) {
                Object extElement = extList.get(i);
                if (extElement instanceof SOAPBinding) {
                    SOAPBinding soapBinding = (SOAPBinding)extElement;
                    bindingStyle = soapBinding.getStyle();
                }
                ++i;
            }
            this.destWsdl.addBinding(destBinding);
            this.processBindingOperations(destBinding, srcBinding, bindingStyle);
        }
    }

    private Map getServiceReachableBindings() {
        LinkedHashMap<QName, Binding> retMap = new LinkedHashMap<QName, Binding>();
        Iterator itService = this.srcWsdl.getServices().values().iterator();
        while (itService.hasNext()) {
            Service srcService = (Service)itService.next();
            Iterator itPort = srcService.getPorts().values().iterator();
            while (itPort.hasNext()) {
                Port srcPort = (Port)itPort.next();
                Binding srcBinding = srcPort.getBinding();
                retMap.put(srcBinding.getQName(), srcBinding);
            }
        }
        return retMap;
    }

    private void processBindingOperations(WSDLBinding destBinding, Binding srcBinding, String bindingStyle) {
        WSDLInterface destInterface = destBinding.getInterface();
        String namespaceURI = destInterface.getQName().getNamespaceURI();
        Iterator it = srcBinding.getBindingOperations().iterator();
        while (it.hasNext()) {
            BindingOutput srcBindingOutput;
            BindingOperation srcBindingOperation = (BindingOperation)it.next();
            WSDLBindingOperation destBindingOperation = new WSDLBindingOperation(destBinding);
            QName refQName = new QName(namespaceURI, srcBindingOperation.getName());
            destBindingOperation.setRef(refQName);
            destBinding.addOperation(destBindingOperation);
            String opName = srcBindingOperation.getName();
            WSDLInterfaceOperation destIntfOperation = destInterface.getOperation(new NCName(opName));
            String operationStyle = null;
            Iterator itExt = srcBindingOperation.getExtensibilityElements().iterator();
            while (itExt.hasNext()) {
                ExtensibilityElement extEl = (ExtensibilityElement)itExt.next();
                if (!(extEl instanceof SOAPOperation)) continue;
                SOAPOperation soapOp = (SOAPOperation)extEl;
                destBindingOperation.setSOAPAction(soapOp.getSoapActionURI());
                operationStyle = soapOp.getStyle();
            }
            destIntfOperation.setStyle(operationStyle != null ? operationStyle : bindingStyle);
            BindingInput srcBindingInput = srcBindingOperation.getBindingInput();
            if (srcBindingInput != null) {
                itExt = srcBindingInput.getExtensibilityElements().iterator();
                while (itExt.hasNext()) {
                    ExtensibilityElement extEl = (ExtensibilityElement)itExt.next();
                    if (extEl instanceof SOAPBody) {
                        SOAPBody body = (SOAPBody)extEl;
                        this.processEncodingStyle(body, destBindingOperation);
                        continue;
                    }
                    if (extEl instanceof SOAPHeader) {
                        SOAPHeader header = (SOAPHeader)extEl;
                        QName messageQName = header.getMessage();
                        String partName = header.getPart();
                        String key = messageQName + "->" + partName;
                        QName elementName = this.messagePartToElementMap.get(key);
                        if (elementName == null) continue;
                        WSDLInterfaceOperationInput destIntfInput = destIntfOperation.getInput(elementName);
                        if (destIntfInput == null) {
                            throw new WSException("Cannot find interface input for element: " + elementName);
                        }
                        WSDLProperty wsdlProperty = new WSDLProperty("http://www.w3.org/2004/08/wsdl/feature/AD/data", false, null, null);
                        destIntfInput.addProperty(wsdlProperty);
                        continue;
                    }
                    if (!(extEl instanceof MIMEMultipartRelated)) continue;
                    MIMEMultipartRelated related = (MIMEMultipartRelated)extEl;
                    Iterator i = related.getMIMEParts().iterator();
                    while (i.hasNext()) {
                        MIMEPart part = (MIMEPart)i.next();
                        Iterator j = part.getExtensibilityElements().iterator();
                        String name = null;
                        String types = null;
                        while (j.hasNext()) {
                            ExtensibilityElement inner = (ExtensibilityElement)j.next();
                            if (!(inner instanceof MIMEContent)) continue;
                            MIMEContent content = (MIMEContent)inner;
                            name = content.getPart();
                            types = types == null ? content.getType() : String.valueOf(types) + "," + content.getType();
                        }
                        if (name == null) continue;
                        QName elementName = new QName(name);
                        WSDLInterfaceOperationInput destIntfInput = destIntfOperation.getInput(elementName);
                        if (destIntfInput == null) {
                            throw new WSException("Cannot find interface input for element: " + elementName);
                        }
                        WSDLProperty wsdlProperty = new WSDLProperty("http://www.jboss.org/jbossws/attachment/mimetype", false, types, null);
                        destIntfInput.addProperty(wsdlProperty);
                    }
                }
            }
            if ((srcBindingOutput = srcBindingOperation.getBindingOutput()) == null) continue;
            itExt = srcBindingOutput.getExtensibilityElements().iterator();
            while (itExt.hasNext()) {
                ExtensibilityElement extEl = (ExtensibilityElement)itExt.next();
                if (extEl instanceof SOAPBody) {
                    SOAPBody body = (SOAPBody)extEl;
                    this.processEncodingStyle(body, destBindingOperation);
                    continue;
                }
                if (extEl instanceof SOAPHeader) {
                    SOAPHeader header = (SOAPHeader)extEl;
                    QName messageQName = header.getMessage();
                    String partName = header.getPart();
                    String key = messageQName + "->" + partName;
                    QName elementName = this.messagePartToElementMap.get(key);
                    if (elementName == null) continue;
                    WSDLInterfaceOperationOutput destIntfOutput = destIntfOperation.getOutput(elementName);
                    if (destIntfOutput == null) {
                        throw new WSException("Cannot find interface output for element: " + elementName);
                    }
                    WSDLProperty wsdlProperty = new WSDLProperty("http://www.w3.org/2004/08/wsdl/feature/AD/data", false, null, null);
                    destIntfOutput.addProperty(wsdlProperty);
                    continue;
                }
                if (!(extEl instanceof MIMEMultipartRelated)) continue;
                MIMEMultipartRelated related = (MIMEMultipartRelated)extEl;
                Iterator i = related.getMIMEParts().iterator();
                while (i.hasNext()) {
                    MIMEPart part = (MIMEPart)i.next();
                    Iterator j = part.getExtensibilityElements().iterator();
                    String name = null;
                    String types = null;
                    while (j.hasNext()) {
                        ExtensibilityElement inner = (ExtensibilityElement)j.next();
                        if (!(inner instanceof MIMEContent)) continue;
                        MIMEContent content = (MIMEContent)inner;
                        name = content.getPart();
                        types = types == null ? content.getType() : String.valueOf(types) + "," + content.getType();
                    }
                    if (name == null) continue;
                    QName elementName = new QName(name);
                    WSDLInterfaceOperationOutput destIntfOutput = destIntfOperation.getOutput(elementName);
                    if (destIntfOutput == null) {
                        throw new WSException("Cannot find interface output for element: " + elementName);
                    }
                    WSDLProperty wsdlProperty = new WSDLProperty("http://www.jboss.org/jbossws/attachment/mimetype", false, types, null);
                    destIntfOutput.addProperty(wsdlProperty);
                }
            }
        }
    }

    private void processEncodingStyle(SOAPBody body, WSDLBindingOperation destBindingOperation) {
        List encStyleList = body.getEncodingStyles();
        if (encStyleList != null) {
            if (encStyleList.size() > 1) {
                log.warn((Object)("Multiple encoding styles not supported: " + encStyleList));
            }
            if (encStyleList.size() > 0) {
                String setStyle;
                String encStyle = (String)encStyleList.get(0);
                if (!encStyle.equals(setStyle = destBindingOperation.getEncodingStyle())) {
                    log.warn((Object)("Encoding style '" + encStyle + "' not supported for: " + destBindingOperation.getRef()));
                }
                destBindingOperation.setEncodingStyle(encStyle);
            }
        }
    }

    private void processServices(Definition srcWsdl) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("BEGIN processServices: " + srcWsdl.getDocumentBaseURI()));
        }
        if (srcWsdl.getServices().size() > 0) {
            Iterator it = srcWsdl.getServices().values().iterator();
            while (it.hasNext()) {
                Service srcService = (Service)it.next();
                QName qname = srcService.getQName();
                WSDLService destService = new WSDLService(this.destWsdl);
                destService.setName(new NCName(qname));
                destService.setQName(qname);
                this.destWsdl.addService(destService);
                this.processPorts(destService, srcService);
            }
        } else {
            log.debug((Object)"Empty wsdl services, processing imports");
            Iterator it = srcWsdl.getImports().values().iterator();
            while (it.hasNext()) {
                List srcImports = (List)it.next();
                Iterator iterator = srcImports.iterator();
                while (iterator.hasNext()) {
                    Import srcImport = (Import)iterator.next();
                    Definition importDefinition = srcImport.getDefinition();
                    this.processServices(importDefinition);
                }
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("END processServices: " + srcWsdl.getDocumentBaseURI()));
        }
    }

    private void processPorts(WSDLService destService, Service srcService) {
        Iterator it = srcService.getPorts().values().iterator();
        while (it.hasNext()) {
            Port srcPort = (Port)it.next();
            this.processPort(destService, srcPort);
        }
    }

    private void processPort(WSDLService destService, Port srcPort) {
        Binding srcBinding = srcPort.getBinding();
        WSDLEndpoint destEndpoint = new WSDLEndpoint(destService);
        destEndpoint.setName(new NCName(srcPort.getName()));
        destEndpoint.setBinding(srcBinding.getQName());
        destEndpoint.setAddress(this.getEndPointAddress(srcPort));
        destService.addEndpoint(destEndpoint);
        this.processBinding(srcBinding);
    }

    private String getEndPointAddress(Port srcPort) {
        String retstr = null;
        Iterator it = srcPort.getExtensibilityElements().iterator();
        while (it.hasNext()) {
            ExtensibilityElement extElement = (ExtensibilityElement)it.next();
            if (!(extElement instanceof SOAPAddress)) continue;
            SOAPAddress addr = (SOAPAddress)extElement;
            retstr = addr.getLocationURI();
        }
        return retstr;
    }

    private void handleSchemaImports(Element schemaEl) throws MalformedURLException {
        Iterator it = DOMUtils.getChildElements((Node)schemaEl, (QName)new QName("http://www.w3.org/2001/XMLSchema", "import"));
        while (it.hasNext()) {
            Element includeEl = (Element)it.next();
            String location = includeEl.getAttribute("schemaLocation");
            if (location == null || location.length() == 0) continue;
            if (this.wsdlLocation == null) {
                throw new WSException("wsdlLocation is null");
            }
            URL currLoc = this.getLocationURL(this.wsdlLocation, location);
            String namespace = includeEl.getAttribute("namespace");
            this.schemaLocationsMap.put(namespace, currLoc);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

