/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.wsdl;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import org.jboss.util.xml.DOMUtils;
import org.jboss.util.xml.DOMWriter;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.wsdl.NCName;
import org.jboss.ws.metadata.wsdl.WSDLBinding;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperation;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperationInput;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperationOutput;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLInterface;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationInput;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutfault;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutput;
import org.jboss.ws.metadata.wsdl.WSDLProperty;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.metadata.wsdl.WSDLWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSDL11Writer
extends WSDLWriter {
    private String wsdlStyle = "RPC/Literal";
    private HashSet<String> writtenFaultMessages = new HashSet();

    public WSDL11Writer(WSDLDefinitions wsdl) {
        super(wsdl);
    }

    public void write(Writer writer) throws IOException {
        this.write(writer, null);
    }

    public void write(Writer writer, String charset) throws IOException {
        if (this.wsdl.getWsdlOneOneDefinition() != null) {
            Definition wsdlDefinition = this.wsdl.getWsdlOneOneDefinition();
            try {
                WSDLFactory wsdlFactory = WSDLFactory.newInstance();
                javax.wsdl.xml.WSDLWriter wsdlWriter = wsdlFactory.newWSDLWriter();
                wsdlWriter.writeWSDL(wsdlDefinition, writer);
            }
            catch (WSDLException e) {
                this.logException((Exception)((Object)e));
                throw new IOException(e.toString());
            }
        } else {
            StringBuffer buffer = new StringBuffer();
            this.wsdlStyle = this.utils.getWSDLStyle(this.wsdl);
            this.writtenFaultMessages.clear();
            this.appendDefinitions(buffer);
            this.appendTypes(buffer);
            this.appendMessages(buffer);
            this.appendPortTypes(buffer);
            this.appendBindings(buffer);
            this.appendServices(buffer);
            buffer.append("</definitions>");
            Element element = DOMUtils.parse((String)buffer.toString());
            if (charset != null) {
                writer.write("<?xml version=\"1.0\" encoding=\"" + charset + "\"?>\n");
            }
            new DOMWriter(writer).setPrettyprint(true).print((Node)element);
        }
    }

    protected void appendMessages(StringBuffer buffer) {
        WSDLInterface[] interfaces = this.wsdl.getInterfaces();
        int len = interfaces != null ? interfaces.length : 0;
        int i = 0;
        while (i < len) {
            WSDLInterface intf = interfaces[i];
            WSDLInterfaceOperation[] operations = intf.getSortedOperations();
            int lenOps = operations.length;
            int j = 0;
            while (j < lenOps) {
                this.appendMessage(buffer, operations[j]);
                this.appendMessagesForExceptions(buffer, operations[j]);
                ++j;
            }
            ++i;
        }
    }

    private void appendMessage(StringBuffer buffer, WSDLInterfaceOperation operation) {
        int lenout;
        String opname = operation.getName().toString();
        if (!"http://www.w3.org/2004/03/wsdl/style/rpc".equals(operation.getStyle())) {
            this.wsdlStyle = "Document/Literal";
        }
        String interfaceName = operation.getWsdlInterface().getName().toString();
        buffer.append("<message name='" + interfaceName + "_" + opname + "' >");
        WSDLInterfaceOperationInput[] inputs = operation.getInputs();
        int lenin = inputs.length;
        int i = 0;
        while (i < lenin) {
            WSDLInterfaceOperationInput input = inputs[i];
            this.appendInputParts(buffer, input, i);
            ++i;
        }
        buffer.append("</message>");
        WSDLInterfaceOperationOutput[] outputs = operation.getOutputs();
        int n = lenout = outputs != null ? outputs.length : 0;
        if ("http://www.w3.org/2004/08/wsdl/in-only".equals(operation.getPattern())) {
            return;
        }
        buffer.append("<message name='" + interfaceName + "_" + opname + "Response' >");
        if (lenout > 0) {
            String str = "";
            int i2 = 0;
            while (i2 < lenout) {
                WSDLInterfaceOperationOutput out = outputs[i2];
                str = String.valueOf(str) + this.appendOutputParts(out, i2);
                ++i2;
            }
            buffer.append(str);
        }
        buffer.append("</message>");
    }

    private void appendMessagesForExceptions(StringBuffer buffer, WSDLInterfaceOperation operation) {
        WSDLInterfaceOperationOutfault[] faults = operation.getOutfaults();
        int len = faults != null ? faults.length : 0;
        int i = 0;
        while (i < len) {
            WSDLInterfaceOperationOutfault fault = faults[i];
            QName xmlName = fault.getRef();
            String exceptionName = xmlName.getLocalPart();
            if (!this.writtenFaultMessages.contains(exceptionName)) {
                buffer.append("<message name='" + exceptionName + "' >");
                String prefix = this.wsdl.getPrefix(xmlName.getNamespaceURI());
                String xmlNameStr = String.valueOf(prefix) + ":" + xmlName.getLocalPart();
                buffer.append("<part name='" + exceptionName + "' element='" + xmlNameStr + "' />");
                buffer.append("</message>");
                this.writtenFaultMessages.add(exceptionName);
            }
            ++i;
        }
    }

    private void appendInputParts(StringBuffer buffer, WSDLInterfaceOperationInput input, int index) {
        if (this.wsdlStyle.equals("RPC/Literal")) {
            QName el = input.getElement();
            QName xmlType = input.getXMLType();
            String prefix = this.wsdl.getPrefix(xmlType.getNamespaceURI());
            buffer.append("<part name='" + el.getLocalPart() + "'");
            buffer.append(" type='" + prefix + ":" + xmlType.getLocalPart() + "'>");
            buffer.append("</part>");
        } else {
            buffer.append("<part name='parameters'");
            QName elm = input.getElement();
            String part = String.valueOf(this.wsdl.getPrefix(elm.getNamespaceURI())) + ":" + elm.getLocalPart();
            buffer.append(" element='" + part + "'>");
            buffer.append("</part>");
        }
    }

    private String appendOutputParts(WSDLInterfaceOperationOutput out, int index) {
        StringBuffer buf = new StringBuffer("");
        if (this.wsdlStyle.equals("RPC/Literal")) {
            QName xmlName = out.getElement();
            QName xmlType = out.getXMLType();
            String prefix = this.wsdl.getPrefix(xmlType.getNamespaceURI());
            buf.append("<part name='" + xmlName.getLocalPart() + "'");
            buf.append(" type='" + prefix + ":" + xmlType.getLocalPart() + "'>");
            buf.append("</part>");
        } else {
            buf.append("<part name='result'");
            QName elm = out.getElement();
            String value = String.valueOf(this.wsdl.getPrefix(elm.getNamespaceURI())) + ":" + elm.getLocalPart();
            buf.append(" element='" + value + "'>");
            buf.append("</part>");
        }
        return buf.toString();
    }

    protected void appendInterfaces(StringBuffer buffer) {
    }

    protected void appendPortTypes(StringBuffer buffer) {
        WSDLInterface[] intfs = this.wsdl.getInterfaces();
        int i = 0;
        while (i < intfs.length) {
            WSDLInterface intf = intfs[i];
            if (i == 0) {
                buffer.append("<portType name='" + intf.getName() + "'>");
            }
            this.appendPortOperations(buffer, intf);
            ++i;
        }
        buffer.append("</portType>");
    }

    protected void appendPortOperations(StringBuffer buffer, WSDLInterface intf) {
        String targetPrefix = this.wsdl.getTargetPrefix();
        WSDLInterfaceOperation[] operations = intf.getSortedOperations();
        int i = 0;
        while (i < operations.length) {
            WSDLInterfaceOperationOutfault[] faults;
            WSDLInterfaceOperation operation = operations[i];
            WSDLInterfaceOperationInput[] inputs = operation.getInputs();
            int inplen = inputs.length;
            buffer.append("<operation name='" + operation.getName().toString() + "'");
            if (this.wsdlStyle.equals("RPC/Literal")) {
                if (inplen > 0) {
                    buffer.append(" parameterOrder='");
                }
                int j = 0;
                while (j < inplen) {
                    if (j > 0) {
                        buffer.append(" ");
                    }
                    WSDLInterfaceOperationInput input = inputs[j];
                    QName el = input.getElement();
                    buffer.append(el.getLocalPart());
                    ++j;
                }
                if (inplen > 0) {
                    buffer.append("'");
                }
            }
            buffer.append(">");
            String opname = operation.getName().toString();
            String interfaceName = operation.getWsdlInterface().getName().toString();
            String msgEl = String.valueOf(targetPrefix) + ":" + interfaceName + "_" + opname;
            buffer.append("<input message='" + msgEl + "'>").append("</input>");
            if (!"http://www.w3.org/2004/08/wsdl/in-only".equals(operation.getPattern())) {
                buffer.append("<output message='" + msgEl + "Response'>");
                buffer.append("</output>");
            }
            int lenf = (faults = operation.getOutfaults()) != null ? faults.length : 0;
            int k = 0;
            while (k < lenf) {
                WSDLInterfaceOperationOutfault flt = faults[k];
                QName elt = flt.getRef();
                String targetNS = this.wsdl.getTargetNamespace();
                elt = new QName(targetNS, elt.getLocalPart(), this.wsdl.getPrefix(targetNS));
                String cleanname = this.utils.chop(this.utils.chop(elt.getLocalPart(), "Error"), "Fault");
                String n = "name='" + cleanname + "'";
                String cleanref = this.utils.chop(this.utils.getFormattedString(elt), "Error");
                buffer.append("<fault  message='" + cleanref + "' " + n + ">");
                buffer.append("</fault>");
                ++k;
            }
            buffer.append("</operation>");
            ++i;
        }
    }

    protected void appendBindings(StringBuffer buffer) {
        WSDLBinding[] bindings = this.wsdl.getBindings();
        int i = 0;
        while (i < bindings.length) {
            WSDLBinding binding = bindings[i];
            buffer.append("<binding name='" + binding.getName() + "' type='" + this.getQNameRef(binding.getInterfaceName()) + "'>");
            if (this.wsdlStyle == null) {
                throw new IllegalArgumentException("WSDL Style is null (should be rpc or document");
            }
            String style = "rpc";
            if (this.wsdlStyle.equals("Document/Literal")) {
                style = "document";
            }
            buffer.append("<soap:binding transport='http://schemas.xmlsoap.org/soap/http' style='" + style + "'/>");
            this.appendBindingOperations(buffer, binding);
            buffer.append("</binding>");
            ++i;
        }
    }

    private boolean isHeaderInput(WSDLBindingOperationInput input) {
        WSDLBindingOperation operation = input.getWsdlBindingOperation();
        WSDLBinding binding = operation.getWsdlBinding();
        WSDLInterface wsdlInterface = binding.getInterface();
        if (wsdlInterface == null) {
            return false;
        }
        WSDLInterfaceOperation interfaceOperation = wsdlInterface.getOperation(new NCName(operation.getRef().getLocalPart()));
        if (interfaceOperation == null) {
            return false;
        }
        WSDLInterfaceOperationInput interfaceInput = interfaceOperation.getInputByPartName(input.getMessageLabel().toString());
        if (interfaceInput == null) {
            return false;
        }
        return interfaceInput.getProperty("http://www.w3.org/2004/08/wsdl/feature/AD/data") != null;
    }

    private boolean isHeaderOutput(WSDLBindingOperationOutput output) {
        WSDLBindingOperation operation = output.getWsdlBindingOperation();
        WSDLBinding binding = operation.getWsdlBinding();
        WSDLInterface wsdlInterface = binding.getInterface();
        if (wsdlInterface == null) {
            return false;
        }
        WSDLInterfaceOperation interfaceOperation = wsdlInterface.getOperation(new NCName(operation.getRef().getLocalPart()));
        if (interfaceOperation == null) {
            return false;
        }
        WSDLInterfaceOperationOutput interfaceOutput = interfaceOperation.getOutputByPartName(output.getMessageLabel().toString());
        if (interfaceOutput == null) {
            return false;
        }
        return interfaceOutput.getProperty("http://www.w3.org/2004/08/wsdl/feature/AD/data") != null;
    }

    protected void appendBindingOperations(StringBuffer buffer, WSDLBinding binding) {
        Object[] operations = binding.getOperations();
        Arrays.sort(operations);
        String tns = this.wsdl.getTargetNamespace();
        int i = 0;
        while (i < operations.length) {
            QName intfname;
            WSDLInterface intf;
            Object operation = operations[i];
            String interfaceName = ((WSDLBindingOperation)operation).getWsdlBinding().getInterfaceName().getLocalPart();
            buffer.append("<operation name='" + ((WSDLBindingOperation)operation).getRef().getLocalPart() + "'>");
            String soapAction = ((WSDLBindingOperation)operation).getSOAPAction() != null ? ((WSDLBindingOperation)operation).getSOAPAction() : "";
            buffer.append("<soap:operation soapAction=\"" + soapAction + "\"/>");
            buffer.append("<input>");
            buffer.append("<soap:body use='literal'");
            if (this.wsdlStyle != "Document/Literal") {
                buffer.append(" namespace='" + tns + "'");
            }
            buffer.append("/>");
            WSDLBindingOperationInput[] inputs = ((WSDLBindingOperation)operation).getInputs();
            int j = 0;
            while (j < inputs.length) {
                WSDLBindingOperationInput input = inputs[j];
                if (this.isHeaderInput(input)) {
                    String messageName = String.valueOf(interfaceName) + "_" + input.getWsdlBindingOperation().getRef().getLocalPart();
                    buffer.append("<soap:header message='tns:" + messageName + "' part='" + input.getMessageLabel() + "'/>");
                }
                ++j;
            }
            buffer.append("</input>");
            if (!"http://www.w3.org/2004/08/wsdl/in-only".equals(this.getBindingOperationPattern((WSDLBindingOperation)operation))) {
                buffer.append("<output>");
                buffer.append("<soap:body use='literal'");
                if (this.wsdlStyle != "Document/Literal") {
                    buffer.append(" namespace='" + tns + "'");
                }
                buffer.append("/>");
                WSDLBindingOperationOutput[] outputs = ((WSDLBindingOperation)operation).getOutputs();
                int j2 = 0;
                while (j2 < outputs.length) {
                    WSDLBindingOperationOutput output = outputs[j2];
                    if (this.isHeaderOutput(output)) {
                        String messageName = String.valueOf(interfaceName) + "_" + output.getWsdlBindingOperation().getRef().getLocalPart();
                        buffer.append("<soap:header message='tns:" + messageName + "' part='" + output.getMessageLabel() + "'/>");
                    }
                    ++j2;
                }
                buffer.append("</output>");
            }
            if ((intf = this.wsdl.getInterface(new NCName((intfname = ((WSDLBindingOperation)operation).getWsdlBinding().getInterfaceName()).getLocalPart()))) == null) {
                throw new WSException("WSDL Interface should not be null");
            }
            WSDLInterfaceOperation interfaceOperation = intf.getOperation(new NCName(((WSDLBindingOperation)operation).getRef().getLocalPart()));
            WSDLInterfaceOperationOutfault[] faults = interfaceOperation.getOutfaults();
            int lenf = faults != null ? faults.length : 0;
            int k = 0;
            while (k < lenf) {
                WSDLInterfaceOperationOutfault flt = faults[k];
                String cleanname = this.utils.chop(this.utils.chop(flt.getRef().getLocalPart(), "Error"), "Fault");
                String n = "name='" + cleanname + "'";
                buffer.append("<fault  " + n + ">");
                buffer.append("<soap:fault  " + n + " use='literal' />");
                buffer.append("</fault>");
                ++k;
            }
            buffer.append("</operation>");
            ++i;
        }
    }

    private String getBindingOperationPattern(WSDLBindingOperation operation) {
        WSDLBinding binding = operation.getWsdlBinding();
        String pattern = binding.getInterface().getOperation(new NCName(operation.getRef().getLocalPart())).getPattern();
        return pattern;
    }

    protected void appendServices(StringBuffer buffer) {
        WSDLService[] services = this.wsdl.getServices();
        int len = services.length;
        int i = 0;
        while (i < len) {
            WSDLService service = services[i];
            buffer.append("<service name='" + service.getName() + "'>");
            WSDLEndpoint[] endpoints = service.getEndpoints();
            int lenend = endpoints.length;
            int j = 0;
            while (j < lenend) {
                WSDLEndpoint endpoint = endpoints[j];
                this.appendServicePort(buffer, endpoint);
                ++j;
            }
            buffer.append("</service>");
            ++i;
        }
    }

    protected void appendServicePort(StringBuffer buffer, WSDLEndpoint endpoint) {
        String name = endpoint.getName().toString();
        QName endpointBinding = endpoint.getBinding();
        String prefix = endpointBinding.getPrefix();
        if (prefix == null || prefix == "") {
            prefix = this.wsdl.getTargetPrefix();
        }
        String ebname = String.valueOf(prefix) + ":" + endpointBinding.getLocalPart();
        buffer.append("<port name='" + name + "' binding='" + ebname + "'>");
        buffer.append("<soap:address location='" + endpoint.getAddress() + "'/>");
        buffer.append("</port>");
    }

    private String getXMLTypeFromWSDLProperty(WSDLInterfaceOperationOutput wiout) {
        String value = "";
        WSDLProperty outprop = wiout.getProperty("http://www.jboss.org/jbossws/rpc/xmltype");
        if (outprop != null) {
            value = outprop.getValue();
        }
        return value;
    }
}

