/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.wsdl;

import org.jboss.logging.Logger;
import org.jboss.ws.metadata.wsdl.WSDLBinding;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperation;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLInterface;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceFault;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationInput;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutfault;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutput;
import org.jboss.ws.metadata.wsdl.WSDLProperty;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.metadata.wsdl.WSDLWriter;

public class WSDL20Writer
extends WSDLWriter {
    protected static final Logger log = Logger.getLogger((Class)(class$org$jboss$ws$metadata$wsdl$WSDL20Writer == null ? (class$org$jboss$ws$metadata$wsdl$WSDL20Writer = WSDL20Writer.class$("org.jboss.ws.metadata.wsdl.WSDL20Writer")) : class$org$jboss$ws$metadata$wsdl$WSDL20Writer));
    protected WSDLUtils utils = WSDLUtils.getInstance();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$org$jboss$ws$metadata$wsdl$WSDL20Writer;

    public WSDL20Writer(WSDLDefinitions wsdl) {
        super(wsdl);
    }

    protected void appendInterfaces(StringBuffer buffer) {
        WSDLInterface[] interfaces = this.wsdl.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            WSDLInterface intf = interfaces[i];
            buffer.append("<interface name='" + intf.getName() + "'>");
            this.appendInterfaceFaults(buffer, intf);
            this.appendInterfaceOperations(buffer, intf);
            buffer.append("</interface>");
            ++i;
        }
    }

    private void appendInterfaceFaults(StringBuffer buffer, WSDLInterface intf) {
        WSDLInterfaceFault[] faults = intf.getFaults();
        int i = 0;
        while (i < faults.length) {
            WSDLInterfaceFault fault = faults[i];
            buffer.append("<fault name='" + fault.getName() + "'");
            buffer.append(" element='" + this.getQNameRef(fault.getXmlName()) + "'>");
            if (fault.getDocumentation() != null) {
                buffer.append(fault.getDocumentation());
            }
            buffer.append("</fault>");
            ++i;
        }
    }

    private void appendInterfaceOperations(StringBuffer buffer, WSDLInterface intf) {
        WSDLInterfaceOperation[] operations = intf.getOperations();
        int i = 0;
        while (i < operations.length) {
            WSDLInterfaceOperation operation = operations[i];
            buffer.append("<operation name='" + operation.getName() + "'>");
            WSDLInterfaceOperationInput[] inputs = operation.getInputs();
            int j = 0;
            while (j < inputs.length) {
                WSDLInterfaceOperationInput ip = inputs[j];
                buffer.append("<input element='" + this.getQNameRef(ip.getElement()) + "'");
                if (ip.getMessageLabel() != null) {
                    buffer.append(" messageLabel='" + ip.getMessageLabel() + "'");
                }
                buffer.append(">");
                this.appendProperties(buffer, ip.getProperties());
                buffer.append("</input>");
                ++j;
            }
            WSDLInterfaceOperationOutput[] outputs = operation.getOutputs();
            int j2 = 0;
            while (j2 < outputs.length) {
                WSDLInterfaceOperationOutput op = outputs[j2];
                buffer.append("<output element='" + this.getQNameRef(op.getElement()) + "'");
                if (op.getMessageLabel() != null) {
                    buffer.append(" messageLabel='" + op.getMessageLabel() + "'");
                }
                buffer.append(">");
                this.appendProperties(buffer, op.getProperties());
                buffer.append("</output>");
                ++j2;
            }
            WSDLInterfaceOperationOutfault[] outfaults = operation.getOutfaults();
            int j3 = 0;
            while (j3 < outfaults.length) {
                WSDLInterfaceOperationOutfault outfault = outfaults[j3];
                buffer.append("<outfault ref='" + this.getQNameRef(outfault.getRef()) + "'>");
                if (outfault.getMessageLabel() != null) {
                    buffer.append(" messageLabel='" + outfault.getMessageLabel() + "'");
                }
                buffer.append("</outfault>");
                ++j3;
            }
            buffer.append("</operation>");
            ++i;
        }
    }

    private void appendProperties(StringBuffer buffer, WSDLProperty[] wsdlProperties) {
        int i = 0;
        while (i < wsdlProperties.length) {
            WSDLProperty wsdlProperty = wsdlProperties[i];
            String uri = wsdlProperty.getURI();
            String value = wsdlProperty.getValue();
            buffer.append("<property uri='" + uri + "'>" + (value != null ? "<value>" + value + "</value>" : "") + "</property>");
            ++i;
        }
    }

    protected void appendBindings(StringBuffer buffer) {
        WSDLBinding[] bindings = this.wsdl.getBindings();
        int i = 0;
        while (i < bindings.length) {
            WSDLBinding binding = bindings[i];
            buffer.append("<binding name='" + binding.getName() + "'");
            if (binding.getInterfaceName() != null) {
                buffer.append(" interface='" + this.getQNameRef(binding.getInterfaceName()) + "'");
            }
            buffer.append(">");
            this.appendBindingOperations(buffer, binding);
            buffer.append("</binding>");
            ++i;
        }
    }

    protected void appendBindingOperations(StringBuffer buffer, WSDLBinding binding) {
        WSDLBindingOperation[] operations = binding.getOperations();
        int i = 0;
        while (i < operations.length) {
            WSDLBindingOperation operation = operations[i];
            buffer.append("<operation ref='" + this.getQNameRef(operation.getRef()) + "'>");
            buffer.append("</operation>");
            ++i;
        }
    }

    protected void appendServices(StringBuffer buffer) {
        WSDLService[] services = this.wsdl.getServices();
        int i = 0;
        while (i < services.length) {
            WSDLService service = services[i];
            buffer.append("<service name='" + service.getName() + "'");
            if (service.getInterfaceName() != null) {
                buffer.append(" interface='" + this.getQNameRef(service.getInterfaceName()) + "'");
            }
            buffer.append(">");
            WSDLEndpoint[] endpoints = service.getEndpoints();
            int j = 0;
            while (j < endpoints.length) {
                WSDLEndpoint endpoint = endpoints[j];
                buffer.append("<endpoint name='" + endpoint.getName() + "'");
                if (endpoint.getBinding() != null) {
                    buffer.append(" binding='" + this.getQNameRef(endpoint.getBinding()) + "'");
                }
                if (endpoint.getAddress() != null) {
                    buffer.append(" address='" + endpoint.getAddress() + "'");
                }
                buffer.append("></endpoint>");
                ++j;
            }
            buffer.append("</service>");
            ++i;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

