/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.wsdl;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.parsers.DocumentBuilder;
import org.jboss.logging.Logger;
import org.jboss.util.xml.DOMUtils;
import org.jboss.ws.metadata.wsdl.WSDL11Reader;
import org.jboss.ws.metadata.wsdl.WSDL20Reader;
import org.jboss.ws.metadata.wsdl.WSDL20Writer;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class WSDLDefinitionsFactory {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$ws$metadata$wsdl$WSDLDefinitionsFactory == null ? (class$org$jboss$ws$metadata$wsdl$WSDLDefinitionsFactory = WSDLDefinitionsFactory.class$("org.jboss.ws.metadata.wsdl.WSDLDefinitionsFactory")) : class$org$jboss$ws$metadata$wsdl$WSDLDefinitionsFactory));
    public static final String FEATURE_IMPORT_DOCUMENTS = "javax.wsdl.importDocuments";
    public static final String FEATURE_VERBOSE = "javax.wsdl.verbose";
    private Map features = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$org$jboss$ws$metadata$wsdl$WSDLDefinitionsFactory;

    private WSDLDefinitionsFactory() {
    }

    public static WSDLDefinitionsFactory newInstance() {
        return new WSDLDefinitionsFactory();
    }

    public void setFeature(String name, boolean value) throws IllegalArgumentException {
        this.features.put(name, new Boolean(value));
    }

    public WSDLDefinitions parse(URL wsdlLocation) throws WSDLException {
        if (wsdlLocation == null) {
            throw new IllegalArgumentException("URL cannot be null");
        }
        log.debug((Object)("parse: " + wsdlLocation.toExternalForm()));
        WSDLDefinitions wsdlDefinitions = null;
        try {
            Document wsdlDoc = this.getDocument(wsdlLocation);
            String defaultNamespace = this.getDefaultNamespace(wsdlDoc);
            if ("http://www.w3.org/2003/11/wsdl".equals(defaultNamespace)) {
                WSDL20Reader wsdlReader = new WSDL20Reader();
                Iterator it = this.features.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    String key = (String)entry.getKey();
                    Boolean flag = (Boolean)entry.getValue();
                    wsdlReader.setFeature(key, flag);
                }
                wsdlDefinitions = wsdlReader.readWSDL(new WSDLLocatorImpl(wsdlLocation));
                wsdlDefinitions.setWsdlDocument(wsdlDoc);
            } else if ("http://schemas.xmlsoap.org/wsdl/".equals(defaultNamespace)) {
                WSDLFactory wsdlFactory = WSDLFactory.newInstance();
                WSDLReader wsdlReader = wsdlFactory.newWSDLReader();
                wsdlReader.setFeature(FEATURE_VERBOSE, false);
                Iterator it = this.features.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    String key = (String)entry.getKey();
                    Boolean flag = (Boolean)entry.getValue();
                    wsdlReader.setFeature(key, flag.booleanValue());
                }
                Definition definition = wsdlReader.readWSDL((WSDLLocator)new WSDLLocatorImpl(wsdlLocation));
                wsdlDefinitions = new WSDL11Reader().process(definition, wsdlLocation);
                wsdlDefinitions.setWsdlDocument(wsdlDoc);
            } else {
                throw new WSDLException("Invalid default namespace: " + defaultNamespace);
            }
            if (log.isTraceEnabled()) {
                StringWriter stwr = new StringWriter();
                WSDL20Writer wsdl20Writer = new WSDL20Writer(wsdlDefinitions);
                wsdl20Writer.write(stwr);
                log.trace((Object)("\n" + stwr.toString()));
            }
        }
        catch (WSDLException e) {
            throw e;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new WSDLException(e);
        }
        return wsdlDefinitions;
    }

    private Document getDocument(URL wsdlLocation) throws WSDLException {
        try {
            InputStream wsdlInputStream = wsdlLocation.openStream();
            try {
                DocumentBuilder builder = DOMUtils.getDocumentBuilder();
                Document document = builder.parse(wsdlInputStream);
                return document;
            }
            finally {
                wsdlInputStream.close();
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new WSDLException(e);
        }
    }

    private String getDefaultNamespace(Document wsdlDoc) throws WSDLException {
        Element root = wsdlDoc.getDocumentElement();
        String defaultNamespace = root.getNamespaceURI();
        return defaultNamespace;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class WSDLLocatorImpl
    implements WSDLLocator {
        private URL wsdlURL;
        private String latestImportURI;

        public WSDLLocatorImpl(URL wsdlFile) {
            if (wsdlFile == null) {
                throw new IllegalArgumentException("WSDL file argument cannot be null");
            }
            this.wsdlURL = wsdlFile;
        }

        public InputSource getBaseInputSource() {
            log.trace((Object)("getBaseInputSource [wsdlUrl=" + this.wsdlURL + "]"));
            try {
                InputStream is = this.wsdlURL.openStream();
                if (is == null) {
                    throw new IllegalArgumentException("Cannot obtain wsdl from [" + this.wsdlURL + "]");
                }
                return new InputSource(is);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot access wsdl from [" + this.wsdlURL + "], " + e.getMessage());
            }
        }

        public String getBaseURI() {
            return this.wsdlURL.toExternalForm();
        }

        public InputSource getImportInputSource(String parent, String resource) {
            log.trace((Object)("getImportInputSource [parent=" + parent + ",resource=" + resource + "]"));
            URL parentURL = null;
            try {
                parentURL = new URL(parent);
            }
            catch (MalformedURLException malformedURLException) {
                log.error((Object)("Not a valid URL: " + parent));
                return null;
            }
            String wsdlImport = null;
            String external = parentURL.toExternalForm();
            if (resource.startsWith("http://") || resource.startsWith("https://")) {
                wsdlImport = resource;
            } else if (resource.startsWith("/")) {
                String beforePath = external.substring(0, external.indexOf(parentURL.getPath()));
                wsdlImport = String.valueOf(beforePath) + resource;
            } else {
                String parentDir = external.substring(0, external.lastIndexOf("/"));
                while (resource.startsWith("./")) {
                    resource = resource.substring(2);
                }
                while (resource.startsWith("../")) {
                    parentDir = parentDir.substring(0, parentDir.lastIndexOf("/"));
                    resource = resource.substring(3);
                }
                wsdlImport = String.valueOf(parentDir) + "/" + resource;
            }
            try {
                log.trace((Object)("Resolved to: " + wsdlImport));
                InputStream is = new URL(wsdlImport).openStream();
                if (is == null) {
                    throw new IllegalArgumentException("Cannot import wsdl from [" + wsdlImport + "]");
                }
                this.latestImportURI = wsdlImport;
                return new InputSource(is);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot access imported wsdl [" + wsdlImport + "], " + e.getMessage());
            }
        }

        public String getLatestImportURI() {
            return this.latestImportURI;
        }
    }
}

