/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.wsdl;

import javax.xml.namespace.QName;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.wsdl.Extendable;
import org.jboss.ws.metadata.wsdl.NCName;
import org.jboss.ws.metadata.wsdl.WSDLBinding;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLInterface;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;
import org.jboss.ws.metadata.wsdl.WSDLService;

public class WSDLEndpoint
extends Extendable {
    private static final long serialVersionUID = 4991302339046047865L;
    private WSDLService wsdlService;
    private NCName name;
    private QName qname;
    private QName binding;
    private String address;

    public WSDLEndpoint(WSDLService wsdlService) {
        this.wsdlService = wsdlService;
    }

    public WSDLInterface getInterface() {
        WSDLInterface wsdlInterface = null;
        WSDLDefinitions wsdlDefinitions = this.wsdlService.getWsdlDefinitions();
        if (this.wsdlService.getInterfaceName() != null) {
            QName qname = this.wsdlService.getInterfaceName();
            wsdlInterface = wsdlDefinitions.getInterface(new NCName(qname));
        } else {
            WSDLBinding wsdlBinding = wsdlDefinitions.getBinding(new NCName(this.binding));
            if (wsdlBinding == null) {
                throw new WSException("Cannot obtain the binding: " + this.binding);
            }
            if (wsdlBinding.getInterfaceName() != null) {
                QName qname = wsdlBinding.getInterfaceName();
                wsdlInterface = wsdlDefinitions.getInterface(new NCName(qname));
            }
        }
        if (wsdlInterface == null) {
            throw new WSException("Cannot obtain the interface associated with this endpoint: " + this.name);
        }
        return wsdlInterface;
    }

    public WSDLInterfaceOperation getInterfaceOperation(NCName opName) {
        WSDLInterface wsdlInterface = this.getInterface();
        WSDLInterfaceOperation wsdlInterfaceOperation = wsdlInterface.getWSDLInterfaceOperation(opName);
        return wsdlInterfaceOperation;
    }

    public NCName getName() {
        return this.name;
    }

    public void setName(NCName name) {
        this.name = name;
    }

    public QName getQName() {
        if (this.qname == null) {
            String tnsURI = this.wsdlService.getWsdlDefinitions().getTargetNamespace();
            this.qname = new QName(tnsURI, this.name.toString());
        }
        return this.qname;
    }

    public void setQName(QName qname) {
        this.qname = qname;
    }

    public QName getBinding() {
        return this.binding;
    }

    public void setBinding(QName binding) {
        this.binding = binding;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
}

