/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.wsdl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.wsdl.Extendable;
import org.jboss.ws.metadata.wsdl.NCName;
import org.jboss.ws.metadata.wsdl.WSDLInterface;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationInfault;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationInput;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutfault;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutput;
import org.jboss.ws.metadata.wsdl.WSDLProperty;

public class WSDLInterfaceOperation
extends Extendable
implements Comparable {
    private static final long serialVersionUID = -5014918078197942626L;
    private WSDLInterface wsdlInterface;
    private NCName name;
    private String pattern;
    private String style = "http://www.w3.org/2004/03/wsdl/style/rpc";
    private boolean safe;
    private Map<QName, WSDLInterfaceOperationInput> inputs = new LinkedHashMap<QName, WSDLInterfaceOperationInput>();
    private Map<QName, WSDLInterfaceOperationOutput> outputs = new LinkedHashMap<QName, WSDLInterfaceOperationOutput>();
    private ArrayList<WSDLInterfaceOperationInfault> infaults = new ArrayList();
    private ArrayList<WSDLInterfaceOperationOutfault> outfaults = new ArrayList();

    public WSDLInterfaceOperation(WSDLInterface wsdlInterface) {
        this.wsdlInterface = wsdlInterface;
    }

    public WSDLInterface getWsdlInterface() {
        return this.wsdlInterface;
    }

    public NCName getName() {
        return this.name;
    }

    public void setName(NCName name) {
        this.name = name;
    }

    public QName getQName() {
        String nsURI = this.wsdlInterface.getQName().getNamespaceURI();
        return new QName(nsURI, this.name.toString());
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public boolean isSafe() {
        return this.safe;
    }

    public void setSafe(boolean safe) {
        this.safe = safe;
    }

    public WSDLInterfaceOperationInput[] getInputs() {
        WSDLInterfaceOperationInput[] arr = new WSDLInterfaceOperationInput[this.inputs.size()];
        new ArrayList<WSDLInterfaceOperationInput>(this.inputs.values()).toArray(arr);
        return arr;
    }

    public void addInput(WSDLInterfaceOperationInput input) {
        QName xmlName = input.getElement();
        if (xmlName == null) {
            throw new IllegalArgumentException("Illegal null element name");
        }
        if (this.inputs.get(xmlName) != null) {
            throw new WSException("Attempt to map multiple operation inputs to: " + xmlName);
        }
        this.inputs.put(xmlName, input);
    }

    public WSDLInterfaceOperationInput getInput(QName qname) {
        WSDLInterfaceOperationInput opInput = this.inputs.get(qname);
        return opInput;
    }

    public WSDLInterfaceOperationInput getInputByPartName(String partName) {
        WSDLInterfaceOperationInput opInput = null;
        Iterator<WSDLInterfaceOperationInput> iterator = this.inputs.values().iterator();
        while (iterator.hasNext()) {
            WSDLInterfaceOperationInput auxInput = iterator.next();
            WSDLProperty property = auxInput.getProperty("http://www.jboss.org/jbossws/partname");
            if (property == null || !property.getValue().equals(partName)) continue;
            opInput = auxInput;
        }
        return opInput;
    }

    public WSDLInterfaceOperationOutput[] getOutputs() {
        WSDLInterfaceOperationOutput[] arr = new WSDLInterfaceOperationOutput[this.outputs.size()];
        new ArrayList<WSDLInterfaceOperationOutput>(this.outputs.values()).toArray(arr);
        return arr;
    }

    public void addOutput(WSDLInterfaceOperationOutput output) {
        QName xmlName = output.getElement();
        if (xmlName == null) {
            throw new IllegalArgumentException("Illegal null element name");
        }
        if (this.outputs.get(xmlName) != null) {
            throw new WSException("Attempt to map multiple operation outputs to: " + xmlName);
        }
        this.outputs.put(xmlName, output);
    }

    public WSDLInterfaceOperationOutput getOutput(QName qname) {
        WSDLInterfaceOperationOutput opOutput = this.outputs.get(qname);
        return opOutput;
    }

    public WSDLInterfaceOperationOutput getOutputByPartName(String partName) {
        WSDLInterfaceOperationOutput opOutput = null;
        Iterator<WSDLInterfaceOperationOutput> iterator = this.outputs.values().iterator();
        while (iterator.hasNext()) {
            WSDLInterfaceOperationOutput auxOutput = iterator.next();
            WSDLProperty property = auxOutput.getProperty("http://www.jboss.org/jbossws/partname");
            if (property == null || !property.getValue().equals(partName)) continue;
            opOutput = auxOutput;
        }
        return opOutput;
    }

    public WSDLInterfaceOperationInfault[] getInfaults() {
        WSDLInterfaceOperationInfault[] arr = new WSDLInterfaceOperationInfault[this.infaults.size()];
        this.infaults.toArray(arr);
        return arr;
    }

    public void addInfault(WSDLInterfaceOperationInfault infault) {
        this.infaults.add(infault);
    }

    public WSDLInterfaceOperationOutfault[] getOutfaults() {
        WSDLInterfaceOperationOutfault[] arr = new WSDLInterfaceOperationOutfault[this.outfaults.size()];
        this.outfaults.toArray(arr);
        return arr;
    }

    public void addOutfault(WSDLInterfaceOperationOutfault outfault) {
        this.outfaults.add(outfault);
    }

    public int compareTo(Object o) {
        int c = -1;
        if (o instanceof WSDLInterfaceOperation) {
            WSDLInterfaceOperation w = (WSDLInterfaceOperation)o;
            String oname = w.getName().toString();
            String myname = this.name.toString();
            c = myname.compareTo(oname);
        }
        return c;
    }
}

